/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.Plane;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ALineConnector;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.ResetAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.util.Vector;

public class LineConnector
extends ALineConnector {
    private Vec3d v1 = new Vec3d();
    private Vec3d v2 = new Vec3d();
    private Vec3d temp = new Vec3d();
    private boolean selectionInterpolationEnabled = false;
    private int selectionInterpolationGranularity = 5;
    private Bbox clipBbox;
    private boolean skinOn = false;
    private Vec3d tempV1 = new Vec3d();
    private Vec3d tempV2 = new Vec3d();
    private Vec3d tempV3 = new Vec3d();

    public LineConnector() {
        super(new Transform());
    }

    protected void drawSelectableGeometryForGroup(Channel channel, Vector aLine) {
        if (this.isSelectionInterpolationEnabled() && aLine.size() == 2) {
            int firstValueIndex = (Integer)aLine.elementAt(0);
            int lastValueIndex = (Integer)aLine.elementAt(aLine.size() - 1);
            Vec3d first = this.v1;
            Vec3d last = this.v2;
            Vec3d firstScreen = new Vec3d();
            Vec3d lastScreen = new Vec3d();
            channel.glLoadName((Object)aLine);
            channel.glPushName(null);
            try {
                first.x = this.pointX.getValue(firstValueIndex);
                first.y = this.pointY.getValue(firstValueIndex);
                first.z = this.pointZ.getValue(firstValueIndex);
                last.x = this.pointX.getValue(lastValueIndex);
                last.y = this.pointY.getValue(lastValueIndex);
                last.z = this.pointZ.getValue(lastValueIndex);
                firstScreen = this.project(first, firstScreen, channel);
                lastScreen = this.project(last, lastScreen, channel);
                Vec3d s = new Vec3d();
                s.set(lastScreen);
                s.subtract(first);
                Vec3d worldCoordsInTheRightDirection = new Vec3d();
                worldCoordsInTheRightDirection.set(last);
                worldCoordsInTheRightDirection.subtract(first);
                double screenLength = s.length();
                double worldLength = worldCoordsInTheRightDirection.length();
                double worldLengthOfOnePixel = worldLength / screenLength;
                int granularity = this.getSelectionInterpolationGranularity();
                if ((double)granularity > screenLength) {
                    granularity = (int)(screenLength / 2.0);
                }
                worldCoordsInTheRightDirection.normalize();
                worldCoordsInTheRightDirection.scale(worldLengthOfOnePixel * (double)granularity);
                int segmentCount = (int)(worldLength / (worldLengthOfOnePixel * (double)granularity));
                if (segmentCount < 2) {
                    segmentCount = 2;
                }
                Vec3d start = new Vec3d(first);
                Vec3d next = new Vec3d(first);
                next.add(worldCoordsInTheRightDirection);
                double interpolationPercent = 0.0;
                double interpolationIncrement = 1.0 / (double)(segmentCount - 1);
                for (int i = 0; i < segmentCount; ++i) {
                    Double bigD;
                    channel.glBegin(1);
                    channel.glVertex(start.x, start.y, start.z);
                    if (i < segmentCount - 1) {
                        bigD = new Double(interpolationPercent);
                        channel.glVertex(next.x, next.y, next.z);
                    } else {
                        bigD = new Double(1.0);
                        channel.glVertex(last.x, last.y, last.z);
                    }
                    channel.glLoadName((Object)bigD);
                    if (channel.isSVGSelectionMode()) {
                        if (i <= segmentCount / 2) {
                            channel.setSVGSelectionText(this.userDataToString(firstValueIndex));
                        } else {
                            channel.setSVGSelectionText(this.userDataToString(lastValueIndex));
                        }
                    }
                    channel.glEnd();
                    interpolationPercent += interpolationIncrement;
                    start.add(worldCoordsInTheRightDirection);
                    next.add(worldCoordsInTheRightDirection);
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            channel.glPopName();
        } else {
            int intersectionCount = aLine.size();
            Vec3d midpoint = this.temp;
            for (int j = 1; j < intersectionCount; ++j) {
                try {
                    int index1 = (Integer)aLine.elementAt(j - 1);
                    this.v1.x = this.pointX.getValue(index1);
                    this.v1.y = this.pointY.getValue(index1);
                    this.v1.z = this.pointZ.getValue(index1);
                    int index2 = (Integer)aLine.elementAt(j);
                    this.v2.x = this.pointX.getValue(index2);
                    this.v2.y = this.pointY.getValue(index2);
                    this.v2.z = this.pointZ.getValue(index2);
                    midpoint.x = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
                    midpoint.y = this.v1.y + (this.v2.y - this.v1.y) / 2.0;
                    midpoint.z = this.v1.z + (this.v2.z - this.v1.z) / 2.0;
                    this.replaceObservation(channel, index1);
                    channel.glLoadName((Object)this.currentGroup);
                    channel.glBegin(1);
                    channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                    channel.glVertex(midpoint.x, midpoint.y, midpoint.z);
                    channel.glEnd();
                    this.replaceObservation(channel, index2);
                    channel.glLoadName((Object)this.currentGroup);
                    channel.glBegin(1);
                    channel.glVertex(midpoint.x, midpoint.y, midpoint.z);
                    channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                    channel.glEnd();
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected void drawSelectableGeometry(Channel channel, int valueIndex, boolean fill, double lineWidth, Vec3d point2) {
        Vector v = this.getCurrentPolyline();
        if (v != null) {
            Vec3d point1 = this.v1;
            Vec3d midpoint = this.v2;
            int previousValueIndex = (Integer)v.elementAt(v.size() - 1);
            try {
                point1.x = this.pointX.getValue(previousValueIndex);
                point1.y = this.pointY.getValue(previousValueIndex);
                point1.z = this.pointZ.getValue(previousValueIndex);
                channel.glLineWidth((float)lineWidth);
                midpoint.x = point1.x + (point2.x - point1.x) / 2.0;
                midpoint.y = point1.y + (point2.y - point1.y) / 2.0;
                midpoint.z = point1.z + (point2.z - point1.z) / 2.0;
                if (fill) {
                    this.drawFillUnder(channel, midpoint, point2);
                } else {
                    channel.glBegin(1);
                    channel.glVertex(midpoint.x, midpoint.y, midpoint.z);
                    channel.glVertex(point2.x, point2.y, point2.z);
                    channel.glEnd();
                }
                this.replaceObservation(channel, previousValueIndex);
                if (fill) {
                    this.drawFillUnder(channel, point1, midpoint);
                } else {
                    channel.glBegin(1);
                    channel.glVertex(point1.x, point1.y, point1.z);
                    channel.glVertex(midpoint.x, midpoint.y, midpoint.z);
                    channel.glEnd();
                }
                this.replaceObservation(channel, valueIndex);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    private Vec3d project(Vec3d v, Vec3d temp, Channel ch) {
        double[] world = new double[3];
        double[] pixel = new double[3];
        world[0] = v.x;
        world[1] = v.y;
        world[2] = v.z;
        ch.gluProject(world, pixel);
        temp.x = pixel[0];
        temp.y = pixel[1];
        temp.z = 0.0;
        return temp;
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        super.render(buildAction);
        Channel ch = (Channel)buildAction.getGraphicsContext();
        this.clipBbox = ch.getClipBounds();
    }

    @Override
    public void reset(AResetAction resetAction) {
        int index;
        int j;
        int intersectionCount;
        Vector v;
        int i;
        if (this.multipleGroup) {
            return;
        }
        super.reset(resetAction);
        ResetAction ra = (ResetAction)resetAction;
        Channel channel = ra.getChannel();
        int polyLineCount = this.renderIndices.size();
        if (polyLineCount <= 0) {
            return;
        }
        Color c = ColorProperty.getDefaultColor();
        Color fc = ColorProperty.getDefaultColor();
        float w = 1.0f;
        boolean fo = false;
        boolean lo = true;
        int firstIndex = this.getFirstIndex();
        try {
            w = (float)this.lineWidth.getValue(firstIndex);
            c = this.color.getValue(firstIndex);
            fc = this.fillColor.getValue(firstIndex);
            fo = this.fillOn.getValue(firstIndex);
            lo = this.lineOn.getValue(firstIndex);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        channel.glPushAttrib(0);
        if (this.clipBbox != null) {
            channel.setClipBounds(this.clipBbox);
        }
        if (fo) {
            channel.glColor(fc);
            channel.glDisable(1);
            for (i = 0; i < polyLineCount; ++i) {
                v = (Vector)this.renderIndices.elementAt(i);
                if (v == null) continue;
                intersectionCount = v.size();
                channel.setVertexBufferReallocationSize(intersectionCount);
                for (j = 1; j < intersectionCount; ++j) {
                    try {
                        index = (Integer)v.elementAt(j - 1);
                        this.v1.x = this.pointX.getValue(index);
                        this.v1.y = this.pointY.getValue(index);
                        this.v1.z = this.pointZ.getValue(index);
                        index = (Integer)v.elementAt(j);
                        this.v2.x = this.pointX.getValue(index);
                        this.v2.y = this.pointY.getValue(index);
                        this.v2.z = this.pointZ.getValue(index);
                        this.drawFillUnder(channel, this.v1, this.v2);
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            }
        }
        if (lo) {
            channel.glLineWidth(w);
            channel.glColor(c);
            channel.lineCapStyle(0);
            channel.setLineJoinStyle(1);
            if (this.stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(this.stippleFactor, (int)((short)this.stipplePattern));
            }
            for (i = 0; i < polyLineCount; ++i) {
                v = (Vector)this.renderIndices.elementAt(i);
                if (v == null) continue;
                intersectionCount = v.size();
                channel.setVertexBufferReallocationSize(intersectionCount);
                channel.glBegin(1);
                for (j = 0; j < intersectionCount; ++j) {
                    index = (Integer)v.elementAt(j);
                    try {
                        double x = this.pointX.getValue(index);
                        double y = this.pointY.getValue(index);
                        double z = this.pointZ.getValue(index);
                        channel.glVertex(x, y, z);
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                channel.glEnd();
            }
        }
        channel.setVertexBufferReallocationSize(10);
        channel.glPopAttrib();
        this.resetRenderIndices();
        this.clipBbox = null;
    }

    @Override
    protected void renderPolylineGroup(ABuildAction buildAction, FilledLineConnector.PolylineGroup group, boolean fillOn) {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int polyLineCount = group.getPolylineCount();
        if (polyLineCount <= 0) {
            return;
        }
        boolean is3d = this.depth.length() > 0.0;
        for (int i = 0; i < polyLineCount; ++i) {
            double alpha_inc;
            Vector line = group.getPolyline(i);
            if (line == null || is3d && line.size() <= 1) continue;
            if (fillOn) {
                if (this.pointX2.isConnected() || this.pointY2.isConnected()) {
                    this.fillStackedPolyline(channel, line, ba.isUseNameStack());
                } else {
                    this.fillPolyline(channel, line, ba.isUseNameStack());
                }
                if (!group.isHighlightOn()) continue;
                this.drawEdge(channel, line, ba.isUseNameStack(), group);
                continue;
            }
            if (this.depth.length() > 0.0) {
                this.drawRibbon(channel, line, ba.isUseNameStack());
                continue;
            }
            this.drawPolyline(channel, line, ba.isUseNameStack());
            if (!this.skinOn) continue;
            double width = this.currentGroup.getLineWidth();
            double alpha = alpha_inc = 0.5 / width;
            double prev_alpha = 0.0;
            for (int w = (int)width - 1; w > 0; --w) {
                channel.glLineWidth((float)w);
                double a = (alpha - prev_alpha) / (1.0 - prev_alpha);
                channel.glColor(new Color(1.0f, 1.0f, 1.0f, (float)a));
                this.drawPolyline(channel, line, ba.isUseNameStack());
                prev_alpha = alpha;
                alpha += alpha_inc;
            }
        }
    }

    private void drawEdge(Channel channel, Vector line, boolean useNameStack, FilledLineConnector.PolylineGroup group) {
        Vec3d centerTweak = new Vec3d();
        Vec3d v = new Vec3d();
        Vec3d n = new Vec3d();
        channel.glPushAttrib(0);
        int intersectionCount = line.size();
        channel.setVertexBufferReallocationSize(intersectionCount);
        centerTweak.set(0.0, 0.0, 0.0);
        if (group.isHighlightOn()) {
            channel.glColor(group.getHighlightColor());
        } else {
            channel.glColor(group.getLineColor());
        }
        channel.glPolygonMode(2);
        if (this.depth.length() > 0.0) {
            channel.setExtrusionVector(this.depth.x, this.depth.y, this.depth.z);
            centerTweak.set(this.depth);
            centerTweak.scale(-0.5);
            channel.glBegin(3);
        } else {
            channel.glBegin(2);
        }
        for (int j = 0; j < intersectionCount; ++j) {
            int index1 = (Integer)line.elementAt(j);
            try {
                this.v1.x = this.pointX.getValue(index1);
                this.v1.y = this.pointY.getValue(index1);
                this.v1.z = this.pointZ.getValue(index1);
                this.v1.add(centerTweak);
                if (j == 0) {
                    n.set(this.fillToPlane.normal);
                    v.set(this.v1);
                    n.scale(v.dot(n));
                    v.subtract(n);
                    channel.glVertex(v.x, v.y, v.z);
                }
                channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                if (j != intersectionCount - 1) continue;
                n.set(this.fillToPlane.normal);
                v.set(this.v1);
                n.scale(v.dot(n));
                v.subtract(n);
                channel.glVertex(v.x, v.y, v.z);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        channel.glEnd();
        channel.setVertexBufferReallocationSize(10);
        channel.glPopAttrib();
    }

    private void fillPolyline(Channel channel, Vector aLine, boolean useNameStack) {
        int intersectionCount = aLine.size();
        channel.setVertexBufferReallocationSize(intersectionCount);
        boolean subpixelRendering_Sav = this.subpixelRendering;
        if (useNameStack) {
            this.subpixelRendering = false;
        }
        Vec3d midpoint = this.temp;
        for (int j = 1; j < intersectionCount; ++j) {
            try {
                int index1 = (Integer)aLine.elementAt(j - 1);
                this.v1.x = this.pointX.getValue(index1);
                this.v1.y = this.pointY.getValue(index1);
                this.v1.z = this.pointZ.getValue(index1);
                int index2 = (Integer)aLine.elementAt(j);
                this.v2.x = this.pointX.getValue(index2);
                this.v2.y = this.pointY.getValue(index2);
                this.v2.z = this.pointZ.getValue(index2);
                if (useNameStack) {
                    midpoint.x = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
                    midpoint.y = this.v1.y + (this.v2.y - this.v1.y) / 2.0;
                    midpoint.z = this.v1.z + (this.v2.z - this.v1.z) / 2.0;
                    this.replaceObservation(channel, index1);
                    channel.glLoadName((Object)this.currentGroup);
                    this.drawFillUnder(channel, this.v1, midpoint);
                    this.replaceObservation(channel, index2);
                    channel.glLoadName((Object)this.currentGroup);
                    this.drawFillUnder(channel, midpoint, this.v2);
                    continue;
                }
                this.drawFillUnder(channel, this.v1, this.v2);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (this.subpixelRendering) {
            this.drawSegments(channel);
        }
        this.subpixelRendering = subpixelRendering_Sav;
        channel.setVertexBufferReallocationSize(10);
    }

    private void fillStackedPolyline(Channel channel, Vector aLine, boolean useNameStack) {
        int intersectionCount = aLine.size();
        channel.setVertexBufferReallocationSize(intersectionCount);
        if (useNameStack) {
            Vec3d midpoint = this.temp;
            Vec3d v1_2 = new Vec3d();
            Vec3d v2_2 = new Vec3d();
            Vec3d midpoint_2 = new Vec3d();
            for (int j = 1; j < intersectionCount; ++j) {
                try {
                    int index1 = (Integer)aLine.elementAt(j - 1);
                    this.v1.x = this.pointX.getValue(index1);
                    this.v1.y = this.pointY.getValue(index1);
                    this.v1.z = this.pointZ.getValue(index1);
                    v1_2.x = this.pointX2.getValue(index1);
                    v1_2.y = this.pointY2.getValue(index1);
                    v1_2.z = this.pointZ2.getValue(index1);
                    int index2 = (Integer)aLine.elementAt(j);
                    this.v2.x = this.pointX.getValue(index2);
                    this.v2.y = this.pointY.getValue(index2);
                    this.v2.z = this.pointZ.getValue(index2);
                    v2_2.x = this.pointX2.getValue(index2);
                    v2_2.y = this.pointY2.getValue(index2);
                    v2_2.z = this.pointZ2.getValue(index2);
                    midpoint.x = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
                    midpoint.y = this.v1.y + (this.v2.y - this.v1.y) / 2.0;
                    midpoint.z = this.v1.z + (this.v2.z - this.v1.z) / 2.0;
                    midpoint_2.x = v1_2.x + (v2_2.x - v1_2.x) / 2.0;
                    midpoint_2.y = v1_2.y + (v2_2.y - v1_2.y) / 2.0;
                    midpoint_2.z = v1_2.z + (v2_2.z - v1_2.z) / 2.0;
                    this.replaceObservation(channel, index1);
                    channel.glLoadName((Object)this.currentGroup);
                    channel.glPolygonMode(3);
                    channel.glBegin(2);
                    channel.glVertex(this.v1.x, this.v1.y);
                    channel.glVertex(midpoint.x, midpoint.y);
                    channel.glVertex(midpoint_2.x, midpoint_2.y);
                    channel.glVertex(v1_2.x, v1_2.y);
                    channel.glEnd();
                    this.replaceObservation(channel, index2);
                    channel.glLoadName((Object)this.currentGroup);
                    channel.glPolygonMode(3);
                    channel.glBegin(2);
                    channel.glVertex(midpoint.x, midpoint.y);
                    channel.glVertex(this.v2.x, this.v2.y);
                    channel.glVertex(v2_2.x, v2_2.y);
                    channel.glVertex(midpoint_2.x, midpoint_2.y);
                    channel.glEnd();
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        } else {
            int index1;
            int j;
            channel.glPolygonMode(3);
            channel.glBegin(2);
            for (j = 0; j < intersectionCount; ++j) {
                try {
                    index1 = (Integer)aLine.elementAt(j);
                    this.v1.x = this.pointX.getValue(index1);
                    this.v1.y = this.pointY.getValue(index1);
                    this.v1.z = this.pointZ.getValue(index1);
                    channel.glVertex(this.v1.x, this.v1.y);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            for (j = intersectionCount - 1; j >= 0; --j) {
                try {
                    index1 = (Integer)aLine.elementAt(j);
                    this.v1.x = this.pointX2.getValue(index1);
                    this.v1.y = this.pointY2.getValue(index1);
                    this.v1.z = this.pointZ2.getValue(index1);
                    channel.glVertex(this.v1.x, this.v1.y);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            channel.glEnd();
        }
        channel.setVertexBufferReallocationSize(10);
    }

    private void drawPolyline(Channel channel, Vector aLine, boolean useNameStack) {
        int intersectionCount = aLine.size();
        channel.setVertexBufferReallocationSize(intersectionCount);
        if (useNameStack) {
            this.drawSelectableGeometryForGroup(channel, aLine);
        } else if (this.depth.length() > 0.0) {
            channel.glPolygonMode(2);
            channel.setExtrusionVector(this.depth.x, this.depth.y, this.depth.z);
            double firstX = 0.0;
            double firstY = 0.0;
            double firstZ = 0.0;
            Vec3d centerTweak = new Vec3d();
            if (this.depth.length() > 0.0) {
                centerTweak.set(this.depth);
                centerTweak.scale(-0.5);
            }
            channel.glBegin(3);
            for (int j = 0; j < intersectionCount; ++j) {
                int index1 = (Integer)aLine.elementAt(j);
                try {
                    this.v1.x = this.pointX.getValue(index1);
                    this.v1.y = this.pointY.getValue(index1);
                    this.v1.z = this.pointZ.getValue(index1);
                    this.v1.add(centerTweak);
                    if (j == 0) {
                        firstX = this.v1.x;
                        firstY = this.v1.y;
                        firstZ = this.v1.z;
                        if (this.fillToPlane.normal.x != 0.0) {
                            firstX = 0.0;
                        } else if (this.fillToPlane.normal.y != 0.0) {
                            firstY = 0.0;
                        } else {
                            firstZ = 0.0;
                        }
                        channel.glVertex(firstX, firstY, firstZ);
                    }
                    channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                    if (j != intersectionCount - 1) continue;
                    if (this.fillToPlane.normal.x == 0.0 && this.fillToPlane.normal.y != 0.0) {
                        channel.glVertex(this.v1.x, 0.0, this.v1.z);
                    }
                    channel.glVertex(firstX, firstY, firstZ);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            channel.glEnd();
        } else {
            if ((this.startArrow || this.endArrow) && intersectionCount >= 2) {
                this.computeArrowHeadParameters(channel, aLine, intersectionCount);
            }
            channel.glBegin(1);
            for (int j = 0; j < intersectionCount; ++j) {
                int index1 = (Integer)aLine.elementAt(j);
                try {
                    this.v1.x = this.pointX.getValue(index1);
                    this.v1.y = this.pointY.getValue(index1);
                    this.v1.z = this.pointZ.getValue(index1);
                    if (this.startArrow && j < this.index_s) {
                        this.adjustStartPoint(this.v1);
                    }
                    if (this.endArrow && j > this.index_e) {
                        this.adjustEndPoint(this.v1);
                    }
                    channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            channel.glEnd();
            if (this.startArrow && intersectionCount >= 2) {
                this.drawArrow(channel, this.arrowV1, this.arrowV2);
            }
            if (this.endArrow && intersectionCount >= 2) {
                this.drawArrow(channel, this.arrowV1end, this.arrowV2end);
            }
        }
        channel.setVertexBufferReallocationSize(10);
    }

    private void computeArrowHeadParameters(Channel channel, Vector aLine, int intersectionCount) {
        int index1;
        int j;
        this.arrowV1 = null;
        this.arrowV2 = null;
        this.index_s = 0;
        if (this.startArrow && intersectionCount >= 2) {
            for (j = 0; j < intersectionCount; ++j) {
                index1 = (Integer)aLine.elementAt(j);
                try {
                    this.v1.x = this.pointX.getValue(index1);
                    this.v1.y = this.pointY.getValue(index1);
                    this.v1.z = this.pointZ.getValue(index1);
                    if (this.arrowV2 == null) {
                        this.arrowV2 = new Vec3d(this.v1);
                        continue;
                    }
                    if (this.arrowV1 != null) continue;
                    this.arrowV1 = new Vec3d(this.v1);
                    if (this.arrowV1.equals((Object)this.arrowV2)) {
                        this.arrowV1 = null;
                        continue;
                    }
                    this.index_s = j;
                    break;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            this.startArrow = this.adjustStartArrow(channel);
        }
        this.arrowV1end = null;
        this.arrowV2end = null;
        this.index_e = intersectionCount - 1;
        if (this.endArrow && intersectionCount >= 2) {
            for (j = intersectionCount - 1; j >= 0; --j) {
                index1 = (Integer)aLine.elementAt(j);
                try {
                    this.v1.x = this.pointX.getValue(index1);
                    this.v1.y = this.pointY.getValue(index1);
                    this.v1.z = this.pointZ.getValue(index1);
                    if (this.arrowV2end == null) {
                        this.arrowV2end = new Vec3d(this.v1);
                        continue;
                    }
                    if (this.arrowV1end != null) continue;
                    this.arrowV1end = new Vec3d(this.v1);
                    if (this.arrowV1end.equals((Object)this.arrowV2end)) {
                        this.arrowV1end = null;
                        continue;
                    }
                    this.index_e = j;
                    break;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            this.endArrow = this.adjustEndArrow(channel);
        }
    }

    private void drawRibbon(Channel channel, Vector aLine, boolean useNameStack) {
        Plane currentFillToPlane = this.getFillToPlane();
        if (this.depth.x > 0.0) {
            this.setFillToPlane(Plane.YZ);
        } else {
            this.setFillToPlane(Plane.YX);
        }
        try {
            int first = (Integer)aLine.elementAt(0);
            this.v1.x = this.pointX.getValue(first);
            this.v1.y = this.pointY.getValue(first);
            this.v1.z = this.pointZ.getValue(first);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        if (this.depth.x > 0.0) {
            this.getFillToPlane().setDistance(this.v1.x + this.depth.x);
        } else {
            this.getFillToPlane().setDistance(this.v1.z + this.depth.z);
        }
        this.fillPolyline(channel, aLine, useNameStack);
        this.setFillToPlane(currentFillToPlane);
    }

    public boolean isSelectionInterpolationEnabled() {
        return this.selectionInterpolationEnabled;
    }

    public void setSelectionInterpolationEnabled(boolean selectionInterpolationEnabled) {
        this.selectionInterpolationEnabled = selectionInterpolationEnabled;
    }

    public int getSelectionInterpolationGranularity() {
        return this.selectionInterpolationGranularity;
    }

    public void setSelectionInterpolationGranularity(int selectionInterpolationGranularity) {
        this.selectionInterpolationGranularity = selectionInterpolationGranularity;
    }

    public void setSkinOn(boolean on) {
        this.skinOn = on;
    }

    public boolean isSkinOn() {
        return this.skinOn;
    }
}

