/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AImage;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Component;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public class Image
extends AImage {
    public static void drawImage(Channel channel, java.awt.Image image, int horizontalJustification, int verticalJustification, int scaleType, boolean scaleOn, double width, double height, Color bgColor) {
        java.awt.Image scaledImage = image;
        channel.glPushAttrib(0);
        channel.glAlignment(horizontalJustification, verticalJustification);
        channel.ImageWaitImage(waitImage);
        if (width < 0.0) {
            width = 0.0;
        }
        if (height < 0.0) {
            height = 0.0;
        }
        double[] startWC = new double[]{0.0, 0.0, 0.0};
        double[] endWC = new double[]{width, height, 0.0};
        double[] startSC = new double[3];
        double[] endSC = new double[3];
        channel.gluProject(startWC, startSC);
        channel.gluProject(endWC, endSC);
        int imageWidth = (int)(endSC[0] - startSC[0]);
        int imageHeight = (int)(startSC[1] - endSC[1]);
        if (scaleOn) {
            scaledImage = image.getScaledInstance(imageWidth, imageHeight, scaleType);
        }
        Color rasterBackground = channel.getRasterBackgroundColor();
        channel.setRasterBackgroundColor(bgColor);
        channel.Image2D(scaledImage, 0.0, 0.0, 0.0, imageWidth, imageHeight);
        channel.setRasterBackgroundColor(rasterBackground);
        channel.glPopAttrib();
    }

    public Image() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        java.awt.Image image = null;
        try {
            int imageIndex = (int)this.whichImage.getValue(buildAction.getValueIndex());
            image = this.getImage(imageIndex);
            if (image != null && this.visibility.getValue(index)) {
                Color background = this.backgroundColorOn.getValue(index) ? this.backgroundColor.getValue(index) : null;
                Image.drawImage(ba.getChannel(), image, this.horizontalJustification.getValue(index), this.verticalJustification.getValue(index), this.imageScaleType.getValue(index), this.imageScaleOn.getValue(index), this.width.getValue(index), this.height.getValue(index), background);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    public static BufferedImage convertImageToBufferedImage(java.awt.Image image) {
        BufferedImage bi;
        if (image instanceof BufferedImage) {
            bi = (BufferedImage)image;
        } else {
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            bi = new BufferedImage(w, h, 1);
            bi.getGraphics().drawImage(image, 0, 0, null);
        }
        return bi;
    }

    public static java.awt.Image loadImage(String name, Component component) {
        java.awt.Image image = null;
        image = Toolkit.getDefaultToolkit().getImage(name);
        if (image != null) {
            MediaTracker mt = new MediaTracker(component);
            mt.addImage(image, 0);
            try {
                mt.waitForAll();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                image = null;
            }
        }
        return image;
    }
}

