/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.SASColors;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AGanttBox;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.ComplexGanttBox;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;

public class GanttBox
extends AGanttBox {
    private static final int BAR_TYPE_CRITICAL = 0;
    private static final int BAR_TYPE_NORMAL = 1;
    private static final int BAR_TYPE_EXTENDED = 2;
    static Vec3d[] earlyArray = new Vec3d[]{new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d()};
    static Vec3d[] interumArray = new Vec3d[]{new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d()};
    static Vec3d[] lateArray = new Vec3d[]{new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d()};
    private static HashMap taskValueHashMap = null;
    private HashMap breaktimeHashMap = null;

    public void clearTaskValueHashMap() {
        if (taskValueHashMap != null) {
            taskValueHashMap.clear();
        }
    }

    public void setBreaktimeHashMap(HashMap newBreaktimes) {
        this.breaktimeHashMap = newBreaktimes;
    }

    public GanttBox() {
        super(new Transform());
    }

    public static void drawElement(Channel channel, double earlyStart, double earlyFinish, double lateStart, double lateFinish, double duration, double target, int boxStyle, int boxConnectionStyle, double boxThickness, double boxSizeAdjustment, Color normalColor, Color slackColor, Color criticalColor, Color outlineColor, int criticalFillStyle, int normalFillStyle, int slackFillStyle, Color milestoneColor, int milestoneSymbol, double milestoneSize, boolean milestoneVisible, Color targetColor, int targetSymbol, double targetSize, boolean targetVisible, String color, boolean highlightOn, Color highlightFillColor, Color highlightEdgeColor, double drawBar, String task, int axisEnd, String calendar, Color breaktimeColor, HashMap breaktimeHashMap, boolean slackTimeVisible) {
        Vec3d[][] geometry = null;
        int[] fillStyle = null;
        Color[] fillColor = null;
        double midh = boxThickness;
        double midw = 0.0;
        if (boxStyle == 3) {
            if (highlightOn) {
                String temp;
                if (taskValueHashMap == null) {
                    taskValueHashMap = new HashMap();
                }
                if ((temp = (String)taskValueHashMap.get(task)) == null) {
                    taskValueHashMap.put(task, task);
                    Vec3d[] boxGeometry = null;
                    double adjust = boxThickness * boxSizeAdjustment;
                    boxGeometry = interumArray;
                    boxGeometry[0].x = 0.0;
                    boxGeometry[0].y = 0.0 - adjust;
                    boxGeometry[1].x = 0.0;
                    boxGeometry[1].y = boxThickness - adjust;
                    boxGeometry[2].x = axisEnd;
                    boxGeometry[2].y = boxThickness - adjust;
                    boxGeometry[3].x = axisEnd;
                    boxGeometry[3].y = 0.0 - adjust;
                    geometry = new Vec3d[][]{boxGeometry};
                    fillStyle = new int[]{1};
                    fillColor = new Color[]{highlightFillColor};
                    Color outline = highlightFillColor;
                    GanttBox.drawBoxes(channel, geometry, fillStyle, fillColor, outline);
                }
            }
            return;
        }
        if (drawBar == 0.0) {
            return;
        }
        if (duration != 0.0) {
            Color userDefinedColor;
            midh = boxThickness;
            midw = 0.0;
            double s1 = earlyStart + midw;
            double s2 = !Double.isNaN(lateFinish) ? lateFinish - midw : 0.0;
            Vec3d[] a = null;
            Vec3d[] boxGeometryEarly = null;
            Vec3d[] boxGeometryInterum = null;
            Vec3d[] boxGeometryLate = null;
            int barType = 1;
            if (!Double.isNaN(lateFinish) || !Double.isNaN(lateStart)) {
                barType = earlyFinish == lateFinish ? 0 : (lateFinish > earlyFinish && lateStart > earlyFinish || lateFinish < earlyFinish && lateStart < earlyFinish ? 2 : 1);
            }
            switch (barType) {
                case 0: {
                    boxGeometryEarly = earlyArray;
                    a = earlyArray;
                    a[0].x = earlyStart;
                    a[0].y = 0.0;
                    a[1].x = earlyStart;
                    a[1].y = boxThickness;
                    a[2].x = s1;
                    a[2].y = midh;
                    a[3].x = s2;
                    a[3].y = midh;
                    a[4].x = earlyFinish;
                    a[4].y = boxThickness;
                    a[5].x = earlyFinish;
                    a[5].y = 0.0;
                    if (!slackTimeVisible) break;
                    normalFillStyle = criticalFillStyle;
                    normalColor = criticalColor;
                    break;
                }
                case 1: {
                    boxGeometryEarly = earlyArray;
                    a = earlyArray;
                    a[0].x = earlyStart;
                    a[0].y = 0.0;
                    a[1].x = earlyStart;
                    a[1].y = boxThickness;
                    a[2].x = s1;
                    a[2].y = midh;
                    a[3].x = earlyFinish;
                    a[3].y = midh;
                    a[4].x = earlyFinish;
                    a[4].y = 0.0;
                    a[5].x = earlyFinish;
                    a[5].y = 0.0;
                    if (Double.isNaN(lateFinish)) break;
                    boxGeometryLate = lateArray;
                    a = lateArray;
                    a[0].x = earlyFinish;
                    a[0].y = 0.0;
                    a[1].x = earlyFinish;
                    a[1].y = midh;
                    a[2].x = s2;
                    a[2].y = midh;
                    a[3].x = lateFinish;
                    a[3].y = boxThickness;
                    a[4].x = lateFinish;
                    a[4].y = 0.0;
                    break;
                }
                case 2: {
                    double indent;
                    boxGeometryEarly = earlyArray;
                    a = earlyArray;
                    a[0].x = earlyStart;
                    a[0].y = 0.0;
                    a[1].x = earlyStart;
                    a[1].y = boxThickness;
                    a[2].x = s1;
                    a[2].y = midh;
                    a[3].x = earlyFinish;
                    a[3].y = midh;
                    a[4].x = earlyFinish;
                    a[4].y = 0.0;
                    a[5].x = earlyFinish;
                    a[5].y = 0.0;
                    switch (boxConnectionStyle) {
                        default: {
                            indent = 0.0;
                            break;
                        }
                        case 2: {
                            indent = midh / 2.0;
                            break;
                        }
                        case 1: {
                            indent = midh / 4.0;
                        }
                    }
                    if (!Double.isNaN(lateStart)) {
                        boxGeometryInterum = interumArray;
                        a = interumArray;
                        a[0].x = earlyFinish;
                        a[0].y = indent;
                        a[1].x = earlyFinish;
                        a[1].y = midh - indent;
                        a[2].x = lateStart;
                        a[2].y = midh - indent;
                        a[3].x = lateStart;
                        a[3].y = indent;
                    }
                    if (Double.isNaN(lateFinish)) break;
                    boxGeometryLate = lateArray;
                    a = lateArray;
                    a[0].x = lateStart;
                    a[0].y = 0.0;
                    a[1].x = lateStart;
                    a[1].y = midh;
                    a[2].x = s2;
                    a[2].y = midh;
                    a[3].x = lateFinish;
                    a[3].y = boxThickness;
                    a[4].x = lateFinish;
                    a[4].y = 0.0;
                }
            }
            if (color != null && (userDefinedColor = SASColors.getInstance().getColor(color.trim())) != null) {
                normalColor = userDefinedColor;
                slackColor = userDefinedColor;
            }
            geometry = new Vec3d[][]{boxGeometryEarly, boxGeometryInterum, boxGeometryLate};
            fillStyle = new int[]{normalFillStyle, slackFillStyle, slackFillStyle};
            fillColor = new Color[]{normalColor, slackColor, slackColor};
            GanttBox.drawBoxes(channel, geometry, fillStyle, fillColor, outlineColor);
            GanttBox.drawBreaks(channel, breaktimeHashMap, geometry, normalFillStyle, boxThickness, breaktimeColor, outlineColor, calendar);
        } else {
            midh = boxThickness - boxThickness / 2.0;
            if (!Double.isNaN(lateFinish)) {
                Vec3d[] boxGeometry = new Vec3d[]{new Vec3d(earlyStart, 0.0, 0.0), new Vec3d(earlyStart, boxThickness, 0.0), new Vec3d(lateFinish, boxThickness, 0.0), new Vec3d(lateFinish, 0.0, 0.0)};
                geometry = new Vec3d[][]{boxGeometry};
            } else {
                Vec3d[] boxGeometry = new Vec3d[]{new Vec3d(earlyStart, 0.0, 0.0), new Vec3d(earlyStart, boxThickness, 0.0)};
                geometry = new Vec3d[][]{boxGeometry};
            }
            fillStyle = new int[]{slackFillStyle};
            fillColor = new Color[]{slackColor};
            GanttBox.drawBoxes(channel, geometry, fillStyle, fillColor, outlineColor);
            GanttBox.drawBreaks(channel, breaktimeHashMap, geometry, normalFillStyle, boxThickness, breaktimeColor, outlineColor, calendar);
            if (milestoneVisible) {
                channel.setMarkerType(milestoneSymbol);
                channel.glColor(milestoneColor);
                channel.glEdgeColor(outlineColor);
                if (milestoneSize == -1.0) {
                    channel.setMarkerSize((int)(boxThickness + boxThickness * 0.25));
                } else {
                    channel.setMarkerSize((int)milestoneSize);
                }
                channel.glBegin(4);
                channel.glVertex(earlyStart, midh);
                if (!Double.isNaN(lateStart)) {
                    channel.glVertex(lateStart, midh);
                }
                channel.glEnd();
            }
        }
        if (!Double.isNaN(target) && target != 0.0 && target != -99.0 && targetVisible) {
            if (highlightOn) {
                outlineColor = highlightEdgeColor;
                targetColor = highlightFillColor;
            }
            channel.setMarkerType(targetSymbol);
            channel.glColor(targetColor);
            channel.glEdgeColor(outlineColor);
            if (targetSize == -1.0) {
                channel.setMarkerSize((int)(boxThickness + boxThickness * 0.25));
            } else {
                channel.setMarkerSize((int)targetSize);
            }
            channel.glBegin(4);
            channel.glVertex(target, boxThickness);
            channel.glEnd();
        }
    }

    private static Bbox determineClipBox(Vec3d[][] geo) {
        float xmin = Float.POSITIVE_INFINITY;
        float xmax = Float.NEGATIVE_INFINITY;
        float ymin = Float.POSITIVE_INFINITY;
        float ymax = Float.NEGATIVE_INFINITY;
        float zmin = 0.0f;
        float zmax = 0.0f;
        for (int ii = 0; geo != null && ii < geo.length; ++ii) {
            for (int jj = 0; geo[ii] != null && jj < geo[ii].length; ++jj) {
                xmin = Math.min((float)geo[ii][jj].x, xmin);
                xmax = Math.max((float)geo[ii][jj].x, xmax);
                ymin = Math.min((float)geo[ii][jj].y, ymin);
                ymax = Math.max((float)geo[ii][jj].y, ymax);
            }
        }
        return new Bbox(xmin, ymin, zmin, xmax, ymax, zmax);
    }

    private static void drawBreaks(Channel channel, HashMap breaktimeHashMap, Vec3d[][] geo, int fillStyle, double thickness, Color color, Color outline, String cal) {
        if (cal != null && breaktimeHashMap != null && !breaktimeHashMap.isEmpty()) {
            ArrayList dates = null;
            dates = cal.trim().length() == 0 ? (ArrayList)breaktimeHashMap.get("DEFAULT") : (ArrayList)breaktimeHashMap.get(cal);
            if (dates != null) {
                Bbox clipBox = GanttBox.determineClipBox(geo);
                channel.setClipBounds(clipBox);
                GanttBox.drawBreaktimeBox(channel, dates, fillStyle, thickness, color, outline, clipBox);
                channel.setClipBounds(null);
            }
        }
    }

    private static void drawBreaktimeBox(Channel channel, ArrayList dates, int fill, double boxThickness, Color boxColor, Color outlineColor, Bbox clipBox) {
        if (dates != null && !dates.isEmpty()) {
            for (int ii = 0; ii < dates.size(); ++ii) {
                ComplexGanttBox.StartFinish startFinishPair = (ComplexGanttBox.StartFinish)dates.get(ii);
                double start = Math.max(startFinishPair.start, clipBox.xmin);
                double finish = Math.min(startFinishPair.finish, clipBox.xmax);
                Vec3d[] boxGeometry = new Vec3d[]{new Vec3d(start, 0.0, 0.0), new Vec3d(start, boxThickness, 0.0), new Vec3d(finish, boxThickness, 0.0), new Vec3d(finish, 0.0, 0.0)};
                Vec3d[][] geometry = new Vec3d[][]{boxGeometry};
                int[] fillStyle = new int[]{fill};
                Color[] fillColor = new Color[]{boxColor};
                GanttBox.drawBoxes(channel, geometry, fillStyle, fillColor, outlineColor);
            }
        }
    }

    private static void drawBoxes(Channel channel, Vec3d[][] geometry, int[] fillStyle, Color[] fillColor, Color outlineColor) {
        for (int ii = 0; ii < geometry.length; ++ii) {
            if (geometry[ii] == null) continue;
            channel.glColor(fillColor[ii]);
            channel.glEdgeColor(outlineColor);
            switch (fillStyle[ii]) {
                case -1: {
                    channel.glPolygonMode(5);
                    break;
                }
                case 1: {
                    channel.glPolygonMode(3);
                    break;
                }
                case 2: {
                    channel.glPolygonMode(4);
                    break;
                }
                case 0: {
                    channel.glColor(outlineColor);
                    channel.glPolygonMode(2);
                }
            }
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            int size = geometry[ii].length;
            for (int jj = 0; jj < size; ++jj) {
                Vec3d p = geometry[ii][jj];
                channel.glVertex(p.x, p.y);
            }
            channel.glEnd();
        }
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int index = ba.getValueIndex();
        double targetValue = Double.NaN;
        try {
            targetValue = this.target.getValue(index);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        double durationValue = Double.NaN;
        try {
            durationValue = this.duration.getValue(index);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        String calendarValue = null;
        try {
            calendarValue = this.calendar.getValue(index);
        }
        catch (MissingValueException e) {
            calendarValue = " ";
        }
        double lateStartValue = Double.NaN;
        try {
            lateStartValue = this.lateStart.getValue(index);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        double lateFinishValue = Double.NaN;
        try {
            lateFinishValue = this.lateFinish.getValue(index);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        String colorValue = null;
        try {
            colorValue = this.color.getValue(index);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        String taskValue = null;
        try {
            taskValue = this.task.getValue(index);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        int xEndPoint = 0;
        try {
            xEndPoint = this.xEnd.getValue(index);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        GanttBox.drawElement(channel, this.earlyStart.getValue(index), this.earlyFinish.getValue(index), lateStartValue, lateFinishValue, durationValue, targetValue, this.boxStyle.getValue(index), this.boxConnectionStyle.getValue(index), this.boxThickness.getValue(index), this.boxSizeAdjustment.getValue(index), this.normalColor.getValue(index), this.slackColor.getValue(index), this.criticalColor.getValue(index), this.outlineColor.getValue(index), this.criticalFillStyle.getValue(index), this.normalFillStyle.getValue(index), this.slackFillStyle.getValue(index), this.milestoneColor.getValue(index), this.milestoneSymbol.getValue(index), this.milestoneSize.getValue(index), this.milestoneVisible.getValue(index), this.targetColor.getValue(index), this.targetSymbol.getValue(index), this.targetSize.getValue(index), this.targetVisible.getValue(index), colorValue, this.highlightOn.getValue(index), this.highlightFillColor.getValue(index), this.highlightEdgeColor.getValue(index), this.drawBar.getValue(index), taskValue, xEndPoint, calendarValue, this.breaktimeColor.getValue(index), this.breaktimeHashMap, this.slackTimeVisible.getValue(index));
    }

    @Override
    protected void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
    }
}

