/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ALabel;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKAPie;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.GTKPieSelectDetail;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.GTKLogEvent;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.Transform;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import javax.swing.ImageIcon;

public class GTKPie
extends GTKAPie {
    private static final Integer sliceDetail = new Integer(0);
    public final StringProperty category = new StringProperty(this, false);
    public final StringProperty subgroup = new StringProperty(this, false);
    public final NumericProperty response = new NumericProperty(this, false);
    public final ColorProperty color = new ColorProperty(this, false);
    public final StringProperty explode = new StringProperty(this, false);
    public final StringProperty visible = new StringProperty(this, false);
    private ArrayList<Slice> slices;
    private ArrayList<Slice> visibleSlices = new ArrayList();
    private ArrayList<DisplaySlice> displaySlices;
    private StringToColorMap colorMap;
    private ArrayList<Double> subGroupTotalResponsesList = new ArrayList();
    private double totalValueForAllGroups;
    private double totalValue;
    public final StringPipe processedCategory = new ProcessedCategory(this);
    public final StringPipe processedSubgroup = new ProcessedSubgroup();
    public final NumericPipe processedResponse = new ProcessedResponse();
    private int subgroupCount;
    private double subLabelBoxHeight = 0.0;
    private boolean showSubLabels = false;
    private static final double DEFAULT_SUBGROUP_LINE_SPACE = 1.0;
    private double lineSpace = 1.0;
    private Channel channel = null;
    private StringVector subgroupUniqueValues;
    private BufferedImage[] texImage;
    private Vec3d labelPosition = new Vec3d();
    private Vec3d wayOutZ = new Vec3d(0.0, 0.0, 500.0);
    private int scaledSliceLabelFontSize = 0;
    private int scaledResponseLabelFontSize = 0;
    private int scaledSubgroupLabelFontSize = 0;
    private int scaledSubgroupTitleFontSize = 0;
    private int fixedSliceLabelFontSize = -1;
    private int fixedResponseLabelFontSize = -1;
    private int fixedSubgroupLabelFontSize = -1;
    private int fixedSubgroupTitleFontSize = -1;
    private double scaledRadius = 0.0;
    private double fixedRadius = 0.0;
    private String actualResponseLabel = "";
    private HashMap<String, String> subToFmtHash = null;
    double maxSubLabelBoxHeight = 200.0;
    private String wideLabel = "W";
    private double wideLabelWidthOverhang = 0.0;
    private double wideLabelHeight = 0.0;
    private ImageIcon skin = null;
    private int skinBorderGap = 9;
    private BufferedImage pieSizedImage = null;
    private int scaledSize;
    private static final double WEE_HAIR = 0.5;
    private static final double MIN_FONT_SIZE = 9.0;
    private static final int TITLE_MARKER_WIDTH_ADD = 12;
    private static final int TITLE_MARKER_HEIGHT = 12;
    private static final int MINIMUM_RADIUS = 8;
    private static final int ARROW_SPACE = 3;
    private static final int MARGIN = 10;

    public GTKPie() {
        super(new Transform());
        this.category.setValue("category");
        this.subgroup.setValue("subgroup");
        this.response.setValue(1.0);
        this.explode.setValue("");
        this.visible.setValue("");
    }

    public void setTextureImage(BufferedImage[] newImage) {
        this.texImage = newImage;
    }

    public BufferedImage[] getTextureImage() {
        return this.texImage;
    }

    public void setSkin(ImageIcon newImage) {
        this.skin = newImage;
    }

    public ImageIcon getSkin() {
        return this.skin;
    }

    public int getVisibleSliceCount() {
        if (this.displaySlices != null) {
            return this.displaySlices.size();
        }
        return 0;
    }

    @Override
    public void init(AInitAction ia) {
        ia.setAnimationInitRequired(true);
        ia.pushValueCount();
        this.explode.init(ia);
        ia.popValueCount();
        ia.pushValueCount();
        this.visible.init(ia);
        ia.popValueCount();
        ia.pushValueCount();
        this.color.init(ia);
        ia.popValueCount();
        if (this.renderer.getModel().isSectorPie() && this.renderer.getModel().getSubgroupVariable() != null && this.renderer.getModel().isSubgroupStacked()) {
            this.buildSectorPie(ia);
            this.colorMap.init(ia);
            this.applyColorForSectorPie(ia);
        } else {
            this.buildPie(ia);
            this.colorMap.init(ia);
            this.applyColor();
        }
        ia.setAnimationInitRequired(false);
    }

    public void setColorMap(StringToColorMap map) {
        this.colorMap = map;
    }

    private void buildPie(AInitAction ia) {
        ia.pushValueCount();
        ia.setCategoryRequest(true);
        this.category.init(ia);
        if (this.subgroup.isConnected()) {
            ia.setCategoryRequest(true);
            this.subgroup.init(ia);
            this.subgroupUniqueValues = (StringVector)ia.getUniqueValueVector();
        } else {
            this.subgroupUniqueValues = new StringVector();
            this.subgroupUniqueValues.addValue(this.subgroup.getValue());
        }
        ia.setCategoryRequest(false);
        this.response.init(ia);
        int valueCount = ia.getValueCount();
        this.highlightFillColor.init(ia);
        this.highlightEdgeColor.init(ia);
        this.highlightOn.init(ia);
        this.highlightPercentage.init(ia);
        ia.popValueCount();
        if (ia.beenInitialized(this)) {
            return;
        }
        this.totalValue = 0.0;
        this.subgroupCount = this.subgroupUniqueValues.size();
        this.displaySlices = new ArrayList();
        StringVector realSUV = new StringVector();
        for (int si = 0; si < this.subgroupCount; ++si) {
            String s;
            int curOb;
            String currentSubgroup;
            this.totalValue = 0.0;
            try {
                currentSubgroup = this.subgroupUniqueValues.getValue(si);
            }
            catch (MissingValueException e) {
                currentSubgroup = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
            }
            ArrayList<Double> negativeResponse = new ArrayList<Double>();
            for (curOb = 0; curOb < valueCount; ++curOb) {
                try {
                    s = this.subgroup.getValue(curOb);
                }
                catch (MissingValueException e) {
                    s = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
                }
                if (!s.equals(currentSubgroup)) continue;
                double value = 0.0;
                try {
                    value = this.response.getValue(curOb);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                if (value > 0.0) {
                    this.totalValue += value;
                    continue;
                }
                negativeResponse.add(value);
            }
            if (negativeResponse.size() > 0) {
                Object[] values = negativeResponse.toArray();
                GTKLogEvent evt = new GTKLogEvent(GTKLogEvent.LOG_TYPE.NEGATIVE_RESPONSE, values);
                this.renderer.addLogEvent(evt);
            }
            if (!(this.totalValue > 0.0)) continue;
            realSUV.addValue(currentSubgroup);
            this.slices = new ArrayList();
            for (curOb = 0; curOb < valueCount; ++curOb) {
                String c = null;
                try {
                    s = this.subgroup.getValue(curOb);
                }
                catch (MissingValueException e) {
                    s = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
                }
                try {
                    if (!s.equals(currentSubgroup)) continue;
                    try {
                        c = this.category.getValue(curOb);
                    }
                    catch (MissingValueException e) {
                        c = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
                    }
                    double r = this.response.getValue(curOb);
                    Formatter form = this.response.getFormatter();
                    if (this.subToFmtHash != null && !this.subToFmtHash.isEmpty() && this.subToFmtHash.containsKey(currentSubgroup)) {
                        form = new Formatter(new GTKFormat((Format)SASFormat.getInstance((String)this.subToFmtHash.get(currentSubgroup))));
                    }
                    if (!((r = Math.max(0.0, r)) > 0.0)) continue;
                    Slice thisSlice = new Slice(r, this.totalValue, c, "", "", s, null, this.highlightOn.getValue(curOb), this.highlightPercentage.getValue(curOb), curOb, false);
                    this.slices.add(thisSlice);
                    this.setSliceLabels(thisSlice, c, r, this.totalValue, form);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            this.visibleSlices.addAll(this.slices);
            this.slices.clear();
            int order = this.getSliceOrder();
            int direction = this.getSliceDirection();
            this.orderSlices(order);
            double otherThresholdPct = this.getOtherThresholdPct();
            int otherThresholdNum = this.getOtherThresholdNum();
            this.createOtherSlice(otherThresholdPct, otherThresholdNum);
            this.positionSlices(direction, null, si);
            this.visibleSlices.clear();
        }
        this.subgroupCount = realSUV.size();
        this.subgroupUniqueValues = realSUV;
        this.scaledRadius = this.calculateRadius(ia);
    }

    private void applyColor() {
        for (Slice slice : this.displaySlices) {
            String s = slice.categoryName;
            slice.fill = slice.isOther ? this.getOtherColor() : this.colorMap.getValue(s);
        }
    }

    private void buildSectorPie(AInitAction ia) {
        boolean DEBUG = false;
        ia.pushValueCount();
        ia.setCategoryRequest(true);
        this.category.init(ia);
        if (this.subgroup.isConnected()) {
            ia.setCategoryRequest(true);
            this.subgroup.init(ia);
            this.subgroupUniqueValues = (StringVector)ia.getUniqueValueVector();
        } else {
            this.subgroupUniqueValues = new StringVector();
            this.subgroupUniqueValues.addValue(this.subgroup.getValue());
        }
        ia.setCategoryRequest(false);
        this.response.init(ia);
        int valueCount = ia.getValueCount();
        this.highlightFillColor.init(ia);
        this.highlightEdgeColor.init(ia);
        this.highlightOn.init(ia);
        this.highlightPercentage.init(ia);
        ia.popValueCount();
        if (ia.beenInitialized(this)) {
            return;
        }
        this.subgroupCount = this.subgroupUniqueValues.size();
        this.displaySlices = new ArrayList();
        StringVector realSUV = new StringVector();
        this.totalValueForAllGroups = this.getTotalValueOfAllResponses(valueCount);
        this.slices = new ArrayList();
        double totalResponseForSubGroup = 0.0;
        for (int si = 0; si < this.subgroupCount; ++si) {
            String currentSubgroup;
            totalResponseForSubGroup = 0.0;
            try {
                currentSubgroup = this.subgroupUniqueValues.getValue(si);
            }
            catch (MissingValueException e) {
                currentSubgroup = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
            }
            if (!(this.totalValueForAllGroups > 0.0)) continue;
            realSUV.addValue(currentSubgroup);
            if (DEBUG) {
                System.out.println("=======================================================");
            }
            if (DEBUG) {
                System.out.println("total across groups: " + this.totalValueForAllGroups);
            }
            for (int curOb = 0; curOb < valueCount; ++curOb) {
                String s;
                String c = null;
                try {
                    s = this.subgroup.getValue(curOb);
                }
                catch (MissingValueException e) {
                    s = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
                }
                if (!s.equals(currentSubgroup)) continue;
                try {
                    c = this.category.getValue(curOb);
                }
                catch (MissingValueException e) {
                    c = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
                }
                try {
                    double r = this.response.getValue(curOb);
                    r = Math.max(0.0, r);
                    if (!(r > 0.0)) continue;
                    Slice thisSlice = new Slice(r, this.totalValueForAllGroups, c, "", "", s, null, this.highlightOn.getValue(curOb), this.highlightPercentage.getValue(curOb), curOb, false);
                    this.slices.add(thisSlice);
                    totalResponseForSubGroup += r;
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            this.subGroupTotalResponsesList.add(totalResponseForSubGroup);
            if (DEBUG) {
                System.out.println("Before ordering");
                System.out.println(this.slices);
            }
            if (DEBUG) {
                System.out.println("After ordering calcs");
                System.out.println(this.visibleSlices);
            }
            if (!DEBUG) continue;
            System.out.println("After other calcs");
            System.out.println(this.visibleSlices);
        }
        this.visibleSlices.addAll(this.slices);
        this.buildSectorPieSliceLabels();
        ArrayList<Slice> outerGroupsRingList = this.getSlicesForOuterGroupsRing(valueCount);
        int order = this.getSliceOrder();
        this.orderSlices(order);
        this.slices.clear();
        int direction = this.getSliceDirection();
        this.positionSlices(direction, outerGroupsRingList, 0);
        this.visibleSlices.clear();
        if (DEBUG) {
            System.out.println("After positioning -- all subgroups");
            System.out.println(this.displaySlices);
        }
        this.subgroupCount = realSUV.size();
        this.subgroupUniqueValues = realSUV;
        this.scaledRadius = this.calculateRadius(ia);
    }

    private void buildSectorPieSliceLabels() {
        Formatter form = this.response.getFormatter();
        for (int i = 0; i < this.subgroupCount; ++i) {
            String currentSubgroup;
            try {
                currentSubgroup = this.subgroupUniqueValues.getValue(i);
            }
            catch (MissingValueException e) {
                currentSubgroup = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
            }
            for (Slice eachSlice : this.visibleSlices) {
                String eachSliceGroup = eachSlice.subgroup;
                if (!currentSubgroup.equals(eachSliceGroup)) continue;
                double eachSliceResponse = eachSlice.value;
                String eachSliceCategory = eachSlice.categoryName;
                if (this.subToFmtHash != null && !this.subToFmtHash.isEmpty() && this.subToFmtHash.containsKey(currentSubgroup)) {
                    form = new Formatter(new GTKFormat((Format)SASFormat.getInstance((String)this.subToFmtHash.get(currentSubgroup))));
                }
                double eachSubgroupTotal = this.subGroupTotalResponsesList.get(i);
                this.setSliceLabels(eachSlice, eachSliceCategory, eachSliceResponse, eachSubgroupTotal, form);
            }
        }
    }

    private void setSliceLabels(Slice thisSlice, String category, double response, double total, Formatter form) {
        form = form.getMaxWidthFormatter();
        String insideLabel = "";
        if (this.insideLabelContent == 10602 || this.insideLabelContent == 10609 || this.insideLabelContent == 10610 || this.insideLabelContent == 10611) {
            insideLabel = insideLabel + category.trim();
        }
        if (this.insideLabelContent == 10603 || this.insideLabelContent == 10609 || this.insideLabelContent == 10612 || this.insideLabelContent == 10611) {
            insideLabel = insideLabel + (insideLabel.length() == 0 ? "" : "\n") + form.format(new Double(response)).trim();
        }
        if (this.insideLabelContent == 10608 || this.insideLabelContent == 10610 || this.insideLabelContent == 10612 || this.insideLabelContent == 10611) {
            insideLabel = insideLabel + (insideLabel.length() == 0 ? "" : "\n") + this.percentFormat.format(new Double(response / total));
        }
        String outsideLabel = "";
        if (this.outsideLabelContent == 10602 || this.outsideLabelContent == 10609 || this.outsideLabelContent == 10610 || this.outsideLabelContent == 10611) {
            outsideLabel = outsideLabel + category.trim();
        }
        if (this.outsideLabelContent == 10603 || this.outsideLabelContent == 10609 || this.outsideLabelContent == 10612 || this.outsideLabelContent == 10611) {
            outsideLabel = outsideLabel + (outsideLabel.length() == 0 ? "" : "\n") + form.format(new Double(response)).trim();
        }
        if (this.outsideLabelContent == 10608 || this.outsideLabelContent == 10610 || this.outsideLabelContent == 10612 || this.outsideLabelContent == 10611) {
            outsideLabel = outsideLabel + (outsideLabel.length() == 0 ? "" : "\n") + this.percentFormat.format(new Double(response / total));
        }
        thisSlice.insideLabel = insideLabel;
        thisSlice.outsideLabel = outsideLabel;
    }

    private ArrayList<Slice> getSlicesForOuterGroupsRing(int valueCountIndex) {
        ArrayList<Slice> outerGroupsRingList = new ArrayList<Slice>();
        for (int i = 0; i < this.subgroupCount; ++i) {
            String currentSubgroup;
            try {
                currentSubgroup = this.subgroupUniqueValues.getValue(i);
            }
            catch (MissingValueException e) {
                currentSubgroup = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
            }
            double eachSubgroupResponse = this.subGroupTotalResponsesList.get(i);
            try {
                Slice thisSlice = new Slice(eachSubgroupResponse, this.totalValueForAllGroups, currentSubgroup, "", "", currentSubgroup, null, this.highlightOn.getValue(valueCountIndex + i), this.highlightPercentage.getValue(valueCountIndex + i), valueCountIndex + i, true);
                outerGroupsRingList.add(thisSlice);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return outerGroupsRingList;
    }

    private double getTotalValueOfAllResponses(int valueCount) {
        double totalValue = 0.0;
        double eachValue = 0.0;
        ArrayList<Double> negativeResponseList = new ArrayList<Double>();
        for (int i = 0; i < valueCount; ++i) {
            try {
                eachValue = this.response.getValue(i);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            if (eachValue > 0.0) {
                totalValue += eachValue;
                continue;
            }
            negativeResponseList.add(eachValue);
        }
        if (negativeResponseList.size() > 0) {
            Object[] negativeResponseArray = negativeResponseList.toArray();
            GTKLogEvent evt = new GTKLogEvent(GTKLogEvent.LOG_TYPE.NEGATIVE_RESPONSE, negativeResponseArray);
            this.renderer.addLogEvent(evt);
        }
        return totalValue;
    }

    private void applyColorForSectorPie(AInitAction ia) {
        DisplaySlice eachDisplaySlice;
        Color[] twoColorAltRampArray = this.renderer.getModel().getTwoColorAltRampColorArray();
        Color startColor = twoColorAltRampArray[0];
        Color endColor = twoColorAltRampArray[1];
        int displaySlicesSize = this.displaySlices.size();
        int groupSlicesCount = this.renderer.getModel().getSubgroupVariable().getUniqueValueCount();
        int categorySlicesCount = displaySlicesSize - groupSlicesCount;
        Color[] gradientColors = this.getGradientColors(startColor, endColor, categorySlicesCount);
        for (int i = 0; i < categorySlicesCount; ++i) {
            eachDisplaySlice = this.displaySlices.get(i);
            eachDisplaySlice.fill = gradientColors[i];
        }
        for (int i = categorySlicesCount; i < displaySlicesSize; ++i) {
            Color eachSubgroupColor;
            eachDisplaySlice = this.displaySlices.get(i);
            if (!eachDisplaySlice.isSubGroupSlice) continue;
            String eachSubgroup = eachDisplaySlice.subgroup;
            eachDisplaySlice.fill = eachSubgroupColor = this.colorMap.getValue(eachSubgroup);
        }
    }

    private Color[] getGradientColors(Color startColor, Color endColor, int numOfSteps) {
        Color[] gradientColors = new Color[numOfSteps];
        gradientColors[0] = startColor;
        if (numOfSteps == 2) {
            gradientColors[1] = endColor;
            return gradientColors;
        }
        gradientColors[numOfSteps - 1] = endColor;
        int startColorRed = startColor.getRed();
        int startColorGreen = startColor.getGreen();
        int startColorBlue = startColor.getBlue();
        int endColorRed = endColor.getRed();
        int endColorGreen = endColor.getGreen();
        int endColorBlue = endColor.getBlue();
        for (int i = 1; i < numOfSteps - 1; ++i) {
            Color c;
            double interpolationFactor = (double)i / (double)numOfSteps;
            int red = (int)((double)(endColorRed - startColorRed) * interpolationFactor + (double)startColorRed);
            int green = (int)((double)(endColorGreen - startColorGreen) * interpolationFactor + (double)startColorGreen);
            int blue = (int)((double)(endColorBlue - startColorBlue) * interpolationFactor + (double)startColorBlue);
            gradientColors[i] = c = new Color(red, green, blue);
        }
        return gradientColors;
    }

    private double calculateRadiusForGTL(AInitAction ia) {
        Dimension size = this.getSize();
        if (size.width <= 0 || size.height <= 0) {
            return 0.0;
        }
        this.channel = InitAction.castInitAction(ia).getChannel();
        int margin = 1;
        Dimension gridLayout = this.getGridLayout();
        double width = size.width - margin * 2;
        double height = size.height - margin * 2;
        if (this.renderer.getModel().isSectorPie()) {
            double scaledReduction = (double)(this.skinBorderGap * 2) * width / (double)this.skinWidth;
            width -= scaledReduction;
            scaledReduction = (double)(this.skinBorderGap * 2) * width / (double)this.skinHeight;
            height -= scaledReduction;
        }
        double radius = Math.min(width / (double)gridLayout.width, height / (double)gridLayout.height) / 2.0;
        double lineWidthMargin = this.outlineWidth / 2;
        if (this.getOutsideLabelContent() != 10601) {
            this.scaledSliceLabelFontSize = this.getOutsideLabelStyle().getFont().getSize();
        } else if (this.getInsideLabelContent() != 10601) {
            this.scaledSliceLabelFontSize = this.getInsideLabelStyle().getFont().getSize();
        }
        if (this.subgroupCount > 1) {
            if (this.getSubgroupLabelPlacement() == 6) {
                return radius - lineWidthMargin;
            }
            String subStr = "";
            this.channel.glSelect2DFont(this.getSubgroupTitleStyle().getFont());
            double subgroupLabelWidth = this.channel.glGetTextWidth(this.getSubgroupTitle());
            String longestSubgroupLabel = this.getSubgroupTitle();
            double subgroupTitleHeight = this.channel.glGetTextHeight(this.getSubgroupTitle());
            this.channel.glSelect2DFont(this.getSubgroupLabelStyle().getFont());
            for (int ii = 0; ii < this.subgroupCount; ++ii) {
                try {
                    subStr = this.subgroupUniqueValues.getValue(ii);
                }
                catch (MissingValueException e) {
                    subStr = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
                }
                double subValWidth = this.channel.glGetTextWidth(subStr);
                if (!(subValWidth > subgroupLabelWidth)) continue;
                subgroupLabelWidth = Math.max(subgroupLabelWidth, subValWidth);
                longestSubgroupLabel = subStr;
            }
            int curFontSize = this.getSubgroupLabelStyle().getFont().getSize();
            this.maxSubLabelBoxHeight = height / (double)gridLayout.height * 0.8;
            this.channel.glSelect2DFont(this.getSubgroupLabelStyle().getFont().deriveFont(this.fixedResponseLabelFontSize >= 0 ? (float)this.fixedResponseLabelFontSize : (float)this.scaledResponseLabelFontSize));
            double proposedWidthRadius = (width / (double)gridLayout.width - (subgroupLabelWidth += 18.0)) / 2.0;
            this.channel.glSelect2DFont(this.getSubgroupLabelStyle().getFont().deriveFont((float)curFontSize));
            subgroupLabelWidth = this.channel.glGetTextWidth(longestSubgroupLabel);
            this.wideLabelHeight = this.channel.glGetTextHeight(longestSubgroupLabel) * 1.5;
            this.scaledSubgroupLabelFontSize = curFontSize;
            this.scaledSubgroupTitleFontSize = this.getSubgroupTitleStyle().getFont().getSize();
            if (this.isTitleMarkerVisible()) {
                subgroupLabelWidth += 12.0;
                subgroupTitleHeight = Math.max(subgroupTitleHeight, 12.0);
            }
            double subgroupLabelHeight = subgroupTitleHeight = this.channel.glGetTextHeight(subStr);
            this.subLabelBoxHeight = subgroupTitleHeight + subgroupLabelHeight * this.lineSpace * (double)(this.subgroupCount - 1);
            double heightRadius = height / (double)gridLayout.height / 2.0;
            return Math.min(proposedWidthRadius, heightRadius) - lineWidthMargin;
        }
        this.actualResponseLabel = this.truncateString(this.getResponseLabel(), size.width / gridLayout.width - 2);
        this.scaledResponseLabelFontSize = this.getResponseTitleStyle().getFont().getSize();
        if (this.getOutsideLabelContent() == 10601 && (this.getInsideLabelContent() == 10601 || this.getInsideLabelPlacement() != 5)) {
            if (this.getExplodeArray().length > 0 || this.isExplodingOtherSlice()) {
                return radius * 0.8 - lineWidthMargin;
            }
            return radius - lineWidthMargin;
        }
        if (this.getOutsideLabelContent() == 10601 && this.getInsideLabelPlacement() == 5 && (radius = this.radiusForBestFit(radius) - lineWidthMargin) > 0.0) {
            return radius;
        }
        return this.calculateRadiusForBIP(ia);
    }

    private double calculateRadius(AInitAction ia) {
        return this.calculateRadiusForGTL(ia);
    }

    private double calculateRadiusForBIP(AInitAction ia) {
        int curFontSize = 12;
        this.wideLabelWidthOverhang = 0.0;
        this.wideLabelHeight = 0.0;
        this.channel = InitAction.castInitAction(ia).getChannel();
        Dimension size = this.getSize();
        if (size.width <= 0 || size.height <= 0) {
            return 0.0;
        }
        int margin = 10;
        int smallerDim = Math.min(size.width, size.height);
        if (smallerDim < 200) {
            margin = smallerDim / 20;
        }
        Dimension gridLayout = this.getGridLayout();
        double width = size.width - margin * 2;
        double height = size.height - margin * 2;
        double lrSpace = 0.0;
        double radius = Math.min(width / (double)gridLayout.width, height / (double)gridLayout.height) / 2.0;
        radius -= Math.min(8.0, radius * 0.25);
        lrSpace = (double)(size.width / gridLayout.width / 2) - radius;
        curFontSize = this.getResponseTitleStyle().getFont().getSize();
        while (true) {
            this.channel.glSelect2DFont(this.getResponseTitleStyle().getFont().deriveFont((float)curFontSize));
            this.wideLabelWidthOverhang = this.channel.glGetTextWidth(this.getResponseLabel());
            this.wideLabelHeight = this.channel.glGetTextHeight(this.getResponseLabel());
            if (!this.isShrinkableFonts() || (double)curFontSize < 9.0 || this.wideLabelWidthOverhang < width / (double)gridLayout.width && this.wideLabelHeight < (double)(size.height / gridLayout.height / 8)) break;
            if (!((double)(--curFontSize) < 9.0) || !(this.wideLabelHeight > (double)(size.height / 5))) continue;
            curFontSize = 0;
        }
        this.scaledResponseLabelFontSize = curFontSize;
        this.actualResponseLabel = this.truncateString(this.getResponseLabel(), size.width / gridLayout.width - 2);
        if (this.subgroupCount > 1) {
            String subStr = "";
            this.channel.glSelect2DFont(this.getSubgroupTitleStyle().getFont());
            double subgroupLabelWidth = this.channel.glGetTextWidth(this.getSubgroupTitle());
            String longestSubgroupLabel = this.getSubgroupTitle();
            double subgroupTitleHeight = this.channel.glGetTextHeight(this.getSubgroupTitle());
            this.channel.glSelect2DFont(this.getSubgroupLabelStyle().getFont());
            for (int ii = 0; ii < this.subgroupCount; ++ii) {
                try {
                    subStr = this.subgroupUniqueValues.getValue(ii);
                }
                catch (MissingValueException e) {
                    subStr = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
                }
                double subValWidth = this.channel.glGetTextWidth(subStr);
                if (!(subValWidth > subgroupLabelWidth)) continue;
                subgroupLabelWidth = Math.max(subgroupLabelWidth, subValWidth);
                longestSubgroupLabel = subStr;
            }
            curFontSize = this.getSubgroupLabelStyle().getFont().getSize();
            this.maxSubLabelBoxHeight = height / (double)gridLayout.height * (this.isTwoD() ? 0.8 : 0.75);
            this.channel.glSelect2DFont(this.getSubgroupLabelStyle().getFont().deriveFont(this.fixedResponseLabelFontSize >= 0 ? (float)this.fixedResponseLabelFontSize : (float)this.scaledResponseLabelFontSize));
            double proposedWidthRadius = (width / (double)gridLayout.width - (subgroupLabelWidth += 12.0)) / 2.0;
            double proposedLabelSpace = subgroupLabelWidth;
            radius = Math.max(proposedWidthRadius, 8.0);
            lrSpace = proposedLabelSpace;
            while (true) {
                this.channel.glSelect2DFont(this.getSubgroupLabelStyle().getFont().deriveFont((float)curFontSize));
                subgroupLabelWidth = this.channel.glGetTextWidth(longestSubgroupLabel);
                this.wideLabelHeight = this.channel.glGetTextHeight(longestSubgroupLabel) * 1.5;
                if (!this.isShrinkableFonts() || (double)curFontSize < 9.0 || subgroupLabelWidth < width / (double)gridLayout.width / 2.5 && this.wideLabelHeight * this.lineSpace * (double)(this.subgroupCount + 2) < this.maxSubLabelBoxHeight) break;
                --curFontSize;
            }
            this.scaledSliceLabelFontSize = curFontSize;
            this.scaledSubgroupLabelFontSize = curFontSize;
            if (this.getSubgroupLabelStyle().getFont().getSize() > this.scaledSubgroupLabelFontSize) {
                this.scaledSubgroupTitleFontSize = this.scaledSubgroupLabelFontSize;
            }
            if (this.isTitleMarkerVisible()) {
                subgroupLabelWidth += 12.0;
                subgroupTitleHeight = Math.max(subgroupTitleHeight, 12.0);
            }
            double subgroupLabelHeight = subgroupTitleHeight = this.channel.glGetTextHeight(subStr);
            this.subLabelBoxHeight = subgroupTitleHeight + subgroupLabelHeight * this.lineSpace * (double)(this.subgroupCount - 1);
            double proposedHeightRadius = Math.min(height / (double)gridLayout.height, this.maxSubLabelBoxHeight / 2.0);
            if (this.wideLabelHeight > (radius = Math.max(Math.min(radius, proposedHeightRadius), 8.0)) || radius < 24.0) {
                curFontSize = 0;
                this.wideLabelHeight = 0.0;
            }
            this.scaledSubgroupLabelFontSize = curFontSize;
            this.scaledSubgroupTitleFontSize = curFontSize;
            if (curFontSize == 0) {
                radius = width / 2.1;
            }
            radius = this.scaledSubgroupLabelFontSize == 0 && this.scaledSubgroupTitleFontSize == 0 ? Math.max(Math.min(radius, proposedHeightRadius), 8.0) : (radius < proposedHeightRadius ? (radius *= (double)gridLayout.width) : proposedHeightRadius * (double)gridLayout.width);
            radius = Math.max(radius, 8.0);
        } else if (this.getOutsideLabelContent() != 10601 || this.getInsideLabelContent() != 10601 && this.getInsideLabelPlacement() == 5) {
            Font baseLabelFont = this.getOutsideLabelContent() != 10601 ? this.getOutsideLabelStyle().getFont() : this.getInsideLabelStyle().getFont();
            curFontSize = baseLabelFont.getSize();
            this.wideLabelWidthOverhang = this.outsideLabelOverhang(radius, curFontSize);
            double proposedWidthRadius = width / (double)gridLayout.width / 2.0 - this.wideLabelWidthOverhang;
            double proposedLRSpace = this.wideLabelWidthOverhang + 5.0;
            if (this.getOutsideLabelPlacement() == 1) {
                proposedLRSpace += 12.0;
                proposedWidthRadius -= 12.0;
            }
            if (proposedWidthRadius < Math.max(8.0, proposedLRSpace / 3.0)) {
                radius = width / (double)gridLayout.width / 2.0;
                lrSpace = 0.0;
                curFontSize = 0;
            } else {
                radius = proposedWidthRadius;
                lrSpace = proposedLRSpace;
            }
            while (true) {
                this.wideLabelWidthOverhang = this.outsideLabelOverhang(radius, curFontSize);
                this.wideLabelHeight = this.channel.glGetTextHeight(this.wideLabel);
                if (!this.isShrinkableFonts() || (double)curFontSize < 9.0 || this.wideLabelWidthOverhang <= lrSpace || this.wideLabelHeight < height / 5.0) break;
                if (!((double)(--curFontSize) < 9.0)) continue;
                curFontSize = 0;
            }
            if (curFontSize == 0 || Math.min(radius, proposedWidthRadius) < 24.0) {
                radius = width / (double)gridLayout.width / 2.0;
                proposedWidthRadius = width / (double)gridLayout.width / 2.0;
                lrSpace = 0.0;
                curFontSize = 0;
            }
            double responseLabelAdjust = 0.0;
            if (gridLayout.getWidth() > 1.0 || gridLayout.getHeight() > 1.0) {
                responseLabelAdjust = Math.max(this.wideLabelHeight, 2.0) * 2.0;
            }
            double proposedHeightRadius = height / (double)gridLayout.height - responseLabelAdjust;
            if (gridLayout.getWidth() == 1.0 && gridLayout.getHeight() == 1.0) {
                proposedHeightRadius = proposedHeightRadius / 2.0 - this.wideLabelHeight;
                if (curFontSize == 0 || Math.min(radius, proposedHeightRadius) < 24.0) {
                    proposedHeightRadius += this.wideLabelHeight;
                }
            }
            if (!this.isTwoD()) {
                proposedHeightRadius *= 0.75;
            }
            radius = radius < proposedHeightRadius ? (radius *= (double)gridLayout.width) : proposedHeightRadius * (double)gridLayout.height;
            if (this.wideLabelHeight > radius || radius < 24.0) {
                curFontSize = 0;
                this.wideLabelHeight = 0.0;
                radius = width / (double)gridLayout.width / 2.0;
                proposedWidthRadius = width / (double)gridLayout.width / 2.0;
                proposedHeightRadius = height / (double)gridLayout.width / 2.0;
                lrSpace = 0.0;
            }
            radius = Math.min(radius, proposedHeightRadius);
            this.scaledSliceLabelFontSize = curFontSize;
        } else {
            radius *= (double)gridLayout.width;
            this.scaledSliceLabelFontSize = curFontSize = this.getInsideLabelStyle().getFont().getSize();
        }
        if (this.getExplodeArray().length > 0 || this.isExplodingOtherSlice()) {
            radius *= 0.8;
        }
        return radius;
    }

    private double outsideLabelOverhang(double radius, int fontSize) {
        ListIterator<DisplaySlice> iter = this.displaySlices.listIterator();
        if (!iter.hasNext()) {
            return radius;
        }
        this.wideLabelWidthOverhang = 0.0;
        String curLabel = "";
        Font labelFont = this.getOutsideLabelContent() != 10601 ? this.getOutsideLabelStyle().getFont() : this.getInsideLabelStyle().getFont();
        this.channel.glSelect2DFont(labelFont.deriveFont((float)fontSize));
        while (iter.hasNext()) {
            DisplaySlice curSlice = iter.next();
            curLabel = this.getOutsideLabelContent() != 10601 ? curSlice.outsideLabel.trim() : curSlice.insideLabel.trim();
            double curLabelWidth = this.channel.glGetTextWidth(curLabel);
            double curLabelHeight = this.channel.glGetTextHeight(curLabel);
            if (this.getOutsideLabelPlacement() == 1) {
                if (curLabelWidth + 9.0 > this.wideLabelWidthOverhang) {
                    this.wideLabel = curLabel;
                    this.wideLabelWidthOverhang = curLabelWidth + 9.0;
                }
            } else {
                double lipa = this.labelInPieArea(radius, curSlice, curLabelWidth);
                if (curLabelWidth - lipa > this.wideLabelWidthOverhang) {
                    this.wideLabel = curLabel;
                    this.wideLabelWidthOverhang = curLabelWidth - lipa;
                }
            }
            this.wideLabelHeight = Math.max(this.wideLabelHeight, curLabelHeight * 1.4);
        }
        return this.wideLabelWidthOverhang;
    }

    private double labelInPieArea(double radius, DisplaySlice curSlice, double labelWidth) {
        double midAngle;
        radius *= 0.12;
        int[] justifications = new int[2];
        for (midAngle = curSlice.startAngle + (curSlice.endAngle - curSlice.startAngle) / 2.0; midAngle < 0.0; midAngle += Math.PI * 2) {
        }
        while (midAngle > Math.PI * 2) {
            midAngle -= Math.PI * 2;
        }
        ALabel.getJustificationByAngle(midAngle, justifications);
        double labelInPieArea = 0.0;
        labelInPieArea = justifications[0] == 1 ? (labelWidth < 2.0 * radius ? labelWidth : 2.0 * radius) : (justifications[1] == 1 ? 0.0 : radius - radius * Math.abs(Math.cos(midAngle)));
        return labelInPieArea;
    }

    private String truncateString(String label, double maxW) {
        String ELIPSES = "...";
        double elipsesW = this.channel.glGetTextWidth("...");
        String newLabel = label;
        if (this.channel.glGetTextWidth(newLabel) > maxW) {
            while (this.channel.glGetTextWidth(newLabel) + elipsesW > maxW) {
                if (newLabel.length() < 1) {
                    newLabel = "";
                    break;
                }
                newLabel = newLabel.substring(0, newLabel.length() - 1);
            }
            newLabel = newLabel + "...";
        }
        if (newLabel.equals("...")) {
            newLabel = "";
        }
        return newLabel;
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        DisplaySlice curSlice;
        double fullRadius;
        boolean textureNeeded;
        ListIterator<DisplaySlice> iter = this.displaySlices.listIterator();
        if (!iter.hasNext()) {
            return;
        }
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        this.channel = ba.getChannel();
        this.channel.glPushAttrib(0);
        boolean bl = textureNeeded = this.texImage != null && this.texImage.length > 0 && this.texImage[0] != null;
        if (textureNeeded) {
            this.channel.glEnable(10);
            this.channel.glTexImage2D((Image)this.texImage[0]);
            this.channel.glTexEnv(10, 1, 3);
            this.channel.glTexEnv(10, 2, 5);
        }
        if (!this.isTwoD()) {
            this.channel.glRotate(-40.0, 1.0, 0.0, 0.0);
            this.channel.glEnable(1);
            this.channel.glEnable(4);
            this.channel.setDepthTestAlgorithm(2);
            this.channel.glEnable(3);
            this.channel.glEnable(19);
            this.channel.glLight(19, 3, new double[]{0.0, -0.85, 1.0});
            this.channel.glLight(19, 0, new double[]{0.5, 0.5, 0.5});
            this.channel.glLight(19, 1, new double[]{1.0, 1.0, 1.0, 1.0});
            this.channel.glLight(19, 2, new double[]{0.0, 0.0, 0.0});
        }
        this.channel.glEdgeColor(this.edgeColor.getValue(index));
        this.channel.glPolygonMode(BuildAction.getGLFillStyle(this.fillOn.getValue(index), this.edgeOn.getValue(index)));
        int sliceNum = 0;
        double d = fullRadius = this.fixedRadius > 0.0 ? this.fixedRadius : this.scaledRadius;
        if (fullRadius <= 0.0) {
            return;
        }
        double minRadius = fullRadius * this.getDonutSize() / 100.0;
        double subSize = (fullRadius - minRadius) / (double)this.subgroupCount;
        double oRadius = fullRadius;
        double iRadius = oRadius * this.getDonutSize() / 100.0;
        double labelX = 0.0;
        double labelY = 0.0;
        double height3D = this.isTwoD() ? 0.0 : fullRadius * 0.25;
        if ((height3D /= (double)(1 + this.subgroupCount / 5)) * (double)(this.subgroupCount + 2) > (double)this.getSize().height) {
            height3D = this.getSize().height / (this.subgroupCount + 2);
        }
        this.channel.glSelect2DFont(this.getSubgroupTitleStyle().getFont());
        double boxWidth = this.channel.glGetTextWidth(this.getSubgroupTitle());
        this.channel.glSelect2DFont(this.getSubgroupLabelStyle().getFont().deriveFont(this.fixedSubgroupLabelFontSize >= 0 ? (float)this.fixedSubgroupLabelFontSize : (float)this.scaledSubgroupLabelFontSize));
        boolean bl2 = this.showSubLabels = this.subgroupCount > 1 && this.getSubgroupLabelPlacement() != 6;
        if (this.scaledSubgroupLabelFontSize == 0 && this.scaledSubgroupTitleFontSize == 0) {
            this.showSubLabels = false;
        }
        double labelHeight = this.channel.glGetTextHeight();
        this.lineSpace = 1.0 * (this.isTwoD() ? 1.0 : 1.5);
        this.subLabelBoxHeight = labelHeight * this.lineSpace * (double)this.subgroupCount;
        boolean subLabelIsRight = false;
        String lastSubgroup = "";
        int si = -1;
        int sliceIndex = 0;
        double curSubHeight3D = 0.0;
        while (iter.hasNext()) {
            curSlice = iter.next();
            ++sliceIndex;
            if (this.subgroupCount <= 1 || curSlice.subgroup == null || curSlice.subgroup.equals(lastSubgroup)) continue;
            double labelWidth = this.channel.glGetTextWidth(curSlice.subgroup);
            if (labelWidth > boxWidth) {
                boxWidth = labelWidth;
            }
            if (!(this.subLabelBoxHeight >= this.maxSubLabelBoxHeight)) continue;
            this.subLabelBoxHeight = this.maxSubLabelBoxHeight;
            this.lineSpace = this.subLabelBoxHeight / ((double)(this.subgroupCount - 1) * labelHeight);
            if (!(this.lineSpace < 0.78)) continue;
            this.showSubLabels = false;
        }
        double baseSubgroupTitleY = this.subLabelBoxHeight / 2.0 - -1.2 * labelHeight * this.lineSpace;
        if (!this.isTwoD()) {
            baseSubgroupTitleY -= height3D;
        }
        if (this.showSubLabels) {
            if (this.getSubgroupLabelPlacement() == 3) {
                subLabelIsRight = true;
                this.channel.glTranslate(-boxWidth / 2.0, 0.0, 0.0);
            } else if (this.getSubgroupLabelPlacement() == 2) {
                this.channel.glTranslate(boxWidth / 2.0, 0.0, 0.0);
            }
        }
        iter = this.displaySlices.listIterator();
        lastSubgroup = "&";
        si = -1;
        sliceIndex = 0;
        double[] unprojectedOrigin = new double[3];
        this.channel.gluUnProject(new double[]{0.0, 0.0, 0.0}, unprojectedOrigin);
        if (this.getResponseLabel() != "") {
            if (this.getResponseTitleStyle().isShadowOn() && this.getResponseTitleStyle().getShadowColor() != null) {
                this.channel.glEnable(11);
                this.channel.setShadowColor(this.getResponseTitleStyle().getShadowColor());
                this.channel.setShadowOffset(this.getResponseTitleStyle().getShadowOffsetX(), this.getResponseTitleStyle().getShadowOffsetY());
            } else {
                this.channel.glDisable(11);
            }
            this.channel.glTextAlign(0, 0);
            this.channel.setRasterBackgroundColor(this.getResponseTitleStyle().getBackgroundColor());
            this.channel.glSelect2DFont(this.getResponseTitleStyle().getFont().deriveFont(this.fixedResponseLabelFontSize >= 0 ? (float)this.fixedResponseLabelFontSize : (float)this.scaledResponseLabelFontSize));
            this.channel.glTranslate(0.0, -this.channel.glGetTextHeight() / 2.0, 0.0);
            this.channel.glColor(this.getResponseTitleStyle().getColor());
            this.channel.glLoadName((Object)new String(this.getResponseLabel()));
            this.channel.glPushName((Object)new Integer(3));
            Point2D.Double adjust = this.getResponseTitleAdjustment();
            double[] respLoc = new double[3];
            this.channel.gluUnProject(new double[]{adjust.x + 4.0, adjust.y, 0.0}, respLoc);
            if (this.isTwoD()) {
                this.channel.gl2DText(this.actualResponseLabel, respLoc[0], respLoc[1], 0.5);
            } else {
                this.channel.gl2DText(this.actualResponseLabel, respLoc[0], respLoc[1] + 0.5, respLoc[2]);
            }
            this.channel.glPopName();
            this.channel.glLoadName(null);
        }
        if (!this.isTwoD()) {
            this.channel.glTranslate(0.0, -height3D * (double)this.subgroupCount / 4.0, 0.0);
        }
        if (this.skin != null) {
            int maxGridDim = Math.max(this.gridLayout.height, this.gridLayout.width);
            if (this.renderer.getModel().isSectorPie()) {
                double scaledIncrement = (double)(this.skinBorderGap * 2) * fullRadius / (double)Math.min(this.skinWidth, this.skinHeight);
                double radiusForSectorPie = fullRadius + scaledIncrement;
                this.scaledSize = (int)(Math.ceil(radiusForSectorPie * 2.0) + 2.0) / maxGridDim;
            } else {
                this.scaledSize = (int)(Math.ceil(fullRadius * 2.0) + 2.0) / maxGridDim;
            }
            this.scaledSize = Math.max(this.scaledSize, 1);
            this.pieSizedImage = new BufferedImage(this.scaledSize, this.scaledSize, 2);
            Graphics2D graphics2D = this.pieSizedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(this.skin.getImage(), 0, 0, this.scaledSize - 1, this.scaledSize - 1, null);
        }
        curSubHeight3D = -height3D;
        double initialInnerRadius = iRadius;
        while (iter.hasNext()) {
            curSlice = iter.next();
            ++sliceIndex;
            if (this.renderer.getModel().isSectorPie() && this.renderer.getModel().getSubgroupVariable() != null && this.renderer.getModel().isSubgroupStacked()) {
                if (curSlice.isSubGroupSlice) {
                    oRadius = fullRadius;
                    iRadius = fullRadius * 0.85;
                } else {
                    oRadius = fullRadius * 0.85;
                    iRadius = 0.0;
                }
            }
            if (this.subgroupCount > 1 && curSlice.subgroup != null && !curSlice.subgroup.equals(lastSubgroup)) {
                lastSubgroup = curSlice.subgroup;
                oRadius = fullRadius - (double)(++si) * subSize;
                iRadius = fullRadius - (double)(si + 1) * subSize;
                if (this.renderer.getModel().isSectorPie() && this.renderer.getModel().getSubgroupVariable() != null && this.renderer.getModel().isSubgroupStacked()) {
                    if (curSlice.isSubGroupSlice) {
                        oRadius = fullRadius;
                        iRadius = fullRadius * 0.85;
                    } else {
                        oRadius = fullRadius * 0.85;
                        iRadius = 0.0;
                    }
                }
                double ringWidth = oRadius - iRadius;
                double gap = 0.0;
                gap = this.gapDimension == RendererUtil.GroupGapDimension.PIXEL ? (this.ringGap < ringWidth ? this.ringGap : 0.0) : ringWidth * this.ringGap / 100.0;
                if (iRadius > initialInnerRadius) {
                    this.donutSize = Math.max(this.donutSize, this.donutSize - gap);
                    iRadius += gap;
                }
                curSubHeight3D += height3D;
                if (this.showSubLabels) {
                    double arrowSpace = 3.0;
                    labelX = fullRadius + arrowSpace * 3.0;
                    double extremeAngle = Math.atan(this.subLabelBoxHeight / 2.0 / labelX);
                    if (this.isTwoD()) {
                        labelY = this.subLabelBoxHeight / 2.0 - (double)si * labelHeight * this.lineSpace;
                        if (fullRadius < this.subLabelBoxHeight) {
                            labelY -= this.subLabelBoxHeight - fullRadius;
                        }
                    } else {
                        labelY = -this.subLabelBoxHeight / 2.0 + (double)si * labelHeight * this.lineSpace + height3D / 2.3 * (double)this.subgroupCount;
                    }
                    if (this.getResponseLabel() != "" && baseSubgroupTitleY > unprojectedOrigin[1] - labelHeight * 2.5) {
                        labelY -= labelHeight;
                    }
                    double thisAngle = this.isTwoD() ? extremeAngle - (double)si * (extremeAngle * 2.0 / (double)(this.subgroupCount - 1)) : -extremeAngle + (double)si * (extremeAngle * 2.0 / (double)(this.subgroupCount - 1));
                    double destX = oRadius * Math.cos(thisAngle);
                    double destY = oRadius * Math.sin(thisAngle);
                    double labelImageAdjust = 0.0;
                    if (subLabelIsRight) {
                        this.channel.glTextAlign(0, 1);
                    } else {
                        labelX *= -1.0;
                        labelX = Math.max(labelX, unprojectedOrigin[0]);
                        destX *= -1.0;
                        arrowSpace *= -1.0;
                        this.channel.glTextAlign(2, 1);
                        this.channel.glSelect2DFont(this.getSubgroupTitleStyle().getFont());
                    }
                    if (this.getSubgroupLabelStyle().isShadowOn() && this.getSubgroupLabelStyle().getShadowColor() != null) {
                        this.channel.glEnable(11);
                        this.channel.setShadowColor(this.getSubgroupLabelStyle().getShadowColor());
                        this.channel.setShadowOffset(this.getSubgroupLabelStyle().getShadowOffsetX(), this.getSubgroupLabelStyle().getShadowOffsetY());
                    } else {
                        this.channel.glDisable(11);
                    }
                    this.channel.setRasterBackgroundColor(this.getSubgroupLabelStyle().getBackgroundColor());
                    this.channel.glSelect2DFont(this.getSubgroupLabelStyle().getFont().deriveFont(this.fixedSubgroupLabelFontSize >= 0 ? (float)this.fixedSubgroupLabelFontSize : (float)this.scaledSubgroupLabelFontSize));
                    this.channel.glColor(this.getSubgroupLabelStyle().getColor());
                    this.channel.glLoadName((Object)new String(curSlice.subgroup));
                    this.channel.glPushName((Object)new Integer(4));
                    this.channel.gl2DText(curSlice.subgroup.trim(), labelX, labelY, height3D + 0.5);
                    this.channel.glPopName();
                    this.channel.glLoadName(null);
                    this.channel.glLineWidth(1.0f);
                    this.channel.glBegin(1);
                    this.channel.glVertex(labelX - arrowSpace, labelY, height3D + 0.5);
                    this.channel.glVertex(destX, destY, curSubHeight3D + height3D + 0.5);
                    this.channel.glEnd();
                    if (si == 0) {
                        if (this.getResponseLabel() != "" && baseSubgroupTitleY > unprojectedOrigin[1] - labelHeight * 2.5) {
                            labelY = baseSubgroupTitleY + height3D;
                            labelY -= labelHeight;
                        }
                        labelY = !this.isTwoD() ? (labelY += this.subLabelBoxHeight) : (labelY += labelHeight * 1.5);
                        if (this.getSubgroupTitleStyle().isShadowOn() && this.getSubgroupTitleStyle().getShadowColor() != null) {
                            this.channel.glEnable(11);
                            this.channel.setShadowColor(this.getSubgroupTitleStyle().getShadowColor());
                            this.channel.setShadowOffset(this.getSubgroupTitleStyle().getShadowOffsetX(), this.getSubgroupTitleStyle().getShadowOffsetY());
                        } else {
                            this.channel.glDisable(11);
                        }
                        this.channel.glSelect2DFont(this.getSubgroupTitleStyle().getFont());
                        this.channel.glColor(this.getSubgroupTitleStyle().getColor());
                        this.channel.setRasterBackgroundColor(this.getSubgroupTitleStyle().getBackgroundColor());
                        this.channel.glLoadName((Object)new Integer(2));
                        if (labelY > fullRadius) {
                            labelY = fullRadius;
                        }
                        this.channel.gl2DText(this.getSubgroupTitle(), labelX, labelY, height3D + 0.5);
                        if (!subLabelIsRight) {
                            labelImageAdjust = this.channel.glGetTextWidth(this.getSubgroupTitle());
                        }
                        if (this.isTitleMarkerVisible()) {
                            this.channel.glLoadName((Object)new Integer(1));
                            this.channel.setMarkerType(this.getTitleMarkerId());
                            this.channel.glBegin(4);
                            this.channel.glVertex(labelX - labelImageAdjust - (double)(this.getTitleMarkerSize() / 2) - 4.0, labelY + 2.0 + height3D);
                            this.channel.glEnd();
                        }
                    }
                }
                sliceNum = 0;
            }
            this.channel.glLineWidth((float)this.outlineWidth);
            if (this.isVisible(curSlice.categoryName, curSlice.isOther)) {
                Color fc = curSlice.fill;
                if (fc == null) {
                    fc = Color.WHITE;
                }
                this.pushSliceNames(curSlice, sliceIndex);
                if (this.isTwoD()) {
                    boolean showOutline = this.edgeOn.getValue();
                    if (this.renderer.getModel().isSectorPie()) {
                        showOutline = curSlice.isSubGroupSlice;
                    }
                    curSlice.shape = this.drawWedge(this.channel, curSlice.endAngle - curSlice.startAngle, curSlice.startAngle, iRadius, oRadius, this.fillOn.getValue() ? fc : this.edgeColor.getValue(), this.edgeColor.getValue(index), showOutline, this.fillOn.getValue(index), this.isExploded(curSlice.categoryName, curSlice.isOther), false, curSlice.valueIndex);
                    if (!buildAction.isUseNameStack() && this.pieSizedImage != null && curSlice.shape != null && this.subgroupCount == 1 && (this.invisibleArray != null && this.invisibleArray.length > 0 || this.explodeArray != null && this.explodeArray.length > 0) && this.isTwoD()) {
                        double midAngle = (curSlice.startAngle + curSlice.endAngle) / 2.0;
                        double originX = this.isExploded(curSlice.categoryName, curSlice.isOther) ? this.explodeAmount * oRadius * Math.cos(midAngle) : 0.0;
                        double originY = this.isExploded(curSlice.categoryName, curSlice.isOther) ? this.explodeAmount * oRadius * -Math.sin(midAngle) : 0.0;
                        Graphics2D gc = (Graphics2D)this.channel.getBackbufferGC();
                        Shape oldClip = gc.getClip();
                        gc.setClip(curSlice.shape);
                        gc.translate(originX, originY);
                        this.channel.glTextAlign(1, 1);
                        this.channel.Image2D((Image)this.pieSizedImage, 0.0, 0.0, 0.0, this.scaledSize, this.scaledSize);
                        gc.translate(-originX, -originY);
                        gc.setClip(oldClip);
                    }
                } else {
                    curSlice.shape = this.drawWedge3D(this.channel, curSlice.endAngle - curSlice.startAngle, curSlice.startAngle, curSubHeight3D, height3D, iRadius, oRadius, this.fillOn.getValue() ? fc : this.edgeColor.getValue(), this.edgeColor.getValue(index), this.edgeOn.getValue(), this.fillOn.getValue(index), this.isExploded(curSlice.categoryName, curSlice.isOther), false);
                }
                this.popSliceNames();
            }
            ++sliceNum;
        }
        iter = this.displaySlices.listIterator();
        if (!iter.hasNext()) {
            return;
        }
        si = -1;
        curSubHeight3D = -height3D;
        sliceIndex = 0;
        if (this.getDonutLabelStyle().isShadowOn() && this.getDonutLabelStyle().getShadowColor() != null) {
            this.channel.glEnable(11);
            this.channel.setShadowColor(this.getDonutLabelStyle().getShadowColor());
            this.channel.setShadowOffset(this.getDonutLabelStyle().getShadowOffsetX(), this.getDonutLabelStyle().getShadowOffsetY());
        } else {
            this.channel.glDisable(11);
        }
        this.channel.glSelect2DFont(this.getDonutLabelStyle().getFont());
        this.channel.glColor(this.getDonutLabelStyle().getColor());
        this.channel.setRasterBackgroundColor(this.getDonutLabelStyle().getBackgroundColor());
        this.channel.glTextAlign(1, 1);
        this.channel.gl2DText(this.getDonutLabel(), 0.0, 0.0, height3D + 0.5);
        if (!(buildAction.isUseNameStack() || this.pieSizedImage == null || this.invisibleArray != null && this.invisibleArray.length != 0 || this.explodeArray != null && this.explodeArray.length != 0 && this.subgroupCount <= 1 || !this.isTwoD())) {
            this.channel.Image2D((Image)this.pieSizedImage, 0.0, 0.0, 0.0, this.scaledSize, this.scaledSize);
        }
        while (iter.hasNext()) {
            double midAngle;
            curSlice = iter.next();
            ++sliceIndex;
            boolean visibleSlice = this.isVisible(curSlice.categoryName, curSlice.isOther);
            if (this.subgroupCount > 1 && curSlice.subgroup != null && !curSlice.subgroup.equals(lastSubgroup)) {
                lastSubgroup = curSlice.subgroup;
                oRadius = fullRadius - (double)(++si) * subSize;
                iRadius = fullRadius - (double)(si + 1) * subSize;
                if (this.renderer.getModel().isSectorPie() && this.renderer.getModel().getSubgroupVariable() != null && this.renderer.getModel().isSubgroupStacked()) {
                    if (curSlice.isSubGroupSlice) {
                        oRadius = fullRadius;
                        iRadius = fullRadius * 0.85;
                    } else {
                        oRadius = fullRadius * 0.85;
                        iRadius = 0.0;
                    }
                }
                double ringWidth = oRadius - iRadius;
                double gap = 0.0;
                gap = this.gapDimension == RendererUtil.GroupGapDimension.PIXEL ? (this.ringGap < ringWidth ? this.ringGap : 0.0) : ringWidth * this.ringGap / 100.0;
                if (iRadius > initialInnerRadius) {
                    this.donutSize = Math.max(this.donutSize, this.donutSize - gap);
                    iRadius += gap;
                }
                curSubHeight3D += height3D;
            }
            if (!visibleSlice) continue;
            for (midAngle = curSlice.startAngle + (curSlice.endAngle - curSlice.startAngle) / 2.0; midAngle < 0.0; midAngle += Math.PI * 2) {
            }
            while (midAngle > Math.PI * 2) {
                midAngle -= Math.PI * 2;
            }
            double originX = this.isExploded(curSlice.categoryName, curSlice.isOther) ? this.explodeAmount * oRadius * Math.cos(midAngle) : 0.0;
            double originY = this.isExploded(curSlice.categoryName, curSlice.isOther) ? this.explodeAmount * oRadius * Math.sin(midAngle) : 0.0;
            boolean ho = curSlice.isHighlightOn();
            if (ho) {
                Color fc = this.highlightFillColor.getValue();
                double hp = curSlice.getHighlightedPercentage();
                this.pushSliceNames(curSlice, sliceIndex);
                if (this.isTwoD()) {
                    boolean showOutline = this.edgeOn.getValue();
                    if (this.renderer.getModel().isSectorPie()) {
                        showOutline = curSlice.isSubGroupSlice;
                    }
                    this.drawWedge(this.channel, curSlice.endAngle - curSlice.startAngle, curSlice.startAngle, oRadius - (oRadius - iRadius) * hp, oRadius, fc, fc, showOutline, false, this.isExploded(curSlice.categoryName, curSlice.isOther), true, curSlice.valueIndex);
                } else {
                    this.drawWedge3D(this.channel, curSlice.endAngle - curSlice.startAngle, curSlice.startAngle, curSubHeight3D, height3D, oRadius - (oRadius - iRadius) * hp, oRadius, fc, fc, true, false, this.isExploded(curSlice.categoryName, curSlice.isOther), true);
                }
                this.popSliceNames();
            }
            if (!curSlice.insideLabel.equals("")) {
                double midRadius;
                double midRadiusAlt = 0.0;
                if (iRadius == 0.0) {
                    midRadius = oRadius * 0.7;
                    midRadiusAlt = oRadius * 0.57;
                } else {
                    midRadius = iRadius + (oRadius - iRadius) / 2.0;
                    midRadiusAlt = iRadius + (oRadius - iRadius) / 1.8;
                }
                labelX = originX + midRadius * Math.cos(midAngle);
                labelY = originY + midRadius * Math.sin(midAngle);
                double labelXAlt = 0.0;
                double labelYAlt = 0.0;
                if (midRadiusAlt > 0.0) {
                    double midAngleAlt = midAngle;
                    midAngleAlt = midAngle > 0.0 && midAngle < 1.5707963267948966 ? (midAngleAlt -= (curSlice.endAngle - curSlice.startAngle) / 4.0) : (midAngle > 1.5707963267948966 && midAngle < 4.71238898038469 ? (midAngle < Math.PI ? (midAngleAlt += (curSlice.endAngle - curSlice.startAngle) / 10.0) : (midAngleAlt -= (curSlice.endAngle - curSlice.startAngle) / 10.0)) : (midAngleAlt += (curSlice.endAngle - curSlice.startAngle) / 4.0));
                    labelXAlt = originX + midRadiusAlt * Math.cos(midAngleAlt);
                    labelYAlt = originY + midRadiusAlt * Math.sin(midAngleAlt);
                }
                this.channel.glTextAlign(1, 1);
                if (this.getInsideLabelStyle().isShadowOn() && this.getInsideLabelStyle().getShadowColor() != null) {
                    this.channel.glEnable(11);
                    this.channel.setShadowColor(this.getInsideLabelStyle().getShadowColor());
                    this.channel.setShadowOffset(this.getInsideLabelStyle().getShadowOffsetX(), this.getInsideLabelStyle().getShadowOffsetY());
                } else {
                    this.channel.glDisable(11);
                }
                this.channel.glSelect2DFont(this.getInsideLabelStyle().getFont().deriveFont(this.fixedSliceLabelFontSize >= 0 ? (float)this.fixedSliceLabelFontSize : (float)this.scaledSliceLabelFontSize));
                Bbox bb = new Bbox();
                this.channel.glGetText2DBbox(curSlice.insideLabel, labelX, labelY, 0.0, 0, bb);
                double[] winCoordsMin = new double[3];
                this.channel.gluProject(new double[]{bb.xmin, bb.ymin, bb.zmin}, winCoordsMin);
                double[] winCoordsMax = new double[3];
                this.channel.gluProject(new double[]{bb.xmax, bb.ymax, bb.zmax}, winCoordsMax);
                Rectangle br = new Rectangle((int)Math.min(winCoordsMin[0], winCoordsMax[0]) - 1, (int)Math.min(winCoordsMin[1], winCoordsMax[1]) - 1, (int)Math.abs(winCoordsMin[0] - winCoordsMax[0] - 1.0), (int)Math.abs(winCoordsMin[1] - winCoordsMax[1] - 1.0));
                Rectangle brAlt = new Rectangle();
                if (midRadiusAlt > 0.0) {
                    Bbox bbAlt = new Bbox();
                    this.channel.glGetText2DBbox(curSlice.insideLabel, labelXAlt, labelYAlt, 0.0, 0, bbAlt);
                    double[] winCoordsMinAlt = new double[3];
                    this.channel.gluProject(new double[]{bbAlt.xmin, bbAlt.ymin, bbAlt.zmin}, winCoordsMinAlt);
                    double[] winCoordsMaxAlt = new double[3];
                    this.channel.gluProject(new double[]{bbAlt.xmax, bbAlt.ymax, bbAlt.zmax}, winCoordsMaxAlt);
                    brAlt = new Rectangle((int)Math.min(winCoordsMinAlt[0], winCoordsMaxAlt[0]) - 1, (int)Math.min(winCoordsMinAlt[1], winCoordsMaxAlt[1]) - 1, (int)Math.abs(winCoordsMinAlt[0] - winCoordsMaxAlt[0] - 1.0), (int)Math.abs(winCoordsMinAlt[1] - winCoordsMaxAlt[1] - 1.0));
                }
                boolean drawThisLabel = true;
                int[] justifications = new int[2];
                if (curSlice.shape != null) {
                    switch (this.getInsideLabelPlacement()) {
                        case 4: {
                            if (curSlice.shape.contains(br) || curSlice.shape.contains(brAlt)) break;
                            drawThisLabel = false;
                            break;
                        }
                        case 5: {
                            if (!curSlice.shape.contains(br) && !curSlice.shape.contains(brAlt)) {
                                if (this.getOutsideLabelContent() != 10601 || this.subgroup.isConnected()) {
                                    drawThisLabel = false;
                                } else {
                                    labelX = originX + oRadius * 1.05 * Math.cos(midAngle);
                                    labelY = originY + oRadius * 1.05 * Math.sin(midAngle) - height3D;
                                    ALabel.getJustificationByAngle(midAngle, justifications);
                                    this.channel.glTextAlign(justifications[0], justifications[1]);
                                }
                            }
                            if (curSlice.shape.contains(br) || !curSlice.shape.contains(brAlt)) break;
                            labelX = labelXAlt;
                            labelY = labelYAlt;
                            break;
                        }
                    }
                }
                this.channel.glGetText2DBbox(curSlice.insideLabel, labelX, labelY, 0.0, 0, bb);
                winCoordsMin = new double[3];
                this.channel.gluProject(new double[]{bb.xmin, bb.ymin, bb.zmin}, winCoordsMin);
                winCoordsMax = new double[3];
                this.channel.gluProject(new double[]{bb.xmax, bb.ymax, bb.zmax}, winCoordsMax);
                br = new Rectangle((int)Math.min(winCoordsMin[0], winCoordsMax[0]), (int)Math.min(winCoordsMin[1], winCoordsMax[1]) + 4, (int)Math.abs(winCoordsMin[0] - winCoordsMax[0]) + 1, (int)Math.abs(winCoordsMin[1] - winCoordsMax[1]) - 3);
                Dimension size = this.getSize();
                Rectangle r = new Rectangle(0, 0, (int)size.getWidth(), (int)size.getHeight());
                if (!r.contains(br)) {
                    drawThisLabel = false;
                }
                if (drawThisLabel) {
                    if (justifications[0] == 2 && labelX - bb.getSizeX() < unprojectedOrigin[0]) {
                        labelX = unprojectedOrigin[0] + bb.getSizeX();
                    }
                    this.labelPosition.set(labelX, labelY, curSubHeight3D + height3D);
                    if (!this.isTwoD()) {
                        this.wayOutZ.set(0.0, 0.0, 0.5);
                        this.labelPosition.add(this.wayOutZ);
                    }
                    this.channel.glColor(this.getInsideLabelStyle().getColor());
                    this.channel.setRasterBackgroundColor(this.getInsideLabelStyle().getBackgroundColor());
                    this.pushSliceNames(curSlice, sliceIndex);
                    this.channel.gl2DText(curSlice.insideLabel, this.labelPosition.x, this.labelPosition.y, this.labelPosition.z);
                    this.popSliceNames();
                }
            }
            if (this.subgroup.isConnected() && this.subgroupCount != 1 || curSlice.outsideLabel.equals("") || this.scaledSliceLabelFontSize <= 0) continue;
            String label = curSlice.outsideLabel.trim();
            this.channel.glSelect2DFont(this.getOutsideLabelStyle().getFont().deriveFont(this.fixedSliceLabelFontSize >= 0 ? (float)this.fixedSliceLabelFontSize : (float)this.scaledSliceLabelFontSize));
            labelHeight = this.channel.glGetTextHeight();
            if (this.getOutsideLabelPlacement() == 0) {
                labelX = originX + oRadius * 1.05 * Math.cos(midAngle);
                labelY = originY + oRadius * 1.05 * Math.sin(midAngle) - height3D;
                int[] justifications = new int[2];
                ALabel.getJustificationByAngle(midAngle, justifications);
                this.channel.glTextAlign(justifications[0], justifications[1]);
                if (justifications[1] == 0) {
                    labelY -= height3D;
                }
            } else if (this.getOutsideLabelPlacement() == 1) {
                double destX = originX + oRadius * Math.cos(midAngle);
                double destY = originY + oRadius * Math.sin(midAngle);
                double midX = originX + oRadius * 1.05 * Math.cos(midAngle);
                double midY = originY + oRadius * 1.05 * Math.sin(midAngle);
                labelX = Math.min(oRadius * 1.2, oRadius + 12.0);
                labelY = midY;
                double startX = labelX - labelHeight / 2.0;
                double startY = labelY;
                if (midAngle > 1.5707963267948966 && midAngle <= 4.71238898038469) {
                    labelX *= -1.0;
                    startX *= -1.0;
                    this.channel.glTextAlign(2, 1);
                } else {
                    this.channel.glTextAlign(0, 1);
                }
                this.channel.glColor(this.getOutsideLabelStyle().getColor());
                this.channel.glBegin(1);
                this.channel.glVertex(startX, startY, height3D);
                if (Math.abs(midX) < Math.abs(startX)) {
                    this.channel.glVertex(midX, midY, height3D);
                }
                this.channel.glVertex(destX, destY, height3D);
                this.channel.glEnd();
            }
            if (this.getOutsideLabelStyle().isShadowOn() && this.getOutsideLabelStyle().getShadowColor() != null) {
                this.channel.glEnable(11);
                this.channel.setShadowColor(this.getOutsideLabelStyle().getShadowColor());
                this.channel.setShadowOffset(this.getOutsideLabelStyle().getShadowOffsetX(), this.getOutsideLabelStyle().getShadowOffsetY());
            } else {
                this.channel.glDisable(11);
            }
            boolean drawThisLabel = true;
            Bbox bb = new Bbox();
            this.channel.glGetText2DBbox(curSlice.outsideLabel, labelX, labelY, 0.0, 0, bb);
            double[] winCoordsMin = new double[3];
            this.channel.gluProject(new double[]{bb.xmin, bb.ymin, bb.zmin}, winCoordsMin);
            double[] winCoordsMax = new double[3];
            this.channel.gluProject(new double[]{bb.xmax, bb.ymax, bb.zmax}, winCoordsMax);
            int padding = 4;
            if (winCoordsMax[1] > 0.0) {
                padding = 0;
                labelY += 2.0;
            }
            Rectangle br = new Rectangle((int)Math.min(winCoordsMin[0], winCoordsMax[0]), (int)Math.min(winCoordsMin[1], winCoordsMax[1]) + padding, (int)Math.abs(winCoordsMin[0] - winCoordsMax[0]) + 1, (int)Math.abs(winCoordsMin[1] - winCoordsMax[1]) - 3);
            Dimension size = this.getSize();
            Rectangle r = new Rectangle(0, 0, (int)size.getWidth(), (int)size.getHeight());
            if (!r.contains(br)) {
                drawThisLabel = false;
            }
            if (!drawThisLabel) continue;
            this.channel.glColor(this.getOutsideLabelStyle().getColor());
            this.channel.setRasterBackgroundColor(this.getOutsideLabelStyle().getBackgroundColor());
            this.channel.gl2DText(label, labelX, labelY, height3D);
        }
        this.channel.glPopAttrib();
    }

    private void pushSliceNames(Slice curSlice, int sliceIndex) {
        this.channel.glLoadName((Object)curSlice.valueIndices);
        this.channel.glPushName((Object)new Integer(sliceIndex - 1));
        this.channel.glPushName((Object)sliceDetail);
    }

    private void popSliceNames() {
        this.channel.glPopName();
        this.channel.glPopName();
        this.channel.glLoadName(null);
    }

    private Shape drawWedge(Channel channel, double angle, double startAngle, double innerRadius, double outerRadius, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, boolean exploded, boolean highlightOn, int valueIndex) {
        if (innerRadius == 0.0 && outerRadius == 0.0) {
            return null;
        }
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        double midAngle = startAngle + angle / 2.0;
        double originX = exploded ? this.explodeAmount * outerRadius * Math.cos(midAngle) : 0.0;
        double originY = exploded ? this.explodeAmount * outerRadius * Math.sin(midAngle) : 0.0;
        double startDegrees = startAngle / (Math.PI * 2) * 360.0;
        double extentDegrees = angle / (Math.PI * 2) * 360.0;
        if (extentDegrees > 359.99 || extentDegrees < -359.99) {
            extentDegrees = 360.0;
        }
        if (highlightOn) {
            channel.glPolygonMode(6);
            channel.glLineWidth(2.0f);
        } else if (edgeOn && fillOn) {
            channel.glPolygonMode(4);
            channel.glEnable(6);
        } else if (fillOn) {
            channel.glPolygonMode(3);
        } else if (edgeOn) {
            channel.glPolygonMode(2);
            channel.glEdgeColor(color);
            channel.glEnable(6);
        }
        Shape wedgeShape = channel.glWedge(originX, originY, innerRadius, outerRadius, startDegrees, extentDegrees);
        boolean tagVisible = false;
        try {
            if (this.renderer.getModel().getCHPipe() != null) {
                tagVisible = this.renderer.getModel().getCHPipe().getValue(valueIndex) > 0.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tagVisible && this.renderer.getModel().getCHImage() != null) {
            double midDegrees = startDegrees + extentDegrees / 2.0;
            double midAngleRad = Math.toRadians(midDegrees);
            Image image = this.renderer.getModel().getCHImage();
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            channel.glAlignment(1, 1);
            int radiusOfIcon = (int)Math.sqrt(h * h + w * w) / 2;
            double radiusForTagDist = outerRadius - (double)radiusOfIcon;
            int Y = (int)(radiusForTagDist * Math.sin(midAngleRad));
            int X = (int)(radiusForTagDist * Math.cos(midAngleRad));
            channel.Image2D(image, (double)X, (double)Y, 0.0, w, h);
        }
        channel.glLineWidth(1.0f);
        channel.glDisable(6);
        return wedgeShape;
    }

    private Shape drawWedge3D(Channel channel, double angle, double startAngle, double startHeight, double height, double innerRadius, double outerRadius, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, boolean exploded, boolean highlightOn) {
        Vec3d cross;
        int count;
        int precision = 70;
        Polygon rough = new Polygon();
        double[] winCoords = new double[3];
        if ((innerRadius = Math.abs(innerRadius)) > (outerRadius = Math.abs(outerRadius))) {
            double temp = innerRadius;
            innerRadius = outerRadius;
            outerRadius = temp;
        }
        if (highlightOn) {
            outerRadius += 0.25;
            height += 0.25;
        }
        double incrementAngle = Math.PI * 2 / (double)precision;
        int numValues = 3;
        if (Math.abs(angle) > incrementAngle) {
            numValues = (int)Math.round(Math.abs(angle) / incrementAngle) + 2;
        }
        incrementAngle = angle > 0.0 ? incrementAngle : -incrementAngle;
        double[] xor = new double[numValues];
        double[] yor = new double[numValues];
        double[] yir = new double[numValues];
        double[] xir = new double[numValues];
        double midAngle = startAngle + angle / 2.0;
        double zOrigin = 0.0;
        xor[0] = exploded ? this.explodeAmount * outerRadius * Math.cos(midAngle) : 0.0;
        yor[0] = exploded ? this.explodeAmount * outerRadius * Math.sin(midAngle) : 0.0;
        double angleSum = startAngle;
        for (count = 1; count <= numValues - 2; ++count) {
            xor[count] = xor[0] + Math.cos(angleSum) * outerRadius;
            yor[count] = yor[0] + Math.sin(angleSum) * outerRadius;
            angleSum += incrementAngle;
        }
        xor[count] = xor[0] + Math.cos(startAngle + angle) * outerRadius;
        yor[count] = yor[0] + Math.sin(startAngle + angle) * outerRadius;
        xir[0] = exploded ? this.explodeAmount * outerRadius * Math.cos(midAngle) : 0.0;
        yir[0] = exploded ? this.explodeAmount * outerRadius * Math.sin(midAngle) : 0.0;
        angleSum = startAngle;
        for (count = 1; count <= numValues - 2; ++count) {
            xir[count] = xir[0] + Math.cos(angleSum) * innerRadius;
            yir[count] = yir[0] + Math.sin(angleSum) * innerRadius;
            angleSum += incrementAngle;
        }
        xir[count] = xir[0] + Math.cos(startAngle + angle) * innerRadius;
        yir[count] = yir[0] + Math.sin(startAngle + angle) * innerRadius;
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getGLFillStyle(fillOn, edgeOn));
        zOrigin = height < 0.0 ? height : 0.0;
        height = Math.abs(height);
        Vec3d v = new Vec3d(0.0, 0.0, height);
        Vec3d w = new Vec3d(0.0, 0.0, 0.0);
        Vec3d ov = new Vec3d(v);
        zOrigin += startHeight;
        if (edgeOn) {
            channel.glEnable(6);
            if (fillOn) {
                channel.glPolygonMode(3);
            } else {
                channel.glPolygonMode(2);
            }
        }
        if (highlightOn) {
            channel.glPolygonMode(7);
        }
        channel.glDisable(0);
        for (count = 1; count <= numValues - 2; ++count) {
            channel.glBegin(2);
            double hh = yor[count] - yor[count + 1];
            double ww = xor[count] - xor[count + 1];
            v.set(0.0, 0.0, height);
            w.set(ww, hh, 0.0);
            cross = v.cross(w);
            if (incrementAngle < 0.0) {
                cross.scale(-1.0);
            }
            channel.glNormal(cross.x, cross.y, cross.z);
            channel.glVertex(xor[count], yor[count], zOrigin);
            channel.glVertex(xor[count + 1], yor[count + 1], zOrigin);
            channel.glVertex(xor[count + 1], yor[count + 1] + 1.0, zOrigin + height);
            channel.glVertex(xor[count], yor[count] + 1.0, zOrigin + height);
            channel.glEnd();
        }
        if (edgeOn) {
            channel.glColor(edgeColor);
            channel.glBegin(1);
            for (count = 1; count <= numValues - 1; ++count) {
                if (!(yor[count] <= yor[0] + height * 0.7)) continue;
                channel.glVertex(xor[count], yor[count], zOrigin);
            }
            channel.glEnd();
        }
        if (innerRadius > 0.0) {
            channel.glColor(color);
            channel.glEdgeColor(edgeColor);
            for (count = 1; count <= numValues - 2; ++count) {
                channel.glBegin(2);
                v.set(ov);
                w.set(xir[count + 1] - xir[count], yir[count + 1] - yir[count], 0.0);
                cross = v.cross(w);
                if (incrementAngle < 0.0) {
                    cross.scale(-1.0);
                }
                channel.glNormal(cross.x, cross.y, cross.z);
                channel.glVertex(xir[count], yir[count], zOrigin);
                channel.glVertex(xir[count + 1], yir[count + 1], zOrigin);
                channel.glVertex(xir[count + 1], yir[count + 1] + 1.0, zOrigin + height);
                channel.glVertex(xir[count], yir[count] + 1.0, zOrigin + height);
                channel.glEnd();
            }
            if (edgeOn) {
                channel.glColor(edgeColor);
                channel.glBegin(1);
                for (count = 1; count <= numValues - 1; ++count) {
                    if (!(yor[count] >= yor[0] + height * 0.7)) continue;
                    channel.glVertex(xir[count], yir[count], zOrigin);
                }
                channel.glEnd();
            }
        }
        if (edgeOn) {
            if (fillOn) {
                channel.glPolygonMode(4);
            } else {
                channel.glPolygonMode(2);
            }
        }
        if (highlightOn) {
            channel.glPolygonMode(7);
        }
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        if (innerRadius > 0.0) {
            for (count = numValues - 1; count >= 1; --count) {
                if (count == 1 && Math.abs(angle) >= 6.282556988648868) {
                    channel.glEdgeFlag(false);
                }
                channel.glVertex(xir[count], yir[count], zOrigin + height);
                channel.gluProject(new double[]{xir[count], yir[count], zOrigin + height}, winCoords);
                rough.addPoint((int)winCoords[0], (int)winCoords[1]);
            }
        } else {
            if (Math.abs(angle) >= 6.282556988648868) {
                channel.glEdgeFlag(false);
            }
            channel.glVertex(xor[0], yor[0], zOrigin + height);
            channel.gluProject(new double[]{xir[0], yir[0], zOrigin + height}, winCoords);
            rough.addPoint((int)winCoords[0], (int)winCoords[1]);
        }
        for (count = 1; count < numValues; ++count) {
            if (Math.abs(angle) >= 6.282556988648868 && count == numValues - 1) {
                channel.glEdgeFlag(false);
            }
            if (Math.abs(angle) >= 6.282556988648868 && count == 1) {
                channel.glEdgeFlag(true);
            }
            channel.glVertex(xor[count], yor[count], zOrigin + height);
            channel.gluProject(new double[]{xor[count], yor[count], zOrigin + height}, winCoords);
            rough.addPoint((int)winCoords[0], (int)winCoords[1]);
        }
        channel.glEnd();
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, -1.0);
        if (innerRadius > 0.0) {
            for (count = 1; count < numValues; ++count) {
                channel.glVertex(xir[count], yir[count], zOrigin);
            }
        } else {
            channel.glVertex(xor[0], yor[0], zOrigin);
        }
        for (count = numValues - 1; count >= 1; --count) {
            channel.glVertex(xor[count], yor[count], zOrigin);
        }
        channel.glEnd();
        if (this.getExplodeArray().length > 0 || this.getInvisibleArray().length > 0 || this.isExplodingOtherSlice()) {
            channel.glBegin(2);
            v.set(ov);
            w.set(xor[1] - xor[0], yor[1] - yor[0], 0.0);
            cross = w.cross(v);
            if (incrementAngle < 0.0) {
                cross.scale(-1.0);
            }
            channel.glNormal(cross.x, cross.y, cross.z);
            channel.glVertex(xor[1], yor[1], zOrigin + height);
            channel.glVertex(xor[1], yor[1], zOrigin);
            if (innerRadius > 0.0) {
                channel.glVertex(xir[1], yir[1], zOrigin);
                channel.glVertex(xir[1], yir[1], zOrigin + height);
            } else {
                channel.glVertex(xor[0], yor[0], zOrigin);
                channel.glVertex(xor[0], yor[0], zOrigin + height);
            }
            channel.glEnd();
            channel.glBegin(2);
            v.set(ov);
            w.set(xor[numValues - 1] - xor[0], yor[numValues - 1] - yor[0], 0.0);
            cross = v.cross(w);
            if (incrementAngle < 0.0) {
                cross.scale(-1.0);
            }
            channel.glNormal(cross.x, cross.y, cross.z);
            channel.glVertex(xor[numValues - 1], yor[numValues - 1], zOrigin + height);
            channel.glVertex(xor[numValues - 1], yor[numValues - 1], zOrigin);
            if (innerRadius > 0.0) {
                channel.glVertex(xir[numValues - 1], yir[numValues - 1], zOrigin);
                channel.glVertex(xir[numValues - 1], yir[numValues - 1], zOrigin + height);
            } else {
                channel.glVertex(xor[0], yor[0], zOrigin);
                channel.glVertex(xor[0], yor[0], zOrigin + height);
            }
            channel.glEnd();
        }
        channel.glDisable(6);
        return rough;
    }

    private int orderSlices(int order) {
        switch (order) {
            case 3: {
                ArrayList<Slice> sortedSlices = this.visibleSlices;
                Collections.sort(sortedSlices);
                this.visibleSlices = sortedSlices;
                break;
            }
            case 4: {
                ArrayList<Slice> sortedSlices = this.visibleSlices;
                Collections.sort(sortedSlices, Collections.reverseOrder());
                this.visibleSlices = sortedSlices;
                break;
            }
            case 1: {
                ArrayList<Slice> sortedSlices = this.visibleSlices;
                Collections.sort(sortedSlices, new Comparator<Slice>(){

                    @Override
                    public int compare(Slice a, Slice b) {
                        return a.categoryName.compareTo(b.categoryName);
                    }
                });
                this.visibleSlices = sortedSlices;
                break;
            }
            case 2: {
                ArrayList<Slice> sortedSlices = this.visibleSlices;
                Collections.sort(sortedSlices, new Comparator<Slice>(){

                    @Override
                    public int compare(Slice a, Slice b) {
                        return b.categoryName.compareTo(a.categoryName);
                    }
                });
                this.visibleSlices = sortedSlices;
                break;
            }
            case 5: {
                Collections.sort(this.visibleSlices, new SectorPieComparator());
                break;
            }
        }
        return 0;
    }

    private int createOtherSlice(double otherThresholdPct, int otherThresholdNum) {
        ArrayList origVisibleSlices = (ArrayList)this.visibleSlices.clone();
        ArrayList<Integer> valueIndexList = new ArrayList<Integer>();
        boolean highlightOn = false;
        double highlightPercentage = 0.0;
        if (otherThresholdPct == 0.0 && otherThresholdNum >= this.visibleSlices.size()) {
            return 0;
        }
        if (this.visibleSlices.size() == 0) {
            return 0;
        }
        Slice curSlice = null;
        int otherAdded = 0;
        int numSlicesInOther = 0;
        double otherVal = 0.0;
        double otherCompare = Math.PI * 2 * otherThresholdPct;
        if (otherThresholdNum > 0) {
            ArrayList sortedSlices = (ArrayList)this.visibleSlices.clone();
            Collections.sort(sortedSlices, Collections.reverseOrder());
            Slice incSlice = (Slice)sortedSlices.get(otherThresholdNum - 1);
            otherCompare = incSlice.extent;
        }
        ListIterator<Slice> iter = this.visibleSlices.listIterator();
        while (iter.hasNext()) {
            curSlice = iter.next();
            if (!(curSlice.extent <= otherCompare)) continue;
            otherVal += curSlice.value;
            iter.remove();
            ++numSlicesInOther;
            valueIndexList.add(new Integer(curSlice.valueIndex));
            highlightOn |= curSlice.highlight;
            highlightPercentage += curSlice.hPercentage;
        }
        highlightPercentage /= (double)numSlicesInOther;
        if (numSlicesInOther == 1) {
            this.visibleSlices = origVisibleSlices;
            otherVal = 0.0;
        }
        if (otherVal > 0.0) {
            String insideLabel = "";
            String outsideLabel = "";
            Formatter form = this.response.getFormatter();
            form = form.getMaxWidthFormatter();
            if (this.insideLabelContent == 10602 || this.insideLabelContent == 10609 || this.insideLabelContent == 10610 || this.insideLabelContent == 10611) {
                insideLabel = insideLabel + this.getOtherLabel().trim();
            }
            if (this.insideLabelContent == 10603 || this.insideLabelContent == 10609 || this.insideLabelContent == 10612 || this.insideLabelContent == 10611) {
                insideLabel = insideLabel + (insideLabel.length() == 0 ? "" : "\n") + form.format(new Double(otherVal)).trim();
            }
            if (this.insideLabelContent == 10608 || this.insideLabelContent == 10610 || this.insideLabelContent == 10612 || this.insideLabelContent == 10611) {
                insideLabel = insideLabel + (insideLabel.length() == 0 ? "" : "\n") + this.percentFormat.format(new Double(otherVal / this.totalValue));
            }
            if (this.outsideLabelContent == 10602 || this.outsideLabelContent == 10609 || this.outsideLabelContent == 10610 || this.outsideLabelContent == 10611) {
                outsideLabel = outsideLabel + this.getOtherLabel().trim();
            }
            if (this.outsideLabelContent == 10603 || this.outsideLabelContent == 10609 || this.outsideLabelContent == 10612 || this.outsideLabelContent == 10611) {
                outsideLabel = outsideLabel + (outsideLabel.length() == 0 ? "" : "\n") + form.format(new Double(otherVal)).trim();
            }
            if (this.outsideLabelContent == 10608 || this.outsideLabelContent == 10610 || this.outsideLabelContent == 10612 || this.outsideLabelContent == 10611) {
                outsideLabel = outsideLabel + (outsideLabel.length() == 0 ? "" : "\n") + this.percentFormat.format(new Double(otherVal / this.totalValue));
            }
            Slice otherSlice = new Slice(otherVal, this.totalValue, this.getOtherLabel(), insideLabel, outsideLabel, curSlice.subgroup, this.getOtherColor(), highlightOn, highlightPercentage, 0, false);
            int n = valueIndexList.size();
            int[] valueIndices = new int[n];
            for (int i = 0; i < n; ++i) {
                Integer bigI = (Integer)valueIndexList.get(i);
                valueIndices[i] = bigI;
            }
            otherSlice.valueIndices = valueIndices;
            this.visibleSlices.add(otherSlice);
            otherAdded = 1;
            otherSlice.isOther = true;
            otherSlice.fill = this.getOtherColor();
        }
        return otherAdded;
    }

    private void positionSlices(int direction, ArrayList<Slice> outerGroupsRingList, int subgroupNum) {
        DisplaySlice dSlice;
        double curAngle = this.getStartAngle();
        if (this.renderer.getModel().isCenterFirstSlice()) {
            double endAngle = this.getEndAngle(direction, curAngle, this.visibleSlices.get(0));
            curAngle -= (endAngle - curAngle) / 2.0;
        }
        for (Slice curSlice : this.visibleSlices) {
            dSlice = new DisplaySlice();
            this.copyProperties(dSlice, curSlice);
            dSlice.startAngle = curAngle;
            dSlice.endAngle = curAngle = this.getEndAngle(direction, curAngle, curSlice);
            this.displaySlices.add(dSlice);
        }
        if (this.renderer.getModel().isSectorPie() && this.renderer.getModel().getSubgroupVariable() != null && this.renderer.getModel().isSubgroupStacked() && outerGroupsRingList != null) {
            curAngle = this.getStartAngle();
            for (Slice eachSlice : outerGroupsRingList) {
                dSlice = new DisplaySlice();
                this.copyProperties(dSlice, eachSlice);
                dSlice.startAngle = curAngle;
                dSlice.endAngle = curAngle = this.getEndAngle(direction, curAngle, eachSlice);
                this.displaySlices.add(dSlice);
            }
        }
    }

    private void copyProperties(DisplaySlice dSlice, Slice curSlice) {
        dSlice.value = curSlice.value;
        dSlice.valueIndex = curSlice.valueIndex;
        dSlice.valueIndices = curSlice.valueIndices;
        dSlice.extent = curSlice.extent;
        dSlice.categoryName = curSlice.categoryName;
        dSlice.insideLabel = curSlice.insideLabel;
        dSlice.outsideLabel = curSlice.outsideLabel;
        dSlice.subgroup = curSlice.subgroup;
        dSlice.fill = curSlice.fill;
        dSlice.isOther = curSlice.isOther;
        dSlice.highlight = curSlice.highlight;
        dSlice.hPercentage = curSlice.hPercentage;
        dSlice.isSubGroupSlice = curSlice.isSubGroupSlice;
    }

    private double getEndAngle(int direction, double curAngle, Slice curSlice) {
        if (direction == -1) {
            BigDecimal bd = new BigDecimal(curAngle += curSlice.extent);
            bd = bd.setScale(6, 4);
            curAngle = bd.doubleValue();
        } else {
            BigDecimal bd = new BigDecimal(curAngle -= curSlice.extent);
            bd = bd.setScale(6, 4);
            curAngle = bd.doubleValue();
        }
        return curAngle;
    }

    private boolean isVisible(String cat, boolean isOtherSlice) {
        if (isOtherSlice) {
            return this.otherSliceVisible;
        }
        String[] invisible = this.getInvisibleArray();
        for (int i = 0; i < invisible.length; ++i) {
            if (!cat.equals(invisible[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isExploded(String cat, boolean isOtherSlice) {
        if (this.subgroupUniqueValues.size() > 1) {
            return false;
        }
        String[] explode = this.getExplodeArray();
        if (isOtherSlice) {
            return this.isExplodingOtherSlice();
        }
        for (int i = 0; i < explode.length; ++i) {
            if (!cat.equals(explode[i])) continue;
            return true;
        }
        return false;
    }

    public void setUniqueSubgroupFormats(HashMap<String, String> s2f) {
        this.subToFmtHash = s2f;
    }

    public void setFixedResponseLabelFontSize(int fixedResponseLabelFontSize) {
        this.fixedResponseLabelFontSize = fixedResponseLabelFontSize;
    }

    public int getFixedResponseLabelFontSize() {
        return this.fixedResponseLabelFontSize;
    }

    public int getScaledResponseLabelFontSize() {
        return this.scaledResponseLabelFontSize;
    }

    public int getFixedSliceLabelFontSize() {
        return this.fixedSliceLabelFontSize;
    }

    public void setFixedSliceLabelFontSize(int fixedSliceLabelFontSize) {
        this.fixedSliceLabelFontSize = fixedSliceLabelFontSize;
    }

    public int getFixedSubgroupLabelFontSize() {
        return this.fixedSubgroupLabelFontSize;
    }

    public void setFixedSubgroupLabelFontSize(int fixedSubgroupLabelFontSize) {
        this.fixedSubgroupLabelFontSize = fixedSubgroupLabelFontSize;
    }

    public int getFixedSubgroupTitleFontSize() {
        return this.fixedSubgroupTitleFontSize;
    }

    public void setFixedSubgroupTitleFontSize(int fixedSubgroupTitleFontSize) {
        this.fixedSubgroupTitleFontSize = fixedSubgroupTitleFontSize;
    }

    public int getScaledSliceLabelFontSize() {
        return this.scaledSliceLabelFontSize;
    }

    public int getScaledSubgroupLabelFontSize() {
        return this.scaledSubgroupLabelFontSize;
    }

    public int getScaledSubgroupTitleFontSize() {
        return this.scaledSubgroupTitleFontSize;
    }

    public double getScaledRadius() {
        return this.scaledRadius;
    }

    public double getFixedRadius() {
        return this.fixedRadius;
    }

    public void setFixedRadius(double fixedRadius) {
        this.fixedRadius = fixedRadius;
    }

    @Override
    public SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        int typeIndex = startIndex + entryLength - 1;
        int obsIndex = typeIndex - 1;
        int originalIndicesIndex = obsIndex - 1;
        if (nameStack.elementAt(typeIndex) == null) {
            return null;
        }
        int type = (Integer)nameStack.elementAt(typeIndex);
        int processedIndex = -1;
        int[] originalValueIndices = null;
        String subLabel = "";
        String respLabel = "";
        switch (type) {
            case 1: 
            case 2: {
                break;
            }
            case 0: {
                processedIndex = (Integer)nameStack.elementAt(obsIndex);
                originalValueIndices = (int[])nameStack.elementAt(originalIndicesIndex);
                break;
            }
            case 4: {
                subLabel = (String)nameStack.elementAt(obsIndex);
                break;
            }
            case 3: {
                respLabel = (String)nameStack.elementAt(obsIndex);
            }
        }
        GTKPieSelectDetail pieSelectDetail = new GTKPieSelectDetail();
        pieSelectDetail.setOriginalValueIndices(originalValueIndices);
        pieSelectDetail.setProcessedIndex(processedIndex);
        pieSelectDetail.setSubgroupLabel(subLabel);
        pieSelectDetail.setResponseLabel(respLabel);
        pieSelectDetail.setType(type);
        pieSelectDetail.pie = this;
        return pieSelectDetail;
    }

    public List<String> getVisibleCategories() {
        ArrayList<String> values = new ArrayList<String>();
        for (Slice slice : this.displaySlices) {
            values.add(slice.categoryName);
        }
        return values;
    }

    public List<LegendEntry> getLegendItems() {
        ArrayList<LegendEntry> items = new ArrayList<LegendEntry>();
        for (DisplaySlice slice : this.displaySlices) {
            if (!this.isVisible(slice.categoryName, slice.isOther)) continue;
            items.add(new LegendEntry(slice));
        }
        return items;
    }

    private double radiusForBestFit(double radius) {
        ListIterator<DisplaySlice> iter = this.displaySlices.listIterator();
        if (!iter.hasNext()) {
            return 0.0;
        }
        if (radius <= 0.0) {
            return -1.0;
        }
        double oRadius = radius;
        double iRadius = oRadius * this.getDonutSize() / 100.0;
        double labelX = 0.0;
        double labelY = 0.0;
        boolean nofit = false;
        Arc2D.Double curSliceShape = null;
        boolean exploded = false;
        while (iter.hasNext() && !nofit) {
            double originY;
            double midAngle;
            DisplaySlice curSlice = iter.next();
            boolean visibleSlice = this.isVisible(curSlice.categoryName, curSlice.isOther);
            if (!visibleSlice) continue;
            for (midAngle = curSlice.startAngle + (curSlice.endAngle - curSlice.startAngle) / 2.0; midAngle < 0.0; midAngle += Math.PI * 2) {
            }
            while (midAngle > Math.PI * 2) {
                midAngle -= Math.PI * 2;
            }
            exploded = exploded || this.isExploded(curSlice.categoryName, curSlice.isOther);
            double originX = this.isExploded(curSlice.categoryName, curSlice.isOther) ? this.explodeAmount * oRadius * Math.cos(midAngle) : 0.0;
            double d = originY = this.isExploded(curSlice.categoryName, curSlice.isOther) ? this.explodeAmount * oRadius * Math.sin(midAngle) : 0.0;
            if (curSlice.insideLabel.equals("")) continue;
            double midRadius = iRadius == 0.0 ? oRadius * 0.7 : iRadius + (oRadius - iRadius) / 2.0;
            labelX = originX + midRadius * Math.cos(midAngle);
            labelY = originY + midRadius * Math.sin(midAngle);
            this.channel.glTextAlign(1, 1);
            this.channel.glSelect2DFont(this.getInsideLabelStyle().getFont().deriveFont(this.fixedSliceLabelFontSize >= 0 ? (float)this.fixedSliceLabelFontSize : (float)this.scaledSliceLabelFontSize));
            Bbox bb = new Bbox();
            this.channel.glGetText2DBbox(curSlice.insideLabel, labelX + radius, radius - labelY, 0.0, 0, bb);
            Rectangle br = new Rectangle((int)Math.min(bb.xmin, bb.xmax), (int)Math.min(bb.ymin, bb.ymax), (int)Math.abs(bb.xmax - bb.xmin), (int)Math.abs(bb.ymax - bb.ymin));
            double startAngle = this.sliceDirection == -1 ? curSlice.startAngle : curSlice.endAngle;
            curSliceShape = new Arc2D.Double(1.0, 1.0, oRadius * 2.0, oRadius * 2.0, startAngle * 180.0 / Math.PI, curSlice.extent * 180.0 / Math.PI, 2);
            if (curSliceShape == null || this.getInsideLabelPlacement() != 5 || curSliceShape.contains(br)) continue;
            nofit = true;
        }
        return !nofit ? oRadius - (exploded ? this.explodeAmount * oRadius : 0.0) : -1.0;
    }

    public class LegendEntry
    implements Comparable<LegendEntry> {
        public String category;
        public Color color;
        public boolean isOther;
        private boolean isSubGroup;
        private String subGroup;
        private boolean isGroupedSectorPie;

        public LegendEntry(DisplaySlice ds) {
            this.category = ds.categoryName;
            this.color = ds.fill;
            this.isOther = ds.isOther;
            this.isSubGroup = ds.isSubGroupSlice;
            this.subGroup = ds.subgroup;
            this.isGroupedSectorPie = GTKPie.this.renderer.getModel().isSectorPie() && GTKPie.this.renderer.getModel().getSubgroupVariable() != null && GTKPie.this.renderer.getModel().isSubgroupStacked();
        }

        @Override
        public int compareTo(LegendEntry o) {
            if (this.isOther != o.isOther) {
                if (this.isOther) {
                    return 1;
                }
                return -1;
            }
            if (this.subGroup.equals(o.subGroup)) {
                return this.category.compareTo(o.category);
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof LegendEntry) {
                LegendEntry le = (LegendEntry)o;
                if (this.isGroupedSectorPie) {
                    if (this.subGroup.equals(le.subGroup)) {
                        return this.category.equals(le.category);
                    }
                } else {
                    return this.category.equals(le.category);
                }
            }
            return false;
        }

        public boolean isSubGroup() {
            return this.isSubGroup;
        }

        public String getSubGroup() {
            return this.subGroup;
        }
    }

    class ProcessedResponse
    implements NumericPipe {
        ProcessedResponse() {
        }

        @Override
        public void init(AInitAction ia) {
        }

        @Override
        public void reset(AResetAction ia) {
        }

        @Override
        public Formatter getFormatter() {
            return GTKPie.this.response.getFormatter();
        }

        @Override
        public double getValue(int index) throws MissingValueException {
            return ((DisplaySlice)((GTKPie)GTKPie.this).displaySlices.get((int)index)).value;
        }
    }

    class ProcessedSubgroup
    implements StringPipe {
        ProcessedSubgroup() {
        }

        @Override
        public void init(AInitAction ia) {
        }

        @Override
        public void reset(AResetAction ia) {
        }

        @Override
        public Formatter getFormatter() {
            return Formatter.defaultFormatter;
        }

        @Override
        public String getValue(int index) throws MissingValueException {
            return ((Slice)((GTKPie)GTKPie.this).displaySlices.get((int)index)).subgroup;
        }
    }

    class ProcessedCategory
    implements StringPipe {
        private GTKPie container;

        public ProcessedCategory(GTKPie container) {
            this.container = container;
        }

        @Override
        public void init(AInitAction ia) {
            this.container.buildPie(ia);
            ia.setValueCount(this.container.displaySlices.size());
            ia.setCategoryPipe(null);
            ia.setUniqueValueVector(null);
        }

        @Override
        public void reset(AResetAction ia) {
        }

        @Override
        public Formatter getFormatter() {
            return Formatter.defaultFormatter;
        }

        @Override
        public String getValue(int index) throws MissingValueException {
            return ((Slice)((GTKPie)GTKPie.this).displaySlices.get((int)index)).categoryName;
        }
    }

    private class SectorPieComparator
    implements Comparator<Slice> {
        private SectorPieComparator() {
        }

        @Override
        public int compare(Slice s1, Slice s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            if (GTKPie.this.renderer.getModel().getSubgroupVariable() != null) {
                if (s1.subgroup != null && s2.subgroup != null && s1.subgroup.equals(s2.subgroup)) {
                    return this.compareValues(s1, s2);
                }
            } else {
                return this.compareValues(s1, s2);
            }
            return 0;
        }

        private int compareValues(Slice s1, Slice s2) {
            double v2 = s2.value;
            double v1 = s1.value;
            double diff = v2 - v1;
            if (diff > 0.0) {
                return 1;
            }
            if (diff < 0.0) {
                return -1;
            }
            return 0;
        }
    }

    class DisplaySlice
    extends Slice {
        protected Shape shape;
        protected int labelOverhang;
        protected double startAngle;
        protected double endAngle;
        protected double radius;
        protected double inRadius;

        DisplaySlice() {
        }

        @Override
        public String toString() {
            return "C=" + this.categoryName + "S=" + this.startAngle + ":E=" + this.endAngle;
        }

        public boolean isHighlightOn() {
            boolean result = false;
            for (int i = 0; i < this.valueIndices.length; ++i) {
                try {
                    result |= GTKPie.this.highlightOn.getValue(this.valueIndices[i]);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            return result;
        }

        public double getHighlightedPercentage() {
            double result = 0.0;
            for (int i = 0; i < this.valueIndices.length; ++i) {
                try {
                    if (!GTKPie.this.highlightOn.getValue(this.valueIndices[i])) continue;
                    result += GTKPie.this.highlightPercentage.getValue(this.valueIndices[i]);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            return result /= (double)this.valueIndices.length;
        }
    }

    class Slice
    implements Comparable<Slice> {
        int valueIndex;
        int[] valueIndices;
        protected double value;
        protected double extent;
        String categoryName;
        String insideLabel;
        String outsideLabel;
        String subgroup;
        Color fill;
        boolean highlight = false;
        boolean invisible = false;
        boolean explode = false;
        boolean isOther = false;
        boolean isSubGroupSlice = false;
        double hPercentage;

        public Slice() {
            this.value = 0.0;
            this.extent = 0.0;
            this.categoryName = "";
            this.insideLabel = "";
            this.outsideLabel = "";
            this.fill = Color.blue;
        }

        public Slice(double v, double total, String cat, String inLab, String outLab, String sub, Color col, boolean high, double highPercentage, int valueIndex, boolean isSubGrpSlice) {
            this.value = v;
            this.extent = total == 0.0 ? 0.0 : v / total * 2.0 * Math.PI;
            this.categoryName = cat;
            this.insideLabel = inLab;
            this.outsideLabel = outLab;
            this.subgroup = sub;
            this.fill = col;
            this.highlight = high;
            this.hPercentage = highPercentage;
            this.valueIndex = valueIndex;
            this.valueIndices = new int[]{valueIndex};
            this.isSubGroupSlice = isSubGrpSlice;
        }

        public String toString() {
            return "L=" + this.insideLabel + ":" + this.outsideLabel + ":V=" + this.value + ":X=" + this.extent;
        }

        @Override
        public int compareTo(Slice s) {
            if (this.extent < s.extent) {
                return -1;
            }
            if (this.extent > s.extent) {
                return 1;
            }
            return 0;
        }
    }
}

