/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AEllipse;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Image;

public class Ellipse
extends AEllipse {
    public Ellipse() {
        super(new Transform());
    }

    public static void drawEllipse(Channel channel, double xCenter, double yCenter, double xRadius, double yRadius, double angle, Color color, Color edgeColor, float lineWidth, int stipplePattern, int stippleFactor, boolean edgeOn, boolean fillOn, boolean SVGRender, Image skin, int skinType, Image[] pixelBenderImages, float dpiFactor, boolean fillPatternOn, int fillPatternType, double fillPatternWidth, Color fillPatternColor, double fillPatternScaleFactor) {
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glLineWidth(lineWidth);
        channel.glFillPatternType(fillPatternType);
        channel.glFillPatternWidth(fillPatternWidth);
        channel.glFillPatternColor(fillPatternColor);
        channel.glFillPatternScaleFactor(fillPatternScaleFactor);
        if (stippleFactor > 0) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFactor, (int)((short)stipplePattern));
        }
        if (edgeOn && fillOn) {
            if (fillPatternOn) {
                channel.glPolygonMode(11);
            } else {
                channel.glPolygonMode(4);
            }
        } else if (fillOn) {
            if (fillPatternOn) {
                channel.glPolygonMode(9);
            } else {
                channel.glPolygonMode(3);
            }
        } else if (edgeOn) {
            if (fillPatternOn) {
                channel.glPolygonMode(10);
            } else {
                channel.glPolygonMode(2);
            }
        } else {
            channel.glPolygonMode(8);
        }
        channel.glSkinType(skinType);
        channel.glPixelBenderImages(pixelBenderImages);
        channel.glDPIScaleFactor(dpiFactor);
        if (skinType != 0 && fillOn && fillPatternOn) {
            channel.glSkinRenderMode(3);
            channel.glPolygonMode(3);
            channel.glEllipse(xCenter, yCenter, xRadius, yRadius, angle, SVGRender, null);
            channel.glSkinType(0);
            channel.glPixelBenderImages(null);
            channel.glPolygonMode(8);
            channel.glEllipse(xCenter, yCenter, xRadius, yRadius, angle, SVGRender, null);
            channel.glSkinType(skinType);
            channel.glSkinRenderMode(12);
            channel.glPolygonMode(3);
            channel.glEllipse(xCenter, yCenter, xRadius, yRadius, angle, SVGRender, skin);
        } else {
            channel.glEllipse(xCenter, yCenter, xRadius, yRadius, angle, SVGRender, skin);
        }
        if (stippleFactor > 0) {
            channel.glDisable(6);
        }
        channel.glSkinType(0);
        channel.glPixelBenderImages(null);
        channel.glPopAttrib();
    }

    public static void drawEllipseSoftware(Channel channel, double xCenter, double yCenter, double xRadius, double yRadius, double angle, Color color, Color edgeColor, float lineWidth, int stipplePattern, int stippleFactor, boolean edgeOn, boolean fillOn) {
        double ry;
        double rx;
        double y;
        double x;
        double theta;
        int i;
        channel.glPushAttrib(0);
        int numOfPoints = 200;
        if (fillOn) {
            channel.glColor(color);
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            for (i = 0; i < numOfPoints; ++i) {
                theta = Math.PI * 2 * (double)i / (double)(numOfPoints - 1);
                x = xRadius * Math.cos(theta);
                y = yRadius * Math.sin(theta);
                if (angle != 0.0) {
                    rx = Math.cos(angle) * x - Math.sin(angle) * y;
                    ry = Math.sin(angle) * x + Math.cos(angle) * y;
                    x = rx;
                    y = ry;
                }
                channel.glVertex(x, y, 0.0);
            }
            channel.glEnd();
        }
        if (edgeOn) {
            channel.glColor(edgeColor);
            channel.glLineWidth(lineWidth);
            if (stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(stippleFactor, (int)((short)stipplePattern));
            }
            channel.glBegin(1);
            channel.glNormal(0.0, 0.0, 1.0);
            for (i = 0; i < numOfPoints; ++i) {
                theta = Math.PI * 2 * (double)i / (double)(numOfPoints - 1);
                x = xRadius * Math.cos(theta);
                y = yRadius * Math.sin(theta);
                if (angle != 0.0) {
                    rx = Math.cos(angle) * x - Math.sin(angle) * y;
                    ry = Math.sin(angle) * x + Math.cos(angle) * y;
                    x = rx;
                    y = ry;
                }
                channel.glVertex(x, y, 0.0);
            }
            channel.glEnd();
            if (stippleFactor > 0) {
                channel.glDisable(6);
            }
        }
        channel.glPopAttrib();
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        if (this.highlightOnly && !this.highlightOn.getValue(index)) {
            return;
        }
        if (ba.getChannel().isSVGSelectionMode()) {
            ba.getChannel().setSVGSelectionText(this.userDataToString(index));
        }
        float lw = this.highlightOn.getValue(index) ? (float)this.highlightWidth : (float)this.lineWidth.getValue(index);
        Color lc = this.highlightOn.getValue(index) && this.highlightColor != null ? this.highlightColor : this.edgeColor.getValue(index);
        int scaledStippleFactor = (int)(0.5 + this.stippleScaleFactor * this.stippleFactor.getValue(index));
        if (ba.getChannel().getBackbufferId() == -1) {
            Ellipse.drawEllipseSoftware(ba.getChannel(), this.xCenter.getValue(index), this.yCenter.getValue(index), this.xRadius.getValue(index), this.yRadius.getValue(index), this.angle.getValue(index), this.color.getValue(index), lc, lw, (int)this.stipplePattern.getValue(index), scaledStippleFactor, this.edgeOn.getValue(index), this.fillOn.getValue(index));
        } else {
            Ellipse.drawEllipse(ba.getChannel(), this.xCenter.getValue(index), this.yCenter.getValue(index), this.xRadius.getValue(index), this.yRadius.getValue(index), this.angle.getValue(index), this.color.getValue(index), lc, lw, (int)this.stipplePattern.getValue(index), scaledStippleFactor, this.edgeOn.getValue(index), this.fillOn.getValue(index), this.SVGRender, this.skin, this.skinType, this.pixelBenderImages, this.DPIScaleFactor, this.fillPatternOn.getValue(index), this.fillPatternType.getValue(index), this.fillPatternWidth.getValue(index), this.fillPatternColor.getValue(index), this.fillPatternScaleFactor.getValue(index));
        }
    }
}

