/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class Dendrogram
extends Element {
    public static final int ORTHOGONAL = 1;
    public static final int TRIANGULAR = 2;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public final NumericProperty coordX = new NumericProperty(this, true);
    public final NumericProperty coordY = new NumericProperty(this, true);
    private final NumericProperty coordZ = new NumericProperty(this, true);
    public final NumericProperty parentX = new NumericProperty(this, true);
    public final NumericProperty parentY = new NumericProperty(this, true);
    private final NumericProperty parentZ = new NumericProperty(this, true);
    public final NumericProperty drawCount = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final IntegerProperty lineWidth = new IntegerProperty(this, true);
    public final IntegerProperty linePattern = new IntegerProperty(this, true);
    public int connectType = 1;
    public int orientation = 2;

    public Dendrogram() {
        super(new Transform());
        this.drawCount.setValue(1.0);
        this.color.setValue(Color.black);
        this.linePattern.setValue(-1);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        BoundingBox box = bBoxAction.getElementBoundingBox();
        bBoxAction.pt1.set(this.coordX.getValue(index), this.coordY.getValue(index), 1.0);
        box.union(bBoxAction.pt1);
        bBoxAction.pt1.set(this.parentX.getValue(index), this.parentY.getValue(index), 1.0);
        box.union(bBoxAction.pt1);
    }

    @Override
    protected void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        double bx = this.coordX.getValue(index);
        double by = this.coordY.getValue(index);
        double bz = this.coordZ.getValue(index);
        double ex = this.parentX.getValue(index);
        double ey = this.parentY.getValue(index);
        double ez = this.parentZ.getValue(index);
        Channel channel = ba.getChannel();
        channel.glLineWidth((float)this.lineWidth.getValue());
        boolean stippleNeeded = false;
        if (this.linePattern.getValue() != -1) {
            stippleNeeded = true;
            double stippleScaleFactor = 1.0;
            int patternIndex = this.linePattern.getValue();
            int stipplePattern = SASLinePatterns.getStipplePattern((int)patternIndex);
            int stippleFactor = (int)(0.5 + stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)patternIndex));
            channel.glEnable(6);
            channel.glLineStipple(stippleFactor, stipplePattern);
        }
        channel.glColor(this.color.getValue());
        channel.glBegin(1);
        switch (this.connectType) {
            case 2: {
                channel.glVertex(bx, by, bz);
                channel.glVertex(ex, ey, ez);
                break;
            }
            case 1: {
                channel.glVertex(bx, by, bz);
                switch (this.orientation) {
                    case 1: {
                        channel.glVertex(ex, by, bz);
                        break;
                    }
                    case 2: {
                        channel.glVertex(bx, ey, bz);
                    }
                }
                channel.glVertex(ex, ey, ez);
            }
        }
        channel.glEnd();
        if (stippleNeeded) {
            channel.glDisable(6);
        }
    }

    public int getConnectType() {
        return this.connectType;
    }

    public void setConnectType(int connectType) {
        this.connectType = connectType;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }
}

