/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.SASColors;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.SelectEntry;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.GanttBox;
import com.sas.graphics.util.gtk.gl.ResetAction;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;

public class ComplexGanttBox
extends Composite {
    public static final int BOX_STYLE_HALF_BOX = 0;
    public static final int BOX_STYLE_MILESTONE = 1;
    public static final int BOX_STYLE_SUMMARY = 2;
    public static final int BOX_STYLE_SUMMARY_ALL = 3;
    public static final int BOX_STYLE_FULL_BOX = 4;
    public static final int BOX_STYLE_FULL_MILESTONE = 5;
    public static final int ARROW_SHAPE_OPEN = 0;
    public static final int ARROW_SHAPE_CLOSED = 1;
    public static final int ARROW_SHAPE_FILLED = 2;
    public static final int ARROW_SHAPE_BARBED = 3;
    public int shape = 0;
    public final NumericProperty earlyStart = new NumericProperty(this, true);
    public final NumericProperty earlyFinish = new NumericProperty(this, true);
    public final NumericProperty lateStart = new NumericProperty(this, true);
    public final NumericProperty lateFinish = new NumericProperty(this, true);
    public final NumericProperty actualStart = new NumericProperty(this, true);
    public final NumericProperty actualFinish = new NumericProperty(this, true);
    public final NumericProperty resourceStart = new NumericProperty(this, true);
    public final NumericProperty resourceFinish = new NumericProperty(this, true);
    public final NumericProperty custom1Start = new NumericProperty(this, true);
    public final NumericProperty custom1Finish = new NumericProperty(this, true);
    public final NumericProperty custom2Start = new NumericProperty(this, true);
    public final NumericProperty custom2Finish = new NumericProperty(this, true);
    public final NumericProperty baselineStart = new NumericProperty(this, true);
    public final NumericProperty baselineFinish = new NumericProperty(this, true);
    public final NumericProperty duration = new NumericProperty(this, true);
    public final NumericProperty target = new NumericProperty(this, true);
    public final StringProperty color = new StringProperty(this, true);
    public final NumericProperty drawBar = new NumericProperty(this, true);
    public final BooleanProperty ganttBoxVisible = new BooleanProperty(this, true);
    public final BooleanProperty actualBoxVisible = new BooleanProperty(this, true);
    public final BooleanProperty resourceBoxVisible = new BooleanProperty(this, true);
    public final BooleanProperty customBox1Visible = new BooleanProperty(this, true);
    public final BooleanProperty customBox2Visible = new BooleanProperty(this, true);
    public final BooleanProperty baselineBoxVisible = new BooleanProperty(this, true);
    public final ColorProperty normalColor = new ColorProperty(this, true);
    public final ColorProperty slackColor = new ColorProperty(this, true);
    public final ColorProperty actualColor = new ColorProperty(this, true);
    public final ColorProperty resourceColor = new ColorProperty(this, true);
    public final ColorProperty custom1Color = new ColorProperty(this, true);
    public final ColorProperty custom2Color = new ColorProperty(this, true);
    public final ColorProperty baselineColor = new ColorProperty(this, true);
    public final ColorProperty criticalColor = new ColorProperty(this, true);
    public final ColorProperty breaktimeColor = new ColorProperty(this, true);
    public final ColorProperty milestoneColor = new ColorProperty(this, true);
    public final IntegerProperty milestoneSymbol = new IntegerProperty(this, true);
    public final NumericProperty milestoneSize = new NumericProperty(this, true);
    public final BooleanProperty milestoneVisible = new BooleanProperty(this, true);
    public final BooleanProperty slackTimeVisible = new BooleanProperty(this, true);
    public final ColorProperty targetColor = new ColorProperty(this, true);
    public final IntegerProperty targetSymbol = new IntegerProperty(this, true);
    public final NumericProperty targetSize = new NumericProperty(this, true);
    public final BooleanProperty targetVisible = new BooleanProperty(this, true);
    public final ColorProperty outlineColor = new ColorProperty(this, true);
    public final ColorProperty connectingLineColor = new ColorProperty(this, true);
    public final NumericProperty connectingLineWidth = new NumericProperty(this, true);
    public final IntegerProperty normalFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty slackFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty actualFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty resourceFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty custom1FillStyle = new IntegerProperty(this, true);
    public final IntegerProperty custom2FillStyle = new IntegerProperty(this, true);
    public final IntegerProperty baselineFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty criticalFillStyle = new IntegerProperty(this, true);
    public final StringProperty markerTask = new StringProperty(this, false);
    public final StringProperty markerLocation = new StringProperty(this, false);
    public final NumericProperty markerPosition = new NumericProperty(this, false);
    public final IntegerProperty markerSymbol = new IntegerProperty(this, false);
    public final StringProperty markerSymbolColor = new StringProperty(this, false);
    public final StringProperty markerText = new StringProperty(this, false);
    public final StringProperty markerTextColor = new StringProperty(this, false);
    public final NumericProperty markerTextJustification = new NumericProperty(this, false);
    MarkerInfo[] markerInfo = null;
    public final StringProperty annoTask = new StringProperty(this, false);
    public final StringProperty annoLocation = new StringProperty(this, false);
    public final NumericProperty annoPosition = new NumericProperty(this, false);
    public final IntegerProperty annoSymbol = new IntegerProperty(this, false);
    public final StringProperty annoSymbolColor = new StringProperty(this, false);
    public final StringProperty annoText = new StringProperty(this, false);
    public final StringProperty annoTextColor = new StringProperty(this, false);
    public final NumericProperty annoTextJustification = new NumericProperty(this, false);
    private Font annoFont = FontManager.getFont((String)"Helvetica", (int)0, (int)12);
    public final NumericProperty annoSymbolSize = new NumericProperty(this, false);
    private Color annoFontColor = Color.BLACK;
    MarkerInfo[] annoInfo = null;
    public final IntegerProperty boxConnectionStyle = new IntegerProperty(this, true);
    public final IntegerProperty boxStyle = new IntegerProperty(this, true);
    public final NumericProperty boxThickness = new NumericProperty(this, true);
    public final NumericProperty boxSizeAdjustment = new NumericProperty(this, true);
    public final BooleanProperty actualOverlaid = new BooleanProperty(this, true);
    public final StringProperty task = new StringProperty(this, true);
    public final StringProperty calendar = new StringProperty(this, true);
    private ArrayList successorPipes = new ArrayList();
    private HashMap taskPoints = new HashMap();
    public final StringProperty breaktimeCalendar = new StringProperty(this, false);
    public final NumericProperty breaktimeDuration = new NumericProperty(this, false);
    public final NumericProperty breaktimeStart = new NumericProperty(this, false);
    public final NumericProperty breaktimeFinish = new NumericProperty(this, false);
    private HashMap breaktimes = new HashMap();
    public final IntegerProperty yStart = new IntegerProperty(this, true);
    public final IntegerProperty yEnd = new IntegerProperty(this, true);
    public final IntegerProperty xEnd = new IntegerProperty(this, true);
    protected GanttBox highlightBox = new GanttBox();
    protected GanttBox ganttBox = new GanttBox();
    protected GanttBox actualBox = new GanttBox();
    protected GanttBox resourceBox = new GanttBox();
    protected GanttBox customBox1 = new GanttBox();
    protected GanttBox customBox2 = new GanttBox();
    protected GanttBox baselineBox = new GanttBox();
    protected int ganttSize = 0;
    protected int actualSize = 0;
    protected int resourceSize = 0;
    protected int customSize1 = 0;
    protected int customSize2 = 0;
    protected int baselineSize = 0;
    protected int totalBoxSize = 0;
    private int valueCount = 0;
    private int viewStart;
    private int viewEnd;
    private double ganttSpace = 0.0;
    public final BooleanProperty highlightOn = new BooleanProperty(this, true);
    public final ColorProperty highlightFillColor = new ColorProperty(this, true);
    public final ColorProperty highlightEdgeColor = new ColorProperty(this, true);
    boolean ok = true;

    public ComplexGanttBox() {
        this.boxStyle.setValue(0);
        this.boxConnectionStyle.setValue(0);
        this.actualOverlaid.setValue(false);
        this.boxThickness.setValue(1.0);
        this.boxSizeAdjustment.setValue(0.25);
        this.duration.setValue(-99.0);
        this.target.setValue(0.0);
        this.drawBar.setValue(1.0);
        this.annoSymbolSize.setValue(-1.0);
        this.normalColor.setValue(new Color(175, 193, 122));
        this.slackColor.setValue(new Color(242, 229, 157));
        this.criticalColor.setValue(new Color(218, 123, 123));
        this.resourceColor.setValue(new Color(171, 145, 169));
        this.custom1Color.setValue(new Color(255, 255, 119));
        this.custom2Color.setValue(new Color(192, 192, 192));
        this.actualColor.setValue(new Color(156, 167, 199));
        this.baselineColor.setValue(new Color(195, 210, 213));
        this.breaktimeColor.setValue(new Color(195, 210, 213));
        this.highlightFillColor.setValue(new Color(234, 234, 234));
        this.highlightEdgeColor.setValue(Color.BLACK);
        this.highlightOn.setValue(false);
        this.outlineColor.setValue(new Color(128, 128, 128));
        this.milestoneColor.setValue(new Color(196, 232, 183));
        this.milestoneSymbol.setValue(108);
        this.milestoneSize.setValue(0.0);
        this.milestoneVisible.setValue(true);
        this.targetColor.setValue(new Color(252, 183, 53));
        this.targetSymbol.setValue(112);
        this.targetSize.setValue(0.0);
        this.targetVisible.setValue(true);
        this.normalFillStyle.setValue(2);
        this.slackFillStyle.setValue(2);
        this.actualFillStyle.setValue(2);
        this.resourceFillStyle.setValue(2);
        this.custom1FillStyle.setValue(2);
        this.custom2FillStyle.setValue(2);
        this.baselineFillStyle.setValue(2);
        this.criticalFillStyle.setValue(2);
        this.highlightBox.boxStyle.setValue(3);
        this.highlightBox.highlightOn.connectFrom(this.highlightOn);
        this.highlightBox.highlightFillColor.connectFrom(this.highlightFillColor);
        this.highlightBox.boxSizeAdjustment.connectFrom(this.boxSizeAdjustment);
        this.highlightBox.task.connectFrom(this.task);
        this.highlightBox.xEnd.connectFrom(this.xEnd);
        this.highlightBox.selectEnabled.setValue(false);
        this.annoSymbolSize.connectFrom(this.annoSymbolSize);
        this.ganttBox.boxStyle.setValue(0);
        this.ganttBox.boxConnectionStyle.connectFrom(this.boxConnectionStyle);
        this.ganttBox.earlyStart.connectFrom(this.earlyStart);
        this.ganttBox.earlyFinish.connectFrom(this.earlyFinish);
        this.ganttBox.lateStart.connectFrom(this.lateStart);
        this.ganttBox.lateFinish.connectFrom(this.lateFinish);
        this.ganttBox.duration.connectFrom(this.duration);
        this.ganttBox.drawBar.connectFrom(this.drawBar);
        this.ganttBox.target.connectFrom(this.target);
        this.ganttBox.normalColor.connectFrom(this.normalColor);
        this.ganttBox.slackColor.connectFrom(this.slackColor);
        this.ganttBox.criticalColor.connectFrom(this.criticalColor);
        this.ganttBox.normalFillStyle.connectFrom(this.normalFillStyle);
        this.ganttBox.slackFillStyle.connectFrom(this.slackFillStyle);
        this.ganttBox.criticalFillStyle.connectFrom(this.criticalFillStyle);
        this.ganttBox.outlineColor.connectFrom(this.outlineColor);
        this.ganttBox.milestoneColor.connectFrom(this.milestoneColor);
        this.ganttBox.milestoneSymbol.connectFrom(this.milestoneSymbol);
        this.ganttBox.milestoneSize.connectFrom(this.milestoneSize);
        this.ganttBox.milestoneVisible.connectFrom(this.milestoneVisible);
        this.ganttBox.targetColor.connectFrom(this.targetColor);
        this.ganttBox.targetSymbol.connectFrom(this.targetSymbol);
        this.ganttBox.targetSize.connectFrom(this.targetSize);
        this.ganttBox.targetVisible.connectFrom(this.targetVisible);
        this.ganttBox.color.connectFrom(this.color);
        this.ganttBox.calendar.connectFrom(this.calendar);
        this.ganttBox.breaktimeColor.connectFrom(this.breaktimeColor);
        this.ganttBox.slackTimeVisible.connectFrom(this.slackTimeVisible);
        this.actualBox.boxStyle.setValue(0);
        this.actualBox.earlyStart.connectFrom(this.actualStart);
        this.actualBox.earlyFinish.connectFrom(this.actualFinish);
        this.actualBox.lateStart.connectFrom(this.actualStart);
        this.actualBox.lateFinish.connectFrom(this.actualFinish);
        this.actualBox.criticalColor.connectFrom(this.actualColor);
        this.actualBox.criticalFillStyle.connectFrom(this.actualFillStyle);
        this.actualBox.outlineColor.connectFrom(this.outlineColor);
        this.actualBox.milestoneColor.connectFrom(this.milestoneColor);
        this.actualBox.milestoneSymbol.connectFrom(this.milestoneSymbol);
        this.actualBox.milestoneSize.connectFrom(this.milestoneSize);
        this.actualBox.milestoneVisible.connectFrom(this.milestoneVisible);
        this.actualBox.targetSize.connectFrom(this.targetSize);
        this.actualBox.targetVisible.connectFrom(this.targetVisible);
        this.actualBox.drawBar.connectFrom(this.drawBar);
        this.actualBox.calendar.connectFrom(this.calendar);
        this.actualBox.breaktimeColor.connectFrom(this.breaktimeColor);
        this.resourceBox.boxStyle.setValue(0);
        this.resourceBox.earlyStart.connectFrom(this.resourceStart);
        this.resourceBox.earlyFinish.connectFrom(this.resourceFinish);
        this.resourceBox.lateStart.connectFrom(this.resourceStart);
        this.resourceBox.lateFinish.connectFrom(this.resourceFinish);
        this.resourceBox.criticalColor.connectFrom(this.resourceColor);
        this.resourceBox.criticalFillStyle.connectFrom(this.resourceFillStyle);
        this.resourceBox.outlineColor.connectFrom(this.outlineColor);
        this.resourceBox.milestoneColor.connectFrom(this.milestoneColor);
        this.resourceBox.milestoneSymbol.connectFrom(this.milestoneSymbol);
        this.resourceBox.milestoneSize.connectFrom(this.milestoneSize);
        this.resourceBox.milestoneVisible.connectFrom(this.milestoneVisible);
        this.resourceBox.targetSize.connectFrom(this.targetSize);
        this.resourceBox.targetVisible.connectFrom(this.targetVisible);
        this.resourceBox.drawBar.connectFrom(this.drawBar);
        this.resourceBox.calendar.connectFrom(this.calendar);
        this.resourceBox.breaktimeColor.connectFrom(this.breaktimeColor);
        this.baselineBox.boxStyle.setValue(0);
        this.baselineBox.earlyStart.connectFrom(this.baselineStart);
        this.baselineBox.earlyFinish.connectFrom(this.baselineFinish);
        this.baselineBox.lateStart.connectFrom(this.baselineStart);
        this.baselineBox.lateFinish.connectFrom(this.baselineFinish);
        this.baselineBox.criticalColor.connectFrom(this.baselineColor);
        this.baselineBox.criticalFillStyle.connectFrom(this.baselineFillStyle);
        this.baselineBox.outlineColor.connectFrom(this.outlineColor);
        this.baselineBox.milestoneColor.connectFrom(this.milestoneColor);
        this.baselineBox.milestoneSymbol.connectFrom(this.milestoneSymbol);
        this.baselineBox.milestoneSize.connectFrom(this.milestoneSize);
        this.baselineBox.milestoneVisible.connectFrom(this.milestoneVisible);
        this.baselineBox.targetSize.connectFrom(this.targetSize);
        this.baselineBox.targetVisible.connectFrom(this.targetVisible);
        this.baselineBox.drawBar.connectFrom(this.drawBar);
        this.baselineBox.calendar.connectFrom(this.calendar);
        this.baselineBox.breaktimeColor.connectFrom(this.breaktimeColor);
        this.customBox1.boxStyle.setValue(0);
        this.customBox1.earlyStart.connectFrom(this.custom1Start);
        this.customBox1.earlyFinish.connectFrom(this.custom1Finish);
        this.customBox1.lateStart.connectFrom(this.custom1Start);
        this.customBox1.lateFinish.connectFrom(this.custom1Finish);
        this.customBox1.criticalColor.connectFrom(this.custom1Color);
        this.customBox1.criticalFillStyle.connectFrom(this.custom1FillStyle);
        this.customBox1.outlineColor.connectFrom(this.outlineColor);
        this.customBox1.milestoneColor.connectFrom(this.milestoneColor);
        this.customBox1.milestoneSymbol.connectFrom(this.milestoneSymbol);
        this.customBox1.milestoneSize.connectFrom(this.milestoneSize);
        this.customBox1.milestoneVisible.connectFrom(this.milestoneVisible);
        this.customBox1.targetSize.connectFrom(this.targetSize);
        this.customBox1.targetVisible.connectFrom(this.targetVisible);
        this.customBox1.drawBar.connectFrom(this.drawBar);
        this.customBox1.calendar.connectFrom(this.calendar);
        this.customBox1.breaktimeColor.connectFrom(this.breaktimeColor);
        this.customBox2.boxStyle.setValue(0);
        this.customBox2.earlyStart.connectFrom(this.custom2Start);
        this.customBox2.earlyFinish.connectFrom(this.custom2Finish);
        this.customBox2.lateStart.connectFrom(this.custom2Start);
        this.customBox2.lateFinish.connectFrom(this.custom2Finish);
        this.customBox2.criticalColor.connectFrom(this.custom2Color);
        this.customBox2.criticalFillStyle.connectFrom(this.custom2FillStyle);
        this.customBox2.outlineColor.connectFrom(this.outlineColor);
        this.customBox2.milestoneColor.connectFrom(this.milestoneColor);
        this.customBox2.milestoneSymbol.connectFrom(this.milestoneSymbol);
        this.customBox2.milestoneSize.connectFrom(this.milestoneSize);
        this.customBox2.milestoneVisible.connectFrom(this.milestoneVisible);
        this.customBox2.targetSize.connectFrom(this.targetSize);
        this.customBox2.targetVisible.connectFrom(this.targetVisible);
        this.customBox2.drawBar.connectFrom(this.drawBar);
        this.customBox2.calendar.connectFrom(this.calendar);
        this.customBox2.breaktimeColor.connectFrom(this.breaktimeColor);
    }

    @Override
    public void setUserData(Object o) {
        super.setUserData(o);
        this.highlightBox.setUserData(o);
        this.ganttBox.setUserData(o);
        this.actualBox.setUserData(o);
        this.resourceBox.setUserData(o);
        this.baselineBox.setUserData(o);
        this.customBox1.setUserData(o);
        this.customBox2.setUserData(o);
    }

    public void setAnnoFont(Font f) {
        if (f != null) {
            this.annoFont = f;
        }
    }

    public void setAnnoFontColor(Color c) {
        if (c != null) {
            this.annoFontColor = c;
        }
    }

    public void addSuccessorPipe(StringPipe sucessorPipe) {
        this.successorPipes.add(sucessorPipe);
    }

    public void removeAllSuccessorPipes() {
        this.successorPipes.removeAll(this.successorPipes);
    }

    @Override
    public void init(AInitAction initAction) {
        this.removeAllElements();
        this.addElement(this.highlightBox);
        this.ganttSize = 0;
        if (this.earlyStart.isConnected() && this.ganttBoxVisible.getValue()) {
            if (!this.lateStart.isConnected()) {
                this.ganttBox.lateStart.connectFrom(this.earlyStart);
                this.ganttBox.lateFinish.connectFrom(this.earlyFinish);
            } else {
                this.ganttBox.lateStart.connectFrom(this.lateStart);
                this.ganttBox.lateFinish.connectFrom(this.lateFinish);
            }
            if (this.duration.isConnected()) {
                this.ganttBox.duration.connectFrom(this.duration);
            }
            if (this.target.isConnected()) {
                this.ganttBox.target.connectFrom(this.target);
            }
            if (this.drawBar.isConnected()) {
                this.ganttBox.drawBar.connectFrom(this.drawBar);
            }
            if (!this.breaktimes.isEmpty() && this.calendar.isConnected()) {
                this.ganttBox.setBreaktimeHashMap(this.breaktimes);
            }
            this.ganttSize = 1;
            this.addElement(this.ganttBox);
        }
        this.actualSize = 0;
        if (this.actualStart.isConnected() && this.actualBoxVisible.getValue()) {
            if (this.duration.isConnected()) {
                this.actualBox.duration.connectFrom(this.duration);
            }
            if (this.drawBar.isConnected()) {
                this.actualBox.drawBar.connectFrom(this.drawBar);
            }
            if (!this.breaktimes.isEmpty() && this.calendar.isConnected()) {
                this.actualBox.setBreaktimeHashMap(this.breaktimes);
            }
            this.actualSize = 1;
            this.addElement(this.actualBox);
        }
        this.resourceSize = 0;
        if (this.resourceStart.isConnected() && this.resourceBoxVisible.getValue()) {
            if (this.duration.isConnected()) {
                this.resourceBox.duration.connectFrom(this.duration);
            }
            if (this.drawBar.isConnected()) {
                this.resourceBox.drawBar.connectFrom(this.drawBar);
            }
            if (!this.breaktimes.isEmpty() && this.calendar.isConnected()) {
                this.resourceBox.setBreaktimeHashMap(this.breaktimes);
            }
            this.resourceSize = 1;
            this.addElement(this.resourceBox);
        }
        this.baselineSize = 0;
        if (this.baselineStart.isConnected() && this.baselineBoxVisible.getValue()) {
            if (this.duration.isConnected()) {
                this.baselineBox.duration.connectFrom(this.duration);
            }
            if (this.drawBar.isConnected()) {
                this.baselineBox.drawBar.connectFrom(this.drawBar);
            }
            if (!this.breaktimes.isEmpty() && this.calendar.isConnected()) {
                this.baselineBox.setBreaktimeHashMap(this.breaktimes);
            }
            this.baselineSize = 1;
            this.addElement(this.baselineBox);
        }
        this.customSize1 = 0;
        if (this.custom1Start.isConnected() && this.customBox1Visible.getValue()) {
            if (this.duration.isConnected()) {
                this.customBox1.duration.connectFrom(this.duration);
            }
            if (this.drawBar.isConnected()) {
                this.customBox1.drawBar.connectFrom(this.drawBar);
            }
            if (!this.breaktimes.isEmpty() && this.calendar.isConnected()) {
                this.customBox1.setBreaktimeHashMap(this.breaktimes);
            }
            this.customSize1 = 1;
            this.addElement(this.customBox1);
        }
        this.customSize2 = 0;
        if (this.custom2Start.isConnected() && this.customBox2Visible.getValue()) {
            if (this.duration.isConnected()) {
                this.customBox2.duration.connectFrom(this.duration);
            }
            if (this.drawBar.isConnected()) {
                this.customBox2.drawBar.connectFrom(this.drawBar);
            }
            if (!this.breaktimes.isEmpty() && this.calendar.isConnected()) {
                this.customBox2.setBreaktimeHashMap(this.breaktimes);
            }
            this.customSize2 = 1;
            this.addElement(this.customBox2);
        }
        this.totalBoxSize = this.ganttSize + this.actualSize + this.resourceSize + this.baselineSize + this.customSize1 + 2 * this.customSize2;
        super.init(initAction);
        for (int i = 0; i < this.successorPipes.size(); ++i) {
            StringPipe sp = (StringPipe)this.successorPipes.get(i);
            sp.init(initAction);
        }
        this.valueCount = initAction.getValueCount();
    }

    public void preProcess() {
        int index;
        double thickness = 1.0;
        try {
            thickness = this.boxThickness.getValue(0);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        AInitAction ia = new AInitAction();
        this.transform.translateY.init(ia);
        int valueCount = ia.getValueCount();
        this.taskPoints.clear();
        for (index = 0; index < valueCount; ++index) {
            try {
                String t = this.task.getValue(index).trim();
                if (t == null) continue;
                double to = Double.NaN;
                double from = Double.NaN;
                if (this.ganttBoxVisible.getValue()) {
                    try {
                        to = this.earlyStart.getValue(index);
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    try {
                        from = this.lateFinish.getValue(index);
                    }
                    catch (MissingValueException e) {
                        try {
                            from = this.lateStart.getValue(index);
                        }
                        catch (MissingValueException ex) {
                            from = this.earlyFinish.getValue(index);
                        }
                    }
                } else if (this.actualBoxVisible.getValue()) {
                    try {
                        to = this.actualStart.getValue(index);
                    }
                    catch (MissingValueException e) {
                        // empty catch block
                    }
                    try {
                        from = this.actualFinish.getValue(index);
                    }
                    catch (MissingValueException e) {}
                } else if (this.resourceBoxVisible.getValue()) {
                    try {
                        to = this.resourceStart.getValue(index);
                    }
                    catch (MissingValueException e) {
                        // empty catch block
                    }
                    try {
                        from = this.resourceFinish.getValue(index);
                    }
                    catch (MissingValueException e) {}
                } else if (this.customBox1Visible.getValue()) {
                    try {
                        to = this.custom1Start.getValue(index);
                    }
                    catch (MissingValueException e) {
                        // empty catch block
                    }
                    try {
                        from = this.custom1Finish.getValue(index);
                    }
                    catch (MissingValueException e) {}
                } else if (this.baselineBoxVisible.getValue()) {
                    try {
                        to = this.baselineStart.getValue(index);
                    }
                    catch (MissingValueException e) {
                        // empty catch block
                    }
                    try {
                        from = this.baselineFinish.getValue(index);
                    }
                    catch (MissingValueException e) {
                        // empty catch block
                    }
                }
                double es = Double.NaN;
                try {
                    es = this.earlyStart.getValue(index);
                }
                catch (MissingValueException e) {
                    // empty catch block
                }
                double lf = Double.NaN;
                try {
                    lf = this.lateFinish.getValue(index);
                }
                catch (MissingValueException e) {
                    // empty catch block
                }
                double ef = Double.NaN;
                try {
                    ef = this.earlyFinish.getValue(index);
                }
                catch (MissingValueException e) {
                    // empty catch block
                }
                double ls = Double.NaN;
                try {
                    ls = this.lateStart.getValue(index);
                }
                catch (MissingValueException e) {
                    // empty catch block
                }
                double middleRaw = this.transform.translateY.getValue(index);
                double middle = middleRaw - this.transform.translateY.getValue(0);
                middle += thickness * 0.25;
                BoxPoints bp = (BoxPoints)this.taskPoints.get(t);
                if (bp == null) {
                    bp = new BoxPoints(to, from, middle, middleRaw, es, ef, ls, lf);
                    this.taskPoints.put(t, bp);
                    continue;
                }
                bp.xBegin = Math.min(bp.xBegin, to);
                bp.xEnd = Math.max(bp.xEnd, from);
                continue;
            }
            catch (MissingValueException e) {
                // empty catch block
            }
        }
        this.initMarkerPipes(ia);
        int markerRowCount = ia.getValueCount();
        this.markerInfo = this._setupMarkers(markerRowCount, this.markerTask, this.task, this.markerLocation, this.markerPosition, this.markerSymbol, this.markerSymbolColor, this.markerText, this.markerTextColor, this.annoFontColor, this.markerTextJustification, true);
        ia.pushValueCount();
        this.initAnnoPipes(ia);
        int annoRowCount = ia.getValueCount();
        ia.popValueCount();
        this.annoInfo = this._setupMarkers(annoRowCount, this.annoTask, this.task, this.annoLocation, this.annoPosition, this.annoSymbol, this.annoSymbolColor, this.annoText, this.annoTextColor, this.annoFontColor, this.annoTextJustification, false);
        ia.pushValueCount();
        this.initBreaktimePipes(ia);
        int breaktimeRowCount = ia.getValueCount();
        ia.popValueCount();
        this.breaktimes.clear();
        for (index = 0; index < breaktimeRowCount; ++index) {
            String cal = "DEFAULT";
            double start = -1.0;
            double finish = -1.0;
            StartFinish sf = null;
            try {
                cal = this.breaktimeCalendar.getValue(index);
                if (cal.length() == 0) {
                    cal = "DEFAULT";
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            try {
                start = this.breaktimeStart.getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            try {
                finish = this.breaktimeFinish.getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            if (finish == -1.0) {
                try {
                    finish = this.breaktimeDuration.getValue(index);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            if (start > -1.0 && finish > -1.0) {
                sf = new StartFinish(start, finish);
            }
            if (sf == null) continue;
            ArrayList<StartFinish> dates = (ArrayList<StartFinish>)this.breaktimes.get(cal);
            if (dates == null) {
                dates = new ArrayList<StartFinish>();
            }
            dates.add(sf);
            this.breaktimes.put(cal, dates);
        }
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        int ganttBoxStyle;
        int otherBoxStyle;
        int index = buildAction.getValueIndex();
        if (this.isClipped(index)) {
            return;
        }
        double thickness = this.boxThickness.getValue(index);
        int boxStyleValue = this.boxStyle.getValue(index);
        boolean fullSize = boxStyleValue == 3 || boxStyleValue == 4 || boxStyleValue == 5;
        double boxThicknessValue = thickness / (double)(this.totalBoxSize + (fullSize ? 0 : 1));
        boolean thickGanttBox = boxStyleValue == 2;
        double adjustedGanttSize = this.ganttSize + (thickGanttBox ? 1 : 0);
        double adjustedActualSize = this.actualSize + (thickGanttBox && this.ganttSize == 0 ? 1 : 0);
        double adjustedResourceSize = this.resourceSize + (thickGanttBox && this.ganttSize == 0 && this.actualSize == 0 ? 1 : 0);
        double adjustedBaselineSize = this.baselineSize + (thickGanttBox && this.ganttSize == 0 && this.actualSize == 0 && this.resourceSize == 0 ? 1 : 0);
        double adjustedCustom1lineSize = this.customSize1 + (thickGanttBox && this.ganttSize == 0 && this.actualSize == 0 && this.resourceSize == 0 && this.customSize1 == 0 ? 1 : 0);
        double adjustedCustom2lineSize = this.customSize2 + (thickGanttBox && this.ganttSize == 0 && this.actualSize == 0 && this.resourceSize == 0 && this.customSize1 == 0 && this.customSize2 == 0 ? 1 : 0);
        this.ganttSpace = boxThicknessValue * adjustedGanttSize;
        double actualSpace = boxThicknessValue * adjustedActualSize;
        double resourceSpace = boxThicknessValue * adjustedResourceSize;
        double baselineSpace = boxThicknessValue * adjustedBaselineSize;
        double customSpace1 = boxThicknessValue * adjustedCustom1lineSize;
        double customSpace2 = boxThicknessValue * adjustedCustom2lineSize;
        this.actualBox.boxThickness.setValue(actualSpace);
        this.ganttBox.boxThickness.setValue(this.ganttSpace);
        this.resourceBox.boxThickness.setValue(resourceSpace);
        this.customBox1.boxThickness.setValue(customSpace1);
        this.customBox2.boxThickness.setValue(customSpace2);
        this.baselineBox.boxThickness.setValue(baselineSpace);
        this.highlightBox.boxThickness.setValue(this.boxThickness.getValue(index));
        if (!this.actualOverlaid.getValue()) {
            this.actualBox.transform.translateY.setValue(this.ganttSpace);
        }
        if (this.actualOverlaid.getValue() && this.ganttBoxVisible.getValue()) {
            this.resourceBox.transform.translateY.setValue(this.ganttSpace);
            this.baselineBox.transform.translateY.setValue(this.ganttSpace + resourceSpace);
            this.customBox1.transform.translateY.setValue(this.ganttSpace + resourceSpace + baselineSpace);
            this.customBox2.transform.translateY.setValue(this.ganttSpace + resourceSpace + baselineSpace + customSpace1 + customSpace2);
        } else {
            this.resourceBox.transform.translateY.setValue(this.ganttSpace + actualSpace);
            this.baselineBox.transform.translateY.setValue(this.ganttSpace + actualSpace + resourceSpace);
            this.customBox1.transform.translateY.setValue(this.ganttSpace + actualSpace + resourceSpace + baselineSpace);
            this.customBox2.transform.translateY.setValue(this.ganttSpace + actualSpace + resourceSpace + baselineSpace + customSpace1);
        }
        switch (boxStyleValue) {
            default: {
                otherBoxStyle = 0;
                ganttBoxStyle = 0;
                break;
            }
            case 1: 
            case 5: {
                ganttBoxStyle = 2;
                otherBoxStyle = 0;
                break;
            }
            case 3: {
                otherBoxStyle = 1;
                ganttBoxStyle = 1;
                break;
            }
            case 2: {
                ganttBoxStyle = 1;
                otherBoxStyle = 0;
            }
        }
        this.ganttBox.boxStyle.setValue(ganttBoxStyle);
        this.actualBox.boxStyle.setValue(otherBoxStyle);
        this.resourceBox.boxStyle.setValue(otherBoxStyle);
        this.baselineBox.boxStyle.setValue(otherBoxStyle);
        this.customBox1.boxStyle.setValue(otherBoxStyle);
        this.customBox2.boxStyle.setValue(otherBoxStyle);
        super.render(buildAction);
    }

    @Override
    public SelectEntry buildSelectEntry(int valueIndex) {
        if (!this.isClipped(valueIndex)) {
            return super.buildSelectEntry(valueIndex);
        }
        return null;
    }

    private boolean isClipped(int index) {
        try {
            double barStart = this.transform.translateY.getValue(index);
            this.viewStart = this.yStart.getValue(index);
            this.viewEnd = this.yEnd.getValue(index);
            return !(barStart <= (double)this.yStart.getValue(index)) || !(barStart >= (double)this.yEnd.getValue(index));
        }
        catch (MissingValueException e) {
            return false;
        }
    }

    @Override
    protected void resetNetwork(AResetAction action) {
        if (this.valueCount > 0) {
            action.setValueIndex(0);
            super.resetNetwork(action);
        }
    }

    @Override
    public void reset(AResetAction resetAction) {
        double xSize;
        super.reset(resetAction);
        this.highlightBox.clearTaskValueHashMap();
        ResetAction ra = (ResetAction)resetAction;
        Channel channel = ra.getChannel();
        boolean beginEndNotInVisibleRange = false;
        double thickness = this.boxThickness.getValue();
        double outExtension = thickness * 0.5;
        double inExtension = thickness * 0.5;
        double ySize = xSize = inExtension * 0.5;
        for (int i = 0; i < this.valueCount; ++i) {
            try {
                String fromTask = this.task.getValue(i).trim();
                BoxPoints from = (BoxPoints)this.taskPoints.get(fromTask);
                if (!this.slackTimeVisible.getValue()) {
                    from.xEnd = from.ef;
                }
                for (int j = 0; j < this.successorPipes.size(); ++j) {
                    try {
                        StringPipe sucessorPipe = (StringPipe)this.successorPipes.get(j);
                        String toTask = sucessorPipe.getValue(i).trim();
                        BoxPoints to = (BoxPoints)this.taskPoints.get(toTask);
                        if (to == null || from == null || Double.isNaN(to.xBegin) || Double.isNaN(from.xEnd)) continue;
                        if (from.yRaw > (double)this.viewStart && to.yRaw < (double)this.viewEnd || from.yRaw < (double)this.viewEnd && to.yRaw > (double)this.viewStart) {
                            beginEndNotInVisibleRange = true;
                        }
                        if (from.yRaw <= (double)this.viewStart && from.yRaw >= (double)this.viewEnd || to.yRaw <= (double)this.viewStart && to.yRaw >= (double)this.viewEnd || beginEndNotInVisibleRange) {
                            Color color = this.connectingLineColor.getValue();
                            channel.glColor(color);
                            channel.glLineWidth((float)this.connectingLineWidth.getValue());
                            channel.glBegin(1);
                            if (beginEndNotInVisibleRange) {
                                channel.glColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 50));
                            }
                            channel.glVertex(from.xEnd, from.yCenter);
                            channel.glVertex(from.xEnd + outExtension, from.yCenter);
                            if (to.xBegin - from.xEnd < outExtension + inExtension) {
                                if (from.yCenter <= to.yCenter) {
                                    channel.glVertex(from.xEnd + outExtension, to.yCenter - thickness * 0.5);
                                    channel.glVertex(to.xBegin - inExtension, to.yCenter - thickness * 0.5);
                                } else {
                                    channel.glVertex(from.xEnd + outExtension, to.yCenter + thickness * 0.5);
                                    channel.glVertex(to.xBegin - inExtension, to.yCenter + thickness * 0.5);
                                }
                            }
                            if (to.xBegin - from.xEnd >= outExtension + inExtension) {
                                channel.glVertex(from.xEnd + outExtension, to.yCenter);
                            } else {
                                channel.glVertex(to.xBegin - inExtension, to.yCenter);
                            }
                            channel.glVertex(to.xBegin, to.yCenter);
                            channel.glEnd();
                            this.shape = 2;
                            double x = to.xBegin;
                            double y = to.yCenter;
                            if (this.shape == 1) {
                                channel.glBegin(1);
                                channel.glVertex(x - xSize, y - ySize * 0.5);
                                channel.glVertex(x, y);
                                channel.glVertex(x - xSize, y + ySize * 0.5);
                                channel.glVertex(x - xSize, y - ySize * 0.5);
                            } else if (this.shape == 2) {
                                channel.glPolygonMode(3);
                                channel.glBegin(2);
                                channel.glVertex(x - xSize, y - ySize * 0.5);
                                channel.glVertex(x, y);
                                channel.glVertex(x - xSize, y + ySize * 0.5);
                            } else if (this.shape == 3) {
                                channel.glPolygonMode(4);
                                channel.glBegin(2);
                                channel.glVertex(x - xSize, y - ySize * 0.5);
                                channel.glVertex(x, y);
                                channel.glVertex(x - xSize, y + ySize * 0.5);
                                channel.glVertex(x - xSize / 3.0, y);
                                channel.glVertex(x - xSize, y - ySize * 0.5);
                            } else if (this.shape == 0) {
                                channel.glBegin(1);
                                channel.glVertex(x - xSize, y - ySize * 0.5);
                                channel.glVertex(x, y);
                                channel.glVertex(x - xSize, y + ySize * 0.5);
                            }
                            channel.glEnd();
                            channel.glLineWidth(1.0f);
                        }
                        beginEndNotInVisibleRange = false;
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this._drawMarkers(this.markerInfo, channel, this.annoFont, this.annoSymbolSize.getValue());
        this._drawMarkers(this.annoInfo, channel, this.annoFont, this.annoSymbolSize.getValue());
    }

    private void initMarkerPipes(AInitAction ia) {
        this.markerTask.init(ia);
        this.markerLocation.init(ia);
        this.markerPosition.init(ia);
        this.markerSymbol.init(ia);
        this.markerSymbolColor.init(ia);
        this.markerText.init(ia);
        this.markerTextColor.init(ia);
        this.markerTextJustification.init(ia);
    }

    private void initAnnoPipes(AInitAction ia) {
        this.annoTask.init(ia);
        this.annoLocation.init(ia);
        this.annoPosition.init(ia);
        this.annoSymbol.init(ia);
        this.annoSymbolColor.init(ia);
        this.annoText.init(ia);
        this.annoTextColor.init(ia);
        this.annoTextJustification.init(ia);
    }

    private void initBreaktimePipes(AInitAction ia) {
        this.breaktimeStart.init(ia);
        this.breaktimeFinish.init(ia);
        this.breaktimeCalendar.init(ia);
        this.breaktimeDuration.init(ia);
    }

    private MarkerInfo[] _setupMarkers(int rowCount, StringProperty mkrTask, StringProperty tsk, StringProperty mkrLocation, NumericProperty mkrPosition, IntegerProperty mkrSymbol, StringProperty mkrSymbolColor, StringProperty mkrText, StringProperty mkrTextColor, Color defaultTextColor, NumericProperty mkrTextJust, boolean scheduleData) {
        MarkerInfo[] info = null;
        BoxPoints bp = null;
        if (mkrPosition.isConnected() || mkrLocation.isConnected()) {
            info = new MarkerInfo[rowCount];
        }
        if (info != null) {
            boolean mkrTaskConnected = false;
            if (mkrTask.isConnected()) {
                mkrTaskConnected = true;
            }
            for (int index = 0; index < info.length; ++index) {
                String t = null;
                String xposTask = null;
                try {
                    if (mkrTaskConnected) {
                        t = mkrTask.getValue(index);
                        if (scheduleData) {
                            xposTask = tsk.getValue(index);
                        }
                    } else {
                        t = tsk.getValue(index);
                    }
                }
                catch (MissingValueException e) {
                    try {
                        if (mkrTaskConnected) {
                            t = tsk.getValue(index);
                        }
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                double xPos = -1.0;
                if (mkrLocation.isConnected() && (bp = xposTask != null ? (BoxPoints)this.taskPoints.get(xposTask) : (BoxPoints)this.taskPoints.get(t)) != null) {
                    try {
                        String location = mkrLocation.getValue(index);
                        if (location.equalsIgnoreCase("ES") && !Double.isNaN(bp.es)) {
                            xPos = bp.es;
                        }
                        if (location.equalsIgnoreCase("EF") && !Double.isNaN(bp.ef)) {
                            xPos = bp.ef;
                        }
                        if (this.slackTimeVisible.getValue()) {
                            if (location.equalsIgnoreCase("LS") && !Double.isNaN(bp.ls)) {
                                xPos = bp.ls;
                            }
                            if (location.equalsIgnoreCase("LF") && !Double.isNaN(bp.lf)) {
                                xPos = bp.lf;
                            }
                        }
                    }
                    catch (MissingValueException location) {
                        // empty catch block
                    }
                }
                if (mkrPosition.isConnected()) {
                    try {
                        xPos = mkrPosition.getValue(index);
                    }
                    catch (MissingValueException location) {
                        // empty catch block
                    }
                }
                int sym = -1;
                if (mkrSymbol.isConnected()) {
                    try {
                        sym = mkrSymbol.getValue(index);
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                String text = null;
                int textJust = 1;
                if (mkrText.isConnected()) {
                    try {
                        text = mkrText.getValue(index);
                    }
                    catch (MissingValueException e) {
                        text = null;
                    }
                    if (text != null && mkrTextJust.isConnected()) {
                        try {
                            textJust = (int)mkrTextJust.getValue(index);
                        }
                        catch (MissingValueException e) {
                            textJust = 0;
                        }
                        switch (textJust) {
                            default: {
                                textJust = 1;
                                break;
                            }
                            case 2: {
                                textJust = 0;
                                break;
                            }
                            case 4: {
                                textJust = 2;
                            }
                        }
                    }
                }
                String symClr = "BLACK";
                if (mkrSymbolColor.isConnected()) {
                    try {
                        symClr = mkrSymbolColor.getValue(index);
                    }
                    catch (MissingValueException e) {
                        symClr = "BLACK";
                    }
                }
                Color textClr = defaultTextColor;
                if (mkrTextColor.isConnected()) {
                    String dataColumnTextClr = null;
                    try {
                        dataColumnTextClr = mkrTextColor.getValue(index);
                        Color clr = SASColors.getInstance().getColor(dataColumnTextClr);
                        if (clr != null) {
                            textClr = clr;
                        }
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                info[index] = new MarkerInfo(xPos, t, sym, symClr, text, textClr, textJust);
            }
        }
        return info;
    }

    private void _drawMarkers(MarkerInfo[] markerInfo, Channel channel, Font f, double size) {
        if (markerInfo != null) {
            for (int ii = 0; ii < markerInfo.length; ++ii) {
                BoxPoints bp;
                String placementTask;
                if (markerInfo[ii].task == null || (placementTask = markerInfo[ii].task.trim()) == null || (bp = (BoxPoints)this.taskPoints.get(placementTask)) == null || !(markerInfo[ii].xPos > -1.0)) continue;
                if (markerInfo[ii].symbol > -1) {
                    Color userDefinedColor;
                    channel.setMarkerType(markerInfo[ii].symbol);
                    if (markerInfo[ii].symbolColor != null && (userDefinedColor = SASColors.getInstance().getColor(markerInfo[ii].symbolColor.trim())) != null) {
                        channel.glColor(userDefinedColor);
                    }
                    if (size == -1.0) {
                        channel.setMarkerSize((int)(this.ganttSpace * 0.8));
                    } else {
                        channel.setMarkerSize((int)size);
                    }
                    channel.glBegin(4);
                    channel.glVertex(markerInfo[ii].xPos, bp.yCenter);
                    channel.glEnd();
                }
                if (markerInfo[ii].text == null) continue;
                int horz = markerInfo[ii].textJust;
                int vertical = 1;
                channel.glTextAlign(horz, vertical);
                channel.glSelect2DFont(f);
                if (markerInfo[ii].textColor != null) {
                    channel.glColor(markerInfo[ii].textColor);
                }
                channel.gl2DText(markerInfo[ii].text, markerInfo[ii].xPos, bp.yCenter, 0.0);
            }
        }
    }

    class MarkerInfo {
        protected double xPos = -1.0;
        protected int symbol = -1;
        protected String task = null;
        protected String symbolColor = null;
        protected String text = null;
        protected Color textColor = null;
        protected int textJust = 1;

        public MarkerInfo(double newPosX, String newTask, int newSymbol, String newSymbolColor, String newText, Color newTextColor, int newTextJust) {
            this.xPos = newPosX;
            this.task = newTask;
            this.symbol = newSymbol;
            this.symbolColor = newSymbolColor;
            this.text = newText == null ? null : newText.trim();
            this.textColor = newTextColor;
            this.textJust = newTextJust;
        }
    }

    class BoxPoints {
        protected double xBegin;
        protected double xEnd;
        protected double yCenter;
        protected double yRaw;
        protected double es;
        protected double ef;
        protected double ls;
        protected double lf;

        public BoxPoints(double newBeginX, double newEndX, double newCenterY, double newRawY, double newES, double newEF, double newLS, double newLF) {
            this.xBegin = newBeginX;
            this.xEnd = newEndX;
            this.yCenter = newCenterY;
            this.yRaw = newRawY;
            this.es = newES;
            this.ef = newEF;
            this.ls = newLS;
            this.lf = newLF;
        }
    }

    class StartFinish {
        protected double start;
        protected double finish;

        public StartFinish(double newStart, double newFinish) {
            this.start = newStart;
            this.finish = newFinish;
        }
    }
}

