/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABox;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class Box
extends ABox {
    public static void drawBox(Channel channel, double sizeX, double sizeY, double sizeZ, Color color, Color edgeColor, int origin, boolean edgeOn, boolean fillOn) {
        Box.drawBox(channel, sizeX, sizeY, sizeZ, color, edgeColor, origin, edgeOn, fillOn, false);
    }

    public static void drawBox(Channel channel, double sizeX, double sizeY, double sizeZ, Color color, Color edgeColor, int origin, boolean edgeOn, boolean fillOn, boolean isNormalsReversed) {
        Box.drawBox(channel, sizeX, sizeY, sizeZ, color, edgeColor, origin, edgeOn, fillOn, isNormalsReversed, -1, 1);
    }

    public static void drawBox(Channel channel, double sizeX, double sizeY, double sizeZ, Color color, Color edgeColor, int origin, boolean edgeOn, boolean fillOn, boolean isNormalsReversed, int edgePattern, int edgeWidth) {
        Vec3d size = new Vec3d();
        Vec3d center = new Vec3d();
        size.x = sizeX;
        size.y = sizeY;
        size.z = sizeZ;
        if (origin != 0) {
            ABox.computeCenter(size.x, size.y, size.z, origin, center);
            channel.glTranslate(center.x, center.y, center.z);
        }
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getGLFillStyle(fillOn, edgeOn));
        if (edgeOn) {
            channel.glEnable(16);
            channel.glPolygonOffset(0.001f, 0.0f);
            channel.glLineWidth((float)edgeWidth);
            channel.glDisable(6);
            if (edgePattern >= 0) {
                int f = SASLinePatterns.getStippleFactor((int)edgePattern);
                int p = SASLinePatterns.getStipplePattern((int)edgePattern);
                channel.glLineStipple(f, p);
                channel.glEnable(6);
            }
        }
        Box.drawBox(channel, size, isNormalsReversed, fillOn);
        channel.glPopAttrib();
        if (origin != 0) {
            channel.glTranslate(-center.x, -center.y, -center.z);
        }
        channel.glFrontFace(0);
    }

    public static void drawBox(Channel channel, Vec3d size, boolean isNormalsReversed) {
        Box.drawBox(channel, size, isNormalsReversed, false, 0, null, null, true);
    }

    public static void drawBox(Channel channel, Vec3d size, boolean isNormalsReversed, boolean fillOn) {
        Box.drawBox(channel, size, isNormalsReversed, false, 0, null, null, fillOn);
    }

    public static void drawBox(Channel channel, Vec3d size, boolean isNormalsReversed, boolean go, int gd, Color c1, Color c2) {
        Box.drawBox(channel, size, isNormalsReversed, go, gd, c1, c2, true);
    }

    public static void drawBox(Channel channel, Vec3d size, boolean isNormalsReversed, boolean go, int gd, Color c1, Color c2, boolean fillOn) {
        if (size.x < 0.0) {
            size.x = -size.x;
        }
        if (size.y < 0.0) {
            size.y = -size.y;
        }
        if (size.z < 0.0) {
            size.z = -size.z;
        }
        if (fillOn) {
            int boxDataIndex = 0;
            channel.glBegin(2);
            for (int face = 0; face < 6; ++face) {
                Vec3d p = boxData[boxDataIndex];
                if (isNormalsReversed) {
                    channel.glFrontFace(1);
                    channel.glNormal(-p.x, -p.y, -p.z);
                } else {
                    channel.glFrontFace(0);
                    channel.glNormal(p.x, p.y, p.z);
                }
                ++boxDataIndex;
                if (go) {
                    if (face == 0) {
                        channel.glColor(c1);
                    } else if (face == 1) {
                        channel.glColor(c2);
                    }
                }
                for (int vertex = 0; vertex < 4; ++vertex) {
                    p = boxData[boxDataIndex];
                    if (go && face != 0 && face != 1) {
                        if (vertex < 2) {
                            channel.glColor(c1);
                        } else {
                            channel.glColor(c2);
                        }
                    }
                    channel.glVertex(p.x * size.x, p.y * size.y, p.z * size.z);
                    ++boxDataIndex;
                }
                channel.glBound();
            }
            channel.glEnd();
        } else {
            int vertex;
            for (int face = 0; face < 6; ++face) {
                Vec3d p;
                if (face != 0 && face != 1) continue;
                channel.glBegin(1);
                for (vertex = 0; vertex < 4; ++vertex) {
                    p = boxData[face * 5 + 1 + vertex];
                    channel.glVertex(p.x * size.x, p.y * size.y, p.z * size.z);
                }
                p = boxData[face * 5 + 1];
                channel.glVertex(p.x * size.x, p.y * size.y, p.z * size.z);
                channel.glEnd();
            }
            int topVertexIndex = 1;
            int bottomVertexIndex = 9;
            for (vertex = 0; vertex < 4; ++vertex) {
                Vec3d topVertex = boxData[topVertexIndex];
                Vec3d bottomVertex = boxData[bottomVertexIndex];
                channel.glBegin(1);
                channel.glVertex(topVertex.x * size.x, topVertex.y * size.y, topVertex.z * size.z);
                channel.glVertex(bottomVertex.x * size.x, bottomVertex.y * size.y, bottomVertex.z * size.z);
                channel.glEnd();
                ++topVertexIndex;
                --bottomVertexIndex;
            }
        }
    }

    public Box() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Box.drawBox(ba.getChannel(), this.sizeX.getValue(index), this.sizeY.getValue(index), this.sizeZ.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), this.origin.getValue(index), this.edgeOn.getValue(index), this.fillOn.getValue(index), this.isNormalsReversed(), this.edgePattern.getValue(index), this.edgeWidth.getValue(index));
    }
}

