/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.gl.Box;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Cylinder;
import com.sas.graphics.util.gtk.gl.Image;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class BaseBar
extends Element {
    private Rectangle2D.Double fullSize = new Rectangle2D.Double();
    private Rectangle2D.Double highlightSize = new Rectangle2D.Double();
    private Rectangle2D.Double threshBelow = new Rectangle2D.Double();
    private Rectangle2D.Double threshAbove = new Rectangle2D.Double();
    private Rectangle2D.Double specLimitRectLower = new Rectangle2D.Double();
    private Rectangle2D.Double specLimitRectUpper = new Rectangle2D.Double();
    private Rectangle2D.Double specLimitRectNot = new Rectangle2D.Double();
    private Color specLimitColorLower = null;
    private Color specLimitColorUpper = null;
    private Vec3d center = new Vec3d();
    private Vec3d size = new Vec3d();
    private BufferedImage[] texImage;
    private boolean twoD = true;
    private float polygonOffsetFactor = 0.001f;
    private float polygonOffsetUnits = 0.0f;
    private boolean drawOrderSortEnabled = false;
    private java.awt.Image skin = null;
    private boolean confidenceEnabled = false;
    private BufferedImage barSizedImage;
    private int skinType = 0;
    private java.awt.Image[] pixelBenderImages = null;
    private float DPIScaleFactor = 1.0f;
    private static final int BRACKET_OFFSET = 4;
    private static final int BRACKET_HANDLE_WIDTH = 2;
    private static final int MIN_BAR_WIDTH = 10;
    private int myValueCount;
    private List drawOrderList;
    protected boolean subpixelRendering = false;
    protected boolean displayZeroHeightBar = true;
    protected boolean skipMissingOnTrendLine = false;
    public final NumericProperty thickness = new NumericProperty(this, true);
    public final NumericProperty depth = new NumericProperty(this, true);
    public final NumericProperty position = new NumericProperty(this, true);
    public final NumericProperty startValue = new NumericProperty(this, true);
    public final NumericProperty endValue = new NumericProperty(this, true);
    public final BooleanProperty verticalOn = new BooleanProperty(this, true);
    public final ColorProperty color1 = new ColorProperty(this, true);
    public final ColorProperty color2 = new ColorProperty(this, true);
    public final ColorProperty highlightFillColor = new ColorProperty(this, true);
    public final ColorProperty highlightEdgeColor = new ColorProperty(this, true);
    public final ColorProperty thresholdColor = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final NumericProperty edgeWidth = new NumericProperty(this, true);
    public final IntegerProperty edgePattern = new IntegerProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final BooleanProperty fillPatternOn = new BooleanProperty(this, true);
    public final IntegerProperty fillPatternType = new IntegerProperty(this, true);
    public final ColorProperty fillPatternColor = new ColorProperty(this, true);
    public final NumericProperty fillPatternWidth = new NumericProperty(this, true);
    public final NumericProperty fillPatternScaleFactor = new NumericProperty(this, true);
    public final BooleanProperty highlightOn = new BooleanProperty(this, true);
    public final NumericProperty highlightPercentage = new NumericProperty(this, true);
    public final BooleanProperty gradientOn = new BooleanProperty(this, true);
    public final BooleanProperty targetOn = new BooleanProperty(this, true);
    public final NumericProperty targetValue = new NumericProperty(this, true);
    public final ColorProperty targetColor = new ColorProperty(this, true);
    public final NumericProperty targetThickness = new NumericProperty(this, true);
    public final NumericProperty targetLineThickness = new NumericProperty(this, true);
    public final NumericProperty targetGran = new NumericProperty(this, true);
    public final BooleanProperty highOn = new BooleanProperty(this, true);
    public final NumericProperty highValue = new NumericProperty(this, true);
    public final ColorProperty highColor = new ColorProperty(this, true);
    public final BooleanProperty lowOn = new BooleanProperty(this, true);
    public final NumericProperty lowValue = new NumericProperty(this, true);
    public final ColorProperty lowColor = new ColorProperty(this, true);
    public final NumericProperty highLowThickness = new NumericProperty(this, true);
    public final BooleanProperty highLowIsBar = new BooleanProperty(this, true);
    public final BooleanProperty highLowFillOn = new BooleanProperty(this, true);
    public final IntegerProperty gradientDirection = new IntegerProperty(this, true);
    public final BooleanProperty textureOn = new BooleanProperty(this, true);
    public final IntegerProperty textureMode = new IntegerProperty(this, true);
    public final IntegerProperty textureStyle = new IntegerProperty(this, true);
    public final IntegerProperty textureIndex = new IntegerProperty(this, true);
    public final BooleanProperty thresholdOn = new BooleanProperty(this, true);
    public final NumericProperty thresholdValue = new NumericProperty(this, true);
    public final IntegerProperty marker3DShape = new IntegerProperty(this, true);
    public final BooleanProperty confidenceLimitEnabled = new BooleanProperty(this, false);
    public final BooleanProperty VGFRenderModeOn = new BooleanProperty(this, true);
    private static final double defaultThickness = 10.0;
    private GradientDefinition contextSensitiveGradient = new GradientDefinition();
    private final PropertyValueBlock propertyValueBlock = new PropertyValueBlock();
    private Comparator positionComparator;
    private Comparator stackComparator;

    public BaseBar() {
        super(new Transform());
        this.color1.setValue(ColorProperty.getDefaultColor());
        this.color2.setValue(ColorProperty.getDefaultColor());
        this.highlightFillColor.setValue(Color.yellow);
        this.highlightEdgeColor.setValue(Color.yellow);
        this.edgeColor.setValue(Color.black);
        this.thickness.setValue(10.0);
        this.depth.connectFrom(this.thickness);
        this.edgeOn.setValue(true);
        this.edgeWidth.setValue(1.0);
        this.edgePattern.setValue(-1);
        this.fillOn.setValue(true);
        this.highlightOn.setValue(false);
        this.highlightPercentage.setValue(1.0);
        this.gradientOn.setValue(false);
        this.gradientDirection.setValue(1);
        this.fillPatternOn.setValue(false);
        this.fillPatternType.setValue(-1);
        this.fillPatternColor.setValue(Color.black);
        this.fillPatternWidth.setValue(1.0);
        this.fillPatternScaleFactor.setValue(1.0);
        this.textureOn.setValue(false);
        this.textureMode.setValue(3);
        this.textureStyle.setValue(4);
        this.thresholdOn.setValue(false);
        this.verticalOn.setValue(true);
        this.targetOn.setValue(false);
        this.targetThickness.setValue(3.3333333333333335);
        this.targetLineThickness.setValue(0.0);
        this.targetGran.setValue(0.0);
        this.targetColor.setValue(Color.black);
        this.highOn.setValue(false);
        this.highColor.setValue(Color.black);
        this.lowOn.setValue(false);
        this.lowColor.setValue(Color.black);
        this.highLowThickness.setValue(5.0);
        this.highLowIsBar.setValue(true);
        this.highLowFillOn.setValue(true);
        this.VGFRenderModeOn.setValue(false);
        this.confidenceLimitEnabled.setValue(this.isConfidenceLimitenabled());
    }

    public void setTextureImage(BufferedImage[] image) {
        this.texImage = image;
        this.setModified();
    }

    public BufferedImage[] getTextureImage() {
        return this.texImage;
    }

    public void setSkin(java.awt.Image newImage) {
        this.skin = newImage;
    }

    public java.awt.Image getSkin() {
        return this.skin;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setPixelBenderImages(java.awt.Image[] newImages) {
        this.pixelBenderImages = newImages;
    }

    public java.awt.Image[] getPixelBenderImages() {
        return this.pixelBenderImages;
    }

    public void setDPIScaleFactor(float fac) {
        this.DPIScaleFactor = fac;
    }

    public float getDPIScaleFactor() {
        return this.DPIScaleFactor;
    }

    public void setSubpixelRendering(boolean b) {
        this.subpixelRendering = b;
    }

    public boolean isSubpixelRendering() {
        return this.subpixelRendering;
    }

    public void setDisplayZeroHeightBar(boolean b) {
        this.displayZeroHeightBar = b;
    }

    public boolean isDisplayZeroHeightBar() {
        return this.displayZeroHeightBar;
    }

    public void setConfidenceLimitEnabled(boolean isConfidenceLimitEnabled) {
        this.confidenceEnabled = isConfidenceLimitEnabled;
    }

    public boolean isConfidenceLimitenabled() {
        return this.confidenceEnabled;
    }

    public void setSkipMissingOnTrendLine(boolean flag) {
        this.skipMissingOnTrendLine = flag;
    }

    public boolean isSkipMissingOnTrendLine() {
        return this.skipMissingOnTrendLine;
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        Vec3d s = bBoxAction.pt1;
        Vec3d c = bBoxAction.pt2;
        double dx = 0.0;
        double dy = 0.0;
        s.set(dx, dy, 0.0);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(c, s);
    }

    public static BufferedImage convertImageToBufferedImage(java.awt.Image image) {
        return Image.convertImageToBufferedImage(image);
    }

    private boolean computeSecificationLimitsRect(PropertyValueBlock pBlock) {
        boolean split = false;
        double halfThick = pBlock.thick / 2.0;
        this.specLimitRectNot.setFrame(0.0, 0.0, 0.0, 0.0);
        this.specLimitRectLower.setFrame(0.0, 0.0, 0.0, 0.0);
        this.specLimitRectUpper.setFrame(0.0, 0.0, 0.0, 0.0);
        this.specLimitColorLower = null;
        this.specLimitColorUpper = null;
        if (pBlock.vertical) {
            double barLow = pBlock.pos - halfThick;
            double barHigh = pBlock.pos + halfThick;
            if (pBlock.specificationLimitLow > barLow) {
                this.specLimitRectLower.x = barLow;
                this.specLimitRectLower.width = pBlock.thick;
                this.specLimitRectLower.y = pBlock.sv;
                this.specLimitRectLower.height = pBlock.ev - pBlock.sv;
                this.specLimitRectNot.setFrame(this.specLimitRectLower);
                this.specLimitColorLower = pBlock.specificationLimitBelowLowColor;
                if (pBlock.specificationLimitLow < barHigh) {
                    this.specLimitRectLower.width = pBlock.specificationLimitLow - barLow;
                    this.specLimitRectNot.width = pBlock.thick - this.specLimitRectLower.width;
                    this.specLimitRectNot.x = pBlock.specificationLimitLow;
                    split = true;
                }
            }
            if (pBlock.specificationLimitHigh < barHigh) {
                this.specLimitRectUpper.x = pBlock.pos - halfThick;
                this.specLimitRectUpper.width = pBlock.thick;
                this.specLimitRectUpper.y = pBlock.sv;
                this.specLimitRectUpper.height = pBlock.ev - pBlock.sv;
                this.specLimitRectNot.setFrame(this.specLimitRectUpper);
                this.specLimitColorUpper = pBlock.specificationLimitAboveHighColor;
                if (pBlock.specificationLimitHigh > barLow) {
                    this.specLimitRectUpper.x = pBlock.specificationLimitHigh;
                    this.specLimitRectUpper.width = barHigh - pBlock.specificationLimitHigh;
                    this.specLimitRectNot.x += this.specLimitRectLower.width;
                    this.specLimitRectNot.width = pBlock.thick - this.specLimitRectUpper.width - this.specLimitRectLower.width;
                    split = true;
                }
            }
        } else {
            if (pBlock.specificationLimitLow > pBlock.pos - halfThick) {
                this.specLimitRectLower.y = pBlock.pos - halfThick;
                this.specLimitRectLower.height = pBlock.thick;
                this.specLimitRectLower.x = pBlock.sv;
                this.specLimitRectLower.width = pBlock.ev - pBlock.sv;
                this.specLimitRectNot.setFrame(this.specLimitRectLower);
                this.specLimitColorLower = pBlock.specificationLimitBelowLowColor;
                if (pBlock.specificationLimitLow < pBlock.pos + halfThick) {
                    this.specLimitRectLower.height = pBlock.specificationLimitLow - (pBlock.pos - halfThick);
                    this.specLimitRectNot.y = pBlock.specificationLimitLow;
                    this.specLimitRectNot.height = pBlock.thick - this.specLimitRectLower.height;
                    split = true;
                }
            }
            if (pBlock.specificationLimitHigh < pBlock.pos + halfThick) {
                this.specLimitRectUpper.y = pBlock.pos - halfThick;
                this.specLimitRectUpper.height = pBlock.thick;
                this.specLimitRectUpper.x = pBlock.sv;
                this.specLimitRectUpper.width = pBlock.ev - pBlock.sv;
                this.specLimitRectNot.setFrame(this.specLimitRectUpper);
                this.specLimitColorUpper = pBlock.specificationLimitAboveHighColor;
                if (pBlock.specificationLimitHigh > pBlock.pos - halfThick) {
                    this.specLimitRectUpper.y = pBlock.specificationLimitHigh;
                    this.specLimitRectUpper.height = pBlock.pos + halfThick - pBlock.specificationLimitHigh;
                    this.specLimitRectNot.y += this.specLimitRectLower.height;
                    this.specLimitRectNot.height = pBlock.thick - this.specLimitRectUpper.height - this.specLimitRectLower.height;
                    split = true;
                }
            }
        }
        return split;
    }

    private void drawSpecificationLimits(Channel channel, PropertyValueBlock pBlock) {
        if (this.specLimitColorLower != null) {
            channel.glColor(this.specLimitColorLower);
            channel.glRect(this.specLimitRectLower.x, this.specLimitRectLower.y, this.specLimitRectLower.x + this.specLimitRectLower.width, this.specLimitRectLower.y + this.specLimitRectLower.height);
        }
        if (this.specLimitColorUpper != null) {
            channel.glColor(this.specLimitColorUpper);
            channel.glRect(this.specLimitRectUpper.x, this.specLimitRectUpper.y, this.specLimitRectUpper.x + this.specLimitRectUpper.width, this.specLimitRectUpper.y + this.specLimitRectUpper.height);
        }
    }

    private void computeThresholdRectangles(double pos, double sv, double ev, double thick, double thresh, boolean vertical, Rectangle2D.Double r1, Rectangle2D.Double r2) {
        double halfThick = thick / 2.0;
        r1.width = 0.0;
        r2.width = 0.0;
        if (ev > sv) {
            if (thresh > ev) {
                thresh = ev;
            }
            if (thresh < sv) {
                thresh = sv;
            }
        } else {
            if (thresh > sv) {
                thresh = sv;
            }
            if (thresh < ev) {
                thresh = ev;
            }
        }
        if (vertical) {
            if (thresh != sv) {
                r1.x = pos - halfThick;
                r1.width = thick;
                r1.y = sv;
                r1.height = thresh - sv;
            }
            if (thresh != ev) {
                r2.x = pos - halfThick;
                r2.width = thick;
                r2.y = thresh;
                r2.height = ev - thresh;
            }
        } else {
            if (thresh != sv) {
                r1.y = pos - halfThick;
                r1.height = thick;
                r1.x = sv;
                r1.width = thresh - sv;
            }
            if (thresh != ev) {
                r2.y = pos - halfThick;
                r2.height = thick;
                r2.x = thresh;
                r2.width = ev - thresh;
            }
        }
        this.removeNegativeWidthHeight(r1);
        this.removeNegativeWidthHeight(r2);
    }

    private void computeRectangle(double pos, double sv, double ev, double thick, double thresh, boolean vertical, Rectangle2D.Double r1) {
        double halfThick = thick / 2.0;
        if (vertical) {
            r1.y = sv;
            r1.height = ev - sv;
            r1.x = pos - halfThick;
            r1.width = thick;
        } else {
            r1.x = sv;
            r1.width = ev - sv;
            r1.y = pos - halfThick;
            r1.height = thick;
        }
        this.removeNegativeWidthHeight(r1);
    }

    private void removeNegativeWidthHeight(Rectangle2D.Double r) {
        if (r.width < 0.0) {
            r.x += r.width;
            r.width = -r.width;
        }
        if (r.height < 0.0) {
            r.y += r.height;
            r.height = -r.height;
        }
    }

    public boolean isTwoD() {
        return this.twoD;
    }

    public void setTwoD(boolean twoD) {
        this.twoD = twoD;
        this.setModified();
    }

    protected void drawThreeDBar(Channel channel, PropertyValueBlock pBlock) {
        boolean softwareRendering;
        boolean bl = softwareRendering = channel.getBackbufferId() == -1;
        if (pBlock.eo) {
            channel.glEnable(16);
            channel.glPolygonOffset(this.polygonOffsetFactor, this.polygonOffsetUnits);
        }
        if (pBlock.ho && pBlock.ho) {
            this.computeRectangle(pBlock.pos, pBlock.sv, pBlock.sv + (pBlock.ev - pBlock.sv) * pBlock.hp, pBlock.thick, pBlock.thresh, pBlock.vertical, this.highlightSize);
        }
        if (pBlock.threshOn) {
            this.computeThresholdRectangles(pBlock.pos, pBlock.sv, pBlock.ev, pBlock.thick, pBlock.thresh, pBlock.vertical, this.threshBelow, this.threshAbove);
            if (pBlock.ev < pBlock.sv) {
                if (this.threshAbove.width != 0.0 && this.threshAbove.height != 0.0) {
                    this.drawThreeDBar(channel, pBlock.m3dshape, pBlock.vertical, pBlock.tc, pBlock.tc, pBlock.ec, pBlock.eo, pBlock.d, this.threshAbove, this.center, this.size, pBlock.ho, pBlock.go, pBlock.gd, pBlock.fo);
                }
                if (this.threshBelow.width != 0.0 && this.threshBelow.height != 0.0) {
                    if (pBlock.textureNeeded) {
                        channel.glEnable(10);
                    }
                    this.drawThreeDBar(channel, pBlock.m3dshape, pBlock.vertical, pBlock.c1, pBlock.c2, pBlock.ec, pBlock.eo, pBlock.d, this.threshBelow, this.center, this.size, pBlock.ho, pBlock.go, pBlock.gd, pBlock.fo);
                    if (pBlock.textureNeeded) {
                        channel.glDisable(10);
                    }
                }
            } else {
                if (this.threshBelow.width != 0.0 && this.threshBelow.height != 0.0) {
                    if (pBlock.textureNeeded) {
                        channel.glEnable(10);
                    }
                    this.drawThreeDBar(channel, pBlock.m3dshape, pBlock.vertical, pBlock.c1, pBlock.c2, pBlock.ec, pBlock.eo, pBlock.d, this.threshBelow, this.center, this.size, pBlock.ho, pBlock.go, pBlock.gd, pBlock.fo);
                    if (pBlock.textureNeeded) {
                        channel.glDisable(10);
                    }
                }
                if (this.threshAbove.width != 0.0 && this.threshAbove.height != 0.0) {
                    this.drawThreeDBar(channel, pBlock.m3dshape, pBlock.vertical, pBlock.tc, pBlock.tc, pBlock.ec, pBlock.eo, pBlock.d, this.threshAbove, this.center, this.size, pBlock.ho, pBlock.go, pBlock.gd, pBlock.fo);
                }
            }
        } else {
            if (pBlock.textureNeeded) {
                channel.glEnable(10);
            }
            this.computeRectangle(pBlock.pos, pBlock.sv, pBlock.ev, pBlock.thick, pBlock.thresh, pBlock.vertical, this.fullSize);
            if (!softwareRendering || softwareRendering && !pBlock.ho) {
                this.drawThreeDBar(channel, pBlock.m3dshape, pBlock.vertical, pBlock.c1, pBlock.c2, pBlock.ec, pBlock.eo, pBlock.d, this.fullSize, this.center, this.size, false, pBlock.go, pBlock.gd, pBlock.fo);
            }
            if (pBlock.textureNeeded) {
                channel.glDisable(10);
            }
        }
        if (pBlock.ho) {
            if (softwareRendering) {
                if (pBlock.hp < 1.0) {
                    Color middleColor = pBlock.c1;
                    if (pBlock.go) {
                        float r = (float)BaseBar.lerp(1.0 - pBlock.hp, (double)pBlock.c1.getRed() / 255.0, (double)pBlock.c2.getRed() / 255.0);
                        float g = (float)BaseBar.lerp(1.0 - pBlock.hp, (double)pBlock.c1.getGreen() / 255.0, (double)pBlock.c2.getGreen() / 255.0);
                        float b = (float)BaseBar.lerp(1.0 - pBlock.hp, (double)pBlock.c1.getBlue() / 255.0, (double)pBlock.c2.getBlue() / 255.0);
                        middleColor = new Color(r, g, b);
                    }
                    this.drawThreeDBar(channel, pBlock.m3dshape, pBlock.vertical, middleColor, pBlock.c2, pBlock.hc, pBlock.eo, pBlock.d, this.highlightSize, this.center, this.size, true, pBlock.go, pBlock.gd, pBlock.fo);
                    this.computeRectangle(pBlock.pos, pBlock.sv + (pBlock.ev - pBlock.sv) * pBlock.hp, pBlock.ev, pBlock.d, pBlock.thresh, pBlock.vertical, this.fullSize);
                    this.drawThreeDBar(channel, pBlock.m3dshape, pBlock.vertical, pBlock.c1, middleColor, pBlock.hc, pBlock.eo, pBlock.d, this.fullSize, this.center, this.size, false, pBlock.go, pBlock.gd, pBlock.fo);
                } else {
                    this.drawThreeDBar(channel, pBlock.m3dshape, pBlock.vertical, pBlock.c1, pBlock.c2, pBlock.hc, pBlock.eo, pBlock.d, this.fullSize, this.center, this.size, true, pBlock.go, pBlock.gd, pBlock.fo);
                }
            } else {
                this.drawThreeDBar(channel, pBlock.m3dshape, pBlock.vertical, pBlock.c1, pBlock.c2, pBlock.hc, pBlock.eo, pBlock.d, this.highlightSize, this.center, this.size, true, pBlock.go, pBlock.gd, pBlock.fo);
            }
        }
        if (pBlock.eo) {
            channel.glDisable(16);
        }
    }

    private void drawThreeDBar(Channel channel, int shape, boolean vertical, Color c, Color c2, Color ec, boolean eo, double thick, Rectangle2D.Double r, Vec3d center1, Vec3d size1, boolean ho, boolean go, int gd, boolean fo) {
        int fillStyle;
        channel.glColor(c);
        channel.glEdgeColor(ec);
        size1.x = r.width;
        size1.y = r.height;
        size1.z = thick;
        center1.x = r.x + size1.x / 2.0;
        center1.y = r.y + size1.y / 2.0;
        center1.z = 0.0;
        channel.glPushMatrix();
        channel.glTranslate(center1.x, center1.y, center1.z);
        if (!vertical) {
            double temp = size1.x;
            size1.x = size1.y;
            size1.y = temp;
            channel.glRotate(90.0, 0.0, 0.0, 1.0);
        }
        if (channel.getBackbufferId() == -1) {
            fillStyle = ho ? 6 : BuildAction.getGLFillStyle(fo, eo);
            if (go) {
                channel.glShadeModel(0);
            } else {
                channel.glShadeModel(1);
            }
        } else {
            if (ho) {
                fillStyle = 6;
                channel.glLineWidth(1.0f);
                size1.x *= 1.001;
                size1.y *= 1.001;
            } else {
                fillStyle = BuildAction.getGLFillStyle(fo, eo);
            }
            go = false;
        }
        switch (shape) {
            default: {
                channel.glPolygonMode(fillStyle);
                Box.drawBox(channel, size1, false, go, gd, c, c2);
                break;
            }
            case 1: {
                channel.glEnable(8);
                Cylinder.drawCylinder(channel, size1.x / 2.0, size1.y, c, ec, fillStyle, true, true, true, 0, 64, false);
            }
        }
        channel.glPopMatrix();
    }

    private static double lerp(double alpha, double d1, double d2) {
        double result = d1 + alpha * (d2 - d1);
        return result;
    }

    private static void drawTwoDConfidenceBracket(Channel channel, Color c, Color ec, double sv, double ev, double pos, double thick, double ew, boolean isBar, boolean isFillOn, boolean isVertical, Rectangle2D.Double barInfo, PropertyValueBlock pBlock) {
        channel.glLineWidth((float)ew);
        thick /= 2.0;
        if (isBar && thick > 0.0) {
            if (isFillOn) {
                channel.glColor(c);
                channel.glEdgeColor(ec);
                channel.glPolygonMode(4);
            } else {
                channel.glColor(ec);
                channel.glPolygonMode(2);
            }
            if (isVertical) {
                double barWidth = barInfo.width / 2.0;
                channel.glColor(ec);
                if (barWidth > 18.0) {
                    channel.glBegin(1);
                    channel.glVertex(pos + barWidth + 4.0, sv);
                    channel.glVertex(pos + barWidth + 4.0, ev);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(pos + barWidth + 4.0 - 2.0, sv);
                    channel.glVertex(pos + barWidth + 4.0, sv);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(pos + barWidth + 4.0, ev);
                    channel.glVertex(pos + barWidth + 4.0 - 2.0, ev);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(pos - barWidth - 4.0, sv);
                    channel.glVertex(pos - barWidth - 4.0, ev);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(pos - barWidth - 4.0 + 2.0, sv);
                    channel.glVertex(pos - barWidth - 4.0, sv);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(pos - barWidth - 4.0, ev);
                    channel.glVertex(pos - barWidth - 4.0 + 2.0, ev);
                    channel.glEnd();
                }
            } else {
                double barWidth = barInfo.height / 2.0;
                channel.glColor(ec);
                if (barWidth > 18.0) {
                    channel.glBegin(1);
                    channel.glVertex(sv, pos + barWidth + 4.0);
                    channel.glVertex(ev, pos + barWidth + 4.0);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(sv, pos + barWidth + 4.0 - 2.0);
                    channel.glVertex(sv, pos + barWidth + 4.0);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(ev, pos + barWidth + 4.0);
                    channel.glVertex(ev, pos + barWidth + 4.0 - 2.0);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(sv, pos - barWidth - 4.0);
                    channel.glVertex(ev, pos - barWidth - 4.0);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(sv, pos - barWidth - 4.0 + 2.0);
                    channel.glVertex(sv, pos - barWidth - 4.0);
                    channel.glEnd();
                    channel.glColor(Color.BLACK);
                    channel.glBegin(1);
                    channel.glVertex(ev, pos - barWidth - 4.0);
                    channel.glVertex(ev, pos - barWidth - 4.0 + 2.0);
                    channel.glEnd();
                }
            }
        } else {
            channel.glColor(c);
            channel.glBegin(1);
            if (isVertical) {
                channel.glVertex(pos, sv);
                channel.glVertex(pos, ev);
            } else {
                channel.glVertex(sv, pos);
                channel.glVertex(ev, pos);
            }
            channel.glEnd();
            if (thick > 0.0) {
                channel.glBegin(1);
                if (isVertical) {
                    channel.glVertex(pos - thick, ev);
                    channel.glVertex(pos + thick, ev);
                } else {
                    channel.glVertex(ev, pos - thick);
                    channel.glVertex(ev, pos + thick);
                }
                channel.glEnd();
            }
        }
    }

    private static void drawTwoDHighLow(Channel channel, Color c, Color ec, double sv, double ev, double pos, double thick, double ew, boolean isBar, boolean isFillOn, boolean isVertical) {
        channel.glLineWidth((float)ew);
        thick /= 2.0;
        if (isBar && thick > 0.0) {
            if (isFillOn) {
                channel.glColor(c);
                channel.glEdgeColor(ec);
                channel.glPolygonMode(4);
            } else {
                channel.glColor(ec);
                channel.glPolygonMode(2);
            }
            if (isVertical) {
                channel.glRect(pos - thick, ev, pos + thick, sv);
            } else {
                channel.glRect(ev, pos - thick, sv, pos + thick);
            }
        } else {
            channel.glColor(c);
            channel.glBegin(1);
            if (isVertical) {
                channel.glVertex(pos, sv);
                channel.glVertex(pos, ev);
            } else {
                channel.glVertex(sv, pos);
                channel.glVertex(ev, pos);
            }
            channel.glEnd();
            if (thick > 0.0) {
                channel.glBegin(1);
                if (isVertical) {
                    channel.glVertex(pos - thick, ev);
                    channel.glVertex(pos + thick, ev);
                } else {
                    channel.glVertex(ev, pos - thick);
                    channel.glVertex(ev, pos + thick);
                }
                channel.glEnd();
            }
        }
    }

    private boolean isNonSpecLimitPartOfBarShowing(PropertyValueBlock pBlock) {
        boolean result = true;
        if (pBlock.specificationLimitsOn) {
            double upperThickness;
            double lowerThickness;
            double notThickness;
            boolean barCrossesSpecLimit = this.computeSecificationLimitsRect(pBlock);
            if (pBlock.vertical) {
                notThickness = this.specLimitRectNot.width;
                lowerThickness = this.specLimitRectLower.width;
                upperThickness = this.specLimitRectUpper.width;
            } else {
                notThickness = this.specLimitRectNot.height;
                lowerThickness = this.specLimitRectLower.height;
                upperThickness = this.specLimitRectUpper.height;
            }
            result = lowerThickness <= 0.0 && upperThickness <= 0.0 || barCrossesSpecLimit && notThickness > 0.0;
        }
        return result;
    }

    protected void drawTwoDBar(Channel channel, PropertyValueBlock pBlock) {
        double lsv;
        String[] svgText = null;
        if (channel.isSVGSelectionMode() && pBlock.trendLineOn) {
            svgText = channel.getSVGSelectionText();
        }
        this.drawTrendLine(channel, pBlock, true);
        this.drawTrendLine(channel, pBlock, false);
        if (channel.isSVGSelectionMode() && pBlock.trendLineOn) {
            channel.setSVGSelectionText(svgText);
        }
        this.computeRectangle(pBlock.pos, pBlock.sv, pBlock.ev, pBlock.thick, pBlock.thresh, pBlock.vertical, this.fullSize);
        if (!this.displayZeroHeightBar && (pBlock.vertical && this.fullSize.height == 0.0 || !pBlock.vertical && this.fullSize.width == 0.0)) {
            return;
        }
        if (pBlock.textureNeeded) {
            channel.glEnable(10);
        }
        channel.glPolygonMode(3);
        boolean drawBar = this.isNonSpecLimitPartOfBarShowing(pBlock);
        boolean drawEdge = pBlock.eo;
        if (pBlock.fo && drawBar && (!this.VGFRenderModeOn.getValue() || this.fullSize.height * this.fullSize.width != 0.0)) {
            if (pBlock.go) {
                this.computeContextSensitiveGradientDirection(pBlock.gd, pBlock.sv, pBlock.ev, pBlock.vertical, pBlock.c1, pBlock.c2);
                channel.glRect(this.fullSize.x, this.fullSize.y, this.contextSensitiveGradient.c1, 1.0f, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height, this.contextSensitiveGradient.c2, 1.0f, this.contextSensitiveGradient.direction);
                if (this.getSkinType() != 0) {
                    channel.glDPIScaleFactor(this.getDPIScaleFactor());
                    channel.glSkinType(this.getSkinType());
                    channel.glPixelBenderImages(this.getPixelBenderImages());
                    channel.glSkinCategory(pBlock.vertical ? 1 : 2);
                    if (pBlock.fpOn || this.getSkin() != null) {
                        channel.glSkinRenderMode(16);
                    } else {
                        channel.glSkinRenderMode(28);
                    }
                    channel.glColor(pBlock.c1);
                    channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
                    channel.glSkinType(0);
                    channel.glPixelBenderImages(null);
                    channel.glSkinCategory(0);
                    channel.glSkinRenderMode(15);
                    drawEdge = false;
                }
            } else {
                channel.glColor(pBlock.c1);
                if (pBlock.specificationLimitsOn && this.specLimitRectNot.width > 0.0) {
                    channel.glRect(this.specLimitRectNot.x, this.specLimitRectNot.y, this.specLimitRectNot.x + this.specLimitRectNot.width, this.specLimitRectNot.y + this.specLimitRectNot.height);
                } else if (this.getSkinType() == 0) {
                    channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
                } else {
                    channel.glDPIScaleFactor(this.getDPIScaleFactor());
                    channel.glSkinType(this.getSkinType());
                    channel.glPixelBenderImages(this.getPixelBenderImages());
                    channel.glSkinCategory(pBlock.vertical ? 1 : 2);
                    if (pBlock.fpOn || this.getSkin() != null) {
                        channel.glSkinRenderMode(3);
                    } else {
                        channel.glSkinRenderMode(15);
                    }
                    channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
                    channel.glSkinType(0);
                    channel.glPixelBenderImages(null);
                    channel.glSkinCategory(0);
                    channel.glSkinRenderMode(15);
                    drawEdge = false;
                }
            }
            if (pBlock.fpOn) {
                if (this.VGFRenderModeOn.getValue() && pBlock.fpt == 3) {
                    channel.glPolygonMode(3);
                } else {
                    channel.glPolygonMode(8);
                }
                if (!drawEdge && this.isSubpixelRendering()) {
                    channel.setSubpixelRendering(false);
                }
                channel.glColor(pBlock.fpc);
                channel.glFillPatternType(pBlock.fpt);
                channel.glFillPatternWidth(pBlock.fpw);
                channel.glFillPatternScaleFactor(pBlock.fpsf);
                channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
                drawBar = false;
                if (!drawEdge && this.isSubpixelRendering()) {
                    channel.setSubpixelRendering(true);
                }
            }
            if (this.getSkin() != null && (int)this.fullSize.height > 0 && (int)this.fullSize.width > 0) {
                int[] size = this.getSkinSizeInPixel(channel);
                int skinWidth = size[0];
                int skinHeight = size[1];
                this.barSizedImage = new BufferedImage(skinWidth, skinHeight, 2);
                Graphics2D graphics2D = this.barSizedImage.createGraphics();
                if (this.getSkinType() != 0 && pBlock.c1.getAlpha() < 255) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)pBlock.c1.getAlpha() / 255.0f));
                }
                graphics2D.drawImage(this.skin, 0, 0, skinWidth, skinHeight, null);
                channel.glAlignment(0, 3);
                channel.Image2D((java.awt.Image)this.barSizedImage, this.fullSize.x, this.fullSize.y, 0.0, skinWidth, --skinHeight);
            }
            if (this.getSkinType() != 0 && (pBlock.fpOn || this.getSkin() != null)) {
                channel.glPolygonMode(3);
                channel.glColor(pBlock.c1);
                channel.glDPIScaleFactor(this.getDPIScaleFactor());
                channel.glSkinType(this.getSkinType());
                channel.glSkinCategory(pBlock.vertical ? 1 : 2);
                int mode = 8;
                if (this.getSkin() == null) {
                    mode |= 4;
                }
                channel.glSkinRenderMode(mode);
                channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
                channel.glSkinType(0);
                channel.glSkinCategory(0);
                channel.glSkinRenderMode(15);
            }
        }
        if (pBlock.fpOn && drawBar && (!this.VGFRenderModeOn.getValue() || this.fullSize.height * this.fullSize.width != 0.0)) {
            if (this.VGFRenderModeOn.getValue() && pBlock.fpt == 3) {
                channel.glPolygonMode(3);
            } else {
                channel.glPolygonMode(8);
            }
            if (!drawEdge && this.isSubpixelRendering()) {
                channel.setSubpixelRendering(false);
            }
            channel.glColor(pBlock.fpc);
            channel.glFillPatternType(pBlock.fpt);
            channel.glFillPatternWidth(pBlock.fpw);
            channel.glFillPatternScaleFactor(pBlock.fpsf);
            channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
            if (!drawEdge && this.isSubpixelRendering()) {
                channel.setSubpixelRendering(true);
            }
        }
        if (pBlock.textureNeeded) {
            channel.glDisable(10);
        }
        if (pBlock.threshOn) {
            this.computeThresholdRectangles(pBlock.pos, pBlock.sv, pBlock.ev, pBlock.thick, pBlock.thresh, pBlock.vertical, this.threshBelow, this.threshAbove);
            if (this.threshAbove.width != 0.0 && this.threshAbove.height != 0.0) {
                channel.glColor(pBlock.tc);
                channel.glRect(this.threshAbove.x, this.threshAbove.y, this.threshAbove.x + this.threshAbove.width, this.threshAbove.y + this.threshAbove.height);
                if (this.getSkin() != null) {
                    int skinWidth = (int)Math.ceil(this.fullSize.width);
                    this.barSizedImage = new BufferedImage(skinWidth, (int)this.threshAbove.height, 2);
                    Graphics2D graphics2D = this.barSizedImage.createGraphics();
                    graphics2D.drawImage(this.skin, 0, 0, skinWidth, (int)this.threshAbove.height, null);
                    channel.glAlignment(0, 3);
                    channel.Image2D((java.awt.Image)this.barSizedImage, this.threshAbove.x, this.threshAbove.y, 0.0, (int)this.threshAbove.width, (int)this.threshAbove.height);
                }
            }
        }
        if (pBlock.specificationLimitsOn) {
            this.drawSpecificationLimits(channel, pBlock);
        }
        if (drawEdge) {
            channel.glPolygonMode(2);
            channel.glColor(pBlock.ec);
            if (this.VGFRenderModeOn.getValue() && this.fullSize.height == 0.0) {
                channel.glBegin(1);
                channel.glVertex(this.fullSize.x, this.fullSize.y);
                channel.glVertex(this.fullSize.x + this.fullSize.width, this.fullSize.y);
                channel.glEnd();
            } else if (this.VGFRenderModeOn.getValue() && this.fullSize.width == 0.0) {
                channel.glBegin(1);
                channel.glVertex(this.fullSize.x, this.fullSize.y);
                channel.glVertex(this.fullSize.x, this.fullSize.y + this.fullSize.height);
                channel.glEnd();
            } else {
                channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
            }
        }
        if (this.isConfidenceLimitenabled()) {
            if (pBlock.hgOn && pBlock.lOn) {
                double t = (int)Math.min(pBlock.hglThick, (pBlock.thick - pBlock.ew) / 3.0);
                double lev = 0.0;
                lsv = 0.0;
                lsv = pBlock.lv <= pBlock.ev || pBlock.lv <= pBlock.hgv ? pBlock.lv : pBlock.hgv;
                lev = pBlock.hgv >= pBlock.ev || pBlock.ev >= pBlock.lv ? pBlock.hgv : pBlock.lv;
                BaseBar.drawTwoDConfidenceBracket(channel, pBlock.hgc, pBlock.ec, lsv, lev, pBlock.pos, t, pBlock.ew, pBlock.hglIsBar, pBlock.hglFillOn, pBlock.vertical, this.fullSize, pBlock);
            }
        } else if (pBlock.hgOn || pBlock.lOn) {
            double t = (int)Math.min(pBlock.hglThick, (pBlock.thick - pBlock.ew) / 3.0);
            if (pBlock.lOn && pBlock.lv <= pBlock.ev) {
                double lev = pBlock.lv;
                lsv = pBlock.ev;
                BaseBar.drawTwoDHighLow(channel, pBlock.lc, pBlock.ec, lsv, lev, pBlock.pos, t, pBlock.ew, pBlock.hglIsBar, pBlock.hglFillOn, pBlock.vertical);
            }
            if (pBlock.hgOn && pBlock.hgv >= pBlock.ev) {
                double hev = pBlock.hgv;
                double hsv = pBlock.ev;
                BaseBar.drawTwoDHighLow(channel, pBlock.hgc, pBlock.ec, hsv, hev, pBlock.pos, t, pBlock.ew, pBlock.hglIsBar, pBlock.hglFillOn, pBlock.vertical);
            }
        }
        if (pBlock.tgOn) {
            double tgOff = pBlock.ew / 2.0;
            double t = Math.max(Math.min(pBlock.tgThick, (pBlock.thick - tgOff * 2.0) / 3.0), 0.0);
            double tb = t / 3.0;
            if (pBlock.tgGran > 0.0) {
                double r = pBlock.tgGran / 2.0;
                tgOff = (double)((int)(pBlock.ew / pBlock.tgGran * 0.5 + r)) * pBlock.tgGran;
                t = Math.max(Math.min(pBlock.tgThick, (pBlock.thick - tgOff * 2.0) / 3.0), 0.0);
                tb = (double)((int)(t / 3.0 / pBlock.tgGran + r)) * pBlock.tgGran;
                t = tb * 3.0;
            }
            if (pBlock.thick - tgOff > 0.0) {
                channel.glColor(pBlock.tgc);
                channel.glEdgeColor(pBlock.tgc);
                channel.glLineWidth((float)pBlock.tglThick);
                channel.glBegin(1);
                if (pBlock.vertical) {
                    channel.glVertex(this.fullSize.x + (tgOff + t), pBlock.tgv);
                    channel.glVertex(this.fullSize.x + this.fullSize.width - tgOff, pBlock.tgv);
                } else {
                    channel.glVertex(pBlock.tgv, this.fullSize.y + tgOff);
                    channel.glVertex(pBlock.tgv, this.fullSize.y + this.fullSize.height - (tgOff + t));
                }
                channel.glEnd();
                channel.glPolygonMode(4);
                channel.glBegin(2);
                if (pBlock.vertical) {
                    double x = this.fullSize.x + tgOff;
                    channel.glVertex(x, pBlock.tgv - tb);
                    channel.glVertex(x, pBlock.tgv + tb);
                    channel.glVertex(x + t, pBlock.tgv);
                } else {
                    double y = this.fullSize.y + this.fullSize.height - tgOff;
                    channel.glVertex(pBlock.tgv - tb, y);
                    channel.glVertex(pBlock.tgv + tb, y);
                    channel.glVertex(pBlock.tgv, y - t);
                }
                channel.glEnd();
            }
        }
        if (pBlock.ho && pBlock.hp <= 1.0 && pBlock.hp >= 0.0) {
            channel.glColor(pBlock.hc);
            channel.glEdgeColor(pBlock.hc);
            this.computeRectangle(pBlock.pos, pBlock.sv, pBlock.sv + (pBlock.ev - pBlock.sv) * pBlock.hp, pBlock.thick, pBlock.thresh, pBlock.vertical, this.fullSize);
            channel.glPolygonMode(6);
            channel.glLineWidth(2.0f);
            if (this.VGFRenderModeOn.getValue() && this.fullSize.height == 0.0) {
                channel.glBegin(1);
                channel.glVertex(this.fullSize.x, this.fullSize.y);
                channel.glVertex(this.fullSize.x + this.fullSize.width, this.fullSize.y);
                channel.glEnd();
            } else if (this.VGFRenderModeOn.getValue() && this.fullSize.width == 0.0) {
                channel.glBegin(1);
                channel.glVertex(this.fullSize.x, this.fullSize.y);
                channel.glVertex(this.fullSize.x, this.fullSize.y + this.fullSize.height);
                channel.glEnd();
            } else {
                channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
            }
            channel.glLineWidth(1.0f);
            channel.glPolygonMode(3);
        }
    }

    private int[] getSkinSizeInPixel(Channel channel) {
        double[] d = new double[3];
        double[] s1 = new double[3];
        double[] s2 = new double[3];
        d[0] = this.fullSize.x;
        d[1] = this.fullSize.y;
        d[2] = 0.0;
        channel.gluProject(d, s1);
        d[0] = this.fullSize.x + this.fullSize.width;
        d[1] = this.fullSize.y + this.fullSize.height;
        channel.gluProject(d, s2);
        int xmin = (int)(Math.min(s1[0], s2[0]) + 0.5);
        int xmax = (int)(Math.max(s1[0], s2[0]) + 0.5);
        int ymin = (int)(Math.min(s1[1], s2[1]) + 0.5);
        int ymax = (int)(Math.max(s1[1], s2[1]) + 0.5);
        return new int[]{xmax - xmin + 1, ymax - ymin + 1};
    }

    private int getFirstNonMissingDrawOrderIndex() {
        int result = -1;
        List dol = this.getDrawOrderList();
        for (int i = 0; i < dol.size(); ++i) {
            BarInfo bi = (BarInfo)dol.get(i);
            if (bi.isMissing()) continue;
            result = i;
            return i;
        }
        return result;
    }

    private void drawTrendLine(Channel channel, PropertyValueBlock pBlock, boolean initial) {
        double endY;
        int tlp;
        double tlw;
        Color tlc;
        BarInfo bi;
        double startY;
        double startX;
        if (!pBlock.trendLineOn) {
            return;
        }
        int doi = pBlock.drawOrderListIndex;
        if (initial && (!pBlock.trendLineInitialOn || doi != this.getFirstNonMissingDrawOrderIndex() || this.skipMissingOnTrendLine && doi > 0)) {
            return;
        }
        List dol = this.getDrawOrderList();
        if (!initial && doi == dol.size() - 1) {
            return;
        }
        if (initial) {
            startX = pBlock.trendLineInitialX;
            startY = pBlock.trendLineInitialY;
            bi = (BarInfo)dol.get(doi);
            tlc = bi.trendLineColor;
            tlw = bi.trendLineWidth;
            tlp = bi.trendLinePattern;
        } else {
            bi = (BarInfo)dol.get(doi);
            startX = bi.categoryPosition + pBlock.thick / 2.0;
            startY = bi.ev;
            Color tlc1 = bi.trendLineColor;
            bi = (BarInfo)dol.get(doi + 1);
            tlc = bi.trendLineColor;
            if (tlc == null) {
                tlc = tlc1;
            }
            tlw = bi.trendLineWidth;
            tlp = bi.trendLinePattern;
        }
        double endX = bi.categoryPosition - pBlock.thick / 2.0;
        switch (pBlock.trendLineType) {
            default: {
                endY = bi.ev;
                break;
            }
            case 0: {
                endY = bi.sv;
            }
        }
        if (Double.isNaN(startX) || Double.isNaN(startY) || Double.isNaN(endX) || Double.isNaN(endY)) {
            return;
        }
        if (tlw >= 0.0) {
            channel.glLineWidth((float)tlw);
        }
        if (tlp >= 0) {
            channel.glEnable(6);
            channel.glLineStipple(SASLinePatterns.getStippleFactor((int)tlp), SASLinePatterns.getStipplePattern((int)tlp));
        }
        channel.glColor(tlc);
        channel.glBegin(1);
        channel.glVertex(startX, startY);
        channel.glVertex(endX, endY);
        channel.glEnd();
        if (tlw >= 0.0) {
            channel.glLineWidth((float)pBlock.ew);
        }
        if (tlp >= 0) {
            if (pBlock.ep >= 0) {
                channel.glLineStipple(SASLinePatterns.getStippleFactor((int)pBlock.ep), SASLinePatterns.getStipplePattern((int)pBlock.ep));
            } else {
                channel.glDisable(6);
            }
        }
    }

    private void computeContextSensitiveGradientDirection(int gd, double sv, double ev, boolean vertical, Color c1, Color c2) {
        this.contextSensitiveGradient.direction = gd;
        this.contextSensitiveGradient.c1 = c1;
        this.contextSensitiveGradient.c2 = c2;
        boolean swapColors = false;
        if (vertical) {
            switch (gd) {
                case 0: {
                    break;
                }
                case 3: {
                    if (!(ev < sv)) break;
                    this.contextSensitiveGradient.direction = 2;
                    break;
                }
                case 2: {
                    if (!(ev < sv)) break;
                    this.contextSensitiveGradient.direction = 3;
                    break;
                }
                case 1: {
                    if (!(ev < sv)) break;
                    swapColors = true;
                }
            }
        } else {
            switch (gd) {
                case 1: {
                    this.contextSensitiveGradient.direction = 0;
                    if (!(ev > sv)) break;
                    swapColors = true;
                    break;
                }
                case 3: {
                    if (!(ev > sv)) break;
                    this.contextSensitiveGradient.direction = 2;
                    swapColors = true;
                    break;
                }
                case 2: {
                    if (ev < sv) {
                        swapColors = true;
                        break;
                    }
                    this.contextSensitiveGradient.direction = 3;
                    break;
                }
                case 0: {
                    this.contextSensitiveGradient.direction = 1;
                }
            }
        }
        if (swapColors) {
            this.contextSensitiveGradient.c1 = c2;
            this.contextSensitiveGradient.c2 = c1;
        }
    }

    protected float getPolygonOffsetFactor() {
        return this.polygonOffsetFactor;
    }

    protected void setPolygonOffsetFactor(float polygonOffsetFactor) {
        this.polygonOffsetFactor = polygonOffsetFactor;
    }

    protected float getPolygonOffsetUnits() {
        return this.polygonOffsetUnits;
    }

    protected void setPolygonOffsetUnits(float polygonOffsetUnits) {
        this.polygonOffsetUnits = polygonOffsetUnits;
    }

    public boolean isDrawOrderSortEnabled() {
        return this.drawOrderSortEnabled;
    }

    protected boolean barsNeedSorting() {
        return !this.isTwoD() && this.isDrawOrderSortEnabled();
    }

    public void setDrawOrderSortEnabled(boolean drawOrderSortEnabled) {
        this.drawOrderSortEnabled = drawOrderSortEnabled;
    }

    protected PropertyValueBlock getPropertyValueBlock() {
        return this.propertyValueBlock;
    }

    protected int getMyValueCount() {
        return this.myValueCount;
    }

    protected void setMyValueCount(int myValueCount) {
        if (myValueCount == -1) {
            myValueCount = 1;
        }
        this.myValueCount = myValueCount;
    }

    protected List getDrawOrderList() {
        if (this.drawOrderList == null) {
            this.drawOrderList = new ArrayList();
        }
        return this.drawOrderList;
    }

    protected Comparator getPositionComparator() {
        if (this.positionComparator == null) {
            this.positionComparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    BarInfo bi0 = (BarInfo)arg0;
                    BarInfo bi1 = (BarInfo)arg1;
                    return Double.compare(bi0.categoryPosition, bi1.categoryPosition);
                }
            };
        }
        return this.positionComparator;
    }

    protected Comparator getStackComparator() {
        if (this.stackComparator == null) {
            this.stackComparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    BarInfo bi0 = (BarInfo)arg0;
                    BarInfo bi1 = (BarInfo)arg1;
                    if (bi0.categoryPosition == bi1.categoryPosition) {
                        return Double.compare(bi0.middle, bi1.middle);
                    }
                    return 0;
                }
            };
        }
        return this.stackComparator;
    }

    protected static class PropertyValueBlock {
        public double sv;
        public double ev;
        public boolean vertical;
        public Color c1;
        public Color c2;
        public Color ec;
        public Color tc;
        public Color hc;
        public Color hec;
        public double hp;
        public boolean fo;
        public boolean eo;
        public boolean go;
        public boolean ho;
        public int gd;
        public boolean texOn;
        public int tm;
        public int ts;
        public int ti;
        public boolean threshOn;
        public double thresh;
        public double thick;
        public double d;
        public double ew;
        public double pos;
        public int ep;
        public int m3dshape;
        public boolean hgOn;
        public double hgv;
        public Color hgc;
        public boolean lOn;
        public double lv;
        public Color lc;
        public boolean fpOn;
        public int fpt;
        public Color fpc;
        public double fpw;
        public double fpsf;
        public double hglThick;
        public boolean hglIsBar;
        public boolean hglFillOn;
        public boolean tgOn;
        public double tgv;
        public Color tgc;
        public double tgThick;
        public double tglThick;
        public double tgGran;
        public boolean textureNeeded;
        public double b;
        public boolean specificationLimitsOn;
        public double specificationLimitLow;
        public double specificationLimitHigh;
        public Color specificationLimitBelowLowColor;
        public Color specificationLimitAboveHighColor;
        public boolean confidenceLimitEnabled;
        public boolean trendLineOn;
        public boolean trendLineInitialOn;
        public int drawOrderListIndex;
        public double trendLineInitialX;
        public double trendLineInitialY;
        public int trendLineType;

        protected PropertyValueBlock() {
        }
    }

    private static class GradientDefinition {
        public int direction;
        public Color c1;
        public Color c2;

        private GradientDefinition() {
        }
    }

    protected static class BarInfo {
        public double categoryPosition = 0.0;
        public double ev = 0.0;
        public double sv = 0.0;
        public int valueIndex;
        public int responseIndex;
        public double middle;
        public Color trendLineColor;
        public double trendLineWidth;
        public int trendLinePattern;

        private BarInfo(double categoryPosition, double sv, double ev, Color trendLineColor, double trendLineWidth, int trendLinePattern, int valueIndex, int responseIndex) {
            this.valueIndex = valueIndex;
            this.responseIndex = responseIndex;
            this.categoryPosition = categoryPosition;
            this.ev = ev;
            this.sv = sv;
            this.middle = sv + (ev - sv) / 2.0;
            this.trendLineColor = trendLineColor;
            this.trendLineWidth = trendLineWidth;
            this.trendLinePattern = trendLinePattern;
        }

        public BarInfo(double categoryPosition, double sv, double ev, Color trendLineColor, int valueIndex) {
            this(categoryPosition, sv, ev, trendLineColor, -1.0, -1, valueIndex, -1);
        }

        public BarInfo(double categoryPosition, double sv, double ev, int valueIndex, int responseIndex) {
            this(categoryPosition, sv, ev, null, -1.0, -1, valueIndex, responseIndex);
        }

        public BarInfo(double categoryPosition, double sv, double ev, Color trendLineColor, double trendLineWidth, int trendLinePattern, int valueIndex) {
            this(categoryPosition, sv, ev, trendLineColor, trendLineWidth, trendLinePattern, valueIndex, -1);
        }

        public boolean isMissing() {
            return this.valueIndex < 0;
        }
    }
}

