/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.SelectEntry;
import com.sas.graphics.util.gtk.gl.BaseBar;
import com.sas.graphics.util.gtk.gl.BuildAction;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;

public class Bar
extends BaseBar {
    public static final int TREND_TO_START = 0;
    public static final int TREND_TO_END = 1;
    public final BooleanProperty trendLineOn = new BooleanProperty(this, true);
    public final BooleanProperty trendLineInitialOn = new BooleanProperty(this, true);
    public final ColorProperty trendLineColor = new ColorProperty(this, true);
    public final NumericProperty trendLineWidth = new NumericProperty(this, true);
    public final IntegerProperty trendLinePattern = new IntegerProperty(this, true);
    public final NumericProperty trendLineInitialX = new NumericProperty(this, true);
    public final NumericProperty trendLineInitialY = new NumericProperty(this, true);
    public final IntegerProperty trendLineType = new IntegerProperty(this, true);
    public final BooleanProperty specificationLimitsOn = new BooleanProperty(this, true);
    public final NumericProperty specificationLimitLow = new NumericProperty(this, true);
    public final NumericProperty specificationLimitHigh = new NumericProperty(this, true);
    public final ColorProperty specificationLimitBelowLowColor = new ColorProperty(this, true);
    public final ColorProperty specificationLimitAboveHighColor = new ColorProperty(this, true);

    public Bar() {
        this.specificationLimitLow.setValue(-1.7976931348623157E308);
        this.specificationLimitHigh.setValue(Double.MAX_VALUE);
        this.trendLineOn.setValue(false);
        this.trendLineWidth.setValue(-1.0);
        this.trendLinePattern.setValue(-1);
        this.trendLineType.setValue(1);
        this.trendLineInitialOn.setValue(false);
        this.trendLineInitialX.setValue(0.0);
        this.trendLineInitialY.setValue(0.0);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
    }

    @Override
    public void init(AInitAction initAction) {
        initAction.pushValueCount();
        super.init(initAction);
        int vc = initAction.getValueCount();
        this.setMyValueCount(vc);
        initAction.popValueCount();
        int initVC = vc == 0 ? 0 : 1;
        this.setValueCount(initVC);
        initAction.setValueCount(initVC);
        if (!initAction.beenInitialized(this)) {
            this.drawOrderSort();
        }
    }

    private void drawOrderSort() {
        List drawOrder = this.getDrawOrderList();
        drawOrder.clear();
        boolean tlo = this.trendLineOn.getValue();
        Color tlc = null;
        double tlw = -1.0;
        int tlp = -1;
        if (this.barsNeedSorting()) {
            for (int i = 0; i < this.getMyValueCount(); ++i) {
                BaseBar.BarInfo bi;
                double pos = 0.0;
                double sv = 0.0;
                try {
                    pos = this.position.getValue(i);
                    sv = this.startValue.getValue(i);
                    double ev = this.endValue.getValue(i);
                    if (tlo) {
                        tlc = this.trendLineColor.getValue(i);
                        tlw = this.trendLineWidth.getValue(i);
                        tlp = this.trendLinePattern.getValue(i);
                    }
                    bi = new BaseBar.BarInfo(pos, sv, ev, tlc, tlw, tlp, i);
                }
                catch (MissingValueException e) {
                    bi = this.skipMissingOnTrendLine && !Double.isNaN(pos) ? new BaseBar.BarInfo(pos, Double.NaN, Double.NaN, null, -1) : new BaseBar.BarInfo(0.0, 0.0, 0.0, null, -1);
                }
                drawOrder.add(bi);
            }
            Collections.sort(drawOrder, this.getPositionComparator());
            Collections.sort(drawOrder, this.getStackComparator());
        }
    }

    @Override
    protected boolean barsNeedSorting() {
        return super.barsNeedSorting() || this.trendLineOn.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        boolean subpixel;
        Channel channel = (Channel)buildAction.getGraphicsContext();
        if (!this.transform.isIdentity()) {
            channel.glPopMatrix();
        }
        if (!(subpixel = channel.isSubpixelRendering()) && this.isSubpixelRendering()) {
            channel.setSubpixelRendering(this.isSubpixelRendering());
        }
        BaseBar.BarInfo bi = null;
        for (int i = 0; i < this.getMyValueCount(); ++i) {
            int valueIndex = i;
            if (this.barsNeedSorting()) {
                bi = (BaseBar.BarInfo)this.getDrawOrderList().get(i);
                if (bi.isMissing()) continue;
                valueIndex = bi.valueIndex;
            }
            boolean isIdentity = this.transform.isIdentity();
            try {
                if (!isIdentity) {
                    buildAction.setValueIndex(valueIndex);
                    this.transform.push(buildAction);
                    this.transform.apply(buildAction);
                }
                BaseBar.PropertyValueBlock pBlock = this.loadPropertyValueBlock(bi, valueIndex, i);
                this.setGLAttributes(channel, pBlock);
                if (buildAction.isUseNameStack()) {
                    channel.glPopName();
                    channel.glLoadName((Object)new SelectEntry(this, valueIndex));
                    channel.glPushName(null);
                    if (channel.isSVGSelectionMode()) {
                        channel.setSVGSelectionText(this.userDataToString(valueIndex));
                    }
                }
                if (this.isTwoD()) {
                    this.drawTwoDBar(channel, pBlock);
                } else {
                    this.drawThreeDBar(channel, pBlock);
                }
            }
            catch (MissingValueException missingValueException) {
            }
            finally {
                if (!isIdentity) {
                    this.transform.pop(buildAction);
                }
            }
            channel.glDisable(10);
            channel.glDisable(6);
        }
        if (!this.transform.isIdentity()) {
            channel.glPushMatrix();
        }
        channel.setSubpixelRendering(subpixel);
    }

    private void setGLAttributes(Channel channel, BaseBar.PropertyValueBlock pBlock) {
        channel.glEdgeColor(pBlock.ec);
        channel.glPolygonMode(BuildAction.getGLFillStyle(pBlock.fo, pBlock.eo));
        channel.glLineWidth((float)pBlock.ew);
        if (pBlock.ep >= 0) {
            channel.glEnable(6);
            channel.glLineStipple(SASLinePatterns.getStippleFactor((int)pBlock.ep), SASLinePatterns.getStipplePattern((int)pBlock.ep));
        }
        BufferedImage[] texImage = this.getTextureImage();
        boolean bl = pBlock.textureNeeded = pBlock.texOn && pBlock.fo && texImage != null && texImage.length > 0;
        if (pBlock.textureNeeded) {
            if (pBlock.ti < 0 || pBlock.ti > texImage.length - 1) {
                pBlock.ti = 0;
            }
            channel.glTexImage2D((Image)texImage[pBlock.ti]);
            channel.glTexEnv(10, 1, pBlock.tm);
            channel.glTexEnv(10, 2, pBlock.ts);
        }
    }

    private BaseBar.PropertyValueBlock loadPropertyValueBlock(BaseBar.BarInfo bi, int valueIndex, int loopIndex) throws MissingValueException {
        BaseBar.PropertyValueBlock pBlock = this.getPropertyValueBlock();
        try {
            if (this.barsNeedSorting()) {
                pBlock.pos = bi.categoryPosition;
                pBlock.sv = bi.sv;
                pBlock.ev = bi.ev;
                pBlock.drawOrderListIndex = loopIndex;
            } else {
                pBlock.pos = this.position.getValue(valueIndex);
                pBlock.sv = this.startValue.getValue(valueIndex);
                pBlock.ev = this.endValue.getValue(valueIndex);
                pBlock.drawOrderListIndex = -1;
            }
            pBlock.vertical = this.verticalOn.getValue(valueIndex);
            pBlock.c1 = this.color1.getValue(valueIndex);
            pBlock.c2 = this.color2.getValue(valueIndex);
            pBlock.ec = this.edgeColor.getValue(valueIndex);
            pBlock.hc = this.highlightFillColor.getValue(valueIndex);
            pBlock.hec = this.highlightEdgeColor.getValue(valueIndex);
            pBlock.hp = this.highlightPercentage.getValue(valueIndex);
            pBlock.fo = this.fillOn.getValue(valueIndex);
            pBlock.eo = this.edgeOn.getValue(valueIndex);
            pBlock.go = this.gradientOn.getValue(valueIndex);
            pBlock.ho = this.highlightOn.getValue(valueIndex);
            pBlock.gd = this.gradientDirection.getValue(valueIndex);
            pBlock.texOn = this.textureOn.getValue(valueIndex);
            pBlock.tm = this.textureMode.getValue(valueIndex);
            pBlock.ts = this.textureStyle.getValue(valueIndex);
            pBlock.ti = this.textureIndex.getValue(valueIndex);
            pBlock.fpOn = this.fillPatternOn.getValue(valueIndex);
            pBlock.fpt = this.fillPatternType.getValue(valueIndex);
            pBlock.fpc = this.fillPatternColor.getValue(valueIndex);
            pBlock.fpw = this.fillPatternWidth.getValue(valueIndex);
            pBlock.fpsf = this.fillPatternScaleFactor.getValue(valueIndex);
            pBlock.thick = this.thickness.getValue(valueIndex);
            pBlock.d = this.depth.getValue(valueIndex);
            pBlock.ew = this.edgeWidth.getValue(valueIndex);
            pBlock.ep = this.edgePattern.getValue(valueIndex);
            pBlock.m3dshape = this.marker3DShape.getValue(valueIndex);
            pBlock.hgOn = this.highOn.getValue(valueIndex);
            if (pBlock.hgOn) {
                try {
                    pBlock.hgv = this.highValue.getValue(valueIndex);
                    pBlock.hgc = this.highColor.getValue(valueIndex);
                }
                catch (MissingValueException e) {
                    pBlock.hgOn = false;
                }
            }
            pBlock.lOn = this.lowOn.getValue(valueIndex);
            if (pBlock.lOn) {
                try {
                    pBlock.lv = this.lowValue.getValue(valueIndex);
                    pBlock.lc = this.lowColor.getValue(valueIndex);
                }
                catch (MissingValueException e) {
                    pBlock.lOn = false;
                }
            }
            pBlock.confidenceLimitEnabled = this.confidenceLimitEnabled.getValue();
            if (!(!pBlock.confidenceLimitEnabled || pBlock.hgOn && pBlock.lOn)) {
                pBlock.hgOn = false;
                pBlock.lOn = false;
            }
            pBlock.hglThick = this.highLowThickness.getValue(valueIndex);
            pBlock.hglIsBar = this.highLowIsBar.getValue();
            pBlock.hglFillOn = this.highLowFillOn.getValue();
            pBlock.threshOn = this.thresholdOn.getValue(valueIndex);
            pBlock.thresh = this.thresholdValue.getValue(valueIndex);
            pBlock.tc = this.thresholdColor.getValue(valueIndex);
            pBlock.tgOn = this.targetOn.getValue(valueIndex);
            if (pBlock.tgOn) {
                try {
                    pBlock.tgv = this.targetValue.getValue(valueIndex);
                    pBlock.tgc = this.targetColor.getValue(valueIndex);
                    pBlock.tgThick = this.targetThickness.getValue(valueIndex);
                    pBlock.tglThick = this.targetLineThickness.getValue(valueIndex);
                    pBlock.tgGran = this.targetGran.getValue(valueIndex);
                }
                catch (MissingValueException e) {
                    pBlock.tgOn = false;
                }
            }
            pBlock.specificationLimitsOn = this.specificationLimitsOn.getValue(valueIndex);
            if (pBlock.specificationLimitsOn) {
                pBlock.specificationLimitLow = this.specificationLimitLow.getValue(valueIndex);
                pBlock.specificationLimitHigh = this.specificationLimitHigh.getValue(valueIndex);
                pBlock.specificationLimitBelowLowColor = this.specificationLimitBelowLowColor.getValue(valueIndex);
                pBlock.specificationLimitAboveHighColor = this.specificationLimitAboveHighColor.getValue(valueIndex);
            }
            pBlock.trendLineOn = this.trendLineOn.getValue(valueIndex);
            if (pBlock.trendLineOn) {
                pBlock.trendLineInitialOn = this.trendLineInitialOn.getValue(valueIndex);
                pBlock.trendLineInitialX = this.trendLineInitialX.getValue(valueIndex);
                pBlock.trendLineInitialY = this.trendLineInitialY.getValue(valueIndex);
                pBlock.trendLineType = this.trendLineType.getValue(valueIndex);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problem loading bar properties.", e);
        }
        return pBlock;
    }
}

