/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ALineConnector;
import com.sas.graphics.util.gtk.Action;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class BandConnector
extends ALineConnector {
    public static final byte LINE = 0;
    public static final byte STEP_LEFT = 1;
    public static final byte STEP_RIGHT = 2;
    public static final byte STEP_CENTER = 3;
    protected double beginPointX2;
    protected double beginPointY2;
    protected double endPointX2;
    protected double endPointY2;
    protected boolean myStepJoin = true;
    protected int myJoinType = 0;
    protected Color myColor = ColorProperty.getDefaultColor();
    protected Color myFillColor = ColorProperty.getDefaultColor();
    protected float myLineWidth;
    protected boolean tailOn = true;
    protected double[] bandRange = null;
    protected double rangeMin = Double.NaN;
    protected double rangeMax = Double.NaN;
    protected boolean outOfRange = false;
    protected boolean yDirection = false;
    public final NumericProperty upperPointX = new NumericProperty(this, true);
    public final NumericProperty lowerPointX = new NumericProperty(this, true);
    public final NumericProperty upperPointY = new NumericProperty(this, true);
    public final NumericProperty lowerPointY = new NumericProperty(this, true);
    protected boolean SVGRender;
    protected boolean reverse = false;
    private boolean drawFill = false;
    private boolean drawFillPattern = false;

    public BandConnector() {
        super(new Transform());
        this.multipleGroup = true;
        this.SVGRender = false;
    }

    public int getJoinType() {
        return this.myJoinType;
    }

    public void setJoinType(int join) {
        this.myJoinType = join;
    }

    public void setStepJoin(boolean join) {
        this.myStepJoin = join;
    }

    public void setTailOn(boolean b) {
        this.tailOn = b;
    }

    public void setSVGRender(boolean SVG) {
        this.SVGRender = SVG;
    }

    public boolean isSVGRender() {
        return this.SVGRender;
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        this.beginPointX2 = Double.NaN;
        this.beginPointY2 = Double.NaN;
    }

    public void setBandRange(double[] range) {
        this.bandRange = range;
    }

    private int getIndexOfLastNonMissingValues(Vector band) {
        for (int i = band.size() - 1; i >= 0; --i) {
            int index = (Integer)band.elementAt(i);
            try {
                if (this.yDirection) {
                    this.pointX.getValue(index);
                    this.upperPointY.getValue(index);
                    this.lowerPointY.getValue(index);
                } else {
                    this.pointY.getValue(index);
                    this.upperPointX.getValue(index);
                    this.lowerPointX.getValue(index);
                }
                return i;
            }
            catch (MissingValueException e) {
                continue;
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drawBand(ABuildAction buildAction, Vector aBand, boolean fillOn) {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        if (fillOn) {
            channel.glPolygonMode(3);
        } else {
            channel.glPolygonMode(2);
        }
        boolean SVGRender = true;
        ArrayList upper = SVGRender ? new ArrayList() : null;
        ArrayList lower = SVGRender ? new ArrayList() : null;
        int lastIndex = this.getIndexOfLastNonMissingValues(aBand);
        int index = -1;
        int index0 = -1;
        int intersectionCount = lastIndex + 1;
        double adj = this.isSVGRender() || this.isSubpixelRendering() ? 0.0 : 1.0;
        boolean extraPoint = false;
        for (int j = 0; (j < intersectionCount || extraPoint) && !this.outOfRange; ++j) {
            if (!extraPoint) {
                index = (Integer)aBand.elementAt(j);
            }
            if (this.yDirection) {
                if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointY2) || Double.isNaN(this.beginPointZ)) {
                    try {
                        this.beginPointX = this.pointX.getValue(index);
                        if (fillOn && this.myJoinType == 2) {
                            this.beginPointX += adj;
                        }
                        this.beginPointX2 = this.beginPointX;
                        this.beginPointY = this.upperPointY.getValue(index);
                        this.beginPointY2 = this.lowerPointY.getValue(index);
                        this.beginPointZ = this.pointZ.getValue(index);
                        index0 = index;
                    }
                    catch (MissingValueException mve) {
                        continue;
                    }
                    if (this.myJoinType != 0 && (!this.reverse && !Double.isNaN(this.rangeMin) && this.rangeMin < this.beginPointX || this.reverse && !Double.isNaN(this.rangeMax) && this.rangeMax > this.beginPointX)) {
                        extraPoint = true;
                        this.endPointX2 = this.endPointX = this.beginPointX;
                        this.endPointY = this.beginPointY;
                        this.endPointY2 = this.beginPointY2;
                        this.endPointZ = this.beginPointZ;
                        this.beginPointX2 = this.reverse ? this.rangeMax : this.rangeMin;
                        this.beginPointX = this.beginPointX2;
                    } else {
                        if (!fillOn || this.myJoinType != 2 || !this.tailOn) continue;
                        channel.glBegin(1);
                        channel.glVertex(this.beginPointX - adj, this.beginPointY, this.beginPointZ);
                        channel.glVertex(this.beginPointX - adj, this.beginPointY2, this.beginPointZ);
                        channel.glEnd();
                        continue;
                    }
                }
            } else if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointX2) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointZ)) {
                try {
                    this.beginPointX = this.upperPointX.getValue(index);
                    this.beginPointX2 = this.lowerPointX.getValue(index);
                    this.beginPointY = this.pointY.getValue(index);
                    if (fillOn && (this.myJoinType == 0 || this.myJoinType == 1)) {
                        this.beginPointY -= adj;
                    }
                    this.beginPointY2 = this.beginPointY;
                    this.beginPointZ = this.pointZ.getValue(index);
                    index0 = index;
                }
                catch (MissingValueException mve) {
                    continue;
                }
                if (this.myJoinType != 0 && (!this.reverse && !Double.isNaN(this.rangeMin) && this.rangeMin < this.beginPointY || this.reverse && !Double.isNaN(this.rangeMax) && this.rangeMax > this.beginPointY)) {
                    extraPoint = true;
                    this.endPointX = this.beginPointX;
                    this.endPointX2 = this.beginPointX2;
                    this.endPointY2 = this.endPointY = this.beginPointY;
                    this.endPointZ = this.beginPointZ;
                    this.beginPointY2 = this.reverse ? this.rangeMax : this.rangeMin;
                    this.beginPointY = this.beginPointY2;
                } else {
                    if (!fillOn || this.myJoinType != 2 && this.myJoinType != 3) continue;
                    double beginX = this.myJoinType == 3 ? this.beginPointX - adj : this.beginPointX;
                    if (!this.tailOn && this.myJoinType != 3) continue;
                    channel.glBegin(1);
                    channel.glVertex(beginX, this.beginPointY, this.beginPointZ);
                    channel.glVertex(this.beginPointX2, this.beginPointY, this.beginPointZ);
                    channel.glEnd();
                    continue;
                }
            }
            try {
                block83: {
                    block86: {
                        block84: {
                            block85: {
                                if (this.yDirection) {
                                    if (!extraPoint) {
                                        this.endPointX = this.pointX.getValue(index);
                                        if (fillOn && (this.myJoinType == 2 || this.myJoinType == 0 && j == intersectionCount - 1)) {
                                            this.endPointX += adj;
                                        }
                                        this.endPointX2 = this.endPointX;
                                        this.endPointY = this.upperPointY.getValue(index);
                                        this.endPointY2 = this.lowerPointY.getValue(index);
                                        this.endPointZ = this.pointZ.getValue(index);
                                    } else {
                                        extraPoint = false;
                                    }
                                } else if (!extraPoint) {
                                    this.endPointX = this.upperPointX.getValue(index);
                                    this.endPointX2 = this.lowerPointX.getValue(index);
                                    this.endPointY = this.pointY.getValue(index);
                                    if (fillOn && this.myJoinType == 1) {
                                        this.endPointY -= adj;
                                    }
                                    this.endPointY2 = this.endPointY;
                                    this.endPointZ = this.pointZ.getValue(index);
                                } else {
                                    extraPoint = false;
                                }
                                if (!Double.isNaN(this.rangeMin)) {
                                    if (this.yDirection) {
                                        if (this.endPointX < this.rangeMin) continue;
                                        this.beginPointX = this.beginPointX2 = Math.max(this.beginPointX, this.rangeMin);
                                        if (this.reverse && this.rangeMin < this.endPointX && this.myJoinType != 0 && j == intersectionCount - 1) {
                                            extraPoint = true;
                                        }
                                    } else {
                                        if (this.endPointY < this.rangeMin) continue;
                                        this.beginPointY = this.beginPointY2 = Math.max(this.beginPointY, this.rangeMin);
                                        if (this.reverse && this.rangeMin < this.endPointY && this.myJoinType != 0 && j == intersectionCount - 1) {
                                            extraPoint = true;
                                        }
                                    }
                                }
                                if (Double.isNaN(this.rangeMax)) break block84;
                                if (!this.yDirection) break block85;
                                if (this.endPointX > this.rangeMax) {
                                    this.outOfRange = true;
                                    this.endPointX = this.endPointX2 = Math.min(this.endPointX, this.rangeMax);
                                    break block84;
                                } else if (!this.reverse && this.rangeMax > this.endPointX && this.myJoinType != 0 && j == intersectionCount - 1) {
                                    extraPoint = true;
                                }
                                break block84;
                            }
                            if (this.endPointY > this.rangeMax) {
                                this.outOfRange = true;
                                this.endPointY = this.endPointY2 = Math.min(this.endPointY, this.rangeMax);
                            } else if (!this.reverse && this.rangeMax > this.endPointY && this.myJoinType != 0 && j == intersectionCount - 1) {
                                extraPoint = true;
                            }
                        }
                        if (!fillOn) break block86;
                        if (ba.isUseNameStack()) {
                            this.drawFillBetween(ba, this.yDirection, index0, index);
                            break block83;
                        } else if (SVGRender) {
                            this.addVertex(ba, this.yDirection, upper, lower, j >= intersectionCount - 1 && !extraPoint);
                            break block83;
                        } else {
                            this.drawFillBetween(ba, this.yDirection);
                        }
                        break block83;
                    }
                    double x1 = this.beginPointX;
                    double x2 = this.endPointX;
                    double y1 = this.beginPointY;
                    double y2 = this.endPointY;
                    double z = this.beginPointZ;
                    for (int i = 0; i < 2; ++i) {
                        double cx = (x1 + x2) * 0.5;
                        double cy = (y1 + y2) * 0.5;
                        switch (this.myJoinType) {
                            case 0: {
                                if (ba.isUseNameStack()) {
                                    this.replaceObservation(channel, index0);
                                    LineSegment.drawLineSegment(channel, x1, y1, z, cx, cy, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                    this.replaceObservation(channel, index);
                                    LineSegment.drawLineSegment(channel, cx, cy, z, x2, y2, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                    break;
                                }
                                LineSegment.drawLineSegment(channel, x1, y1, z, x2, y2, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                break;
                            }
                            case 1: {
                                if (this.yDirection) {
                                    if (ba.isUseNameStack()) {
                                        this.replaceObservation(channel, index0);
                                    }
                                    LineSegment.drawLineSegment(channel, x1, y1, z, x2 - adj, y1, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                    if (!this.myStepJoin || ba.isUseNameStack()) break;
                                    LineSegment.drawLineSegment(channel, x2, y1, z, x2, y2, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                    break;
                                }
                                if (ba.isUseNameStack()) {
                                    this.replaceObservation(channel, index0);
                                }
                                LineSegment.drawLineSegment(channel, x1, y1, z, x1, y2 - adj, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                if (!this.myStepJoin || ba.isUseNameStack()) break;
                                LineSegment.drawLineSegment(channel, x1, y2, z, x2, y2, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                break;
                            }
                            case 2: {
                                if (this.yDirection) {
                                    if (this.myStepJoin && !ba.isUseNameStack()) {
                                        LineSegment.drawLineSegment(channel, x1, y1, z, x1, y2, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                    }
                                    if (ba.isUseNameStack()) {
                                        this.replaceObservation(channel, index);
                                    }
                                    LineSegment.drawLineSegment(channel, x1 + adj, y2, z, x2, y2, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                    break;
                                }
                                if (this.myStepJoin && !ba.isUseNameStack()) {
                                    LineSegment.drawLineSegment(channel, x1, y1, z, x2, y1, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                }
                                if (ba.isUseNameStack()) {
                                    this.replaceObservation(channel, index);
                                }
                                LineSegment.drawLineSegment(channel, x2, y1 + adj, z, x2, y2, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                break;
                            }
                            case 3: {
                                if (this.yDirection) {
                                    if (ba.isUseNameStack()) {
                                        this.replaceObservation(channel, index0);
                                    }
                                    LineSegment.drawLineSegment(channel, x1, y1, z, cx - adj, y1, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                    if (this.myStepJoin && !ba.isUseNameStack()) {
                                        LineSegment.drawLineSegment(channel, cx, y1, z, cx, y2, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                    }
                                    if (ba.isUseNameStack()) {
                                        this.replaceObservation(channel, index);
                                    }
                                    LineSegment.drawLineSegment(channel, cx, y2, z, x2, y2, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                    break;
                                }
                                if (ba.isUseNameStack()) {
                                    this.replaceObservation(channel, index0);
                                }
                                LineSegment.drawLineSegment(channel, x1, y1, z, x1, cy, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                if (this.myStepJoin && !ba.isUseNameStack()) {
                                    LineSegment.drawLineSegment(channel, x1, cy, z, x2, cy, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                }
                                if (ba.isUseNameStack()) {
                                    this.replaceObservation(channel, index);
                                }
                                LineSegment.drawLineSegment(channel, x2, cy + adj, z, x2, y2, z, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                                break;
                            }
                        }
                        x1 = this.beginPointX2;
                        x2 = this.endPointX2;
                        y1 = this.beginPointY2;
                        y2 = this.endPointY2;
                    }
                }
                this.beginPointX = this.endPointX;
                this.beginPointX2 = this.endPointX2;
                this.beginPointY = this.endPointY;
                this.beginPointY2 = this.endPointY2;
                this.beginPointZ = this.endPointZ;
                index0 = index;
                if (extraPoint) {
                    if (this.yDirection) {
                        this.endPointX2 = this.reverse ? this.rangeMin : this.rangeMax;
                        this.endPointX = this.endPointX2;
                        this.endPointY = this.beginPointY;
                        this.endPointY2 = this.beginPointY2;
                        this.endPointZ = this.beginPointZ;
                        continue;
                    }
                    this.endPointY2 = this.reverse ? this.rangeMin : this.rangeMax;
                    this.endPointY = this.endPointY2;
                    this.endPointX = this.beginPointX;
                    this.endPointX2 = this.beginPointX2;
                    this.endPointZ = this.beginPointZ;
                    continue;
                }
                if (j != intersectionCount - 1 || !fillOn || this.myJoinType != 1 && this.myJoinType != 3) continue;
                if (this.yDirection) {
                    if (this.myJoinType == 3) {
                        this.endPointY2 += adj;
                    }
                    if (!this.tailOn && this.myJoinType != 3) continue;
                    channel.glBegin(1);
                    channel.glVertex(this.endPointX, this.endPointY, this.endPointZ);
                    channel.glVertex(this.endPointX, this.endPointY2, this.endPointZ);
                    channel.glEnd();
                    continue;
                }
                if (this.myJoinType != 1 || !this.tailOn) continue;
                this.endPointY += adj;
                channel.glBegin(1);
                channel.glVertex(this.endPointX, this.endPointY, this.endPointZ);
                channel.glVertex(this.endPointX2, this.endPointY, this.endPointZ);
                channel.glEnd();
                continue;
            }
            catch (MissingValueException mve) {
                if (!this.skipMissing) continue;
                this.beginPointX = Double.NaN;
                this.beginPointX2 = Double.NaN;
                this.beginPointY = Double.NaN;
                this.beginPointY2 = Double.NaN;
                this.beginPointZ = Double.NaN;
            }
        }
        if (fillOn && SVGRender && !ba.isUseNameStack()) {
            if (this.drawFillPattern) {
                channel.glFillPatternType(this.currentGroup.getFillPatternType());
                channel.glFillPatternWidth(this.currentGroup.getFillPatternWidth());
                channel.glFillPatternScaleFactor(this.currentGroup.getFillPatternScaleFactor());
                channel.glFillPatternColor(this.currentGroup.getFillPatternColor());
                if (this.drawFill) {
                    channel.glPolygonMode(9);
                } else {
                    channel.glPolygonMode(8);
                }
            }
            if (upper.size() + lower.size() > 10) {
                channel.setVertexBufferReallocationSize(upper.size() + lower.size());
            }
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            if (this.yDirection) {
                Vec3d v;
                int i;
                for (i = upper.size() - 1; i >= 0; --i) {
                    v = (Vec3d)upper.get(i);
                    channel.glVertex(v.x, v.y, v.z);
                }
                for (i = 0; i < lower.size(); ++i) {
                    v = (Vec3d)lower.get(i);
                    channel.glVertex(v.x, v.y, v.z);
                }
            } else {
                Vec3d v;
                int i;
                for (i = 0; i < upper.size(); ++i) {
                    v = (Vec3d)upper.get(i);
                    channel.glVertex(v.x, v.y, v.z);
                }
                for (i = lower.size() - 1; i >= 0; --i) {
                    v = (Vec3d)lower.get(i);
                    channel.glVertex(v.x, v.y, v.z);
                }
            }
            channel.glEnd();
            channel.setVertexBufferReallocationSize(10);
        }
    }

    private void drawPolylineBand(ABuildAction buildAction, Vector aBand) {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        if (ba.isUseNameStack()) {
            this.drawBand(buildAction, aBand, false);
            return;
        }
        int lastIndex = this.getIndexOfLastNonMissingValues(aBand);
        int index = -1;
        int intersectionCount = lastIndex + 1;
        if (intersectionCount > 10) {
            channel.setVertexBufferReallocationSize(intersectionCount);
        }
        for (int i = 0; i < 2; ++i) {
            boolean newLine = true;
            channel.glBegin(1);
            boolean extraPoint = false;
            for (int j = 0; (j < intersectionCount || extraPoint) && !this.outOfRange; ++j) {
                if (!extraPoint) {
                    index = (Integer)aBand.elementAt(j);
                }
                if (this.yDirection) {
                    if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointY2) || Double.isNaN(this.beginPointZ)) {
                        try {
                            this.beginPointX2 = this.beginPointX = this.pointX.getValue(index);
                            this.beginPointY = this.upperPointY.getValue(index);
                            this.beginPointY2 = this.lowerPointY.getValue(index);
                            this.beginPointZ = this.pointZ.getValue(index);
                        }
                        catch (MissingValueException mve) {
                            continue;
                        }
                        if (this.myJoinType == 0 || !(!this.reverse && !Double.isNaN(this.rangeMin) && this.rangeMin < this.beginPointX) && (!this.reverse || Double.isNaN(this.rangeMax) || !(this.rangeMax > this.beginPointX))) continue;
                        extraPoint = true;
                        this.endPointX2 = this.endPointX = this.beginPointX;
                        this.endPointY = this.beginPointY;
                        this.endPointY2 = this.beginPointY2;
                        this.endPointZ = this.beginPointZ;
                        this.beginPointX2 = this.reverse ? this.rangeMax : this.rangeMin;
                        this.beginPointX = this.beginPointX2;
                    }
                } else if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointX2) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointZ)) {
                    try {
                        this.beginPointX = this.upperPointX.getValue(index);
                        this.beginPointX2 = this.lowerPointX.getValue(index);
                        this.beginPointY2 = this.beginPointY = this.pointY.getValue(index);
                        this.beginPointZ = this.pointZ.getValue(index);
                    }
                    catch (MissingValueException mve) {
                        continue;
                    }
                    if (this.myJoinType == 0 || !(!this.reverse && !Double.isNaN(this.rangeMin) && this.rangeMin < this.beginPointY) && (!this.reverse || Double.isNaN(this.rangeMax) || !(this.rangeMax > this.beginPointY))) continue;
                    extraPoint = true;
                    this.endPointX = this.beginPointX;
                    this.endPointX2 = this.beginPointX2;
                    this.endPointY2 = this.endPointY = this.beginPointY;
                    this.endPointZ = this.beginPointZ;
                    this.beginPointY2 = this.reverse ? this.rangeMax : this.rangeMin;
                    this.beginPointY = this.beginPointY2;
                }
                try {
                    double z;
                    double y2;
                    double y1;
                    double x2;
                    double x1;
                    if (this.yDirection) {
                        if (!extraPoint) {
                            this.endPointX2 = this.endPointX = this.pointX.getValue(index);
                            this.endPointY = this.upperPointY.getValue(index);
                            this.endPointY2 = this.lowerPointY.getValue(index);
                            this.endPointZ = this.pointZ.getValue(index);
                        } else {
                            extraPoint = false;
                        }
                    } else if (!extraPoint) {
                        this.endPointX = this.upperPointX.getValue(index);
                        this.endPointX2 = this.lowerPointX.getValue(index);
                        this.endPointY2 = this.endPointY = this.pointY.getValue(index);
                        this.endPointZ = this.pointZ.getValue(index);
                    } else {
                        extraPoint = false;
                    }
                    if (!Double.isNaN(this.rangeMin)) {
                        if (this.yDirection) {
                            if (this.endPointX < this.rangeMin) continue;
                            this.beginPointX = this.beginPointX2 = Math.max(this.beginPointX, this.rangeMin);
                            if (this.reverse && this.rangeMin < this.endPointX && this.myJoinType != 0 && j == intersectionCount - 1) {
                                extraPoint = true;
                            }
                        } else {
                            if (this.endPointY < this.rangeMin) continue;
                            this.beginPointY = this.beginPointY2 = Math.max(this.beginPointY, this.rangeMin);
                            if (this.reverse && this.rangeMin < this.endPointY && this.myJoinType != 0 && j == intersectionCount - 1) {
                                extraPoint = true;
                            }
                        }
                    }
                    if (!Double.isNaN(this.rangeMax)) {
                        if (this.yDirection) {
                            if (this.endPointX > this.rangeMax) {
                                this.outOfRange = true;
                                this.endPointX = this.endPointX2 = Math.min(this.endPointX, this.rangeMax);
                            } else if (!this.reverse && this.rangeMax > this.endPointX && this.myJoinType != 0 && j == intersectionCount - 1) {
                                extraPoint = true;
                            }
                        } else if (this.endPointY > this.rangeMax) {
                            this.outOfRange = true;
                            this.endPointY = this.endPointY2 = Math.min(this.endPointY, this.rangeMax);
                        } else if (!this.reverse && this.rangeMax > this.endPointY && this.myJoinType != 0 && j == intersectionCount - 1) {
                            extraPoint = true;
                        }
                    }
                    if (i == 0) {
                        x1 = this.beginPointX;
                        x2 = this.endPointX;
                        y1 = this.beginPointY;
                        y2 = this.endPointY;
                        z = this.beginPointZ;
                    } else {
                        x1 = this.beginPointX2;
                        x2 = this.endPointX2;
                        y1 = this.beginPointY2;
                        y2 = this.endPointY2;
                        z = this.beginPointZ;
                    }
                    switch (this.myJoinType) {
                        case 0: {
                            if (newLine) {
                                channel.glVertex(x1, y1, z);
                            }
                            channel.glVertex(x2, y2, z);
                            break;
                        }
                        case 1: {
                            if (this.yDirection) {
                                channel.glVertex(x1, y1, z);
                                channel.glVertex(x2, y1, z);
                                if (!this.tailOn && j >= intersectionCount - 1) break;
                                channel.glVertex(x2, y2, z);
                                break;
                            }
                            channel.glVertex(x1, y1, z);
                            channel.glVertex(x1, y2, z);
                            if (!this.tailOn && j >= intersectionCount - 1) break;
                            channel.glVertex(x2, y2, z);
                            break;
                        }
                        case 2: {
                            if (this.yDirection) {
                                if (this.tailOn || j > 1) {
                                    channel.glVertex(x1, y1, z);
                                }
                                channel.glVertex(x1, y2, z);
                                channel.glVertex(x2, y2, z);
                                break;
                            }
                            if (this.tailOn || j > 1) {
                                channel.glVertex(x1, y1, z);
                            }
                            channel.glVertex(x2, y1, z);
                            channel.glVertex(x2, y2, z);
                            break;
                        }
                        case 3: {
                            double cx = (x1 + x2) * 0.5;
                            double cy = (y1 + y2) * 0.5;
                            if (this.yDirection) {
                                channel.glVertex(x1, y1, z);
                                channel.glVertex(cx, y1, z);
                                channel.glVertex(cx, y2, z);
                                channel.glVertex(x2, y2, z);
                                break;
                            }
                            channel.glVertex(x1, y1, z);
                            channel.glVertex(x1, cy, z);
                            channel.glVertex(x2, cy, z);
                            channel.glVertex(x2, y2, z);
                        }
                    }
                    newLine = false;
                    this.beginPointX = this.endPointX;
                    this.beginPointX2 = this.endPointX2;
                    this.beginPointY = this.endPointY;
                    this.beginPointY2 = this.endPointY2;
                    this.beginPointZ = this.endPointZ;
                    if (!extraPoint) continue;
                    if (this.yDirection) {
                        this.endPointX2 = this.reverse ? this.rangeMin : this.rangeMax;
                        this.endPointX = this.endPointX2;
                        this.endPointY = this.beginPointY;
                        this.endPointY2 = this.beginPointY2;
                        this.endPointZ = this.beginPointZ;
                        continue;
                    }
                    this.endPointY2 = this.reverse ? this.rangeMin : this.rangeMax;
                    this.endPointY = this.endPointY2;
                    this.endPointX = this.beginPointX;
                    this.endPointX2 = this.beginPointX2;
                    this.endPointZ = this.beginPointZ;
                    continue;
                }
                catch (MissingValueException mve) {
                    if (!this.skipMissing) continue;
                    this.beginPointX = Double.NaN;
                    this.beginPointX2 = Double.NaN;
                    this.beginPointY = Double.NaN;
                    this.beginPointY2 = Double.NaN;
                    this.beginPointZ = Double.NaN;
                    channel.glEnd();
                    newLine = true;
                    channel.glBegin(1);
                }
            }
            channel.glEnd();
            this.beginPointX = Double.NaN;
            this.beginPointX2 = Double.NaN;
            this.beginPointY = Double.NaN;
            this.beginPointY2 = Double.NaN;
            this.beginPointZ = Double.NaN;
            this.outOfRange = false;
        }
        channel.setVertexBufferReallocationSize(10);
    }

    protected void addVertex(Action action, boolean yDirection, ArrayList upper, ArrayList lower, boolean lastPoint) {
        if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointX2) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointY2) || Double.isNaN(this.beginPointZ) || Double.isNaN(this.endPointX) || Double.isNaN(this.endPointX2) || Double.isNaN(this.endPointY) || Double.isNaN(this.endPointY2) || Double.isNaN(this.endPointZ)) {
            return;
        }
        Vec3d v1 = new Vec3d();
        Vec3d v2 = new Vec3d();
        Vec3d v3 = new Vec3d();
        Vec3d v4 = new Vec3d();
        switch (this.myJoinType) {
            case 0: {
                v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                v3.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                upper.add(v1);
                lower.add(v2);
                if (!lastPoint) break;
                upper.add(v4);
                lower.add(v3);
                break;
            }
            case 1: {
                if (yDirection) {
                    v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(this.endPointX2, this.beginPointY2, this.beginPointZ);
                    v4.set(this.endPointX, this.beginPointY, this.beginPointZ);
                    upper.add(v1);
                    upper.add(v4);
                    lower.add(v2);
                    lower.add(v3);
                    break;
                }
                v1.set(this.beginPointX2, this.endPointY2, this.beginPointZ);
                v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                v3.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                v4.set(this.beginPointX, this.endPointY, this.beginPointZ);
                upper.add(v3);
                upper.add(v4);
                lower.add(v2);
                lower.add(v1);
                break;
            }
            case 2: {
                if (yDirection) {
                    v1.set(this.beginPointX, this.endPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.endPointY2, this.beginPointZ);
                    v3.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                    v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                    upper.add(v1);
                    upper.add(v4);
                    lower.add(v2);
                    lower.add(v3);
                    break;
                }
                v1.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                v2.set(this.endPointX2, this.beginPointY2, this.beginPointZ);
                v3.set(this.endPointX, this.beginPointY, this.beginPointZ);
                v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                upper.add(v3);
                upper.add(v4);
                lower.add(v2);
                lower.add(v1);
                break;
            }
            case 3: {
                Vec3d v5 = new Vec3d();
                Vec3d v6 = new Vec3d();
                Vec3d v7 = new Vec3d();
                Vec3d v8 = new Vec3d();
                double cx = (this.beginPointX + this.endPointX) * 0.5;
                double cy = (this.beginPointY + this.endPointY) * 0.5;
                double cx2 = (this.beginPointX2 + this.endPointX2) * 0.5;
                double cy2 = (this.beginPointY2 + this.endPointY2) * 0.5;
                if (yDirection) {
                    v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(cx2, this.beginPointY2, this.beginPointZ);
                    v4.set(cx, this.beginPointY, this.beginPointZ);
                    v5.set(cx, this.endPointY, this.beginPointZ);
                    v6.set(cx2, this.endPointY2, this.beginPointZ);
                    v7.set(this.endPointX2, this.endPointY2, this.endPointZ);
                    v8.set(this.endPointX, this.endPointY, this.endPointZ);
                    upper.add(v1);
                    upper.add(v4);
                    upper.add(v5);
                    lower.add(v2);
                    lower.add(v3);
                    lower.add(v6);
                    if (!lastPoint) break;
                    upper.add(v8);
                    lower.add(v7);
                    break;
                }
                v1.set(this.beginPointX2, cy2, this.beginPointZ);
                v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                v3.set(this.beginPointX, this.beginPointY, this.endPointZ);
                v4.set(this.beginPointX, cy, this.endPointZ);
                v5.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                v6.set(this.endPointX2, cy2, this.beginPointZ);
                v7.set(this.endPointX, cy, this.beginPointZ);
                v8.set(this.endPointX, this.endPointY, this.beginPointZ);
                upper.add(v3);
                upper.add(v4);
                upper.add(v7);
                lower.add(v2);
                lower.add(v1);
                lower.add(v6);
                if (!lastPoint) break;
                upper.add(v8);
                lower.add(v5);
            }
        }
    }

    protected void drawFillBetween(Action action, boolean yDirection) {
        if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointX2) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointY2) || Double.isNaN(this.beginPointZ) || Double.isNaN(this.endPointX) || Double.isNaN(this.endPointX2) || Double.isNaN(this.endPointY) || Double.isNaN(this.endPointY2) || Double.isNaN(this.endPointZ)) {
            return;
        }
        Vec3d v1 = new Vec3d();
        Vec3d v2 = new Vec3d();
        Vec3d v3 = new Vec3d();
        Vec3d v4 = new Vec3d();
        Vec3d normal = new Vec3d(0.0, 0.0, 1.0);
        switch (this.myJoinType) {
            case 0: {
                if (yDirection) {
                    v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                    v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                } else {
                    v1.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                    v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                    v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                }
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                break;
            }
            case 1: {
                if (yDirection) {
                    v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(this.endPointX2, this.beginPointY2, this.beginPointZ);
                    v4.set(this.endPointX, this.beginPointY, this.beginPointZ);
                } else {
                    v1.set(this.beginPointX2, this.endPointY2, this.beginPointZ);
                    v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                    v4.set(this.beginPointX, this.endPointY, this.beginPointZ);
                }
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                break;
            }
            case 2: {
                if (yDirection) {
                    v1.set(this.beginPointX, this.endPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.endPointY2, this.beginPointZ);
                    v3.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                    v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                } else {
                    v1.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                    v2.set(this.endPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(this.endPointX, this.beginPointY, this.beginPointZ);
                    v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                }
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                break;
            }
            case 3: {
                double cx = (this.beginPointX + this.endPointX) * 0.5;
                double cy = (this.beginPointY + this.endPointY) * 0.5;
                double cx2 = (this.beginPointX2 + this.endPointX2) * 0.5;
                double cy2 = (this.beginPointY2 + this.endPointY2) * 0.5;
                if (yDirection) {
                    v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(cx2, this.beginPointY2, this.beginPointZ);
                    v4.set(cx, this.beginPointY, this.beginPointZ);
                    this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                    v1.set(cx, this.endPointY, this.beginPointZ);
                    v2.set(cx2, this.endPointY2, this.beginPointZ);
                    v3.set(this.endPointX2, this.endPointY2, this.endPointZ);
                    v4.set(this.endPointX, this.endPointY, this.endPointZ);
                    this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                    break;
                }
                v1.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                v2.set(this.endPointX2, cy2, this.beginPointZ);
                v3.set(this.endPointX, cy, this.beginPointZ);
                v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                v1.set(this.beginPointX2, cy2, this.beginPointZ);
                v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                v3.set(this.beginPointX, this.beginPointY, this.endPointZ);
                v4.set(this.beginPointX, cy, this.endPointZ);
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
            }
        }
    }

    protected void drawFillBetween(Action action, boolean yDirection, int beginIndex, int endIndex) {
        if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointX2) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointY2) || Double.isNaN(this.beginPointZ) || Double.isNaN(this.endPointX) || Double.isNaN(this.endPointX2) || Double.isNaN(this.endPointY) || Double.isNaN(this.endPointY2) || Double.isNaN(this.endPointZ)) {
            return;
        }
        Channel channel = (Channel)action.getGraphicsContext();
        Vec3d v1 = new Vec3d();
        Vec3d v2 = new Vec3d();
        Vec3d v3 = new Vec3d();
        Vec3d v4 = new Vec3d();
        Vec3d normal = new Vec3d(0.0, 0.0, 1.0);
        double cx = (this.beginPointX + this.endPointX) * 0.5;
        double cy = (this.beginPointY + this.endPointY) * 0.5;
        double cx2 = (this.beginPointX2 + this.endPointX2) * 0.5;
        double cy2 = (this.beginPointY2 + this.endPointY2) * 0.5;
        switch (this.myJoinType) {
            case 0: {
                if (yDirection) {
                    v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(cx2, cy2, this.beginPointZ);
                    v4.set(cx, cy, this.beginPointZ);
                    this.replaceObservation(channel, beginIndex);
                    this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                    v1.set(cx, cy, this.beginPointZ);
                    v2.set(cx2, cy2, this.beginPointZ);
                    v3.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                    v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                    this.replaceObservation(channel, endIndex);
                    this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                    break;
                }
                v1.set(cx2, cy2, this.beginPointZ);
                v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                v3.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                v4.set(cx, cy, this.beginPointZ);
                this.replaceObservation(channel, beginIndex);
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                v1.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                v2.set(cx2, cy2, this.beginPointZ);
                v3.set(cx, cy, this.beginPointZ);
                v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                this.replaceObservation(channel, endIndex);
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                break;
            }
            case 1: {
                if (yDirection) {
                    v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(this.endPointX2, this.beginPointY2, this.beginPointZ);
                    v4.set(this.endPointX, this.beginPointY, this.beginPointZ);
                    this.replaceObservation(channel, beginIndex);
                    this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                    break;
                }
                v1.set(this.beginPointX2, this.endPointY2, this.beginPointZ);
                v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                v3.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                v4.set(this.beginPointX, this.endPointY, this.beginPointZ);
                this.replaceObservation(channel, beginIndex);
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                break;
            }
            case 2: {
                if (yDirection) {
                    v1.set(this.beginPointX, this.endPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.endPointY2, this.beginPointZ);
                    v3.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                    v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                    this.replaceObservation(channel, endIndex);
                    this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                    break;
                }
                v1.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                v2.set(this.endPointX2, this.beginPointY2, this.beginPointZ);
                v3.set(this.endPointX, this.beginPointY, this.beginPointZ);
                v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                this.replaceObservation(channel, endIndex);
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                break;
            }
            case 3: {
                if (yDirection) {
                    v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
                    v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                    v3.set(cx2, this.beginPointY2, this.beginPointZ);
                    v4.set(cx, this.beginPointY, this.beginPointZ);
                    this.replaceObservation(channel, beginIndex);
                    this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                    v1.set(cx, this.endPointY, this.beginPointZ);
                    v2.set(cx2, this.endPointY2, this.beginPointZ);
                    v3.set(this.endPointX2, this.endPointY2, this.endPointZ);
                    v4.set(this.endPointX, this.endPointY, this.endPointZ);
                    this.replaceObservation(channel, endIndex);
                    this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                    break;
                }
                v1.set(this.beginPointX2, cy2, this.beginPointZ);
                v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
                v3.set(this.beginPointX, this.beginPointY, this.endPointZ);
                v4.set(this.beginPointX, cy, this.endPointZ);
                this.replaceObservation(channel, beginIndex);
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
                v1.set(this.endPointX2, this.endPointY2, this.beginPointZ);
                v2.set(this.endPointX2, cy2, this.beginPointZ);
                v3.set(this.endPointX, cy, this.beginPointZ);
                v4.set(this.endPointX, this.endPointY, this.beginPointZ);
                this.replaceObservation(channel, endIndex);
                this.drawTrapezoid(action, 2, normal, v1, v2, v3, v4);
            }
        }
    }

    protected void drawTrapezoid(Action action, int drawMode, Vec3d normal, Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4) {
        Channel channel = (Channel)action.getGraphicsContext();
        if (channel != null) {
            if (drawMode == 3) {
                channel.setExtrusionVector(this.depth.x, this.depth.y, this.depth.z);
            }
            channel.glBegin(drawMode);
            channel.glNormal(normal.x, normal.y, normal.z);
            channel.glVertex(v1.x, v1.y, v1.z);
            channel.glVertex(v2.x, v2.y, v2.z);
            channel.glVertex(v3.x, v3.y, v3.z);
            channel.glVertex(v4.x, v4.y, v4.z);
            channel.glVertex(v1.x, v1.y, v1.z);
            channel.glEnd();
        }
    }

    public static void drawConstantYBand(Channel channel, double beginX, double endX, double beginZ, double upperY, double lowerY, boolean joinOn, Color color, double lineWidth, int stipplePat, int stippleFac, boolean fillOn, Color fillColor) {
        if (fillOn) {
            channel.glColor(fillColor);
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            channel.glVertex(beginX, upperY, beginZ);
            channel.glVertex(beginX, lowerY, beginZ);
            channel.glVertex(endX, lowerY, beginZ);
            channel.glVertex(endX, upperY, beginZ);
            channel.glEnd();
        }
        if (!joinOn) {
            return;
        }
        if (stippleFac > 0) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        channel.glLineWidth((float)lineWidth);
        channel.glColor(color);
        channel.glBegin(1);
        channel.glVertex((double)((float)beginX), (double)((float)upperY), (double)((float)beginZ));
        channel.glVertex((double)((float)endX), (double)((float)upperY), (double)((float)beginZ));
        channel.glEnd();
        channel.glBegin(1);
        channel.glVertex((double)((float)beginX), (double)((float)lowerY), (double)((float)beginZ));
        channel.glVertex((double)((float)endX), (double)((float)lowerY), (double)((float)beginZ));
        channel.glEnd();
        channel.glLineWidth(1.0f);
        if (stippleFac > 0) {
            channel.glDisable(6);
        }
    }

    public static void drawConstantXBand(Channel channel, double beginY, double endY, double beginZ, double upperX, double lowerX, boolean joinOn, Color color, double lineWidth, int stipplePat, int stippleFac, boolean fillOn, Color fillColor) {
        if (fillOn) {
            channel.glColor(fillColor);
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            channel.glVertex((double)((float)upperX), (double)((float)beginY), (double)((float)beginZ));
            channel.glVertex((double)((float)upperX), (double)((float)endY), (double)((float)beginZ));
            channel.glVertex((double)((float)lowerX), (double)((float)endY), (double)((float)beginZ));
            channel.glVertex((double)((float)lowerX), (double)((float)beginY), (double)((float)beginZ));
            channel.glEnd();
        }
        if (!joinOn) {
            return;
        }
        if (stippleFac > 0) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        channel.glLineWidth((float)lineWidth);
        channel.glColor(color);
        channel.glBegin(1);
        channel.glVertex((double)((float)upperX), (double)((float)beginY), (double)((float)beginZ));
        channel.glVertex((double)((float)upperX), (double)((float)endY), (double)((float)beginZ));
        channel.glEnd();
        channel.glBegin(1);
        channel.glVertex((double)((float)lowerX), (double)((float)beginY), (double)((float)beginZ));
        channel.glVertex((double)((float)lowerX), (double)((float)beginY), (double)((float)beginZ));
        channel.glEnd();
        channel.glLineWidth(1.0f);
        if (stippleFac > 0) {
            channel.glDisable(6);
        }
    }

    @Override
    protected void renderPolylineGroup(ABuildAction buildAction, FilledLineConnector.PolylineGroup group, boolean fillOn) {
        int polyLineCount = group.getPolylineCount();
        if (polyLineCount <= 0) {
            return;
        }
        this.stipplePattern = group.getStipplePattern();
        this.stippleFactor = group.getStippleFactor();
        this.myLineWidth = (float)group.getLineWidth();
        this.myColor = group.getLineColor();
        this.myFillColor = group.getFillColor();
        this.yDirection = this.pointX.getConnection() != null;
        this.rangeMin = Double.NaN;
        this.rangeMax = Double.NaN;
        this.reverse = false;
        if (this.bandRange != null) {
            ContinuousRangeToNumericMapper m;
            ContinuousRangeToNumericMapper continuousRangeToNumericMapper = m = this.yDirection ? (ContinuousRangeToNumericMapper)this.pointX.getConnection() : (ContinuousRangeToNumericMapper)this.pointY.getConnection();
            if (!Double.isNaN(this.bandRange[0])) {
                this.rangeMin = m.getValue(this.bandRange[0]);
            }
            if (!Double.isNaN(this.bandRange[1])) {
                this.rangeMax = m.getValue(this.bandRange[1]);
            }
            if (!Double.isNaN(this.bandRange[0]) && !Double.isNaN(this.bandRange[1]) && this.bandRange[0] > this.bandRange[1]) {
                this.reverse = true;
            }
        }
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        for (int i = 0; i < polyLineCount; ++i) {
            Vector band = group.getPolyline(i);
            if (band == null) continue;
            this.beginPointX2 = Double.NaN;
            this.beginPointY2 = Double.NaN;
            this.outOfRange = false;
            if (!fillOn && (this.myStepJoin || this.myJoinType == 0)) {
                this.drawPolylineBand(buildAction, band);
                continue;
            }
            this.drawBand(buildAction, band, fillOn);
        }
    }

    @Override
    protected void renderMultipleGroups(ABuildAction buildAction) {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        boolean subpixel = channel.isSubpixelRendering();
        if (!subpixel && this.isSubpixelRendering()) {
            channel.setSubpixelRendering(this.isSubpixelRendering());
        }
        Collection groups = this.perGroupPolylines.values();
        Iterator iter = groups.iterator();
        boolean lo = this.lineOn.getValue();
        this.drawFill = this.fillOn.getValue();
        this.drawFillPattern = this.fillPatternOn.getValue();
        channel.glPushAttrib(0);
        while (iter.hasNext()) {
            this.currentGroup = (FilledLineConnector.PolylineGroup)iter.next();
            this.renderIndices = this.currentGroup.getPolylines();
            if (this.drawFill || this.drawFillPattern) {
                if (this.subpixelRendering && !ba.isUseNameStack()) {
                    this.middle = new ArrayList();
                }
                this.currentGroup.setFillAttributes(channel);
                this.renderPolylineGroup(buildAction, this.currentGroup, true);
            }
            if (!lo) continue;
            this.currentGroup.setDrawAttributes(channel);
            this.renderPolylineGroup(buildAction, this.currentGroup, false);
            channel.glSkinType(0);
            channel.lineCapStyle(0);
            channel.setLineJoinStyle(1);
        }
        channel.glPopAttrib();
        channel.setSubpixelRendering(subpixel);
    }
}

