/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AAxis;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AxisDetail;
import com.sas.graphics.util.gtk.AxisMetrics;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.TickMarkStyle;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.ComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;

public abstract class Axis
extends AAxis {
    private static final Integer labelDetailType = new Integer(0);
    private static final Integer secondaryLabelDetailType = new Integer(5);
    private static final Integer tickDetailType = new Integer(1);
    private static final Integer titleDetailType = new Integer(2);
    private static final Integer titleMarkerDetailType = new Integer(4);
    private static final Integer lineDetailType = new Integer(3);
    private Font currentLabelFont;
    private double currentlabelHeight;
    private double currentFirstRowDepth;
    private double currentLabelAngle;
    private int currentLabelMargin = this.getLabelMargin();
    private boolean drawing = true;
    private int valueAngle;
    private boolean createFit = true;
    private boolean use3DFitting = false;
    private boolean forceHJustification = false;
    private String[] fitAlgorithm;
    private String forceFitAlgorithm;
    private boolean staggering = false;
    private int longestLabelLength;
    private AxisMetrics currentAxisMetrics;
    private Vec3d start = new Vec3d();
    private Vec3d end = new Vec3d();
    private double[] majorT = new double[2];
    private double[] minorT = new double[2];
    private double mySize;
    private double maxDepth;
    private double primarySign;
    private AAxis.LabelAlignment secondaryLabelAlignment = new AAxis.LabelAlignment(0, "", 0.0, "");
    private String lastSecondaryLabel = null;
    private double labelSpace = 0.0;
    private double labelStaggerSpace = 0.0;
    private double majorTickLength = 0.0;
    private double minorTickLength = 0.0;
    private double maxWidth;
    private int truncateStartCount = 4;
    private int truncateEndCount = 4;
    private int truncateAngleStartCount = 9;
    private int truncateAngleEndCount = 9;
    private int staggerThreshold = Integer.MAX_VALUE;
    private boolean metricsVisible = false;
    private Bbox tempBbox = new Bbox();
    private Bbox displayTitleBbox = new Bbox();
    private final Vector processedLabels = new Vector();
    protected Channel channel;
    protected int justifyLabelH;
    protected int justifyLabelV;
    private boolean ignoreFudge = false;
    private double displayTitleHeight;
    private double displayTitleWidth;
    private String displayTitle;
    private boolean getMetricsExecuting = false;
    private PostFitInfoImpl postFitInfo = new PostFitInfoImpl();
    private boolean invokePostFitProcessorDuringGetMetrics = false;
    private String lastLabelFittingAlgorithm = null;
    private boolean titleHasBeenTruncated = false;
    private boolean titleHasBeenSplit = false;
    private BoundingBox bbox = null;
    private Rectangle2D projectedIndividualBounds;
    private double lowExtender = 0.0;
    private double highExtender = 0.0;
    private double tickBoxDepth = 0.0;
    private boolean metricsTitleOnly = false;
    private boolean compressLowExtender = false;
    private boolean compressHighExtender = false;
    private AxisMetrics am = null;
    private String[] titleList = null;
    private double titleYDepth = 0.0;
    private double titleXDepth = 0.0;
    private double labelDepth;
    private char[] labelSplitChar = new char[]{' '};
    private int multilineLabelJustification = -1;
    private boolean labelSplitCharDrop = true;
    private boolean splitLabels = false;
    private int labelAlignment = -1;
    private double maximumAllocatedSize = Double.NaN;
    private double allocatedLabelSize = Double.NaN;
    private double labelSplitWidth = Double.NaN;
    private double fixedLabelSplitWidth = Double.NaN;
    private int titleTruncateEndCount = -1;
    private char[] titleSplitChar = new char[]{' '};
    private int multilineTitleJustification = -1;
    private boolean titleSplitCharDrop = true;
    private double titleSplitWidth = Double.NaN;
    private boolean addLabelMargin = false;
    private boolean brokenAxis = false;
    private ContinuousRangeToNumericMap[] segmentMaps;
    private boolean SVGRender = false;
    private double axisLineOffsetCoverage = 1.0;

    public void setAxisLineOffsetCoverage(double d) {
        this.axisLineOffsetCoverage = d;
    }

    public double getAxisLineOffsetCoverage() {
        return this.axisLineOffsetCoverage;
    }

    public void setSVGRender(boolean SVG) {
        this.SVGRender = SVG;
    }

    public boolean isSVGRender() {
        return this.SVGRender;
    }

    public void setBrokenAxis(boolean b) {
        this.brokenAxis = b;
    }

    public boolean isBrokenAxis() {
        return this.brokenAxis;
    }

    public void setSegmentMaps(ContinuousRangeToNumericMap[] maps) {
        this.segmentMaps = maps;
    }

    public ContinuousRangeToNumericMap[] getSegmentMaps() {
        return this.segmentMaps;
    }

    public void setTitleTruncateEndCount(int count) {
        this.titleTruncateEndCount = count;
    }

    public int getTitleTruncateEndCount() {
        return this.titleTruncateEndCount;
    }

    public void setTitleSplitChar(char[] c) {
        this.titleSplitChar = c;
    }

    public char[] getTitleSplitChar() {
        return this.titleSplitChar;
    }

    public void setMultilineTitleJustification(int just) {
        this.multilineTitleJustification = just;
    }

    public int getMultilineTitleJustification() {
        return this.multilineTitleJustification;
    }

    public void setTitleSplitCharDrop(boolean b) {
        this.titleSplitCharDrop = b;
    }

    public boolean isTitleSplitCharDrop() {
        return this.titleSplitCharDrop;
    }

    public void setTitleSplitWidth(double w) {
        this.titleSplitWidth = w;
    }

    public double getTitleSplitWidth() {
        return this.titleSplitWidth;
    }

    public void setLabelSplitChar(char[] c) {
        this.labelSplitChar = c;
    }

    public char[] getLabelSplitChar() {
        return this.labelSplitChar;
    }

    public void setMultilineLabelJustification(int just) {
        this.multilineLabelJustification = just;
    }

    public int getMultilineLabelJustification() {
        return this.multilineLabelJustification;
    }

    public void setLabelSplitCharDrop(boolean b) {
        this.labelSplitCharDrop = b;
    }

    public boolean isLabelSplitCharDrop() {
        return this.labelSplitCharDrop;
    }

    public void setLabelAlignment(int align) {
        this.labelAlignment = align;
    }

    public int getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setFixedLabelSplitWidth(double w) {
        this.fixedLabelSplitWidth = w;
    }

    public double getFixedLabelSplitWidth() {
        return this.fixedLabelSplitWidth;
    }

    public void setMaximumAllocatedSize(double size) {
        this.maximumAllocatedSize = size;
    }

    public double getMaximumAllocatedSize() {
        return this.maximumAllocatedSize;
    }

    @Override
    protected abstract void setJustificationStyles();

    protected abstract void move2Origin();

    protected abstract double getDistance(int var1);

    public Axis() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) {
        this.drawing = true;
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        this.channel = ba.getChannel();
        if (this.createFit) {
            this.createFitAlgorithm();
        }
        this.constructAxis(ba.getValueIndex(), null);
        if (this.isMetricsVisible()) {
            AxisMetrics.drawMetrics(this.channel, this.getMetrics(this.channel), this);
        }
    }

    private void unionProjection(BoundingBox bb) {
        Rectangle2D r = NetworkRoot.projectBoundingBox(bb, this.channel);
        if (this.projectedIndividualBounds == null) {
            this.projectedIndividualBounds = new Rectangle2D.Double();
            this.projectedIndividualBounds.setFrame(r);
        } else {
            Rectangle2D.union(r, this.projectedIndividualBounds, this.projectedIndividualBounds);
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        ComputeBoundingBoxAction bba = ComputeBoundingBoxAction.castComputeBoundingBoxAction(bBoxAction);
        this.projectedIndividualBounds = null;
        this.bbox = new BoundingBox();
        this.getMetrics(bba.getChannel(), bba.getValueIndex());
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(this.bbox.getCenter(), this.bbox.getSize());
        this.bbox = null;
        bBoxAction.unionRectangle(this.projectedIndividualBounds);
    }

    public AxisMetrics getPreferredMetrics(Channel aChannel) {
        int labelCount = 0;
        AxisMetrics result = new AxisMetrics();
        this.channel = aChannel;
        this.setupChannelWithStyle(this.style.getLabelStyle());
        double labelHeight = aChannel.glGetTextHeight();
        double verticalLabelSpace = this.style.getVerticalLabelSpace() * labelHeight;
        double horizontalLabelSpace = this.style.getHorizontalLabelSpace() * labelHeight;
        double height = aChannel.glGetTextHeight();
        int tickJust = this.style.getMajorTickStyle().getTickMarkJustification();
        double tickLength = this.style.getMajorTickStyle().getLength() * labelHeight;
        int labelHJust = this.style.getLabelStyle().getHorizontalJustification();
        int labelVJust = this.style.getLabelStyle().getVerticalJustification();
        double titleSpace = 0.0;
        double tw = 0.0;
        double th = 0.0;
        double axisHeight = 0.0;
        double outsideLength = 0.0;
        double maxLength = 0.0;
        double insideLength = 0.0;
        double axisWidth = 0.0;
        double axisLineLength = 0.0;
        double lowExtender = 0.0;
        double highExtender = 0.0;
        double firstLabelLength = 0.0;
        double lastLabelLength = 0.0;
        double lineOffset = this.getLineOffset();
        if (this.style.isAxisLineOn()) {
            maxLength = this.getLength();
        }
        if (this.style.isLabelsOn()) {
            this.init(new InitAction(aChannel));
            this.sortLabelsByOffset();
            labelCount = this.originalProcessedLabels.size();
            for (int i = 0; i < labelCount; ++i) {
                String l = ((AAxis.LabelAlignment)this.originalProcessedLabels.get((int)i)).rawLabel;
                if (i == 0) {
                    firstLabelLength = aChannel.glGetTextWidth(l);
                }
                if (i == this.originalProcessedLabels.size() - 1) {
                    lastLabelLength = aChannel.glGetTextWidth(l);
                }
                maxLength = Math.max(aChannel.glGetTextWidth(l), maxLength);
            }
        }
        if (this.isTitleOn()) {
            TextStyle tStyle = this.style.getTitleStyle();
            Bbox tBox = new Bbox();
            this.setupChannelWithStyle(tStyle);
            aChannel.glGetText2DBbox(this.displayTitle, 0.0, 0.0, 0.0, (int)tStyle.getAngle(), tBox);
            titleSpace = this.style.getTitleSpace() * labelHeight;
            tw = tBox.xmax - tBox.xmin;
            th = tBox.ymax - tBox.ymin;
            this.setupChannelWithStyle(this.style.getLabelStyle());
        }
        if (this.style.isMajorTickMarksOn()) {
            if (tickJust == 1) {
                outsideLength = tickLength;
            } else if (tickJust == 2) {
                insideLength = outsideLength = tickLength / 2.0;
            } else if (tickJust == 0) {
                insideLength = tickLength;
            }
        }
        if (this.orientation == 2) {
            double labelsHeight = height * (double)labelCount;
            if (labelVJust == 1) {
                lowExtender = Math.max(height / 2.0 + lineOffset, 0.0);
                highExtender = Math.max(height / 2.0 - lineOffset, 0.0);
            } else if (labelVJust == 0) {
                lowExtender = Math.max(height + lineOffset, 0.0);
                highExtender = Math.max(-lineOffset, 0.0);
            } else if (labelVJust == 3) {
                lowExtender = Math.max(lineOffset, 0.0);
                highExtender = Math.max(height - lineOffset, 0.0);
            }
            axisLineLength = labelsHeight - lowExtender - highExtender;
            outsideLength += maxLength + horizontalLabelSpace;
            axisHeight = lowExtender + axisLineLength + highExtender;
            if (this.isTitleOn()) {
                outsideLength += tw + titleSpace;
                axisHeight = Math.max(axisHeight, th);
            }
            axisWidth = insideLength + outsideLength;
        } else {
            double labelsWidth = (maxLength + (double)this.currentLabelMargin) * (double)labelCount - (double)this.currentLabelMargin;
            if (labelHJust == 1) {
                lowExtender = Math.max(firstLabelLength / 2.0 + lineOffset, 0.0);
                highExtender = Math.max(lastLabelLength / 2.0 - lineOffset, 0.0);
            } else if (labelHJust == 0) {
                lowExtender = Math.max(lineOffset, 0.0);
                highExtender = Math.max(lastLabelLength - lineOffset, 0.0);
            } else if (labelHJust == 2) {
                lowExtender = Math.max(firstLabelLength + lineOffset, 0.0);
                highExtender = Math.max(-lineOffset, 0.0);
            }
            axisLineLength = labelsWidth - lowExtender - highExtender;
            outsideLength += height + verticalLabelSpace;
            axisWidth = lowExtender + axisLineLength + highExtender;
            if (this.isTitleOn()) {
                outsideLength += th + titleSpace;
                axisWidth = Math.max(axisWidth, tw);
            }
            axisHeight = insideLength + outsideLength;
        }
        result.setInsideLength(insideLength);
        result.setOutsideLength(outsideLength);
        result.setLowExtender(lowExtender);
        result.setLineLength(axisLineLength);
        result.setHighExtender(highExtender);
        result.setHeight(axisHeight);
        result.setWidth(axisWidth);
        return result;
    }

    private boolean isTitleOn() {
        String t;
        boolean result = false;
        if (this.style.isTitleOn() && (t = this.displayTitle) != null && t.length() > 0) {
            result = true;
        }
        return result;
    }

    private double computeMaxLableDepth() {
        double result = -1.0;
        Vec3d maxSize = this.getMaximumSize();
        if (maxSize != null && this.getOrientation() != 2 && this.getOrientation() == 1) {
            result = maxSize.y;
            if (this.isTitleOn()) {
                this.setupChannelWithStyle(this.style.getTitleStyle());
                result -= this.channel.glGetTextHeight(this.displayTitle);
                result -= this.style.getTitleSpace() * this.currentlabelHeight;
            }
            if (this.style.isMajorTickMarksOn()) {
                double tickLength = this.currentlabelHeight * this.style.getMajorTickStyle().getLength();
                switch (this.style.getMajorTickStyle().getTickMarkJustification()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        result -= tickLength;
                        break;
                    }
                    case 2: {
                        result -= tickLength / 2.0;
                    }
                }
            }
            result -= this.computeLabelSpace();
        }
        return result;
    }

    private double computeLabelSpace() {
        double space = this.currentLabelAngle == 90.0 || this.currentLabelAngle == 270.0 || this.getOrientation() == 2 ? this.style.getHorizontalLabelSpace() : this.style.getVerticalLabelSpace();
        if (this.style.getLengthUnits() == 3) {
            space *= this.currentlabelHeight;
        }
        return space;
    }

    public AxisMetrics getMetricsTitleOnly(Channel ch) {
        this.metricsTitleOnly = true;
        NumericVector nv = new NumericVector(0);
        StringVector sv = new StringVector(0);
        Pipe loSave = this.labelOffset.getConnection();
        StringPipe lSave = this.labels.getConnection();
        boolean secondaryLabelsConnected = this.secondaryLabels.isConnected();
        StringPipe slSave = null;
        this.labelOffset.connectFrom(nv);
        this.labels.connectFrom(sv);
        if (secondaryLabelsConnected) {
            slSave = this.secondaryLabels.getConnection();
            this.secondaryLabels.connectFrom(sv);
        }
        AxisMetrics m = this.getMetrics(ch, 0);
        if (loSave instanceof IntegerPipe) {
            this.labelOffset.connectFrom((IntegerPipe)loSave);
        } else {
            this.labelOffset.connectFrom((NumericPipe)loSave);
        }
        this.labels.connectFrom(lSave);
        if (secondaryLabelsConnected) {
            this.secondaryLabels.connectFrom(slSave);
        }
        this.metricsTitleOnly = false;
        return m;
    }

    public AxisMetrics getMetrics(Channel ch) {
        AxisMetrics m = this.getMetrics(ch, 0);
        return m;
    }

    private AxisMetrics getMetrics(Channel ch, int obs) {
        this.getMetricsExecuting = true;
        this.init(new AInitAction());
        AxisMetrics result = new AxisMetrics();
        this.channel = ch;
        this.drawing = false;
        this.constructAxis(obs, result);
        this.getMetricsExecuting = false;
        return result;
    }

    protected void move2Origin(BoundingBox bb) {
        if (bb != null) {
            this.channel.glPushMatrix();
            this.channel.glLoadIdentity();
            this.move2Origin();
            double[] matrix = new double[16];
            this.channel.glGetMatrix(matrix);
            bb.transform(matrix);
            this.channel.glPopMatrix();
        }
    }

    private boolean isRendering() {
        return this.getCurrentAxisMetrics() == null;
    }

    private AxisMetrics getCurrentAxisMetrics() {
        return this.currentAxisMetrics;
    }

    private void setCurrentAxisMetrics(AxisMetrics axisMetrics) {
        this.currentAxisMetrics = axisMetrics;
    }

    private void constructAxis(int obs, AxisMetrics am) {
        this.lastSecondaryLabel = null;
        this.labelSpace = 0.0;
        this.labelStaggerSpace = 0.0;
        this.majorTickLength = 0.0;
        this.minorTickLength = 0.0;
        this.maxWidth = Double.MIN_VALUE;
        this.maxDepth = 0.0;
        this.valueAngle = 0;
        this.primarySign = this.primary ? 1.0 : -1.0;
        this.setCurrentAxisMetrics(am);
        this.processTitles();
        this.sortLabelsByOffset();
        this.processLabels();
        this.invokePostFitProcessor();
        if (this.isRendering()) {
            this.channel.glPushName((Object)new Integer(-1));
        }
        this.mySize = this.getDistance(obs);
        this.channel.glPushMatrix();
        this.move2Origin();
        if (this.drawing && this.style.getBackground() != null) {
            this.drawBackground();
        }
        this.drawAxisLine();
        if (this.style.isMajorTickMarksOn() || this.style.isLabelsOn() || this.style.isMinorTickMarksOn() || this.isTickBoxOn()) {
            AAxis.LabelAlignment la;
            int i;
            this.majorTickLength = this.getTickLength(this.style.getMajorTickStyle());
            this.minorTickLength = this.getTickLength(this.style.getMinorTickStyle());
            this.labelStaggerSpace = this.style.getLabelStaggerSpace() * this.currentlabelHeight;
            this.majorT[0] = 0.0;
            this.majorT[1] = 0.0;
            if (this.style.isMajorTickMarksOn()) {
                this.positionTicMark(this.style.getMajorTickStyle(), this.majorTickLength, this.majorT);
            }
            if (this.style.isMinorTickMarksOn()) {
                this.positionTicMark(this.style.getMinorTickStyle(), this.minorTickLength, this.minorT);
            }
            this.labelSpace = this.computeLabelSpace();
            this.drawTickBoxes();
            this.drawExplicitMajorTickMarks();
            this.drawExplicitMinorTickMarks();
            this.setupChannelWithStyle(this.style.getLabelStyle());
            for (i = 0; i < this.processedLabels.size(); ++i) {
                la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                this.drawMajorTick(la);
                this.drawLabel(la);
                this.drawMinorTickMarks(la, i);
            }
            if (this.style.isSecondaryLabelsOn() && this.getSecondaryLabelCount() > 0) {
                this.setupChannelWithStyle(this.style.getSecondaryLabelStyle());
                this.secondaryLabelAlignment.height = this.channel.glGetTextHeight();
                for (i = 0; i < this.processedLabels.size(); ++i) {
                    la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                    this.drawSecondaryLabel(la);
                }
            }
        }
        if (!this.metricsTitleOnly) {
            this.labelDepth = this.maxDepth;
            this.maxDepth += this.extraSpaceForTickBox();
            this.tickBoxDepth = this.maxDepth;
        }
        this.drawTitle();
        this.computeAxisMetrics();
        this.channel.glPopMatrix();
        if (this.isRendering()) {
            this.channel.glPopName();
        }
    }

    private double getTickLength(TickMarkStyle tms) {
        double result;
        double l = tms.getLength();
        switch (this.style.getLengthUnits()) {
            default: {
                result = l * this.currentlabelHeight;
                break;
            }
            case 4: {
                result = l;
            }
        }
        return result;
    }

    private void computeAxisMetrics() {
        AxisMetrics am = this.getCurrentAxisMetrics();
        int labelCount = this.processedLabels.size();
        if (am != null) {
            double highExt = 0.0;
            double lowExt = 0.0;
            double titleWidth = 0.0;
            double titleHeight = 0.0;
            int labelHJust = this.style.getLabelStyle().getHorizontalJustification();
            int labelVJust = this.style.getLabelStyle().getVerticalJustification();
            double lineOffset = this.getLineOffset();
            am.setLineLength(this.mySize);
            am.setFittingAlgorithm(this.lastLabelFittingAlgorithm);
            am.setLabelsThinned(this.findLabelsHaveBeenThinned());
            am.setVisibleLabelIndices(this.findVisibleLabelIndices());
            am.setTitleTruncated(this.titleHasBeenTruncated);
            am.setTitleSplit(this.titleHasBeenSplit);
            am.setDisplayTitle(this.displayTitle);
            am.setLabelFont(this.currentLabelFont);
            if (this.style.isMajorTickMarksOn()) {
                TickMarkStyle majorTickStyle = this.style.getMajorTickStyle();
                int tickJust = majorTickStyle.getTickMarkJustification();
                if (tickJust == 0) {
                    am.setInsideLength(this.majorTickLength);
                    am.setOutsideLength(0.0);
                } else if (tickJust == 1) {
                    am.setInsideLength(0.0);
                    am.setOutsideLength(this.majorTickLength);
                } else if (tickJust == 2) {
                    am.setInsideLength(this.majorTickLength / 2.0);
                    am.setOutsideLength(this.majorTickLength / 2.0);
                }
            } else {
                am.setOutsideLength(this.extraWhiteSpaceWhenNoMajorTicks());
            }
            if (this.orientation == 2) {
                double bottomMostTickOrLine = 0.0;
                double topMostTickOrLine = 0.0;
                double topOfLabel = 0.0;
                double bottomOfLabel = 0.0;
                double topOfSecondaryLabel = 0.0;
                double bottomOfSecondaryLabel = 0.0;
                if (labelCount > 0) {
                    bottomMostTickOrLine = ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)0)).offset;
                    topMostTickOrLine = ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)(this.processedLabels.size() - 1))).offset;
                }
                lineOffset = this.getLineOffset();
                bottomMostTickOrLine = Math.min(bottomMostTickOrLine, lineOffset);
                topMostTickOrLine = Math.max(topMostTickOrLine, this.getLength() + lineOffset);
                for (int i = 0; i < this.processedLabels.size(); ++i) {
                    AAxis.LabelAlignment currentLa = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                    if (currentLa.drop || !this.style.isLabelsOn()) continue;
                    topOfLabel = currentLa.offset;
                    bottomOfLabel = currentLa.offset;
                    if (this.style.isSecondaryLabelsOn() && !currentLa.secondaryLabelDrop) {
                        topOfSecondaryLabel = currentLa.offset;
                        bottomOfSecondaryLabel = currentLa.offset;
                    }
                    switch (labelVJust) {
                        case 1: {
                            topOfLabel += currentLa.height / 2.0;
                            bottomOfLabel -= currentLa.height / 2.0;
                            if (!this.style.isSecondaryLabelsOn() || currentLa.secondaryLabelDrop) break;
                            topOfLabel = Math.min(topOfLabel, topOfSecondaryLabel -= currentLa.secondaryLabelWidth / 2.0);
                            bottomOfLabel = Math.max(bottomOfLabel, bottomOfSecondaryLabel += currentLa.secondaryLabelWidth / 2.0);
                            break;
                        }
                        case 3: {
                            topOfLabel += currentLa.height;
                            if (!this.style.isSecondaryLabelsOn() || currentLa.secondaryLabelDrop) break;
                            topOfLabel = Math.min(topOfLabel, topOfSecondaryLabel -= currentLa.secondaryLabelWidth / 2.0);
                            break;
                        }
                        case 0: {
                            bottomOfLabel -= currentLa.height;
                            if (!this.style.isSecondaryLabelsOn() || currentLa.secondaryLabelDrop) break;
                            bottomOfLabel = Math.max(bottomOfLabel, bottomOfSecondaryLabel += currentLa.secondaryLabelWidth / 2.0);
                            break;
                        }
                    }
                    if (this.compressLowExtender) {
                        bottomOfLabel = Math.max(0.0, bottomOfLabel);
                    }
                    if (this.compressHighExtender) {
                        topOfLabel = Math.min(this.getLength() + lineOffset, topOfLabel);
                    }
                    if (bottomMostTickOrLine > bottomOfLabel) {
                        lowExt = Math.max(bottomMostTickOrLine - bottomOfLabel, lowExt);
                    }
                    if (!(topMostTickOrLine < topOfLabel)) continue;
                    highExt = Math.max(topOfLabel - topMostTickOrLine, highExt);
                }
                am.setLowExtender(lowExt);
                am.setHighExtender(highExt);
                am.setOutsideLength(am.getOutsideLength() + this.labelSpace + this.maxWidth * (double)(this.staggering ? 2 : 1) + this.extraSpaceForTickBox());
                if (this.isTitleOn()) {
                    if (this.isPrimary()) {
                        am.setOutsideLength(Math.max(am.getOutsideLength(), Math.abs(this.displayTitleBbox.xmin)));
                    } else {
                        am.setOutsideLength(Math.max(am.getOutsideLength(), Math.abs(this.displayTitleBbox.xmax)));
                    }
                }
                am.setHeight(Math.max(titleHeight, am.getHighExtender() + am.getLowExtender() + topMostTickOrLine - bottomMostTickOrLine));
                am.setWidth(am.getOutsideLength() + am.getInsideLength() + this.getHalfLineWidth());
            } else {
                double leftOfLabel = 0.0;
                double rightOfLabel = 0.0;
                double leftOfSecondaryLabel = 0.0;
                double rightOfSecondaryLabel = 0.0;
                double rightMostTickOrLine = 0.0;
                double leftMostTickOrLine = 0.0;
                int n = labelHJust = this.forceHJustification ? this.justifyLabelH : this.style.getLabelStyle().getHorizontalJustification();
                if (labelCount > 0) {
                    leftMostTickOrLine = ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)0)).offset;
                    rightMostTickOrLine = ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)(this.processedLabels.size() - 1))).offset;
                }
                lineOffset = this.getLineOffset();
                leftMostTickOrLine = Math.min(leftMostTickOrLine, lineOffset);
                rightMostTickOrLine = Math.max(rightMostTickOrLine, this.getLength() + lineOffset);
                double labelHeight = 0.0;
                for (int i = 0; i < this.processedLabels.size(); ++i) {
                    AAxis.LabelAlignment currentLa = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                    if (currentLa.drop || !this.style.isLabelsOn()) continue;
                    leftOfLabel = currentLa.offset + currentLa.angleOffset;
                    rightOfLabel = currentLa.offset + currentLa.angleOffset;
                    if (this.style.isSecondaryLabelsOn() && !currentLa.secondaryLabelDrop) {
                        leftOfSecondaryLabel = currentLa.offset;
                        rightOfSecondaryLabel = currentLa.offset;
                    }
                    switch (labelHJust) {
                        case 1: {
                            leftOfLabel -= currentLa.width / 2.0;
                            rightOfLabel += currentLa.width / 2.0;
                            if (!this.style.isSecondaryLabelsOn() || currentLa.secondaryLabelDrop) break;
                            leftOfLabel = Math.min(leftOfLabel, leftOfSecondaryLabel -= currentLa.secondaryLabelWidth / 2.0);
                            rightOfLabel = Math.max(rightOfLabel, rightOfSecondaryLabel += currentLa.secondaryLabelWidth / 2.0);
                            break;
                        }
                        case 0: {
                            rightOfLabel += currentLa.width;
                            if (!this.style.isSecondaryLabelsOn() || currentLa.secondaryLabelDrop) break;
                            rightOfLabel = Math.max(rightOfLabel, rightOfSecondaryLabel += currentLa.secondaryLabelWidth);
                            break;
                        }
                        case 2: {
                            if (currentLa.angleOffset == 0.0) {
                                leftOfLabel -= currentLa.width;
                            } else {
                                rightOfLabel += currentLa.width;
                            }
                            if (!this.style.isSecondaryLabelsOn() || currentLa.secondaryLabelDrop) break;
                            if (currentLa.angleOffset == 0.0) {
                                leftOfSecondaryLabel -= currentLa.secondaryLabelWidth;
                            } else {
                                rightOfSecondaryLabel += currentLa.secondaryLabelWidth;
                            }
                            leftOfLabel = Math.min(leftOfLabel, leftOfSecondaryLabel);
                        }
                    }
                    if (this.compressLowExtender) {
                        leftOfLabel = Math.max(1.0, leftOfLabel);
                    }
                    if (this.compressHighExtender) {
                        rightOfLabel = Math.min(this.getLength() + lineOffset - 1.0, rightOfLabel);
                    }
                    if (leftMostTickOrLine > leftOfLabel) {
                        lowExt = Math.max(leftMostTickOrLine - leftOfLabel, lowExt);
                    }
                    if (rightMostTickOrLine < rightOfLabel) {
                        highExt = Math.max(rightOfLabel - rightMostTickOrLine, highExt);
                    }
                    labelHeight = Math.max(labelHeight, currentLa.height);
                }
                if (this.style.isSecondaryLabelsOn() && this.getSecondaryLabelCount() > 0 && labelHeight > 0.0) {
                    labelHeight += this.secondaryLabelAlignment.height;
                }
                double fudge = 2.0;
                if (this.style.getLabelStyle().isShadowOn()) {
                    fudge += (double)this.style.getLabelStyle().getShadowOffsetY();
                }
                if (this.ignoreFudge) {
                    fudge = 0.0;
                }
                am.setLowExtender(lowExt + fudge);
                am.setHighExtender(highExt);
                am.setOutsideLength(am.getOutsideLength() + labelHeight + fudge + this.labelSpace + (this.staggering ? labelHeight + this.labelStaggerSpace : 0.0) + this.extraSpaceForTickBox());
                if (this.isTitleOn()) {
                    if (this.isPrimary()) {
                        am.setOutsideLength(Math.max(am.getOutsideLength(), Math.abs(this.displayTitleBbox.ymin)));
                    } else {
                        am.setOutsideLength(Math.max(am.getOutsideLength(), Math.abs(this.displayTitleBbox.ymax)));
                    }
                }
                am.setHeight(am.getOutsideLength() + am.getInsideLength() + this.getHalfLineWidth());
                am.setWidth(Math.max(titleWidth, am.getHighExtender() + am.getLowExtender() + rightMostTickOrLine - leftMostTickOrLine));
            }
            this.lowExtender = am.getLowExtender();
            this.highExtender = am.getHighExtender();
            this.am = am;
        }
    }

    private void drawMajorTick(AAxis.LabelAlignment la) {
        if (this.style.isMajorTickMarksOn() && (this.style.isShowThinnedTicks() || !la.drop) && this.getMajorTickOffsetCount() <= 0) {
            if (this.isRendering()) {
                this.channel.glLoadName((Object)new Integer(la.observation));
                this.channel.glPushName((Object)tickDetailType);
            }
            this.orient(this.start, la.offset, this.majorT[0], 0.0);
            this.orient(this.end, la.offset, this.majorT[1], 0.0);
            this.drawMajorTickMark(this.start.x, this.start.y, this.start.z, this.end.x, this.end.y, this.end.z, this.style.getMajorTickStyle().getColor(), this.style.getMajorTickStyle().getLineWidth());
            this.maxDepth = Math.max(this.maxDepth, Math.abs(this.majorT[1]));
            if (this.isRendering()) {
                this.channel.glPopName();
            }
        }
    }

    private double extraWhiteSpaceWhenNoMajorTicks() {
        double result = 0.0;
        if (!this.style.isMajorTickMarksOn()) {
            result = 0.15 * this.currentlabelHeight;
        }
        return result;
    }

    private void drawLabel(AAxis.LabelAlignment la) {
        if (this.style.isLabelsOn() && !la.drop) {
            double labelTop;
            if (!la.adjacentToAxis) {
                double whiteSpace = this.labelSpace + this.currentFirstRowDepth + this.labelStaggerSpace + this.extraWhiteSpaceWhenNoMajorTicks();
                labelTop = this.majorT[1] - whiteSpace * this.primarySign;
            } else {
                double whiteSpace = this.labelSpace + this.extraWhiteSpaceWhenNoMajorTicks();
                labelTop = this.majorT[1] - whiteSpace * this.primarySign;
            }
            if (this.isRendering()) {
                this.channel.glLoadName((Object)new Integer(la.observation));
                this.channel.glPushName((Object)labelDetailType);
            }
            int savedLabelHJust = this.justifyLabelH;
            double alignmentAdj = 0.0;
            if (this.getLabelAlignment() != -1) {
                if (this.orientation == 1) {
                    if (this.isPrimary() && this.getLabelAlignment() == 3 || !this.isPrimary() && this.getLabelAlignment() == 0) {
                        alignmentAdj = Math.abs(-this.primarySign * this.labelDepth - labelTop) - la.height;
                    } else if (this.getLabelAlignment() == 1) {
                        alignmentAdj = (Math.abs(-this.primarySign * this.labelDepth - labelTop) - la.height) * 0.5;
                    }
                } else if (this.orientation == 2) {
                    if (this.isPrimary() && this.getLabelAlignment() == 0 || !this.isPrimary() && this.getLabelAlignment() == 2) {
                        alignmentAdj = Math.abs(-this.primarySign * this.labelDepth - labelTop) - la.width;
                    } else if (this.getLabelAlignment() == 1) {
                        alignmentAdj = (Math.abs(-this.primarySign * this.labelDepth - labelTop) - la.width) * 0.5;
                    }
                }
                alignmentAdj *= this.primarySign;
            }
            if (this.compressLowExtender || this.compressHighExtender) {
                double adj1 = 0.0;
                double adj2 = 0.0;
                if (this.orientation == 2) {
                    switch (this.style.getLabelStyle().getVerticalJustification()) {
                        case 1: {
                            adj1 = la.height * 0.5;
                            adj2 = la.height * 0.5;
                            break;
                        }
                        case 3: {
                            adj1 = 0.0;
                            adj2 = la.height;
                            break;
                        }
                        case 0: {
                            adj1 = la.height;
                            adj2 = 0.0;
                            break;
                        }
                    }
                } else {
                    int labelHJust = this.forceHJustification ? this.justifyLabelH : this.style.getLabelStyle().getHorizontalJustification();
                    switch (labelHJust) {
                        case 1: {
                            adj1 = la.width * 0.5;
                            adj2 = la.width * 0.5;
                            break;
                        }
                        case 0: {
                            adj1 = 0.0;
                            adj2 = la.width;
                            if (this.valueAngle != 315 && this.valueAngle != 45) break;
                            adj1 += this.currentlabelHeight / 1.414;
                            adj2 -= this.currentlabelHeight / 1.414;
                            break;
                        }
                        case 2: {
                            adj1 = la.width;
                            adj2 = 0.0;
                            break;
                        }
                    }
                    adj1 += 1.0;
                    adj2 += 1.0;
                }
                if (this.compressLowExtender && this.compressHighExtender) {
                    this.orient(this.start, Math.min(Math.max(this.getLineOffset() + adj1, la.offset), this.getLength() + this.getLineOffset() - adj2), labelTop - alignmentAdj, 0.0);
                } else if (this.compressLowExtender) {
                    this.orient(this.start, Math.max(this.getLineOffset() + adj1, la.offset), labelTop - alignmentAdj, 0.0);
                } else if (this.compressHighExtender) {
                    this.orient(this.start, Math.min(la.offset, this.getLength() + this.getLineOffset() - adj2), labelTop - alignmentAdj, 0.0);
                }
            } else if (this.splitLabels && this.multilineLabelJustification != -1) {
                this.justifyLabelH = this.multilineLabelJustification;
                if (this.orientation == 1) {
                    if (this.multilineLabelJustification == 0) {
                        this.orient(this.start, la.offset - la.width * 0.5, labelTop - alignmentAdj, 0.0);
                    } else if (this.multilineLabelJustification == 2) {
                        this.orient(this.start, la.offset + la.width * 0.5, labelTop - alignmentAdj, 0.0);
                    } else if (this.multilineLabelJustification == 1) {
                        this.orient(this.start, la.offset, labelTop - alignmentAdj, 0.0);
                    }
                } else if (this.orientation == 2) {
                    if (this.isPrimary() && this.multilineLabelJustification == 0 || !this.isPrimary() && this.multilineLabelJustification == 2) {
                        this.orient(this.start, la.offset, labelTop - alignmentAdj - this.primarySign * la.width, 0.0);
                    } else if (this.isPrimary() && this.multilineLabelJustification == 2 || !this.isPrimary() && this.multilineLabelJustification == 0) {
                        this.orient(this.start, la.offset, labelTop - alignmentAdj, 0.0);
                    } else if (this.multilineLabelJustification == 1) {
                        this.orient(this.start, la.offset, labelTop - alignmentAdj - this.primarySign * la.width * 0.5, 0.0);
                    }
                }
            } else {
                this.orient(this.start, la.offset, labelTop - alignmentAdj, 0.0);
            }
            this.drawLabel(la, this.start, this.style.getLabelStyle(), this.valueAngle, true, this.isUseLabelFromStyle());
            if (this.isRendering()) {
                this.channel.glPopName();
            }
            labelTop = Math.abs(labelTop);
            this.maxDepth = Math.max(this.maxDepth, labelTop += this.labelOrientation == 2 ? la.height : la.width);
            double fudge = 1.0;
            if (this.ignoreFudge) {
                fudge = 0.0;
            }
            this.maxWidth = Math.max(this.maxWidth, this.channel.glGetTextWidth(la.theLabel) + fudge);
            if (this.splitLabels && this.multilineLabelJustification != -1) {
                this.justifyLabelH = savedLabelHJust;
            }
        }
    }

    private void drawSecondaryLabel(AAxis.LabelAlignment la) {
        if (this.style.isSecondaryLabelsOn() && !la.drop) {
            la.secondaryLabelDrop = la.secondaryLabel.equals(this.lastSecondaryLabel);
            if (!la.secondaryLabelDrop) {
                this.lastSecondaryLabel = la.secondaryLabel;
                double whiteSpace = this.labelSpace + this.currentFirstRowDepth + this.labelStaggerSpace;
                double labelTop = this.majorT[1] - whiteSpace * this.primarySign;
                if (this.isRendering()) {
                    this.channel.glLoadName((Object)new Integer(la.observation));
                    this.channel.glPushName((Object)secondaryLabelDetailType);
                }
                this.orient(this.start, la.offset, labelTop, 0.0);
                this.secondaryLabelAlignment.set(la);
                this.secondaryLabelAlignment.theLabel = la.secondaryLabel;
                this.secondaryLabelAlignment.width = la.secondaryLabelWidth;
                this.secondaryLabelAlignment.height = la.secondaryLabelHeight;
                this.drawLabel(this.secondaryLabelAlignment, this.start, this.style.getSecondaryLabelStyle(), this.valueAngle, false, true);
                if (this.isRendering()) {
                    this.channel.glPopName();
                }
                labelTop = Math.abs(labelTop);
                this.maxDepth = Math.max(this.maxDepth, labelTop += this.labelOrientation == 2 ? la.secondaryLabelHeight : la.secondaryLabelWidth);
            }
        }
    }

    private boolean isTickBoxOn() {
        return this.style.isTickBoxOn() || this.style.getTickBoxBackground() != null;
    }

    private void drawTickBoxes() {
        boolean stippleNeeded;
        if (!this.drawing || !this.isTickBoxOn()) {
            return;
        }
        int stippleFac = this.style.getTickBoxStyle().getStippleFactor();
        int stipplePat = this.style.getTickBoxStyle().getStipplePattern();
        boolean bl = stippleNeeded = stippleFac > 0 && (stipplePat & 0xFFFF) != 65535;
        if (stippleNeeded) {
            this.channel.glEnable(6);
            this.channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        this.channel.glLineWidth((float)this.style.getTickBoxStyle().getWidth());
        int polygonMode = this.channel.getPolygonMode();
        Color bkColor = this.style.getTickBoxBackground();
        if (bkColor != null && this.style.isTickBoxOn()) {
            this.channel.glPolygonMode(4);
            this.channel.glColor(bkColor);
            this.channel.glEdgeColor(this.style.getTickBoxStyle().getColor());
        } else if (bkColor != null) {
            this.channel.glPolygonMode(3);
            this.channel.glColor(bkColor);
        } else {
            this.channel.glPolygonMode(2);
            this.channel.glColor(this.style.getTickBoxStyle().getColor());
        }
        double primarySign = this.primary ? 1.0 : -1.0;
        Vec3d v1start = new Vec3d();
        Vec3d v1end = new Vec3d();
        Vec3d v2start = new Vec3d();
        Vec3d v2end = new Vec3d();
        double firstLabelOffset = Double.MIN_VALUE;
        double lastLabelOffset = Double.MAX_VALUE;
        if (this.processedLabels.size() > 0) {
            firstLabelOffset = ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)0)).offset;
            lastLabelOffset = ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)(this.processedLabels.size() - 1))).offset;
        }
        if (this.getMajorTickOffsetCount() > 0) {
            double offset2;
            int n = this.getMajorTickOffsetCount();
            double offset1 = this.getLineOffset();
            this.orient(v1start, offset1, 0.0, 0.0);
            this.orient(v1end, offset1, -this.tickBoxDepth * primarySign, 0.0);
            for (int i = 0; i < n; ++i) {
                try {
                    offset2 = this.majorTickOffset.getValue(i);
                    if (offset2 < firstLabelOffset || offset2 > lastLabelOffset) continue;
                    this.orient(v2start, offset2, 0.0, 0.0);
                    this.orient(v2end, offset2, -this.tickBoxDepth * primarySign, 0.0);
                    this.drawOneTickBox(v1start, v1end, v2start, v2end);
                    v1start.set(v2start);
                    v1end.set(v2end);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            offset2 = this.getLineOffset() + this.mySize;
            this.orient(v2start, offset2, 0.0, 0.0);
            this.orient(v2end, offset2, -this.tickBoxDepth * primarySign, 0.0);
            this.drawOneTickBox(v1start, v1end, v2start, v2end);
        } else {
            double offset2;
            double offset1 = this.getLineOffset();
            this.orient(v1start, offset1, 0.0, 0.0);
            this.orient(v1end, offset1, -this.tickBoxDepth * primarySign, 0.0);
            for (int i = 0; i < this.processedLabels.size(); ++i) {
                AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                offset2 = la.offset;
                if (offset2 < firstLabelOffset || offset2 > lastLabelOffset) continue;
                this.orient(v2start, offset2, 0.0, 0.0);
                this.orient(v2end, offset2, -this.tickBoxDepth * primarySign, 0.0);
                this.drawOneTickBox(v1start, v1end, v2start, v2end);
                v1start.set(v2start);
                v1end.set(v2end);
            }
            offset2 = this.getLineOffset() + this.mySize;
            this.orient(v2start, offset2, 0.0, 0.0);
            this.orient(v2end, offset2, -this.tickBoxDepth * primarySign, 0.0);
            this.drawOneTickBox(v1start, v1end, v2start, v2end);
        }
        this.channel.glPolygonMode(polygonMode);
        this.channel.glLineWidth(1.0f);
        if (stippleNeeded) {
            this.channel.glDisable(6);
        }
    }

    private void drawOneTickBox(Vec3d v1start, Vec3d v1end, Vec3d v2start, Vec3d v2end) {
        this.channel.glBegin(2);
        this.channel.glVertex(v1start.x, v1start.y, v1start.z);
        this.channel.glVertex(v1end.x, v1end.y, v1end.z);
        this.channel.glVertex(v2end.x, v2end.y, v2end.z);
        this.channel.glVertex(v2start.x, v2start.y, v2start.z);
        this.channel.glEnd();
    }

    private double extraSpaceForTickBox() {
        if (!this.style.isTickBoxOn() && this.style.getTickBoxBackground() == null) {
            return 0.0;
        }
        double halfWidth = 0.0;
        int width = this.style.getTickBoxStyle().getWidth();
        if (width > 1) {
            halfWidth = Math.floor((double)(width - 1) / 2.0);
        }
        return (this.style.isLabelsOn() ? this.labelSpace : this.majorTickLength) + (this.style.isTickBoxOn() ? halfWidth : 0.0);
    }

    private void drawTitle() {
        if (this.isTitleOn()) {
            Vec3d max;
            double titleSpace = this.style.getTitleSpace() * this.currentlabelHeight;
            if (this.style.isTitlePositionedAtMax() && (max = this.getMaximumSize()) != null) {
                this.setupChannelWithStyle(this.style.getTitleStyle());
                double maxExtent = this.orientation == 1 ? max.y : max.x;
                titleSpace = this.hotelText && this.orientation == 2 ? Math.max(maxExtent - this.channel.glGetTextWidth(this.displayTitle) * 0.5 - this.maxDepth, 0.0) : Math.max(maxExtent - this.channel.glGetTextHeight(this.displayTitle) - this.maxDepth, titleSpace);
            }
            double titleSpaceX = this.style.getTitleEndSpace() * this.currentlabelHeight;
            double signX = this.getTitlePosition() == 0 ? -1.0 : (this.getTitlePosition() == 2 ? 1.0 : 0.0);
            boolean shift = false;
            double maxDisplayTitleWidth = this.displayTitleWidth;
            if (this.checkTitleShift() && this.titleList != null) {
                maxDisplayTitleWidth = this.getMaximumTitleWidth();
            }
            if (this.displayTitle != null) {
                double minX;
                shift = this.checkTitleShift() && this.maxDepth > maxDisplayTitleWidth;
                TextStyle tStyle = this.style.getTitleStyle();
                if (this.autoAlignTitle) {
                    this.end.set(this.getLineOffset() + titleSpaceX * signX, (shift ? 0.0 : -this.maxDepth) * this.primarySign, 0.0);
                    if (this.getTitlePosition() == 0 && this.lowExtender > 0.0) {
                        this.end.x -= this.lowExtender;
                    }
                    if (this.getTitlePosition() == 2 && this.highExtender > 0.0) {
                        this.end.x += this.highExtender;
                    }
                } else {
                    this.end.set(this.getLineOffset() + titleSpaceX * signX, -(this.maxDepth + titleSpace) * this.primarySign, 0.0);
                }
                this.positionTitle(this.end, this.mySize);
                int saveH = this.justifyLabelH;
                int saveV = this.justifyLabelV;
                this.justifyLabelH = tStyle.getHorizontalJustification();
                if (shift) {
                    this.justifyLabelH = this.primary ? 2 : 0;
                }
                this.justifyLabelV = tStyle.getVerticalJustification();
                this.channel.glAlignment(this.justifyLabelH, this.justifyLabelV);
                this.setupChannelWithStyle(tStyle);
                this.channel.glGetText2DBbox(this.displayTitle, this.end.x, this.end.y, this.end.z, (int)tStyle.getAngle(), this.displayTitleBbox);
                if (this.style.isTitleMarkerVisible() && (this.justifyLabelH == 1 || this.justifyLabelH == 2) && this.justifyLabelV == 0) {
                    double titleMarkerXOffset = 0.0;
                    double titleMarkerYOffset = 0.0;
                    if (this.justifyLabelH == 1) {
                        this.end.x += ((double)this.style.getTitleMarkerSize() + this.style.getTitleMarkerSpace()) / 2.0;
                        titleMarkerXOffset = -(this.displayTitleBbox.getSizeX() / 2.0 + (double)this.style.getTitleMarkerSize() / 2.0 + this.style.getTitleMarkerSpace() + 2.0);
                    } else if (this.justifyLabelH == 2) {
                        this.end.x -= (double)this.style.getTitleMarkerSize() + this.style.getTitleMarkerSpace() + 2.0;
                        titleMarkerXOffset = (double)this.style.getTitleMarkerSize() / 2.0;
                    }
                    titleMarkerYOffset = -this.displayTitleBbox.getSizeY() / 2.0;
                    if (this.isRendering()) {
                        this.channel.glLoadName((Object)titleMarkerDetailType);
                        this.channel.setMarkerSize(this.style.getTitleMarkerSize());
                        this.channel.setMarkerType(this.style.getTitleMarkerId());
                        this.channel.glBegin(4);
                        this.channel.glVertex(this.end.x + titleMarkerXOffset, this.end.y + titleMarkerYOffset, this.end.z);
                        this.channel.glEnd();
                    }
                }
                if (this.isRendering()) {
                    this.channel.glLoadName((Object)titleDetailType);
                }
                if (this.orientation == 1 && !this.isUse3DFitting() && this.getTitlePosition() == 1 && this.titleFitPolicy == 0 && this.displayTitleBbox.xmin < (minX = this.getXMinimunBounds())) {
                    this.end.x = minX;
                    this.justifyLabelH = 0;
                }
                if ((this.getTitlePosition() == 1 || this.getTitlePosition() == 3) && this.titleHasBeenSplit && this.multilineTitleJustification != -1) {
                    if (this.orientation == 1) {
                        this.justifyLabelH = this.multilineTitleJustification;
                        minX = this.getXMinimunBounds();
                        if (this.multilineTitleJustification == 0) {
                            this.end.x = this.displayTitleBbox.xmin < minX ? minX : (this.end.x -= this.displayTitleBbox.getSizeX() / 2.0);
                        } else if (this.multilineTitleJustification == 2) {
                            Vec3d size = this.getProcessedMaximumTitleSize();
                            double maxX = minX + size.x;
                            this.end.x = this.displayTitleBbox.xmax > maxX ? maxX : (this.end.x += this.displayTitleBbox.getSizeX() / 2.0);
                        }
                    } else if (this.orientation == 2) {
                        this.justifyLabelV = this.multilineTitleJustification;
                        double minY = this.getYMinimunBounds();
                        if (this.multilineTitleJustification == 3) {
                            this.end.y = this.displayTitleBbox.ymin < minY ? minY : (this.end.y -= this.displayTitleBbox.getSizeY() / 2.0);
                        } else if (this.multilineTitleJustification == 0) {
                            Vec3d size = this.getProcessedMaximumTitleSize();
                            double maxY = minY + size.y;
                            this.end.y = this.displayTitleBbox.ymax > maxY ? maxY : (this.end.y += this.displayTitleBbox.getSizeY() / 2.0);
                        }
                    }
                }
                this.drawTitle(this.displayTitle, this.end.x, this.end.y, this.end.z, this.style.getTitleStyle());
                if (this.getTitlePosition() != 1 && this.getTitlePosition() != 3) {
                    if (this.orientation == 2) {
                        this.titleXDepth = shift ? this.end.x : this.end.x + this.displayTitleWidth * this.primarySign;
                        this.titleYDepth = this.end.y + this.displayTitleHeight * signX;
                    } else {
                        this.titleXDepth = this.end.x + this.displayTitleWidth * signX;
                        this.titleYDepth = this.end.y + this.displayTitleHeight * this.primarySign;
                    }
                    if (this.orientation == 2 && this.getTitlePosition() == 2 && this.titleList != null && this.titleList.length > 1) {
                        Bbox tBox = new Bbox();
                        this.end.y += this.displayTitleHeight;
                        for (int i = 1; i < this.titleList.length; ++i) {
                            this.drawTitle(this.titleList[i], this.end.x, this.end.y, this.end.z, this.style.getTitleStyle());
                            this.channel.glGetText2DBbox(this.titleList[i], this.end.x, this.end.y, this.end.z, (int)tStyle.getAngle(), tBox);
                            this.titleXDepth = this.primary ? (shift ? this.end.x : Math.max(this.titleXDepth, this.end.x + tBox.getSizeX() * this.primarySign)) : (shift ? this.end.x : Math.min(this.titleXDepth, this.end.x + tBox.getSizeX() * this.primarySign));
                            this.titleYDepth = this.end.y + tBox.getSizeY();
                            this.end.y += tBox.getSizeY();
                        }
                    }
                }
                this.justifyLabelH = saveH;
                this.justifyLabelV = saveV;
            }
        }
    }

    private double getXMinimunBounds() {
        Vec3d max;
        double result = this.getLineOffset();
        AAxis.LabelAlignment la = this.nextNonDroppedLabel(0, this.processedLabels.size() - 1);
        if (la != null) {
            result = Math.min(result, la.offset - la.width / 2.0);
        }
        if ((max = this.getProcessedMaximumTitleSize()) != null && max.x > this.displayTitleBbox.getSizeX() && this.getTitlePosition() != 3) {
            result += (max.x - this.displayTitleBbox.getSizeX()) / 2.0;
        }
        return result;
    }

    private double getYMinimunBounds() {
        Vec3d max;
        double result = this.getLineOffset();
        AAxis.LabelAlignment la = this.nextNonDroppedLabel(0, this.processedLabels.size() - 1);
        if (la != null) {
            result = Math.min(result, la.offset - la.width / 2.0);
        }
        if ((max = this.getProcessedMaximumTitleSize()) != null && max.y > this.displayTitleBbox.getSizeY() && this.getTitlePosition() != 3) {
            result += (max.y - this.displayTitleBbox.getSizeY()) / 2.0;
        }
        return result;
    }

    private void drawBackground() {
        if (this.am == null) {
            return;
        }
        this.channel.glColor(this.style.getBackground());
        this.channel.glPolygonMode(3);
        this.channel.glBegin(2);
        double depth = this.am.getOutsideLength() * this.primarySign;
        if (this.orientation == 2) {
            Vec3d v = new Vec3d(0.0, this.getLineOffset() - this.am.getLowExtender(), 0.0);
            if (this.getTitlePosition() == 1 || this.getTitlePosition() == 3) {
                this.channel.glVertex(v.x, v.y);
                this.channel.glVertex(v.x - depth, v.y);
                this.channel.glVertex(v.x - depth, v.y + this.am.getHeight());
                this.channel.glVertex(v.x, v.y + this.am.getHeight());
            } else if (this.getTitlePosition() == 2) {
                this.channel.glVertex(v.x, v.y);
                this.channel.glVertex(v.x - depth, v.y);
                this.channel.glVertex(v.x - depth, this.titleYDepth);
                if (this.primary && this.titleXDepth > v.x || !this.primary && this.titleXDepth < v.x) {
                    this.channel.glVertex(this.titleXDepth, this.titleYDepth);
                    this.channel.glVertex(this.titleXDepth, v.y + this.am.getHeight());
                    this.channel.glVertex(v.x, v.y + this.am.getHeight());
                } else {
                    this.channel.glVertex(v.x, this.titleYDepth);
                }
            } else if (this.getTitlePosition() == 0) {
                if (this.primary && this.titleXDepth > v.x || !this.primary && this.titleXDepth < v.x) {
                    this.channel.glVertex(this.titleXDepth, this.titleYDepth);
                    this.channel.glVertex(this.titleXDepth, v.y);
                    this.channel.glVertex(v.x, v.y);
                } else {
                    this.channel.glVertex(v.x, this.titleYDepth);
                }
                this.channel.glVertex(v.x, v.y + this.am.getHeight());
                this.channel.glVertex(v.x - depth, v.y + this.am.getHeight());
                this.channel.glVertex(v.x - depth, this.titleYDepth);
            }
        } else {
            Vec3d v = new Vec3d(this.getLineOffset() - this.am.getLowExtender(), 0.0, 0.0);
            if (this.getTitlePosition() == 1 || this.getTitlePosition() == 3) {
                this.channel.glVertex(v.x, v.y);
                this.channel.glVertex(v.x + this.am.getWidth(), v.y);
                this.channel.glVertex(v.x + this.am.getWidth(), v.y - depth);
                this.channel.glVertex(v.x, v.y - depth);
            } else if (this.getTitlePosition() == 2) {
                this.channel.glVertex(v.x + this.am.getWidth(), v.y);
                this.channel.glVertex(v.x, v.y);
                this.channel.glVertex(v.x, v.y - depth);
                this.channel.glVertex(this.titleXDepth, v.y - depth);
                this.channel.glVertex(this.titleXDepth, v.y);
                if (this.primary && this.titleYDepth > v.y || !this.primary && this.titleYDepth < v.y) {
                    this.channel.glVertex(this.titleXDepth, this.titleYDepth);
                    this.channel.glVertex(v.x + this.am.getWidth(), this.titleYDepth);
                }
            } else if (this.getTitlePosition() == 0) {
                this.channel.glVertex(v.x, v.y);
                if (this.primary && this.titleYDepth > v.y || !this.primary && this.titleYDepth < v.y) {
                    this.channel.glVertex(v.x, this.titleYDepth);
                    this.channel.glVertex(this.titleXDepth, this.titleYDepth);
                }
                this.channel.glVertex(this.titleXDepth, v.y);
                this.channel.glVertex(this.titleXDepth, v.y - depth);
                this.channel.glVertex(v.x + this.am.getWidth(), v.y - depth);
                this.channel.glVertex(v.x + this.am.getWidth(), v.y);
            }
        }
        this.channel.glEnd();
    }

    private void drawAxisLine() {
        if (this.style.isAxisLineOn()) {
            if (this.isRendering()) {
                this.channel.glPushName((Object)lineDetailType);
            }
            double halfLine = this.getHalfLineWidth();
            if (this.axisLineOffsetCoverage < 1.0) {
                double lineOffset = -this.getLineOffset();
                if (this.axisLineOffsetCoverage == 0.0) {
                    this.orient(this.start, lineOffset, -halfLine, 0.0);
                    this.orient(this.end, lineOffset + this.getDataLength(), -halfLine, 0.0);
                } else {
                    double endOffset = this.mySize - this.getDataLength() - lineOffset;
                    double ext1 = lineOffset * this.axisLineOffsetCoverage;
                    double ext2 = endOffset * this.axisLineOffsetCoverage;
                    this.orient(this.start, lineOffset - ext1, -halfLine, 0.0);
                    this.orient(this.end, lineOffset + this.getDataLength() + ext2, -halfLine, 0.0);
                }
            } else {
                this.orient(this.start, 0.0, -halfLine, 0.0);
                this.orient(this.end, this.mySize, -halfLine, 0.0);
            }
            boolean subpixel = this.channel.isSubpixelRendering();
            if (!this.SVGRender) {
                this.channel.setSubpixelRendering(false);
            }
            this.drawAxisLine(this.start.x, this.start.y, this.start.z, this.end.x, this.end.y, this.end.z, this.style.getAxisLineColor(), this.style.getLineWidth());
            this.channel.setSubpixelRendering(subpixel);
            if (this.bbox != null) {
                this.bbox.union(this.start);
                this.bbox.union(this.end);
                BoundingBox bb = new BoundingBox();
                bb.union(this.start);
                this.unionProjection(bb);
                bb = new BoundingBox();
                bb.union(this.end);
                this.unionProjection(bb);
            }
            if (this.isRendering()) {
                this.channel.glPopName();
            }
        }
    }

    private void drawMinorTickMarks(AAxis.LabelAlignment la, int i) {
        if (this.style.isMinorTickMarksOn() && this.getMinorTickOffsetCount() <= 0 && i > 0 && (this.style.isShowThinnedTicks() || !la.drop)) {
            int t = 0;
            int lastMajorIndex = i - 1;
            if (this.style.isShowThinnedTicks()) {
                lastMajorIndex = i - 1;
            } else {
                lastMajorIndex = -1;
                for (t = i - 1; t >= 0 && lastMajorIndex < 0; --t) {
                    AAxis.LabelAlignment lla = (AAxis.LabelAlignment)this.processedLabels.elementAt(t);
                    if (lla.drop) continue;
                    lastMajorIndex = t;
                }
            }
            if (lastMajorIndex >= 0) {
                int ticCount = this.style.getMinorTickStyle().getMinorTickCount();
                double lastMajorOffset = ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)lastMajorIndex)).offset;
                if (this.isRendering()) {
                    this.channel.glLoadName((Object)new Integer(la.observation));
                    this.channel.glPushName((Object)tickDetailType);
                }
                for (t = 0; t < ticCount; ++t) {
                    double ratio = (double)(t + 1) / (double)(ticCount + 1);
                    double offset = lastMajorOffset + (la.offset - lastMajorOffset) * ratio;
                    this.orient(this.start, offset, this.minorT[0], 0.0);
                    this.orient(this.end, offset, this.minorT[1], 0.0);
                    this.drawMinorTickMark(this.start.x, this.start.y, this.start.z, this.end.x, this.end.y, this.end.z, this.style.getMinorTickStyle().getColor(), this.style.getMinorTickStyle().getLineWidth());
                }
                if (this.isRendering()) {
                    this.channel.glPopName();
                }
            }
        }
    }

    private void drawExplicitMinorTickMarks() {
        if (this.style.isMinorTickMarksOn() && this.getMinorTickOffsetCount() > 0) {
            Vec3d startTemp = new Vec3d();
            Vec3d startEnd = new Vec3d();
            int n = this.getMinorTickOffsetCount();
            for (int i = 0; i < n; ++i) {
                if (this.isRendering()) {
                    this.channel.glLoadName((Object)new Integer(i));
                    this.channel.glPushName((Object)tickDetailType);
                }
                try {
                    double offset = this.minorTickOffset.getValue(i);
                    this.orient(startTemp, offset, this.minorT[0], 0.0);
                    this.orient(startEnd, offset, this.minorT[1], 0.0);
                    this.drawMinorTickMark(startTemp.x, startTemp.y, startTemp.z, startEnd.x, startEnd.y, startEnd.z, this.style.getMinorTickStyle().getColor(), this.style.getMinorTickStyle().getLineWidth());
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                if (!this.isRendering()) continue;
                this.channel.glPopName();
            }
        }
    }

    private void drawExplicitMajorTickMarks() {
        if (this.style.isMajorTickMarksOn() && this.getMajorTickOffsetCount() > 0) {
            Vec3d startTemp = new Vec3d();
            Vec3d startEnd = new Vec3d();
            int n = this.getMajorTickOffsetCount();
            for (int i = 0; i < n; ++i) {
                if (this.isRendering()) {
                    this.channel.glLoadName((Object)new Integer(i));
                    this.channel.glPushName((Object)tickDetailType);
                }
                try {
                    double offset = this.majorTickOffset.getValue(i);
                    this.orient(startTemp, offset, this.majorT[0], 0.0);
                    this.orient(startEnd, offset, this.majorT[1], 0.0);
                    this.drawMajorTickMark(startTemp.x, startTemp.y, startTemp.z, startEnd.x, startEnd.y, startEnd.z, this.style.getMajorTickStyle().getColor(), this.style.getMajorTickStyle().getLineWidth());
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                if (!this.isRendering()) continue;
                this.channel.glPopName();
            }
        }
    }

    private double getHalfLineWidth() {
        double halfLine = 0.0;
        if (this.ignoreFudge) {
            double[] win = new double[3];
            double[] obj1 = new double[3];
            double[] obj2 = new double[3];
            win[2] = 0.0;
            win[1] = 0.0;
            win[0] = 0.0;
            this.channel.gluUnProject(win, obj1);
            win[0] = this.style.getLineWidth();
            this.channel.gluUnProject(win, obj2);
            Vec3d p1 = new Vec3d(obj1[0], obj1[1], obj1[2]);
            Vec3d p2 = new Vec3d(obj2[0], obj2[1], obj2[2]);
            p2.subtract(p1);
            halfLine = p2.length() / 2.0;
        } else {
            int lineWidth = this.style.getLineWidth();
            if (lineWidth > 1) {
                halfLine = Math.floor((double)(lineWidth - 1) / 2.0);
            }
        }
        return halfLine;
    }

    private void processTitles() {
        this.processTitles(this.title.getValue(), this.shortTitle.getValue());
    }

    private void processTitles(String t, String st) {
        this.setupChannelWithStyle(this.style.getTitleStyle());
        this.displayTitle = t;
        if (this.titleFitPolicy == 0) {
            if (this.getTitlePosition() == 3) {
                if (!this.displayTitleFits(this.getDataLength()) && st != null && st.length() > 0) {
                    this.displayTitle = st;
                }
            } else if (!this.displayTitleFits() && st != null && st.length() > 0) {
                this.displayTitle = st;
            }
        }
        this.titleHasBeenTruncated = false;
        this.titleHasBeenSplit = false;
        switch (this.titleFitPolicy) {
            default: {
                if (this.displayTitleFits()) break;
                this.truncateTitle();
                this.titleHasBeenTruncated = true;
                break;
            }
            case 1: {
                double length = this.getTitlePosition() == 3 && Double.isNaN(this.titleSplitWidth) ? this.getDataLength() : this.titleSplitWidth;
                if (this.displayTitleFits(length)) break;
                this.splitTitle(false);
                break;
            }
            case 2: {
                this.splitTitle(true);
            }
        }
    }

    private void calculateDisplayTitleSize() {
        this.setupChannelWithStyle(this.style.getTitleStyle());
        this.channel.glGetText2DBbox(this.displayTitle, 0.0, 0.0, 0.0, (int)this.style.getTitleStyle().getAngle(), this.displayTitleBbox);
        this.displayTitleHeight = this.displayTitleBbox.getSizeY();
        this.displayTitleWidth = this.displayTitleBbox.getSizeX();
    }

    private double getMaximumTitleWidth() {
        if (this.titleList == null || this.titleList.length < 2) {
            return this.displayTitleWidth;
        }
        this.setupChannelWithStyle(this.style.getTitleStyle());
        Bbox tBox = new Bbox();
        double maxWidth = this.displayTitleWidth;
        for (int i = 1; i < this.titleList.length; ++i) {
            this.channel.glGetText2DBbox(this.titleList[i], 0.0, 0.0, 0.0, (int)this.style.getTitleStyle().getAngle(), tBox);
            maxWidth = Math.max(maxWidth, tBox.getSizeX());
        }
        return maxWidth;
    }

    private boolean checkTitleShift() {
        return this.orientation == 2 && this.autoAlignTitle && this.ignoreTitleAlignment;
    }

    private void truncateTitle() {
        if (this.titleTruncateEndCount > 0 && this.titleTruncateEndCount < this.displayTitle.length()) {
            this.truncateTitleByEndCount();
            return;
        }
        Vec3d max = this.getProcessedMaximumTitleSize();
        if (max != null && this.displayTitle.length() > 3) {
            StringBuffer sb = new StringBuffer(this.displayTitle);
            sb.append("...");
            do {
                sb.delete(sb.length() - 4, sb.length());
                sb.append("...");
                this.displayTitle = sb.toString();
            } while (!this.displayTitleFits() && this.displayTitle.length() > 3);
        }
    }

    private void truncateTitleByEndCount() {
        String suffix = this.displayTitle.substring(this.displayTitle.length() - this.titleTruncateEndCount);
        String truncatedTitle = this.displayTitle.substring(0, this.displayTitle.length() - this.titleTruncateEndCount);
        int length = truncatedTitle.length();
        Vec3d max = this.getProcessedMaximumTitleSize();
        if (max != null && length > 3) {
            StringBuffer sb = new StringBuffer(truncatedTitle);
            sb.append("...");
            do {
                sb.delete(sb.length() - 4, sb.length());
                sb.append("...");
                this.displayTitle = sb.toString() + suffix;
            } while (!this.displayTitleFits() && --length > 3);
        }
    }

    private void splitTitle(boolean always) {
        if (this.hotelText && this.orientation == 2) {
            this.splitTitleToHotelText();
            return;
        }
        Vec3d max = this.getProcessedMaximumTitleSize();
        if (max != null) {
            String[] labs;
            if (Double.isNaN(this.titleSplitWidth)) {
                this.titleSplitWidth = this.getTitlePosition() == 3 ? this.getDataLength() : (this.getOrientation() == 1 ? max.x : max.y);
                this.titleSplitWidth *= 0.95;
            }
            if ((labs = this.splitLabel(this.displayTitle, always, this.titleSplitChar, this.titleSplitCharDrop, this.titleSplitWidth, this.style.getTitleStyle().getFont())).length >= 2 || !labs[0].equals(this.displayTitle)) {
                this.displayTitle = labs[0];
                for (int j = 1; j < labs.length; ++j) {
                    this.displayTitle = this.displayTitle + '\n';
                    this.displayTitle = this.displayTitle + labs[j];
                }
                if (labs.length >= 2) {
                    this.titleHasBeenSplit = true;
                }
            }
            this.calculateDisplayTitleSize();
        }
    }

    private void splitTitleToHotelText() {
        Vec3d max = this.getProcessedMaximumTitleSize();
        if (max != null) {
            int length;
            if (Double.isNaN(this.titleSplitWidth)) {
                this.titleSplitWidth = this.getTitlePosition() == 3 ? this.getDataLength() : (this.getOrientation() == 1 ? max.x : max.y);
                this.titleSplitWidth *= 0.95;
            }
            if ((length = this.displayTitle.length()) >= 2) {
                char[] hotelText = new char[length * 2 - 1];
                int idx = 0;
                for (int i = 0; i < length - 1; ++i) {
                    hotelText[idx++] = this.displayTitle.charAt(i);
                    hotelText[idx++] = 10;
                }
                hotelText[idx] = this.displayTitle.charAt(length - 1);
                this.displayTitle = new String(hotelText);
                this.titleHasBeenSplit = true;
            }
            this.calculateDisplayTitleSize();
        }
    }

    private Vec3d getProcessedMaximumTitleSize() {
        Vec3d result = this.getMaximumTitleSize();
        if (result == null) {
            result = this.getMaximumSize();
        }
        return result;
    }

    private boolean displayTitleFits() {
        boolean fits = true;
        Vec3d max = this.getProcessedMaximumTitleSize();
        this.calculateDisplayTitleSize();
        if (max != null) {
            switch (this.orientation) {
                case 1: 
                case 3: {
                    fits = max.x > this.displayTitleWidth;
                    break;
                }
                case 2: {
                    fits = max.y > this.displayTitleHeight;
                }
            }
        }
        return fits;
    }

    private boolean displayTitleFits(double size) {
        if (Double.isNaN(size)) {
            return this.displayTitleFits();
        }
        boolean fits = true;
        Vec3d max = this.getProcessedMaximumTitleSize();
        this.calculateDisplayTitleSize();
        if (max != null) {
            switch (this.orientation) {
                case 1: 
                case 3: {
                    fits = Math.min(size, max.x) > this.displayTitleWidth;
                    break;
                }
                case 2: {
                    fits = Math.min(size, max.y) > this.displayTitleHeight;
                }
            }
        }
        return fits;
    }

    private void setupChannelWithStyle(TextStyle ts) {
        this.channel.glSelect2DFont(ts.getFont());
        if (ts.isShadowOn()) {
            this.channel.glEnable(11);
            this.channel.setShadowOffset(ts.getShadowOffsetX(), ts.getShadowOffsetY());
            this.channel.setShadowColor(ts.getShadowColor());
            this.channel.setShadowSoftness(ts.getShadowSoftness());
        } else {
            this.channel.glDisable(11);
        }
    }

    private void processLabels() {
        AAxis.LabelAlignment la;
        TextStyle labelStyle = this.style.getLabelStyle();
        this.currentLabelMargin = this.getLabelMargin();
        this.currentLabelFont = labelStyle.getFont();
        this.setupChannelWithStyle(labelStyle);
        this.currentlabelHeight = this.channel.glGetTextHeight();
        this.currentFirstRowDepth = Double.NEGATIVE_INFINITY;
        this.currentLabelAngle = 0.0;
        this.justify(this.style.getLabelStyle());
        this.channel.glTextAlign(this.justifyLabelH, this.justifyLabelV);
        int numLabels = this.originalProcessedLabels.size();
        this.longestLabelLength = -1;
        Vec3d v = new Vec3d();
        for (int i = 0; i < numLabels; ++i) {
            la = (AAxis.LabelAlignment)this.originalProcessedLabels.elementAt(i);
            la.theLabel = la.rawLabel;
            if (la.theLabel.length() > this.longestLabelLength) {
                this.longestLabelLength = la.theLabel.length();
            }
            this.updateDeviceCoords(la, v);
            la.width = this.channel.glGetTextWidth(la.theLabel);
            la.height = this.currentlabelHeight;
            this.updateFirstRowDepth(la);
        }
        this.setupChannelWithStyle(this.style.getSecondaryLabelStyle());
        double secondaryLabelHeight = this.channel.glGetTextHeight();
        for (int i = 0; i < numLabels; ++i) {
            la = (AAxis.LabelAlignment)this.originalProcessedLabels.elementAt(i);
            la.secondaryLabelWidth = this.channel.glGetTextWidth(la.secondaryLabel);
            la.secondaryLabelHeight = secondaryLabelHeight;
        }
        this.executeLabelFittingAlgorithms();
    }

    private void updateDeviceCoords(AAxis.LabelAlignment la, Vec3d tempVector) {
        if (this.use3DFitting) {
            this.orient(tempVector, la.offset, 0.0, 0.0);
            this.channel.glGetTextProjection(la.theLabel, tempVector.x, tempVector.y, tempVector.z, 0, la.deviceCoords);
        }
    }

    private void updateFirstRowDepth(AAxis.LabelAlignment la) {
        if (la.adjacentToAxis) {
            double depth = this.orientation == 2 ? la.width : la.height;
            this.currentFirstRowDepth = Math.max(this.currentFirstRowDepth, depth);
        }
    }

    protected void positionTitle(Vec3d titleOrigin, double lengthTemp) {
        double positionOffset = 0.0;
        switch (this.titlePosition) {
            case 0: {
                break;
            }
            default: {
                positionOffset = lengthTemp / 2.0;
                break;
            }
            case 3: {
                double titleLength;
                double d = titleLength = this.orientation == 2 ? this.displayTitleHeight : this.displayTitleWidth;
                if (titleLength > lengthTemp) {
                    positionOffset = lengthTemp / 2.0;
                    break;
                }
                positionOffset = -this.getLineOffset() + this.getDataLength() / 2.0;
                double extra = titleLength - this.getDataLength();
                if (!(extra > 0.0)) break;
                double extra2 = Math.ceil(extra * 0.5);
                double minOffset = -this.getLineOffset();
                double maxOffset = lengthTemp - this.getDataLength() - minOffset;
                if (!(extra2 > minOffset) && !(extra2 > maxOffset)) break;
                if (minOffset < maxOffset) {
                    positionOffset += extra2 - minOffset;
                    break;
                }
                if (!(minOffset > maxOffset)) break;
                positionOffset -= extra2 - maxOffset;
                break;
            }
            case 2: {
                positionOffset = lengthTemp;
            }
        }
        this.orient(titleOrigin, titleOrigin.x + positionOffset, titleOrigin.y, titleOrigin.z);
    }

    protected void positionTicMark(TickMarkStyle tmStyle, double lengthTemp, double[] pos) {
        double primarySignTemp = this.primary ? 1.0 : -1.0;
        switch (tmStyle.getTickMarkJustification()) {
            default: {
                pos[0] = 0.0;
                break;
            }
            case 0: {
                pos[0] = primarySignTemp * lengthTemp;
                break;
            }
            case 2: {
                pos[0] = primarySignTemp * lengthTemp / 2.0;
            }
        }
        pos[1] = pos[0] - lengthTemp * primarySignTemp;
    }

    public int getLabelCount(Channel aChannel, double axisLength) {
        new InitAction(aChannel).apply(this);
        this.processLabels();
        int i = 0;
        for (double width = 0.0; i < this.processedLabels.size() && width <= axisLength; width += ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)i)).width, ++i) {
        }
        return i;
    }

    protected void drawAxisLine(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width) {
        this.drawLine(beginX, beginY, beginZ, endX, endY, endZ, color, width, this.style.getLineStipplePattern(), this.style.getLineStippleFactor(), true);
    }

    protected void drawLine(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width, int stipplePattern, int stippleFactor, boolean disableAntialiasingForHorizontalOrVerticalLines) {
        if (this.drawing) {
            LineSegment.drawLineSegment(this.channel, beginX, beginY, beginZ, endX, endY, endZ, color, width, stipplePattern, stippleFactor, disableAntialiasingForHorizontalOrVerticalLines);
        }
    }

    public double getLineOffset() {
        return 0.0;
    }

    @Override
    protected void setLabelStyle(TextStyle style) {
        this.channel.glSelect2DFont(style.getFont());
    }

    protected void justify(TextStyle tStyle) {
        this.justifyLabelH = this.forceHJustification ? this.justifyLabelH : tStyle.getHorizontalJustification();
        this.justifyLabelV = tStyle.getVerticalJustification();
        if (!this.primary) {
            if (this.labelOrientation != 2 && this.justifyLabelH != 1) {
                this.justifyLabelH = this.justifyLabelH == 2 ? 0 : 2;
            }
            if (this.labelOrientation == 2 && this.justifyLabelV != 1) {
                this.justifyLabelV = this.justifyLabelV == 0 ? 3 : 0;
            }
        }
    }

    @Override
    protected void drawLabel(int obs, String aLabel, double atX, double atY, double atZ, TextStyle tStyle, Color color, double maximumWidth, double maximumHeight, double textAngle, boolean changeFont) {
        Font font;
        double fit2Width = maximumWidth > 0.0 ? maximumWidth : Double.POSITIVE_INFINITY;
        double fit2Height = maximumHeight > 0.0 ? maximumHeight : Double.POSITIVE_INFINITY;
        Font font2 = font = changeFont ? this.currentLabelFont : tStyle.getFont();
        if (tStyle.isShadowOn()) {
            this.channel.glEnable(11);
            this.channel.setShadowColor(tStyle.getShadowColor());
            this.channel.setShadowOffset(tStyle.getShadowOffsetX(), tStyle.getShadowOffsetY());
            this.channel.setShadowSoftness(tStyle.getShadowSoftness());
        } else {
            this.channel.glDisable(11);
        }
        if (this.drawing) {
            this.channel.glPushMatrix();
            this.channel.glTranslate(atX, atY, atZ);
            RasterLabel.drawRasterLabel(this.channel, aLabel, color, textAngle, this.justifyLabelH, this.justifyLabelV, false, false, fit2Width, fit2Height, font, tStyle.getBackgroundColor(), tStyle.isShadowOn(), tStyle.getShadowColor(), tStyle.getShadowOffsetX(), tStyle.getShadowOffsetY());
            this.channel.glPopMatrix();
        }
        if (this.bbox != null) {
            this.channel.glGetText2DBbox(aLabel, atX, atY, atZ, (int)textAngle, this.tempBbox);
            BoundingBox boundingBox = this.tempBbox.getBoundingBox();
            this.bbox.union(boundingBox);
            this.unionProjection(boundingBox);
        }
    }

    @Override
    protected void drawMajorTickMark(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width) {
        this.drawLine(beginX, beginY, beginZ, endX, endY, endZ, color, width, 0, 0, true);
    }

    @Override
    protected void drawMinorTickMark(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width) {
        this.drawLine(beginX, beginY, beginZ, endX, endY, endZ, color, width, 0, 0, true);
    }

    @Override
    public SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        int typeIndex = startIndex + entryLength - 1;
        int obsIndex = typeIndex - 1;
        int type = (Integer)nameStack.elementAt(typeIndex);
        int labelIndex = -1;
        if (type == 0 || type == 1 || type == 5) {
            labelIndex = (Integer)nameStack.elementAt(obsIndex);
        }
        AxisDetail axisDetail = new AxisDetail();
        axisDetail.setType(type);
        axisDetail.setLabelIndex(labelIndex);
        return axisDetail;
    }

    public void setFitAlgorithm(String[] stringArray) {
        this.fitAlgorithm = stringArray;
        this.createFit = false;
    }

    public void setUse3DFitting(boolean b) {
        this.use3DFitting = b;
    }

    public boolean isUse3DFitting() {
        return this.use3DFitting;
    }

    public void setForceFitAlgorithm(String algorithm) {
        this.forceFitAlgorithm = algorithm;
        if (this.forceFitAlgorithm != null) {
            this.forceFitAlgorithm = this.forceFitAlgorithm.toLowerCase();
        }
    }

    public void setCompressLowExtender(boolean b) {
        this.compressLowExtender = b;
    }

    public boolean isCompressLowExtender() {
        return this.compressLowExtender;
    }

    public void setCompressHighExtender(boolean b) {
        this.compressHighExtender = b;
    }

    public boolean isCompressHighExtender() {
        return this.compressHighExtender;
    }

    private void createFitAlgorithm() {
        int numShrinks;
        boolean stagger = this.style.getLabelStyle().isStagger();
        boolean truncate = this.style.getLabelStyle().isTruncate();
        boolean shrink = this.style.getLabelStyle().isFit();
        boolean split = this.style.getLabelStyle().isSplit();
        boolean angle = false;
        String angleString = "";
        int minimumFontSize = this.style.getMinimumLabelFontSize();
        int numFits = 0;
        switch ((int)this.style.getLabelStyle().getAngle()) {
            case 90: {
                angleString = "angle90";
                angle = true;
                break;
            }
            case 270: {
                angleString = "angle270";
                angle = true;
            }
        }
        if (stagger) {
            ++numFits;
        }
        if (split) {
            ++numFits;
        }
        if (truncate) {
            ++numFits;
        }
        if (stagger && truncate) {
            ++numFits;
        }
        if (this.dropOn) {
            ++numFits;
        }
        if (shrink && (numShrinks = (this.style.getLabelStyle().getFont().getSize() - minimumFontSize) / 2) > 0) {
            numFits = numFits * numShrinks + numShrinks;
        }
        if (angle && numFits == 0) {
            numFits = 1;
        }
        int index = 0;
        if (++numFits == 2 && angle) {
            this.fitAlgorithm = new String[2];
            this.fitAlgorithm[0] = "";
            index = 1;
        } else {
            this.fitAlgorithm = new String[numFits];
            while (index < numFits - 1) {
                if (stagger) {
                    this.fitAlgorithm[index++] = "stagger";
                }
                if (split) {
                    this.fitAlgorithm[index++] = "split";
                }
                if (truncate) {
                    this.fitAlgorithm[index++] = "truncate";
                }
                if (stagger && truncate) {
                    this.fitAlgorithm[index++] = "truncatestagger";
                }
                if (shrink) {
                    this.fitAlgorithm[index++] = "shrink";
                }
                if (!this.dropOn) continue;
                this.fitAlgorithm[index++] = "thin";
            }
        }
        this.fitAlgorithm[index] = "nolabels";
        if (angle) {
            for (int i = 0; i < this.fitAlgorithm.length - 1; ++i) {
                this.fitAlgorithm[i] = angleString + this.fitAlgorithm[i];
            }
        }
        this.createFit = false;
    }

    private void executeLabelFittingAlgorithms() {
        boolean split;
        this.lastLabelFittingAlgorithm = "";
        String currentRemainingFitAlgorithms = null;
        this.staggering = false;
        this.splitLabels = false;
        this.revertAxis(true);
        String lastSingleLabelFittingAlgorithm = "";
        boolean isForceFitting = this.forceFitAlgorithm != null;
        String[] fitAlgorithmStart = this.fitAlgorithm;
        if (isForceFitting) {
            fitAlgorithmStart = new String[]{this.forceFitAlgorithm};
        }
        if (fitAlgorithmStart == null || this.originalProcessedLabels.size() <= 0) {
            return;
        }
        boolean bl = split = fitAlgorithmStart.length > 0 && fitAlgorithmStart[0].startsWith("extendedsplit");
        if (this.labelOrientation == 1 && split) {
            this.allocatedLabelSize = this.computeAllocatedLabelSize();
        }
        this.addLabelMargin = false;
        block0: for (int i = 0; i < fitAlgorithmStart.length && (isForceFitting || split || !this.labelsFit()); ++i) {
            currentRemainingFitAlgorithms = fitAlgorithmStart[i];
            if (i > 0) {
                this.revertAxis(true);
            }
            while (currentRemainingFitAlgorithms.length() != 0 && (isForceFitting || split || !this.labelsFit())) {
                if (currentRemainingFitAlgorithms.startsWith("thinkeepend")) {
                    this.thinAxis(true);
                    lastSingleLabelFittingAlgorithm = "thinkeepend";
                } else if (currentRemainingFitAlgorithms.startsWith("thin_end_to_beginning")) {
                    this.thinFromOneEnd(false);
                    lastSingleLabelFittingAlgorithm = "thin_end_to_beginning";
                } else if (currentRemainingFitAlgorithms.startsWith("thin_beginning_to_end")) {
                    this.thinFromOneEnd(true);
                    lastSingleLabelFittingAlgorithm = "thin_beginning_to_end";
                } else if (currentRemainingFitAlgorithms.startsWith("thin_inside_to_outside")) {
                    this.thinInsideToOutside();
                    lastSingleLabelFittingAlgorithm = "thin_inside_to_outside";
                } else if (currentRemainingFitAlgorithms.startsWith("thin")) {
                    this.thinAxis(false);
                    lastSingleLabelFittingAlgorithm = "thin";
                } else if (currentRemainingFitAlgorithms.startsWith("shrink")) {
                    this.shrinkAxis();
                    lastSingleLabelFittingAlgorithm = "shrink";
                } else if (currentRemainingFitAlgorithms.startsWith("truncatedrop")) {
                    this.truncateDropAxis();
                    lastSingleLabelFittingAlgorithm = "truncatedrop";
                } else if (currentRemainingFitAlgorithms.startsWith("extendedsplitalways")) {
                    this.splitAxis(true);
                    lastSingleLabelFittingAlgorithm = "extendedsplitalways";
                    split = false;
                } else if (currentRemainingFitAlgorithms.startsWith("extendedsplit")) {
                    this.splitAxis(false);
                    lastSingleLabelFittingAlgorithm = "extendedsplit";
                    split = false;
                } else if (currentRemainingFitAlgorithms.startsWith("truncate")) {
                    this.truncateAxis(this.getTruncateStartCount(), this.getTruncateEndCount());
                    lastSingleLabelFittingAlgorithm = "truncate";
                } else if (currentRemainingFitAlgorithms.startsWith("stagger")) {
                    this.staggerAxis();
                    lastSingleLabelFittingAlgorithm = "stagger";
                } else if (currentRemainingFitAlgorithms.startsWith("split")) {
                    this.splitAxis();
                    lastSingleLabelFittingAlgorithm = "split";
                } else if (currentRemainingFitAlgorithms.startsWith("angle45")) {
                    this.justifyLabelH = this.primary ? 2 : 0;
                    this.forceHJustification = true;
                    this.angleAxis(45);
                    lastSingleLabelFittingAlgorithm = "angle45";
                } else if (currentRemainingFitAlgorithms.startsWith("angle315")) {
                    this.justifyLabelH = this.primary ? 0 : 2;
                    this.forceHJustification = true;
                    this.angleAxis(315);
                    lastSingleLabelFittingAlgorithm = "angle315";
                } else if (currentRemainingFitAlgorithms.startsWith("angle270")) {
                    this.angleAxis(270);
                    lastSingleLabelFittingAlgorithm = "angle270";
                } else if (currentRemainingFitAlgorithms.startsWith("angle90")) {
                    this.angleAxis(90);
                    lastSingleLabelFittingAlgorithm = "angle90";
                } else if (currentRemainingFitAlgorithms.startsWith("revertsize")) {
                    this.revertAxisSize();
                    lastSingleLabelFittingAlgorithm = "revertsize";
                } else if (currentRemainingFitAlgorithms.startsWith("undoforcefit")) {
                    isForceFitting = false;
                    lastSingleLabelFittingAlgorithm = "undoforcefit";
                    this.addLabelMargin = true;
                } else {
                    if (currentRemainingFitAlgorithms.equals("nolabels")) {
                        this.removeAllLabels();
                        this.lastLabelFittingAlgorithm = "nolabels";
                        continue block0;
                    }
                    currentRemainingFitAlgorithms = "";
                }
                currentRemainingFitAlgorithms = currentRemainingFitAlgorithms.substring(lastSingleLabelFittingAlgorithm.length(), currentRemainingFitAlgorithms.length());
                this.lastLabelFittingAlgorithm = fitAlgorithmStart[i].substring(0, fitAlgorithmStart[i].length() - currentRemainingFitAlgorithms.length());
            }
        }
    }

    private void thinFromOneEnd(boolean thinFromBeginning) {
        block5: {
            if (this.getLength() <= 0.0) {
                return;
            }
            int labelCount = this.processedLabels.size();
            boolean fits = this.labelsFit();
            if (labelCount <= 2 || fits) break block5;
            this.setLabelDrop(1, labelCount - 2, true);
            if (thinFromBeginning) {
                for (int i = 1; i < labelCount - 1 && !fits; ++i) {
                    AAxis.LabelAlignment cur = (AAxis.LabelAlignment)this.processedLabels.get(i);
                    AAxis.LabelAlignment prev = this.prevNonDroppedLabel(i - 1, 0);
                    AAxis.LabelAlignment next = this.nextNonDroppedLabel(i + 1, labelCount - 1);
                    if (this.labelsOverlap(cur, prev) || this.labelsOverlap(cur, next)) continue;
                    cur.drop = false;
                }
            } else {
                for (int i = labelCount - 2; i > 0 && !fits; --i) {
                    AAxis.LabelAlignment cur = (AAxis.LabelAlignment)this.processedLabels.get(i);
                    AAxis.LabelAlignment prev = this.prevNonDroppedLabel(i - 1, 0);
                    AAxis.LabelAlignment next = this.nextNonDroppedLabel(i + 1, labelCount - 1);
                    if (this.labelsOverlap(cur, prev) || this.labelsOverlap(cur, next)) continue;
                    cur.drop = false;
                }
            }
        }
    }

    private void setLabelDrop(int start, int end, boolean b) {
        for (int i = start; i <= end; ++i) {
            AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.get(i);
            la.drop = b;
        }
    }

    private void thinInsideToOutside() {
        if (this.getLength() <= 0.0) {
            return;
        }
        int labelCount = this.processedLabels.size();
        boolean fits = this.labelsFit();
        if (labelCount > 2 && !fits) {
            boolean middleFits;
            this.setLabelDrop(1, labelCount - 2, true);
            int middleIndex = (labelCount - 1) / 2;
            AAxis.LabelAlignment middle = (AAxis.LabelAlignment)this.processedLabels.get(middleIndex);
            AAxis.LabelAlignment prev = this.prevNonDroppedLabel(middleIndex - 1, 0);
            AAxis.LabelAlignment next = this.nextNonDroppedLabel(middleIndex + 1, labelCount - 1);
            boolean bl = middleFits = !this.labelsOverlap(middle, prev) && !this.labelsOverlap(middle, next);
            if (middleFits) {
                middle.drop = false;
                int lowIndex = middleIndex - 1;
                int highIndex = labelCount % 2 == 0 ? middleIndex + 2 : middleIndex + 1;
                int i = lowIndex;
                while (i > 0) {
                    boolean highFits;
                    AAxis.LabelAlignment low = (AAxis.LabelAlignment)this.processedLabels.get(lowIndex);
                    prev = this.prevNonDroppedLabel(lowIndex - 1, 0);
                    next = this.nextNonDroppedLabel(lowIndex + 1, labelCount - 1);
                    boolean lowFits = !this.labelsOverlap(low, prev) && !this.labelsOverlap(low, next);
                    AAxis.LabelAlignment high = (AAxis.LabelAlignment)this.processedLabels.get(highIndex);
                    prev = this.prevNonDroppedLabel(highIndex - 1, 0);
                    next = this.nextNonDroppedLabel(highIndex + 1, labelCount - 1);
                    boolean bl2 = highFits = !this.labelsOverlap(high, prev) && !this.labelsOverlap(high, next);
                    if (lowFits && highFits) {
                        low.drop = false;
                        high.drop = false;
                    }
                    --i;
                    --lowIndex;
                    ++highIndex;
                }
            }
        }
    }

    private AAxis.LabelAlignment prevNonDroppedLabel(int startIndex, int min) {
        AAxis.LabelAlignment result = null;
        for (int i = startIndex; i >= min && result == null; --i) {
            AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.get(i);
            if (la.drop) continue;
            result = la;
        }
        return result;
    }

    private AAxis.LabelAlignment nextNonDroppedLabel(int startIndex, int max) {
        AAxis.LabelAlignment result = null;
        for (int i = startIndex; i <= max && result == null; ++i) {
            AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.get(i);
            if (la.drop) continue;
            result = la;
        }
        return result;
    }

    private void thinAxis(boolean forceLastLabel) {
        int i;
        int numLabels = this.processedLabels.size();
        int increment = 1;
        if (this.getLength() <= 0.0) {
            return;
        }
        while (increment <= numLabels / 2 && !this.labelsFit()) {
            if (forceLastLabel) {
                ++increment;
                while (increment <= numLabels && (numLabels - 1) % increment != 0) {
                    ++increment;
                }
            } else {
                ++increment;
            }
            for (i = 0; i < numLabels; ++i) {
                ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)i)).drop = true;
            }
            for (i = 0; i < numLabels; i += increment) {
                ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)i)).drop = false;
            }
            if (forceLastLabel) {
                ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)(numLabels - 1))).drop = false;
            }
            if (!this.staggering) continue;
            for (i = 0; i < numLabels; i += increment * 2) {
                ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)i)).adjacentToAxis = true;
            }
            for (i = increment; i < numLabels; i += increment * 2) {
                ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)i)).adjacentToAxis = false;
            }
        }
        if ((double)increment >= (double)numLabels / 2.0) {
            for (i = 1; i < numLabels - 1; ++i) {
                ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)i)).drop = true;
            }
            ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)(numLabels - 1))).drop = false;
        }
        if (this.isBrokenAxis()) {
            this.adjustThinning();
        }
    }

    private void adjustThinning() {
        ContinuousRangeToNumericMap[] segMaps = this.getSegmentMaps();
        if (segMaps == null) {
            return;
        }
        int numLabels = this.processedLabels.size();
        int startIdx = 0;
        for (int s = 0; s < segMaps.length; ++s) {
            AAxis.LabelAlignment la;
            double min = segMaps[s].getOutputMin();
            double max = segMaps[s].getOutputMax();
            int firstLabelIdx = -1;
            int lastLabelIdx = -1;
            boolean hasLabel = false;
            for (int i = startIdx; i < numLabels; ++i) {
                la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                if (!(la.offset >= min) || !(la.offset <= max)) continue;
                if (firstLabelIdx < 0) {
                    firstLabelIdx = i;
                }
                lastLabelIdx = i;
                if (la.drop) continue;
                hasLabel = true;
            }
            if (!hasLabel && firstLabelIdx >= 0) {
                int middle = firstLabelIdx + (int)((double)(lastLabelIdx - firstLabelIdx) * 0.5);
                la = (AAxis.LabelAlignment)this.processedLabels.elementAt(middle);
                la.drop = false;
                la.adjacentToAxis = true;
            }
            startIdx = lastLabelIdx + 1;
        }
    }

    private void shrinkAxis() {
        boolean fit = false;
        int newLabelFontSize = this.currentLabelFont.getSize() - 1;
        if (this.forceFitAlgorithm != null) {
            fit = this.labelsFit();
        }
        while (newLabelFontSize >= this.style.getMinimumLabelFontSize() && !fit) {
            Font styleFont = this.style.getLabelStyle().getFont();
            this.currentLabelFont = styleFont.deriveFont(styleFont.getStyle(), newLabelFontSize);
            this.channel.glSelect2DFont(this.currentLabelFont);
            this.currentlabelHeight = this.channel.glGetTextHeight();
            this.currentFirstRowDepth = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.processedLabels.size(); ++i) {
                AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                if (this.currentLabelAngle == 0.0) {
                    la.width = this.channel.glGetTextWidth(la.theLabel);
                    la.height = this.currentlabelHeight;
                } else if (this.currentLabelAngle == 270.0 || this.currentLabelAngle == 90.0) {
                    la.height = this.channel.glGetTextWidth(la.theLabel);
                    la.width = this.currentlabelHeight;
                } else if (this.currentLabelAngle == 45.0 || this.currentLabelAngle == 315.0) {
                    // empty if block
                }
                this.updateFirstRowDepth(la);
            }
            fit = this.labelsFit();
            newLabelFontSize = this.currentLabelFont.getSize() - 1;
        }
    }

    private void truncateAxis(int startCount, int endCount) {
        double maxLabelDepth = 0.0;
        boolean truncateBasedOnMaxSize = false;
        if (this.getMaximumSize() != null && (this.valueAngle == 270 || this.valueAngle == 90 || this.valueAngle == 315)) {
            truncateBasedOnMaxSize = true;
            maxLabelDepth = this.computeMaxLableDepth();
        }
        for (int i = 0; i < this.processedLabels.size(); ++i) {
            AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
            if (truncateBasedOnMaxSize) {
                this.truncateLabelByMaxSize(la, maxLabelDepth);
                continue;
            }
            this.truncateLabelByLength(la, startCount, endCount);
        }
    }

    private void truncateDropAxis() {
        int truncationLength = this.longestLabelLength;
        while (true) {
            for (int i = 0; i < this.processedLabels.size(); ++i) {
                String newLabel;
                AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                if (la.theLabel.length() <= 4 || la.theLabel.length() < truncationLength) continue;
                la.theLabel = newLabel = la.theLabel.substring(0, la.theLabel.length() - 4) + "...";
                la.width = this.channel.glGetTextWidth(la.theLabel);
                la.height = this.currentlabelHeight;
            }
            if (this.labelsFit() || truncationLength <= 4) break;
            --truncationLength;
        }
    }

    private void truncateLabelByMaxSize(AAxis.LabelAlignment la, double maxLabelDepth) {
        int startCount = (int)Math.ceil((double)(la.theLabel.length() - 3) / 2.0);
        int endCount = la.theLabel.length() - 3 - startCount;
        while (la.height > maxLabelDepth && endCount > 0) {
            if (startCount + endCount + 3 > la.theLabel.length()) {
                return;
            }
            this.truncateLabelByLength(la, startCount, endCount);
            if (startCount > endCount) {
                --startCount;
                continue;
            }
            --endCount;
        }
    }

    private void truncateLabelByLength(AAxis.LabelAlignment la, int startCount, int endCount) {
        if (la.theLabel.length() > startCount + endCount + 3) {
            String newLabel;
            la.theLabel = newLabel = la.theLabel.substring(0, startCount) + "..." + la.theLabel.substring(la.theLabel.length() - endCount, la.theLabel.length());
            la.width = this.channel.glGetTextWidth(la.theLabel);
            la.height = this.currentlabelHeight;
            if (this.valueAngle == 270 || this.valueAngle == 90) {
                double temp = la.width;
                la.width = la.height;
                la.height = temp;
            }
        }
    }

    private void staggerAxis() {
        if (this.longestLabelLength < this.getStaggerThreshold()) {
            this.staggering = true;
            for (int i = 1; i < this.processedLabels.size(); i += 2) {
                AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                la.adjacentToAxis = false;
            }
        }
    }

    private void splitAxis() {
        AAxis.LabelAlignment la = null;
        for (int i = 0; i < this.processedLabels.size(); ++i) {
            int middle;
            la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
            if (la.theLabel.length() <= 2) continue;
            int split = -1;
            for (int j = middle = (int)Math.ceil((double)la.theLabel.length() / 2.0); j > 0 && split == -1; --j) {
                if (middle + (middle - j) < la.theLabel.length() && la.theLabel.charAt(middle + (middle - j)) == ' ') {
                    split = middle + (middle - j);
                    continue;
                }
                if (la.theLabel.charAt(j) != ' ') continue;
                split = j;
            }
            if (split == -1) continue;
            la.theLabel = la.theLabel.substring(0, split) + '\n' + la.theLabel.substring(split + 1, la.theLabel.length());
            la.width = this.channel.glGetTextWidth(la.theLabel);
            la.height = this.channel.glGetTextHeight(la.theLabel);
        }
    }

    private void splitAxis(boolean splitAlways) {
        if (this.hotelText && this.orientation == 1) {
            this.splitAxisToHotelText();
            return;
        }
        this.labelSplitWidth = this.computeLabelSplitWidth();
        if (this.labelSplitChar == null && Double.isNaN(this.labelSplitWidth)) {
            return;
        }
        AAxis.LabelAlignment la = null;
        for (int i = 0; i < this.processedLabels.size(); ++i) {
            String[] labs;
            la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
            if (la.theLabel.length() < 2 || !splitAlways && la.width <= this.labelSplitWidth || (labs = this.splitLabel(la.theLabel, splitAlways, this.labelSplitChar, this.labelSplitCharDrop, this.labelSplitWidth, this.style.getLabelStyle().getFont())).length < 2 && labs[0].equals(la.theLabel)) continue;
            la.theLabel = labs[0];
            for (int j = 1; j < labs.length; ++j) {
                la.theLabel = la.theLabel + '\n';
                la.theLabel = la.theLabel + labs[j];
            }
            la.width = this.channel.glGetTextWidth(la.theLabel);
            la.height = this.channel.glGetTextHeight(la.theLabel);
            if (labs.length < 2) continue;
            this.splitLabels = true;
        }
        this.allocatedLabelSize = Double.NaN;
    }

    private void splitAxisToHotelText() {
        this.labelSplitWidth = this.computeLabelSplitWidth();
        if (Double.isNaN(this.labelSplitWidth)) {
            return;
        }
        AAxis.LabelAlignment la = null;
        for (int i = 0; i < this.processedLabels.size(); ++i) {
            la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
            int length = la.theLabel.length();
            if (length < 2) continue;
            char[] hotelText = new char[length * 2 - 1];
            int idx = 0;
            for (int j = 0; j < length - 1; ++j) {
                hotelText[idx++] = la.theLabel.charAt(j);
                hotelText[idx++] = 10;
            }
            hotelText[idx] = la.theLabel.charAt(length - 1);
            la.theLabel = new String(hotelText);
            la.width = this.channel.glGetTextWidth(la.theLabel);
            la.height = this.channel.glGetTextHeight(la.theLabel);
            this.splitLabels = true;
        }
        this.allocatedLabelSize = Double.NaN;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] splitLabel(String theLabel, boolean splitAlways, char[] splitChars, boolean splitCharDrop, double splitWidth, Font font) {
        ArrayList<String> split = new ArrayList<String>();
        boolean delimiterPrev = false;
        String str = "";
        String currWord = "";
        String currDelimiter = "";
        String lastWord = "";
        for (int i = 0; i < theLabel.length(); ++i) {
            String line;
            int l;
            char c;
            block17: {
                block19: {
                    block18: {
                        c = theLabel.charAt(i);
                        if (!this.isDelimiter(c, splitChars)) break block17;
                        if (splitAlways || splitCharDrop || lastWord.length() <= 0 || Double.isNaN(splitWidth)) break block18;
                        StringBuilder stringBuilder = new StringBuilder();
                        if (!(this.getTextWidth(stringBuilder.append(str).append(c).toString(), font) > splitWidth)) break block18;
                        l = delimiterPrev ? currDelimiter.length() + lastWord.length() : currWord.length();
                        line = str.substring(0, str.length() - l);
                        if (line.length() > 0) {
                            split.add(line);
                            str = str.substring(line.length());
                            if (!delimiterPrev) {
                                lastWord = currWord;
                                currWord = "";
                                currDelimiter = "";
                            }
                        }
                        break block19;
                    }
                    if (!delimiterPrev) {
                        lastWord = currWord;
                        currWord = "";
                        currDelimiter = "";
                    }
                }
                str = str + c;
                currDelimiter = currDelimiter + c;
                delimiterPrev = true;
                continue;
            }
            if (delimiterPrev && splitAlways) {
                String line2 = lastWord;
                if (!splitCharDrop && currDelimiter.length() > 0) {
                    line2 = line2 + currDelimiter;
                }
                if (line2.length() > 0) {
                    split.add(line2);
                }
                str = Character.toString(c);
                currWord = Character.toString(c);
                currDelimiter = "";
                delimiterPrev = false;
                continue;
            }
            if (!Double.isNaN(splitWidth)) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.getTextWidth(stringBuilder.append(str).append(c).toString(), font) > splitWidth) {
                    l = splitCharDrop ? currDelimiter.length() + currWord.length() : currWord.length();
                    line = str.substring(0, str.length() - l);
                    if (line.length() > 0) {
                        split.add(line);
                    }
                    str = currWord + c;
                    currWord = currWord + c;
                    currDelimiter = "";
                    lastWord = "";
                    delimiterPrev = false;
                    continue;
                }
            }
            str = str + c;
            currWord = currWord + c;
            delimiterPrev = false;
        }
        if (str.length() > 0) {
            if (splitAlways && delimiterPrev && splitCharDrop) {
                if ((str = str.substring(0, str.length() - currDelimiter.length())).length() > 0) {
                    split.add(str);
                }
            } else {
                split.add(str);
            }
        }
        if (split.size() == 0) {
            return new String[]{""};
        }
        String[] labs = new String[split.size()];
        int i = 0;
        while (i < split.size()) {
            labs[i] = (String)split.get(i);
            ++i;
        }
        return labs;
    }

    private double getTextWidth(String text, Font font) {
        FontMetrics fm = this.channel.getBackbufferGC().getFontMetrics(font);
        return fm.getStringBounds(text, this.channel.getBackbufferGC()).getWidth();
    }

    private boolean isDelimiter(char c, char[] splitChars) {
        if (splitChars == null) {
            return false;
        }
        for (int i = 0; i < splitChars.length; ++i) {
            if (c != splitChars[i]) continue;
            return true;
        }
        return false;
    }

    private double computeAllocatedLabelSize() {
        if (Double.isNaN(this.maximumAllocatedSize)) {
            return Double.NaN;
        }
        double result = -1.0;
        if (this.getOrientation() == 2) {
            result = this.maximumAllocatedSize;
            if (this.isTitleOn()) {
                this.setupChannelWithStyle(this.style.getTitleStyle());
                result -= this.hotelText ? this.channel.glGetTextWidth(this.displayTitle) : this.channel.glGetTextHeight(this.displayTitle);
                result -= this.style.getTitleSpace() * this.currentlabelHeight;
                this.setupChannelWithStyle(this.style.getLabelStyle());
            }
            if (this.style.isMajorTickMarksOn()) {
                double tickLength = this.getTickLength(this.style.getMajorTickStyle());
                switch (this.style.getMajorTickStyle().getTickMarkJustification()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        result -= tickLength;
                        break;
                    }
                    case 2: {
                        result -= tickLength / 2.0;
                    }
                }
            } else {
                result -= this.extraWhiteSpaceWhenNoMajorTicks();
            }
            result -= this.extraSpaceForTickBox();
            result -= this.computeLabelSpace();
        } else if (this.getOrientation() == 1) {
            result = this.maximumAllocatedSize;
            if (this.isTitleOn()) {
                this.setupChannelWithStyle(this.style.getTitleStyle());
                result -= this.channel.glGetTextHeight(this.displayTitle);
                result -= this.style.getTitleSpace() * this.currentlabelHeight;
                this.setupChannelWithStyle(this.style.getLabelStyle());
            }
            if (this.style.isMajorTickMarksOn()) {
                double tickLength = this.currentlabelHeight * this.style.getMajorTickStyle().getLength();
                switch (this.style.getMajorTickStyle().getTickMarkJustification()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        result -= tickLength;
                        break;
                    }
                    case 2: {
                        result -= tickLength / 2.0;
                    }
                }
            }
            result -= this.computeLabelSpace();
        }
        return result;
    }

    private double computeLabelSplitWidth() {
        int labelCount;
        if (!Double.isNaN(this.fixedLabelSplitWidth)) {
            return this.fixedLabelSplitWidth;
        }
        if (this.orientation == 2) {
            return this.allocatedLabelSize;
        }
        if (this.orientation == 1 && (labelCount = this.processedLabels.size()) > 1) {
            AAxis.LabelAlignment la1 = (AAxis.LabelAlignment)this.processedLabels.elementAt(0);
            AAxis.LabelAlignment la2 = (AAxis.LabelAlignment)this.processedLabels.elementAt(1);
            return Math.abs(la2.offset - la1.offset) - (double)this.currentLabelMargin;
        }
        return Double.NaN;
    }

    public double getLabelSplitWidth() {
        return this.labelSplitWidth;
    }

    private void angleAxis(int angle) {
        Bbox b = this.tempBbox;
        this.valueAngle = angle;
        this.justify(this.style.getLabelStyle());
        this.currentLabelAngle = angle;
        for (int i = 0; i < this.processedLabels.size(); ++i) {
            AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
            if (angle == 45 || angle == 315) {
                this.channel.glAlignment(this.justifyLabelH, this.justifyLabelV);
                this.channel.glGetText2DBbox(la.theLabel, 0.0, 0.0, 0.0, angle, b);
                la.height = b.getSizeY();
                la.width = b.getSizeX();
                la.angleOffset = b.xmin;
                continue;
            }
            if (angle != 90 && angle != 270) continue;
            double temp = la.height;
            la.height = la.width;
            la.width = temp;
        }
        this.currentLabelMargin = 0;
    }

    private void removeAllLabels() {
        for (int i = 0; i < this.processedLabels.size(); ++i) {
            AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
            la.width = 1.0;
            la.height = 1.0;
            la.drop = true;
        }
    }

    private void revertAxis(boolean resetSize) {
        this.processedLabels.setSize(this.originalProcessedLabels.size());
        this.processedLabels.trimToSize();
        for (int i = 0; i < this.originalProcessedLabels.size(); ++i) {
            AAxis.LabelAlignment la1 = (AAxis.LabelAlignment)this.originalProcessedLabels.get(i);
            AAxis.LabelAlignment la2 = (AAxis.LabelAlignment)this.processedLabels.get(i);
            if (la2 == null) {
                la2 = new AAxis.LabelAlignment(la1);
                this.processedLabels.set(i, la2);
            } else {
                la2.set(la1);
            }
            if (resetSize) continue;
            la2.width = 0.0;
            la2.height = 0.0;
        }
        this.valueAngle = 0;
        this.currentLabelMargin = this.labelMargin;
        this.forceHJustification = false;
        this.staggering = false;
        this.splitLabels = false;
        this.justify(this.style.getLabelStyle());
        this.forceHJustification = false;
        if (resetSize) {
            this.currentLabelFont = this.style.getLabelStyle().getFont();
            this.channel.glSelect2DFont(this.currentLabelFont);
        }
    }

    private void revertAxisSize() {
        Font styleFont = this.style.getLabelStyle().getFont();
        int newSize = this.style.getLabelStyle().getFont().getSize();
        this.currentLabelFont = styleFont.deriveFont(styleFont.getStyle(), newSize);
        this.channel.glSelect2DFont(this.currentLabelFont);
        for (int i = 0; i < this.processedLabels.size(); ++i) {
            AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
            la.width = this.channel.glGetTextWidth(la.theLabel);
            la.height = this.channel.glGetTextHeight(la.theLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean labelsFit() {
        AAxis.LabelAlignment la1;
        Vector vector = this.processedLabels;
        synchronized (vector) {
        }
        int labelCount = this.processedLabels.size();
        double maxLabelDepth = Double.POSITIVE_INFINITY;
        Vec3d maximumSize = this.getMaximumSize();
        if (labelCount == 1 && maximumSize != null) {
            la1 = (AAxis.LabelAlignment)this.processedLabels.elementAt(0);
            if (la1.width > maximumSize.x || la1.height > maximumSize.y) {
                return false;
            }
        } else {
            if (this.valueAngle == 315 || this.valueAngle == 45) {
                double margin;
                la1 = (AAxis.LabelAlignment)this.processedLabels.elementAt(0);
                AAxis.LabelAlignment la2 = (AAxis.LabelAlignment)this.processedLabels.elementAt(1);
                if (la2.drop) {
                    for (int i = 2; i < this.processedLabels.size(); ++i) {
                        la2 = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                        if (!la2.drop) break;
                    }
                }
                double d = margin = this.addLabelMargin ? (double)this.getLabelMargin() : 0.0;
                return la2.offset - la1.offset >= this.currentlabelHeight + margin;
            }
            if (this.valueAngle == 270 || this.valueAngle == 90) {
                if (maximumSize == null) {
                    labelCount = 2;
                } else {
                    maxLabelDepth = this.computeMaxLableDepth();
                }
            }
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < labelCount; ++i) {
                la1 = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                if (la1.drop) continue;
                if (this.justifyLabelH == 1) {
                    la1 = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                    minX = Math.min(minX, la1.offset - la1.width / 2.0);
                    maxX = Math.max(maxX, la1.offset + la1.width / 2.0);
                }
                if (i == labelCount - 1) continue;
                AAxis.LabelAlignment la2 = (AAxis.LabelAlignment)this.processedLabels.elementAt(i + 1);
                if (!Double.isNaN(this.allocatedLabelSize) && (this.labelOrientation == 2 && la1.height > this.allocatedLabelSize || this.labelOrientation == 1 && la1.width > this.allocatedLabelSize)) {
                    return false;
                }
                if (la1.height > maxLabelDepth) {
                    return false;
                }
                if (maximumSize != null && (la1.width > maximumSize.x || la2.width > maximumSize.x) && this.style.isLabelsOn()) {
                    return false;
                }
                int next = i + 1;
                while ((la2.adjacentToAxis != la1.adjacentToAxis || la2.drop) && next + 1 < this.processedLabels.size()) {
                    la2 = (AAxis.LabelAlignment)this.processedLabels.elementAt(++next);
                }
                if (la2.adjacentToAxis != la1.adjacentToAxis || la2.drop || !this.labelsOverlap(la1, la2)) continue;
                return false;
            }
            if (maximumSize != null && maxX - minX > maximumSize.x) {
                return false;
            }
        }
        return true;
    }

    private boolean labelsOverlap(AAxis.LabelAlignment la1, AAxis.LabelAlignment la2) {
        AAxis.LabelAlignment firstLa;
        AAxis.LabelAlignment secondLa;
        if (this.use3DFitting) {
            return la1.deviceCoords.intersects(la2.deviceCoords);
        }
        if (la1 == null || la2 == null) {
            return false;
        }
        if (la1.offset > la2.offset) {
            secondLa = la1;
            firstLa = la2;
        } else {
            secondLa = la2;
            firstLa = la1;
        }
        if ((this.orientation == 1 || this.orientation == 3) && (this.justifyLabelH == 0 ? firstLa.offset + firstLa.width + (double)this.currentLabelMargin > secondLa.offset : (this.justifyLabelH == 2 ? firstLa.offset > secondLa.offset - secondLa.width - (double)this.currentLabelMargin : firstLa.offset + firstLa.width / 2.0 + (double)this.currentLabelMargin > secondLa.offset - secondLa.width / 2.0))) {
            return true;
        }
        return (this.orientation == 2 || this.orientation == 3) && (this.justifyLabelV == 0 ? firstLa.offset + firstLa.height > secondLa.offset : (this.justifyLabelV == 3 ? firstLa.offset > secondLa.offset - secondLa.height : firstLa.offset + firstLa.height / 2.0 > secondLa.offset - secondLa.height / 2.0));
    }

    public int getTruncateEndCount() {
        return this.truncateEndCount;
    }

    public int getTruncateStartCount() {
        return this.truncateStartCount;
    }

    public void setTruncateEndCount(int truncateEndCount) {
        this.truncateEndCount = truncateEndCount;
    }

    public void setTruncateStartCount(int truncateStartCount) {
        this.truncateStartCount = truncateStartCount;
    }

    public int getTruncateAngleEndCount() {
        return this.truncateAngleEndCount;
    }

    public int getTruncateAngleStartCount() {
        return this.truncateAngleStartCount;
    }

    public void setTruncateAngleEndCount(int truncateAngleEndCount) {
        this.truncateAngleEndCount = truncateAngleEndCount;
    }

    public void setTruncateAngleStartCount(int truncateAngleStartCount) {
        this.truncateAngleStartCount = truncateAngleStartCount;
    }

    public boolean isMetricsVisible() {
        return this.metricsVisible;
    }

    public void setMetricsVisible(boolean trueOrFalse) {
        this.metricsVisible = trueOrFalse;
    }

    public int getStaggerThreshold() {
        return this.staggerThreshold;
    }

    public void setStaggerThreshold(int staggerThreshold) {
        this.staggerThreshold = staggerThreshold;
    }

    public void setIgnoreFudge(boolean b) {
        this.ignoreFudge = b;
    }

    private boolean findLabelsHaveBeenThinned() {
        int n = this.processedLabels.size();
        for (int i = 0; i < n; ++i) {
            AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.get(i);
            if (!la.drop) continue;
            return true;
        }
        return false;
    }

    private int[] findVisibleLabelIndices() {
        int i;
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (i = 0; i < this.processedLabels.size(); ++i) {
            AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.get(i);
            if (la.drop) continue;
            indexList.add(new Integer(i));
        }
        int[] result = new int[indexList.size()];
        for (i = 0; i < indexList.size(); ++i) {
            result[i] = (Integer)indexList.get(i);
        }
        return result;
    }

    private void invokePostFitProcessor() {
        if (this.getPostFitProcessor() != null && (!this.getMetricsExecuting || this.invokePostFitProcessorDuringGetMetrics && this.getMetricsExecuting)) {
            this.postFitInfo.setFittingAlgorithm(this.lastLabelFittingAlgorithm);
            this.getPostFitProcessor().postFitUpdate(this.postFitInfo);
        }
    }

    public boolean isInvokePostFitProcessorDuringGetMetrics() {
        return this.invokePostFitProcessorDuringGetMetrics;
    }

    public void setInvokePostFitProcessorDuringGetMetrics(boolean invokePostFitProcessorDuringGetMetrics) {
        this.invokePostFitProcessorDuringGetMetrics = invokePostFitProcessorDuringGetMetrics;
    }

    public void setTitleList(String[] list) {
        this.titleList = list;
    }

    public String[] getTitleList() {
        return this.titleList;
    }

    public boolean isDisplayTitleFit() {
        if (this.titleFitPolicy == 0) {
            return this.displayTitleFits();
        }
        return true;
    }

    static /* synthetic */ String[] access$202(Axis x0, String[] x1) {
        x0.fitAlgorithm = x1;
        return x1;
    }

    private class PostFitInfoImpl
    implements AAxis.PostFitContext {
        private String fittingAlgorithm = null;

        private PostFitInfoImpl() {
        }

        @Override
        public int[] getVisibleLabelIndices() {
            return Axis.this.findVisibleLabelIndices();
        }

        @Override
        public void setDisplayLabels(String[] labels, double[] labelOffsets) {
            if (labels == null || labelOffsets == null) {
                return;
            }
            if (labels.length != labelOffsets.length) {
                throw new IllegalArgumentException("The \"labels\" and \"labelOffsets\" arrays must be the same length.");
            }
            String[] fitAlgorithmSave = Axis.this.fitAlgorithm;
            Axis.access$202(Axis.this, new String[0]);
            Axis.this.originalProcessedLabels.setSize(labels.length);
            for (int i = 0; i < labels.length; ++i) {
                AAxis.LabelAlignment la = (AAxis.LabelAlignment)Axis.this.originalProcessedLabels.get(i);
                if (la == null) {
                    la = new AAxis.LabelAlignment(i, labels[i], labelOffsets[i], null);
                    Axis.this.originalProcessedLabels.set(i, la);
                    continue;
                }
                la.init(i, labels[i], labelOffsets[i], la.secondaryLabel);
            }
            Axis.this.processLabels();
            Axis.access$202(Axis.this, fitAlgorithmSave);
        }

        @Override
        public void setDisplayTitles(String title, String shortTitle) {
            Axis.this.processTitles(title, shortTitle);
        }

        @Override
        public boolean labelsHaveBeenThinned() {
            int n = Axis.this.processedLabels.size();
            for (int i = 0; i < n; ++i) {
                AAxis.LabelAlignment la = (AAxis.LabelAlignment)Axis.this.processedLabels.get(i);
                if (!la.drop) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isRendering() {
            return !Axis.this.getMetricsExecuting;
        }

        public void setFittingAlgorithm(String algorithm) {
            if (algorithm.length() == 0) {
                algorithm = null;
            }
            this.fittingAlgorithm = algorithm;
        }

        @Override
        public String getFittingAlgorithm() {
            return this.fittingAlgorithm;
        }
    }
}

