/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.SASColors;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericTableModelVariable;
import com.sas.graphics.util.gtk.Property;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.SelectEntry;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringTableModelVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.AnnotationSelectDetail;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.table.TableModel;

public class Annotation
extends Element {
    public final StringProperty function = new StringProperty(this, true);
    public final StringProperty text = new StringProperty(this, true);
    public final StringProperty color = new StringProperty(this, true);
    public final StringProperty style = new StringProperty(this, true);
    public final NumericProperty size = new NumericProperty(this, true);
    public final StringProperty hsys = new StringProperty(this, true);
    public final NumericProperty x = new NumericProperty(this, true);
    public final StringProperty xsys = new StringProperty(this, true);
    public final NumericProperty y = new NumericProperty(this, true);
    public final StringProperty ysys = new StringProperty(this, true);
    public final StringProperty position = new StringProperty(this, true);
    public final StringProperty html = new StringProperty(this, true);
    public final NumericProperty line = new NumericProperty(this, true);
    public final NumericProperty angle = new NumericProperty(this, true);
    public final StringProperty cborder = new StringProperty(this, true);
    public final StringProperty cbox = new StringProperty(this, true);
    public final NumericProperty rotate = new NumericProperty(this, true);
    public final NumericProperty width = new NumericProperty(this, true);
    public final NumericProperty transparency = new NumericProperty(this, true);
    private List variables = new ArrayList();
    private int valueCount;
    private boolean visible = true;
    private final AnnotationState state = new AnnotationState();
    private ColumnToProperty[] columnNameToProperty = new ColumnToProperty[]{new ColumnToProperty("function", this.function), new ColumnToProperty("text", this.text), new ColumnToProperty("color", this.color), new ColumnToProperty("style", this.style), new ColumnToProperty("size", this.size), new ColumnToProperty("hsys", this.hsys), new ColumnToProperty("x", this.x), new ColumnToProperty("xsys", this.xsys), new ColumnToProperty("y", this.y), new ColumnToProperty("ysys", this.ysys), new ColumnToProperty("position", this.position), new ColumnToProperty("html", this.html), new ColumnToProperty("line", this.line), new ColumnToProperty("angle", this.angle), new ColumnToProperty("cborder", this.cborder), new ColumnToProperty("cbox", this.cbox), new ColumnToProperty("rotate", this.rotate), new ColumnToProperty("width", this.width), new ColumnToProperty("transparency", this.transparency)};

    public void setDataBounds(BoundingBox dbox) {
        this.state.dataBox = dbox;
    }

    public BoundingBox getDataBounds() {
        return this.state.dataBox;
    }

    public Annotation() {
        super(new Transform());
        this.transparency.setValue(1.0);
        this.width.setValue(1.0);
        this.angle.setValue(Double.NaN);
    }

    @Override
    protected void getBoundingBox(AComputeBoundingBoxAction boxAction) throws MissingValueException {
    }

    @Override
    public void init(AInitAction initAction) {
        initAction.pushValueCount();
        super.init(initAction);
        this.valueCount = initAction.getValueCount();
        if (this.valueCount == -1) {
            this.valueCount = 1;
        }
        this.setValueCount(1);
        initAction.popValueCount();
        initAction.setValueCount(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void render(ABuildAction buildAction) throws MissingValueException {
        if (!this.visible) {
            return;
        }
        Channel ch = (Channel)buildAction.getGraphicsContext();
        this.state.begin(ch);
        ch.glEdgeFlag(true);
        int i = 0;
        while (true) {
            block19: {
                if (i >= this.valueCount) {
                    this.state.end(this.valueCount - 1);
                    return;
                }
                if (buildAction.isUseNameStack()) {
                    ch.glPopName();
                    ch.glLoadName((Object)new SelectEntry(this, i));
                    ch.glPushName((Object)new Integer(i));
                }
                try {
                    this.state.beginFunction(this.function, i);
                    this.state.validateCoordinateSystems(this.xsys, this.ysys, this.hsys, i);
                    this.state.translateCoordinates(this.x, this.y, this.size, i);
                    this.state.setColor(this.color, this.transparency, i);
                    switch (this.state.getFunction()) {
                        case 5: {
                            this.state.newPolygon(i);
                            this.state.setStyle(this.style, i);
                            this.state.setLineWidth();
                            this.state.setLineStipple(this.line, i);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 6: {
                            if (this.state.isFunctionContinued() || this.state.flast == 5) {
                                this.state.addPoint();
                                break;
                            }
                            break block19;
                        }
                        case 4: 
                        case 7: {
                            this.state.setLineWidth();
                            this.state.setLineStipple(this.line, i);
                            if (this.state.isFunctionContinued()) {
                                this.state.addPoint();
                                break;
                            }
                            this.state.newLine();
                            break;
                        }
                        case 0: {
                            this.state.setBackgroundColor(this.cbox, i);
                            this.state.setBorderColor(this.cborder, i);
                            this.state.setPosition(this.position, i);
                            this.state.setFont(this.style, i);
                            this.state.addText(this.text, this.angle, i);
                            break;
                        }
                        case 1: {
                            this.state.setBackgroundColor(this.cborder, i);
                            this.state.setBorderColor(this.cbox, i);
                        }
                        case 2: {
                            this.state.addMarker(this.text, this.style, i);
                            break;
                        }
                        case 8: {
                            this.state.setStyle(this.style, i);
                            this.state.setLineWidth(this.width, i);
                            this.state.addPieSlice(this.angle, this.rotate, i);
                            break;
                        }
                        case 9: 
                        case 10: {
                            this.state.setLineWidth();
                            this.state.setLineStipple(this.line, i);
                            this.state.setStyle(this.style, i);
                            this.state.addRectangle(i);
                        }
                    }
                    this.state.endFunction();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    @Override
    protected SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entrySize = (Integer)nameStack.elementAt(startIndex);
        Integer firstValueIndexOfPrimitive = (Integer)nameStack.elementAt(startIndex + entrySize - 1);
        AnnotationSelectDetail asd = new AnnotationSelectDetail();
        String htmlString = "";
        try {
            htmlString = this.html.getValue(firstValueIndexOfPrimitive);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        asd.setHtml(htmlString);
        return asd;
    }

    public void dispose() {
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable v = (Variable)this.variables.get(i);
            v.disconnect();
        }
        this.variables.clear();
    }

    public void connectAnnotationElement(TableModel tableModel) {
        this.dispose();
        for (int i = 0; i < this.columnNameToProperty.length; ++i) {
            int columnIndex = Annotation.findColumnIndex(tableModel, this.columnNameToProperty[i].columnName);
            if (columnIndex < 0) continue;
            Property p = this.columnNameToProperty[i].property;
            if (p instanceof StringProperty) {
                StringTableModelVariable sv = new StringTableModelVariable();
                sv.connectFrom(tableModel, columnIndex);
                ((StringProperty)p).connectFrom(sv.value);
                continue;
            }
            NumericTableModelVariable nv = new NumericTableModelVariable();
            nv.connectFrom(tableModel, columnIndex);
            ((NumericProperty)p).connectFrom(nv.value);
        }
    }

    private static int findColumnIndex(TableModel tableModel, String columnName) {
        int columnCount = tableModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (!columnName.equalsIgnoreCase(tableModel.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    private static class AnnotationState {
        private static final int INVALID_FUNCTION = -1;
        private static final String FUNCTION_LABEL = "label";
        private static final int FUNCTION_LABEL_ID = 0;
        private static final String FUNCTION_SYMBOL = "symbol";
        private static final int FUNCTION_SYMBOL_ID = 1;
        private static final String FUNCTION_POINT = "point";
        private static final int FUNCTION_POINT_ID = 2;
        private static final String FUNCTION_MOVE = "move";
        private static final int FUNCTION_MOVE_ID = 3;
        private static final String FUNCTION_DRAW = "draw";
        private static final int FUNCTION_DRAW_ID = 4;
        private static final String FUNCTION_POLY = "poly";
        private static final int FUNCTION_POLY_ID = 5;
        private static final String FUNCTION_POLYCONT = "polycont";
        private static final int FUNCTION_POLYCONT_ID = 6;
        private static final String FUNCTION_DRAW2TXT = "draw2txt";
        private static final int FUNCTION_DRAW2TXT_ID = 7;
        private static final String FUNCTION_PIE = "pie";
        private static final int FUNCTION_PIE_ID = 8;
        private static final String FUNCTION_FRAME = "frame";
        private static final int FUNCTION_FRAME_ID = 9;
        private static final String FUNCTION_BAR = "bar";
        private static final int FUNCTION_BAR_ID = 10;
        private static final String FUNCTION_TXT2CNTL = "txt2cntl";
        private static final int FUNCTION_TXT2CNTL_ID = 11;
        private static final String FUNCTION_CNTL2TXT = "cntl2txt";
        private static final int FUNCTION_CNTL2TXT_ID = 12;
        private static final String FUNCTION_SWAP = "swap";
        private static final int FUNCTION_SWAP_ID = 13;
        private static final char SYS_DATA_PERCENT_ABSOLUTE = '1';
        private static final char SYS_DATA_COORD_ABSOLUTE = '2';
        private static final char SYS_GRAPHICS_PERCENT_ABSOLUTE = '3';
        private static final char SYS_GRAPHICS_CELL_ABSOLUTE = '4';
        private static final char SYS_OUTPUT_PERCENT_ABSOLUTE = '5';
        private static final char SYS_OUTPUT_CELL_ABSOLUTE = '6';
        private static final char SYS_DATA_PERCENT_RELATIVE = '7';
        private static final char SYS_DATA_COORD_RELATIVE = '8';
        private static final char SYS_GRAPHICS_PERCENT_RELATIVE = '9';
        private static final char SYS_GRAPHICS_CELL_RELATIVE = 'A';
        private static final char SYS_OUTPUT_PERCENT_RELATIVE = 'B';
        private static final char SYS_OUTPUT_CELL_RELATIVE = 'C';
        private static final char SYS_POINT_SIZE = 'D';
        private SASColors sasColors = SASColors.getInstance();
        private BoundingBox dataBox = null;
        private double xlast;
        private double ylast;
        private double xlstt;
        private double ylstt;
        private Channel ch = null;
        private int func;
        private int flast;
        private boolean isText;
        private boolean isDrawingPrimitive = false;
        private char xsys;
        private char ysys;
        private char hsys;
        private double[] vp;
        private double x;
        private double y;
        private double cellsize;
        private double size;
        private double lastAngle;
        private Color currentColor;
        private int firstIndexOfPrimitive;

        private AnnotationState() {
        }

        protected void begin(Channel channel) {
            this.ch = channel;
            this.vp = channel.glGetDoublev(0);
            this.flast = -1;
            this.func = -1;
            this.isDrawingPrimitive = false;
            this.isText = false;
            this.lastAngle = 0.0;
            this.cellsize = FontManager.getDefaultFont().getSize();
            this.cellsize /= 72.0;
            this.cellsize *= 72.0;
            channel.setLineJoinStyle(0);
            this.xlstt = this.xlast = this.translateToDataSystem(0.0, 0.0, '6', this.dataBox.getSize().x, this.dataBox.getMinimum().x, this.vp[2], 0);
            this.ylstt = this.ylast = this.translateToDataSystem(0.0, 0.0, '6', this.dataBox.getSize().y, this.dataBox.getMinimum().y, this.vp[3], 1);
        }

        protected void end(int i) {
            if (this.isDrawingPrimitive) {
                this.endPrimitive(i);
            }
        }

        protected void copyText2Cntl() {
            this.xlast = this.xlstt;
            this.ylast = this.ylstt;
        }

        protected void copyCntl2Text() {
            this.xlstt = this.xlast;
            this.ylstt = this.ylast;
        }

        protected void swapCntlAndText() {
            double t = this.xlast;
            this.xlast = this.xlstt;
            this.xlstt = t;
            t = this.ylast;
            this.ylast = this.ylstt;
            this.ylstt = t;
        }

        protected void newPolygon(int i) {
            this.ch.glBegin(2);
            this.ch.glVertex(this.x, this.y);
            this.firstIndexOfPrimitive = i;
        }

        protected void newLine() {
            this.ch.glBegin(1);
            this.ch.glVertex(this.getLastX(), this.getLastY());
            this.addPoint();
        }

        protected void addPoint() {
            this.ch.glVertex(this.x, this.y);
            this.isDrawingPrimitive = true;
        }

        protected void setStyle(StringProperty s, int i) {
            String style = this.getString(s, i);
            if (style.length() == 0 || style.indexOf("empty") >= 0 || style.length() < 3 && style.indexOf(101) == style.length() - 1) {
                this.ch.glEdgeColor(this.currentColor);
                this.ch.glPolygonMode(2);
            } else if (this.func == 8) {
                this.ch.glPolygonMode(3);
            } else {
                this.ch.glPolygonMode(4);
            }
        }

        protected void setLineWidth(NumericProperty w, int i) {
            double width = this.getNumber(w, i, 1.0);
            this.ch.glLineWidth((float)width);
        }

        protected void setLineWidth() {
            if (this.size < 1.0) {
                this.size = 1.0;
            }
            this.ch.glLineWidth((float)((int)(this.size + 0.5)));
        }

        protected void setLineStipple(NumericProperty ls, int i) {
            int line = (int)this.getNumber(ls, i, 0.0);
            if (line > 1) {
                this.ch.glEnable(6);
                this.ch.glLineStipple(SASLinePatterns.getStippleFactor((int)line), SASLinePatterns.getStipplePattern((int)line));
            } else {
                this.ch.glDisable(6);
            }
        }

        protected void setBackgroundColor(StringProperty p, int i) {
            Color c = this.currentColor;
            String s = this.getString(p, i);
            c = s.equalsIgnoreCase("ctext") ? this.currentColor : this.sasColors.getColor(s.toUpperCase());
            if (c != null) {
                this.ch.setRasterBackgroundColor(c);
            }
        }

        protected void setBorderColor(StringProperty p, int i) {
            Color c = this.currentColor;
            String s = this.getString(p, i);
            c = s.equalsIgnoreCase("cback") ? this.ch.getBackgroundColor() : this.sasColors.getColor(s.toUpperCase());
            if (c != null) {
                this.ch.setRasterBackgroundEdgeColor(c);
            }
        }

        protected void setPosition(StringProperty p, int i) {
            int ypos;
            int xpos;
            String s = this.getString(p, i);
            int chpos = s.length() > 0 ? s.toUpperCase().toCharArray()[0] : 43;
            switch (chpos) {
                case 49: 
                case 52: 
                case 55: 
                case 60: 
                case 65: 
                case 68: {
                    xpos = 2;
                    break;
                }
                default: {
                    xpos = 1;
                    break;
                }
                case 51: 
                case 54: 
                case 57: 
                case 62: 
                case 67: 
                case 70: {
                    xpos = 0;
                }
            }
            switch (chpos) {
                case 49: 
                case 50: 
                case 51: 
                case 65: 
                case 66: 
                case 67: {
                    ypos = 3;
                    break;
                }
                default: {
                    ypos = 1;
                    break;
                }
                case 55: 
                case 56: 
                case 57: 
                case 68: 
                case 69: 
                case 70: {
                    ypos = 0;
                }
            }
            this.ch.glAlignment(xpos, ypos);
        }

        protected boolean isFunctionContinued() {
            return this.func == this.flast;
        }

        protected void setFont(StringProperty p, int i) {
            String s = this.getString(p, i);
            String[] fattr = s.split("/");
            int fstyle = FontManager.getDefaultFont().getStyle();
            if (fattr != null && fattr.length > 1) {
                if (fattr[1].indexOf("bo") == 0 || fattr[1].indexOf("BO") == 0) {
                    fstyle = 1;
                } else if (fattr[1].indexOf("it") == 0 || fattr[1].indexOf("IT") == 0) {
                    fstyle = 2;
                } else if (fattr[1].equalsIgnoreCase("plain") || fattr[1].equalsIgnoreCase("normal")) {
                    fstyle = 0;
                }
            }
            Font font = FontManager.getFont((String)(fattr != null && fattr.length > 0 ? fattr[0] : FontManager.getDefaultFont().getFontName()), (int)fstyle, (int)((int)this.size));
            this.ch.glSelect2DFont(font);
        }

        protected void addText(StringProperty t, NumericProperty a, int i) {
            String text = this.getString(t, i);
            double angle = this.getNumber(a, i, 0.0);
            this.ch.gl2DText(text, this.x, this.y, 0.0, (int)angle);
            this.ch.setRasterBackgroundColor(null);
            this.ch.setRasterBackgroundEdgeColor(null);
        }

        protected void addMarker(StringProperty t, StringProperty s, int i) {
            int markerType = this.func == 2 ? 16 : this.symbolToID(this.getString(t, i), this.getString(s, i));
            this.ch.glEdgeColor(this.currentColor);
            this.ch.setMarkerSize((int)this.size);
            this.ch.setMarkerType(markerType);
            this.ch.glMarker(this.x, this.y, 0.0);
            this.ch.setRasterBackgroundColor(null);
            this.ch.setRasterBackgroundEdgeColor(null);
        }

        protected void addPieSlice(NumericProperty a, NumericProperty r, int i) {
            if (this.xlast != this.x && this.ylast != this.y) {
                this.lastAngle = 0.0;
            }
            double angle = this.getNumber(a, i, this.lastAngle);
            double rotate = this.getNumber(r, i, 0.0);
            this.ch.glWedge(this.x, this.y, 0.0, this.size, angle, rotate);
            this.lastAngle += rotate;
            this.lastAngle %= 360.0;
        }

        protected void addRectangle(int i) {
            this.ch.glRect(this.x, this.y, this.getLastX(), this.getLastY());
        }

        protected void endFunction() {
            this.flast = this.func;
            switch (this.func) {
                case 12: {
                    this.xlstt = this.xlast;
                    this.ylstt = this.ylast;
                    break;
                }
                case 11: {
                    this.xlast = this.xlstt;
                    this.ylast = this.ylstt;
                    break;
                }
                case 13: {
                    double d = this.xlast;
                    this.xlast = this.xlstt;
                    this.xlstt = d;
                    d = this.ylast;
                    this.ylast = this.ylstt;
                    this.ylstt = d;
                    break;
                }
                default: {
                    if (this.isText) {
                        this.xlstt = this.x;
                        this.ylstt = this.y;
                        break;
                    }
                    this.xlast = this.x;
                    this.ylast = this.y;
                }
            }
        }

        protected double getLastX() {
            return this.isText ? this.xlstt : this.xlast;
        }

        protected double getLastY() {
            return this.isText ? this.ylstt : this.ylast;
        }

        protected double getDefaultSize() {
            return this.isPercent(this.hsys) ? 2.0 : 1.0;
        }

        private int symbolToID(String type, String style) {
            int markerType;
            boolean empty = style.equalsIgnoreCase("markere");
            int n = markerType = empty ? 0 : 16;
            markerType = type.equalsIgnoreCase("Plus") ? 1 : (type.equalsIgnoreCase("X") ? 4 : (type.equalsIgnoreCase("Star") ? 58 : (type.equalsIgnoreCase("Square") ? 3 : (type.equalsIgnoreCase("Diamond") ? 6 : (type.equalsIgnoreCase("Triangle") ? 2 : (type.equalsIgnoreCase("Circle") ? 0 : (type.equalsIgnoreCase("Dot") ? 16 : (type.equals(">") ? 25 : (type.equals("*") ? 24 : (type.equals("+") ? 40 : (type.equals("A") ? (empty ? 59 : 105) : (type.equals("B") ? (empty ? 60 : 106) : (type.equals("C") ? (empty ? 2 : 18) : (type.equals("D") ? (empty ? 5 : 21) : (type.equals("E") ? (empty ? 140 : 126) : (type.equals("F") ? (empty ? 143 : 127) : (type.equals("G") ? (empty ? 140 : 124) : (type.equals("H") ? (empty ? 141 : 125) : (type.equals("I") ? 138 : (type.equals("J") ? 139 : (type.equals("K") ? 104 : (type.equals("L") ? 137 : (type.equals("M") ? (empty ? 144 : 122) : (type.equals("N") ? (empty ? 69 : 121) : (type.equals("O") ? (empty ? 145 : 123) : (type.equals("P") ? (empty ? 6 : 22) : (type.equals("Q") ? (empty ? 131 : 129) : (type.equals("R") ? (empty ? 130 : 128) : (type.equals("S") ? (empty ? 52 : 17) : (type.equals("T") ? 58 : (type.equals("U") ? (empty ? 3 : 19) : (type.equals("V") ? (empty ? 54 : 23) : 1))))))))))))))))))))))))))))))));
            return markerType;
        }

        private boolean isPercent(char sysChar) {
            return sysChar == '1' || sysChar == '7' || sysChar == '3' || sysChar == '9' || sysChar == '5' || sysChar == 'B';
        }

        private String getString(StringProperty p, int i) {
            try {
                return p.getValue(i);
            }
            catch (MissingValueException e) {
                return "";
            }
        }

        private double getNumber(NumericProperty p, int i, double defaultValue) {
            try {
                return p.getValue(i);
            }
            catch (MissingValueException e) {
                return defaultValue;
            }
        }

        private void beginFunction(StringProperty f, int i) throws IllegalArgumentException {
            this.func = -1;
            this.isText = false;
            String functionString = this.getString(f, i);
            if (FUNCTION_LABEL.equalsIgnoreCase(functionString)) {
                this.isText = true;
                this.func = 0;
            } else if (FUNCTION_SYMBOL.equalsIgnoreCase(functionString)) {
                this.func = 1;
            } else if (FUNCTION_POINT.equalsIgnoreCase(functionString)) {
                this.func = 2;
            } else if (FUNCTION_MOVE.equalsIgnoreCase(functionString)) {
                this.func = 3;
            } else if (FUNCTION_DRAW.equalsIgnoreCase(functionString)) {
                this.func = 4;
            } else if (FUNCTION_POLY.equalsIgnoreCase(functionString)) {
                this.func = 5;
            } else if (FUNCTION_POLYCONT.equalsIgnoreCase(functionString)) {
                this.func = 6;
            } else if (FUNCTION_DRAW2TXT.equalsIgnoreCase(functionString)) {
                this.func = 7;
            } else if (FUNCTION_PIE.equalsIgnoreCase(functionString)) {
                this.func = 8;
            } else if (FUNCTION_FRAME.equalsIgnoreCase(functionString)) {
                this.func = 9;
            } else if (FUNCTION_BAR.equalsIgnoreCase(functionString)) {
                this.func = 10;
            } else if (FUNCTION_SWAP.equalsIgnoreCase(functionString)) {
                this.func = 13;
            } else if (FUNCTION_CNTL2TXT.equalsIgnoreCase(functionString)) {
                this.func = 12;
            } else if (FUNCTION_TXT2CNTL.equalsIgnoreCase(functionString)) {
                this.func = 11;
            }
            if (this.func == -1) {
                throw new IllegalArgumentException();
            }
            if (this.isDrawingPrimitive && !this.isFunctionContinued()) {
                this.endPrimitive(i);
            }
        }

        protected int getFunction() {
            return this.func;
        }

        private char getCoordinateSystem(StringProperty p, int i, char defaultValue) throws IllegalArgumentException {
            String s = this.getString(p, i);
            if (s.length() == 0) {
                return defaultValue;
            }
            if (s.length() > 1) {
                throw new IllegalArgumentException();
            }
            return s.toUpperCase().toCharArray()[0];
        }

        private void endPrimitive(int i) {
            this.ch.glLoadName((Object)new Integer(this.firstIndexOfPrimitive));
            this.ch.glEnd();
            this.ch.glLoadName((Object)new Integer(i));
            this.ch.glDisable(6);
            this.ch.glLineWidth(1.0f);
            this.isDrawingPrimitive = false;
        }

        protected void validateCoordinateSystems(StringProperty x, StringProperty y, StringProperty h, int i) {
            this.xsys = this.getCoordinateSystem(x, i, '4');
            this.ysys = this.getCoordinateSystem(y, i, '4');
            this.hsys = this.getCoordinateSystem(h, i, 'A');
        }

        protected void setColor(StringProperty p, NumericProperty t, int i) {
            if (this.func == 6 && this.flast == 6) {
                return;
            }
            String cString = this.getString(p, i);
            Color c = this.sasColors.getColor(cString.toUpperCase());
            if (c == null) {
                if (this.func == 6) {
                    this.ch.glPolygonMode(3);
                    return;
                }
                c = Color.BLACK;
            }
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(this.getNumber(t, i, 1.0) * 255.0 + 0.5));
            if (this.func == 6) {
                this.ch.glEdgeColor(c);
            } else {
                this.ch.glColor(c);
            }
            this.currentColor = c;
        }

        private void translateCoordinates(NumericProperty x, NumericProperty y, NumericProperty sz, int i) {
            if (this.func == 7) {
                this.x = this.xlstt;
                this.y = this.ylstt;
            } else {
                double lastx = this.getLastX();
                double lasty = this.getLastY();
                this.x = this.getNumber(x, i, lastx);
                this.y = this.getNumber(y, i, lasty);
                this.x = this.translateToDataSystem(this.x, lastx, this.xsys, this.dataBox.getSize().x, this.dataBox.getMinimum().x, this.vp[2], 0);
                this.y = this.translateToDataSystem(this.y, lasty, this.ysys, this.dataBox.getSize().y, this.dataBox.getMinimum().y, this.vp[3], 1);
            }
            this.size = this.getNumber(sz, i, this.getDefaultSize());
            this.size = this.isText ? this.getPointSize() : (this.func == 8 ? this.normalizeRadius() : this.translateSizeToPixels());
        }

        private double translateToDataSystem(double val, double lastVal, char sys, double dataSize, double dataMin, double viewportSize, int ord) {
            double[] scrn = new double[]{0.0, 0.0, 0.0};
            double[] data = new double[]{0.0, 0.0, 0.0};
            switch (sys) {
                case '1': {
                    val *= 0.01 * dataSize;
                    val += dataMin;
                    break;
                }
                default: {
                    break;
                }
                case '3': 
                case '5': {
                    scrn[ord] = ord == 0 ? val * 0.01 * viewportSize : (100.0 - val) * 0.01 * viewportSize;
                    this.ch.gluUnProject(scrn, data);
                    val = data[ord] + dataMin;
                    break;
                }
                case '4': 
                case '6': {
                    scrn[ord] = val * this.cellsize;
                    this.ch.gluUnProject(scrn, data);
                    val = data[ord];
                    break;
                }
                case '7': {
                    val = lastVal + val * 0.01 * dataSize;
                    break;
                }
                case '8': {
                    val += lastVal;
                    break;
                }
                case 'A': 
                case 'C': {
                    data[ord] = lastVal;
                    this.ch.gluProject(data, scrn);
                    int n = ord;
                    scrn[n] = scrn[n] + val * this.cellsize;
                    this.ch.gluUnProject(scrn, data);
                    val = data[ord];
                    break;
                }
                case '9': 
                case 'B': {
                    scrn[ord] = lastVal * val * 0.01 * viewportSize;
                    this.ch.gluUnProject(scrn, data);
                    val = data[ord];
                }
            }
            return val;
        }

        private double translateSizeToPixels() {
            double[] scr1 = new double[]{0.0, 0.0, 0.0};
            double[] scr2 = new double[]{0.0, 0.0, 0.0};
            double[] data = new double[]{0.0, 0.0, 0.0};
            double sz = this.size;
            if (this.hsys == 'D') {
                this.hsys = (char)65;
            }
            switch (this.hsys) {
                default: {
                    if (this.func == 7 || this.func == 4 || this.func == 3) {
                        sz = Math.round(sz);
                        break;
                    }
                    sz *= this.cellsize;
                    break;
                }
                case '1': 
                case '7': {
                    data[0] = this.dataBox.getMinimum().x;
                    data[1] = this.y;
                    this.ch.gluProject(data, scr1);
                    data[1] = data[1] + sz * 0.01 * this.dataBox.getSize().y;
                    this.ch.gluProject(data, scr2);
                    sz = Math.abs(scr2[1] - scr1[1]);
                    break;
                }
                case '2': 
                case '8': {
                    data[0] = this.dataBox.getMinimum().x;
                    data[1] = this.y;
                    this.ch.gluProject(data, scr1);
                    data[1] = data[1] + sz;
                    this.ch.gluProject(data, scr2);
                    sz = Math.abs(scr2[1] - scr1[1]);
                    break;
                }
                case '3': 
                case '5': 
                case '9': 
                case 'B': {
                    sz *= 0.01 * this.vp[3];
                }
            }
            return sz;
        }

        private double normalizeRadius() {
            double[] scr1 = new double[]{0.0, 0.0, 0.0};
            double[] scr2 = new double[]{0.0, 0.0, 0.0};
            double[] data = new double[]{0.0, 0.0, 0.0};
            double sz = this.size;
            if (this.hsys == 'D') {
                this.hsys = (char)65;
            }
            switch (this.hsys) {
                case '3': 
                case '5': 
                case '9': 
                case 'B': {
                    sz *= 0.01 * this.vp[3];
                }
                default: {
                    this.ch.gluUnProject(data, scr1);
                    data[1] = sz;
                    this.ch.gluUnProject(data, scr2);
                    sz = Math.abs(scr2[1] - scr1[1]);
                    break;
                }
                case '1': 
                case '7': {
                    sz *= 0.01 * this.dataBox.getSize().y;
                }
                case '2': 
                case '8': 
            }
            return sz;
        }

        private double getPointSize() {
            if (this.hsys == 'D') {
                return this.size;
            }
            double sz = this.translateSizeToPixels();
            double dpi = 72.0;
            if (!GraphicsEnvironment.isHeadless()) {
                dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            sz /= dpi;
            sz *= 72.0;
            sz = FontManager.adjustFontSize((double)sz);
            return sz;
        }
    }

    private static class ColumnToProperty {
        public final String columnName;
        public final Property property;

        public ColumnToProperty(String columnName, Property property) {
            this.columnName = columnName;
            this.property = property;
        }
    }
}

