/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.datatree;

import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.datatree.DataTreeResponseNode;
import java.text.Format;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DataTreeUtil {
    public static DataTreeGroupNode addGroupPath(DataTreeGroupNode root, List path, boolean addValueIndex) {
        if (path.size() <= 0) {
            return root;
        }
        DataTreeGroupNode currentNode = root;
        int n = path.size();
        for (int i = 0; i < n; ++i) {
            Object o = path.get(i);
            if (!(o instanceof DataTreeGroupNode)) {
                throw new IllegalStateException("Elements of path list must be of type " + DataTreeGroupNode.class.getName() + ".");
            }
            DataTreeGroupNode pe = (DataTreeGroupNode)o;
            DataTreeGroupNode groupChild = currentNode.findGroupNodeChild(pe);
            if (groupChild == null) {
                groupChild = pe.copy();
                currentNode.add(groupChild);
            } else if (addValueIndex) {
                groupChild.addValueIndex(pe.getFirstValueIndex());
                groupChild.getValueIndexSet().addAll(pe.getValueIndexSet());
            }
            currentNode = groupChild;
        }
        return currentNode;
    }

    public static DefaultMutableTreeNode[] createLeafNodeArray(DefaultMutableTreeNode root) {
        ArrayList<DefaultMutableTreeNode> l = new ArrayList<DefaultMutableTreeNode>();
        if (root != null && root.getChildCount() > 0) {
            Enumeration<TreeNode> nodes = root.depthFirstEnumeration();
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
                if (!node.isLeaf()) continue;
                l.add(node);
            }
        }
        int leafNodeCount = l.size();
        DefaultMutableTreeNode[] leafNodes = new DefaultMutableTreeNode[leafNodeCount];
        for (int i = 0; i < leafNodeCount; ++i) {
            leafNodes[i] = (DefaultMutableTreeNode)l.get(i);
        }
        return leafNodes;
    }

    public static DataTreeGroupNode findGroupAtLevel(DataTreeResponseNode leaf, int levelIndex) {
        DataTreeGroupNode result = null;
        DataTreeGroupNode current = (DataTreeGroupNode)leaf.getParent();
        while (current.getParent() != null) {
            DataTreeGroupNode g = current;
            if (g.getLevelIndex() == levelIndex) {
                result = g;
                break;
            }
            current = (DataTreeGroupNode)current.getParent();
        }
        return result;
    }

    public static DataTreeGroupNode findGroupAtLevel(DataTreeGroupNode node, int levelIndex) {
        DataTreeGroupNode result = null;
        DataTreeGroupNode current = node;
        while (current.getParent() != null) {
            DataTreeGroupNode g = current;
            if (g.getLevelIndex() == levelIndex) {
                result = g;
                break;
            }
            current = (DataTreeGroupNode)current.getParent();
        }
        return result;
    }

    public static String[] getResponseStrings(DataTreeResponseNode responseNode, DataTreeInfo info) {
        int responseCount = responseNode.getResponseCount();
        String[] result = new String[responseCount];
        for (int i = 0; i < responseCount; ++i) {
            StringBuffer sb = new StringBuffer();
            Variable v = info.getResponseVariableAt(i);
            Format f = v.getJavaFormat();
            sb.append(v.getLabel());
            sb.append("=");
            try {
                if (responseNode.isNumeric(info, i)) {
                    double d = responseNode.getDoubleValue(i);
                    if (f != null) {
                        sb.append(f.format(new Double(d)).trim());
                    } else {
                        sb.append(d);
                    }
                } else {
                    String s = responseNode.getStringValue(i);
                    if (f != null) {
                        sb.append(f.format(s).trim());
                    } else {
                        sb.append(s);
                    }
                }
            }
            catch (MissingValueException e) {
                sb.append(ValueMap.getDefaultMissingValueLabel(e.getMissingValue()));
            }
            result[i] = sb.toString();
        }
        return result;
    }

    public static String getResponseString(DataTreeResponseNode responseNode, DataTreeInfo info) {
        String[] s = DataTreeUtil.getResponseStrings(responseNode, info);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(s[i]);
        }
        return sb.toString();
    }

    public static DataTreeGroupNode getLeftMostNodeAtLevel(DataTreeGroupNode root, int levelIndex) {
        DataTreeGroupNode r = null;
        DataTreeGroupNode current = root;
        for (int li = levelIndex; li >= 0 && current != null; --li) {
            if (current.getChildCount() <= 0) continue;
            TreeNode n = current.getChildAt(0);
            if (n instanceof DataTreeGroupNode) {
                current = (DataTreeGroupNode)n;
                if (current.getLevelIndex() != levelIndex) continue;
                r = current;
                continue;
            }
            current = null;
        }
        return r;
    }

    public static String getPathWhereExpression(DataTreeGroupNode node) {
        return DataTreeUtil.getPathWhereExpression(node, null);
    }

    public static String getPathWhereExpression(DataTreeGroupNode node1, DataTreeGroupNode node2, boolean byObservation) {
        if (byObservation) {
            return DataTreeUtil.getPathWhereExpressionByObservation(node1, node2);
        }
        return DataTreeUtil.getPathWhereExpressionByValue(node1, node2);
    }

    public static String getPathWhereExpression(DataTreeGroupNode node1, DataTreeGroupNode node2) {
        return DataTreeUtil.getPathWhereExpressionByObservation(node1, node2);
    }

    private static String getPathWhereExpressionByObservation(DataTreeGroupNode node1, DataTreeGroupNode node2) {
        String result = null;
        HashSet obs1 = new HashSet();
        HashSet obs2 = new HashSet();
        DataTreeUtil.getPathValueIndexIntersection(node1, obs1);
        DataTreeUtil.getPathValueIndexIntersection(node2, obs2);
        if (!obs1.isEmpty() && !obs2.isEmpty()) {
            obs1.retainAll(obs2);
            result = DataTreeUtil.getWhereExpression(obs1);
        } else if (!obs2.isEmpty()) {
            result = DataTreeUtil.getWhereExpression(obs2);
        } else if (!obs1.isEmpty()) {
            result = DataTreeUtil.getWhereExpression(obs1);
        }
        return result;
    }

    private static String getPathWhereExpressionByValue(DataTreeGroupNode node) {
        String result = null;
        if (!node.isRoot()) {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            DataTreeGroupNode root = (DataTreeGroupNode)node.getRoot();
            DataTreeInfo info = (DataTreeInfo)root.getValue();
            while (!node.isRoot()) {
                String name = info.getGroupVariableAt(node.getLevelIndex()).getName();
                Object value = node.getValue();
                if (!(value instanceof Number)) {
                    value = "\"" + value.toString() + "\"";
                }
                sb.append(name + "=" + value.toString());
                if ((node = (DataTreeGroupNode)node.getParent()).isRoot()) continue;
                sb.append(" and ");
            }
            sb.append(")");
            result = sb.toString();
        }
        return result;
    }

    private static String getPathWhereExpressionByValue(DataTreeGroupNode node1, DataTreeGroupNode node2) {
        String exp1 = DataTreeUtil.getPathWhereExpressionByValue(node1);
        String exp2 = DataTreeUtil.getPathWhereExpressionByValue(node2);
        String result = exp1 != null && exp2 != null ? exp1 + "and" + exp2 : (exp1 == null && exp2 == null ? null : (exp1 != null ? exp1 : exp2));
        return result;
    }

    public static int[] getPathIncludeList(DataTreeGroupNode node) {
        return DataTreeUtil.getPathIncludeList(node, null);
    }

    public static int[] getPathIncludeList(DataTreeGroupNode node1, DataTreeGroupNode node2) {
        HashSet obs1 = new HashSet();
        HashSet obs2 = new HashSet();
        DataTreeUtil.getPathValueIndexIntersection(node1, obs1);
        DataTreeUtil.getPathValueIndexIntersection(node2, obs2);
        obs1.retainAll(obs2);
        return DataTreeUtil.getIncludeList(obs1);
    }

    private static void getPathValueIndexIntersection(DataTreeGroupNode node, HashSet obs) {
        if (node != null && node.getLevelIndex() >= 0) {
            DataTreeGroupNode gn = DataTreeUtil.findGroupAtLevel(node, 0);
            obs.addAll(gn.getValueIndexSet());
            while (node != null && node.getLevelIndex() >= 0) {
                obs.retainAll(node.getValueIndexSet());
                node = (DataTreeGroupNode)node.getParent();
            }
        }
    }

    public static String getWhereExpression(HashSet obs) {
        String result = null;
        StringBuffer sb = new StringBuffer();
        if (!obs.isEmpty()) {
            int count = 0;
            sb.append("(");
            for (Object o : obs) {
                if (count > 0) {
                    sb.append("|");
                }
                ++count;
                sb.append("obs=");
                sb.append(o);
            }
            sb.append(")");
            result = sb.toString();
        } else {
            result = "(obs=-1)";
        }
        return result;
    }

    public static int[] getIncludeList(HashSet obs) {
        int[] result = new int[obs.size()];
        if (!obs.isEmpty()) {
            int i = 0;
            for (Object o : obs) {
                result[i++] = (Integer)o;
                ++i;
            }
        }
        return result;
    }

    public static DataTreeGroupNode copyTree(DefaultMutableTreeNode[] leafNodeArray) {
        int leafCount = leafNodeArray.length;
        DataTreeGroupNode newRoot = new DataTreeGroupNode();
        if (leafCount == 0) {
            newRoot.setValue(new DataTreeInfo());
        } else {
            ArrayList<DataTreeGroupNode> path = new ArrayList<DataTreeGroupNode>();
            DataTreeGroupNode root = (DataTreeGroupNode)leafNodeArray[0].getRoot();
            DataTreeInfo newInfo = new DataTreeInfo((DataTreeInfo)root.getValue());
            newRoot.setValue(newInfo);
            newRoot.getValueIndexSet().clear();
            newRoot.getValueIndexSet().addAll(root.getValueIndexSet());
            for (int i = 0; i < leafCount; ++i) {
                DataTreeGroupNode gn;
                DefaultMutableTreeNode node = leafNodeArray[i];
                if (node instanceof DataTreeResponseNode) {
                    DataTreeResponseNode leaf = (DataTreeResponseNode)leafNodeArray[i];
                    gn = (DataTreeGroupNode)leaf.getParent();
                } else {
                    gn = (DataTreeGroupNode)node;
                }
                path.clear();
                while (gn.getParent() != null) {
                    path.add(0, gn);
                    gn = (DataTreeGroupNode)gn.getParent();
                }
                gn = DataTreeUtil.addGroupPath(newRoot, path, false);
                if (!(node instanceof DataTreeResponseNode)) continue;
                gn.add(new DataTreeResponseNode((DataTreeResponseNode)node));
            }
        }
        return newRoot;
    }
}

