/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.datatree;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import javax.swing.tree.DefaultMutableTreeNode;

public class DataTreeResponseNode
extends DefaultMutableTreeNode {
    private Object[] values;

    public DataTreeResponseNode(int responseArrayLength) {
        this.values = new Object[responseArrayLength];
    }

    public DataTreeResponseNode(DataTreeResponseNode rn) {
        this.values = new Object[rn.values.length];
        for (int i = 0; i < rn.values.length; ++i) {
            this.values[i] = rn.values[i];
        }
    }

    public int getResponseCount() {
        return this.values.length;
    }

    public boolean isNumeric(DataTreeInfo info, int responseIndex) {
        if (info == null) {
            throw new IllegalArgumentException("info cannot be null.");
        }
        if (responseIndex < 0 || responseIndex > info.getResponseVariableCount() - 1) {
            throw new IllegalArgumentException("responseIndex out of range.");
        }
        return info.getResponseVariableAt(responseIndex) instanceof NumericVariable;
    }

    public void setValue(Object value, int responseIndex) {
        this.values[responseIndex] = value;
    }

    public double getDoubleValue(int responseIndex) throws MissingValueException {
        Object v = this.values[responseIndex];
        MissingValues mv = null;
        double d = 0.0;
        if (v instanceof Number) {
            d = ((Number)v).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                mv = MissingValues.Dot;
            }
        } else if (v instanceof MissingValues) {
            mv = (MissingValues)v;
        } else if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 1 && s.charAt(0) == '.') {
                mv = MissingValues.Dot;
            } else {
                try {
                    d = Double.parseDouble(((String)v).trim());
                }
                catch (NumberFormatException e) {
                    mv = MissingValues.Dot;
                }
            }
        } else {
            mv = MissingValues.Dot;
        }
        if (mv != null) {
            MissingValueException e = MissingValueException.getDefaultMissingValueExeption();
            e.setMissingValue(mv);
            throw e;
        }
        return d;
    }

    public String getStringValue(int responseIndex) throws MissingValueException {
        String s;
        Object v = this.values[responseIndex];
        MissingValues mv = null;
        if (v instanceof String) {
            s = (String)v;
        } else if (v instanceof MissingValues || v == null) {
            mv = MissingValues._BLANK_;
            s = null;
        } else {
            s = v.toString();
        }
        if (mv != null) {
            MissingValueException e = MissingValueException.getDefaultMissingValueExeption();
            e.setMissingValue(mv);
            throw e;
        }
        return s;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.values.length; ++i) {
            sb.append(this.values[i] + ", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

