/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.datatree;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.datatree.DataTreeResponseNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DataTreeGroupNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private Object value = null;
    private String formattedValue = null;
    private HashSet valueIndexSet = null;
    private Integer firstValueIndex = null;
    private int levelIndex = -1;
    private static final String DEFAULT_NAME = "";
    private static final int DEFAULT_SPAN = -1;
    private static final int DEFAULT_SPAN_DEPTH = -1;
    private String tupleElementName = "";
    private int tupleElementSpan = -1;
    private int tupleElementSpanDepth = -1;

    public DataTreeGroupNode() {
        this.valueIndexSet = new HashSet();
    }

    public DataTreeGroupNode(int levelIndex, Object value, int valueIndex, String formattedValue, Locale locale) {
        this(levelIndex, value, valueIndex, formattedValue, DEFAULT_NAME, -1, -1, locale);
    }

    public DataTreeGroupNode(int levelIndex, Object value, int valueIndex, String formattedValue, String tupleElementName, int tupleElementSpan, int tupleElementSpanDepth, Locale locale) {
        this.levelIndex = levelIndex;
        this.value = value;
        this.formattedValue = formattedValue;
        this.tupleElementName = tupleElementName;
        this.tupleElementSpan = tupleElementSpan;
        this.tupleElementSpanDepth = tupleElementSpanDepth;
        this.firstValueIndex = new Integer(valueIndex);
        this.valueIndexSet = new HashSet();
        this.valueIndexSet.add(this.firstValueIndex);
    }

    protected DataTreeGroupNode(DataTreeGroupNode gn) {
        this.levelIndex = gn.levelIndex;
        this.value = gn.value;
        this.formattedValue = gn.formattedValue;
        this.firstValueIndex = gn.firstValueIndex;
        this.tupleElementName = gn.tupleElementName;
        this.tupleElementSpan = gn.tupleElementSpan;
        this.tupleElementSpanDepth = gn.tupleElementSpanDepth;
        this.valueIndexSet = (HashSet)gn.valueIndexSet.clone();
    }

    public DataTreeGroupNode copy() {
        return new DataTreeGroupNode(this);
    }

    protected void doCopy(DataTreeGroupNode from, DataTreeGroupNode to) {
        to.levelIndex = from.levelIndex;
        to.value = from.value;
        to.formattedValue = from.formattedValue;
        to.firstValueIndex = from.firstValueIndex;
        to.tupleElementName = from.tupleElementName;
        to.tupleElementSpan = from.tupleElementSpan;
        to.tupleElementSpanDepth = from.tupleElementSpanDepth;
        to.valueIndexSet = (HashSet)from.valueIndexSet.clone();
    }

    public void sortChildren(int sortOrder, boolean compareByFormattedValue, boolean isNumeric, List scratchList) {
        if (sortOrder == 0) {
            return;
        }
        int n = this.getChildCount();
        if (n <= 1) {
            return;
        }
        this.sortChildrenUsingNodeData(sortOrder, compareByFormattedValue, isNumeric, scratchList);
    }

    protected void sortChildrenUsingNodeData(int sortOrder, boolean compareByFormattedValue, boolean isNumeric, List scratchList) {
        int i;
        int n = this.getChildCount();
        if (scratchList == null) {
            scratchList = new ArrayList<TreeNode>();
        }
        scratchList.clear();
        for (i = 0; i < n; ++i) {
            scratchList.add(this.getChildAt(i));
        }
        Comparator comparator = new Comparator(isNumeric, compareByFormattedValue, sortOrder, this.getLocaleFromVariable(), this.getSortStrategyFromVariable());
        Collections.sort(scratchList, comparator);
        this.removeAllChildren();
        for (i = 0; i < n; ++i) {
            this.add((DataTreeGroupNode)scratchList.get(i));
        }
    }

    protected Variable getFirstVariable() {
        Variable result = null;
        DataTreeGroupNode root = (DataTreeGroupNode)this.getRoot();
        DataTreeInfo info = (DataTreeInfo)root.getValue();
        if (info.getGroupVariableCount() > 0) {
            result = info.getGroupVariableAt(0);
        } else if (info.getResponseVariableCount() > 0) {
            result = info.getResponseVariableAt(0);
        }
        return result;
    }

    private Locale getLocaleFromVariable() {
        return this.getFirstVariable().getLocale();
    }

    private int getSortStrategyFromVariable() {
        return this.getFirstVariable().getSortStrategy();
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public Object getValue() {
        return this.value;
    }

    public double getNumericValue() throws MissingValueException {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        MissingValueException mve = MissingValueException.getDefaultMissingValueExeption();
        mve.setMissingValue((MissingValues)this.value);
        throw mve;
    }

    public String getStringValue() throws MissingValueException {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        MissingValueException mve = MissingValueException.getDefaultMissingValueExeption();
        mve.setMissingValue((MissingValues)this.value);
        throw mve;
    }

    public void addValueIndex(int valueIndex) {
        Integer vi = new Integer(valueIndex);
        this.addValueIndex(vi);
    }

    public void addValueIndex(Integer valueIndex) {
        if (this.firstValueIndex == null) {
            this.firstValueIndex = valueIndex;
        }
        this.valueIndexSet.add(valueIndex);
    }

    public void clearValueIndices() {
        this.valueIndexSet.clear();
        this.firstValueIndex = null;
    }

    public Iterator getValueIndexIterator() {
        return this.valueIndexSet.iterator();
    }

    public int getValueIndexCount() {
        return this.valueIndexSet.size();
    }

    HashSet getValueIndexSet() {
        return this.valueIndexSet;
    }

    public int getFirstValueIndex() {
        if (this.firstValueIndex == null) {
            throw new IllegalStateException("No value index set.");
        }
        return this.firstValueIndex;
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public DataTreeGroupNode findGroupNodeChild(DataTreeGroupNode pe) {
        DataTreeGroupNode result = null;
        DataTreeGroupNode child = null;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode c = (DefaultMutableTreeNode)this.getChildAt(i);
            if (!(c instanceof DataTreeGroupNode) || !this.tupleElementsMatch(child = (DataTreeGroupNode)c, pe) || pe.getLevelIndex() != child.getLevelIndex() || !pe.formattedValue.equals(child.getFormattedValue())) continue;
            result = child;
            break;
        }
        return result;
    }

    protected boolean tupleElementsMatch(DataTreeGroupNode n1, DataTreeGroupNode n2) {
        return n1.tupleElementName.equals(n2.tupleElementName) && n1.tupleElementSpan == n2.tupleElementSpan && n1.tupleElementSpanDepth == n2.tupleElementSpanDepth;
    }

    public DataTreeResponseNode findResponseNodeChild() {
        DataTreeResponseNode result = null;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode c = (DefaultMutableTreeNode)this.getChildAt(i);
            if (!(c instanceof DataTreeResponseNode)) continue;
            result = (DataTreeResponseNode)c;
            break;
        }
        return result;
    }

    public void setFormattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
    }

    public void setLevelIndex(int levelIndex) {
        this.levelIndex = levelIndex;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getTupleElementSpan() {
        return this.tupleElementSpan;
    }

    public void setTupleElementSpan(int span) {
        this.tupleElementSpan = span;
    }

    public int getTupleElementSpanDepth() {
        return this.tupleElementSpanDepth;
    }

    public void setTupleElementSpanDepth(int spanDepth) {
        this.tupleElementSpanDepth = spanDepth;
    }

    public String getTupleElementName() {
        return this.tupleElementName;
    }

    public void setTupleElementName(String name) {
        this.tupleElementName = name;
    }

    @Override
    public String toString() {
        return this.getFormattedValue();
    }

    private static class Comparator
    extends Sort.SortComparator {
        private boolean isNumeric;
        private boolean compareByFormattedValue;

        public Comparator(boolean isNumeric, boolean compareByFormattedValue, int sortOrder, Locale locale, int sortStrategy) {
            super(sortOrder, locale, sortStrategy);
            this.isNumeric = isNumeric;
            this.compareByFormattedValue = compareByFormattedValue;
        }

        public int compare(Object o1, Object o2) {
            boolean n;
            Object v2;
            Object v1;
            DataTreeGroupNode gn1 = (DataTreeGroupNode)o1;
            DataTreeGroupNode gn2 = (DataTreeGroupNode)o2;
            if (this.compareByFormattedValue) {
                v1 = gn1.getFormattedValue();
                v2 = gn2.getFormattedValue();
                n = false;
            } else {
                v1 = gn1.getValue();
                v2 = gn2.getValue();
                n = this.isNumeric;
            }
            return Sort.compare(v1, v2, n, this);
        }
    }
}

