/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.AnimationProcessor;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.FrequencyVariable;
import com.sas.graphics.util.gtk.GroupProcessor;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericAnimationVariable;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OrderProcessor;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.SortProcessor;
import com.sas.graphics.util.gtk.Statistic;
import com.sas.graphics.util.gtk.StringAnimationVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.SubsetProcessor;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.WhereProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class VariableProcessor
implements Pipe {
    public static final int ORDER_FORWARD = 0;
    public static final int ORDER_REVERSE = 1;
    private Vector variables = new Vector();
    private int rawValueCount;
    private boolean modified;
    private boolean initInProgress;
    private SubsetProcessor subsetProcessor = new SubsetProcessor();
    private SortProcessor sortProcessor = new SortProcessor();
    private OrderProcessor orderProcessor = new OrderProcessor();
    private WhereProcessor whereProcessor = new WhereProcessor();
    private GroupProcessor groupProcessor = new GroupProcessor();
    private Vector groupVariables = new Vector();
    private AnimationProcessor animationProcessor = null;
    public final IntegerPipe category;
    private boolean isAnimationEnabled;
    private ArrayList tempSelectList;
    private AInitAction tempIA;

    public VariableProcessor() {
        this.category = this.groupProcessor.category;
        this.isAnimationEnabled = false;
        this.tempIA = new AInitAction();
        this.initInProgress = false;
        this.modified = false;
    }

    public void setAnimationEnabled(boolean b) {
        this.isAnimationEnabled = b;
        if (this.isAnimationEnabled) {
            this.allocAnimationProcessor();
        }
    }

    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    private boolean isModified() {
        return this.modified;
    }

    private void setModified(boolean trueOrFalse) {
        this.modified = trueOrFalse;
        this.setVariablesModified(trueOrFalse);
    }

    public DataTreeGroupNode getTree() {
        AInitAction ia = new AInitAction();
        this.init(ia);
        return this.groupProcessor.getTree();
    }

    @Override
    public Formatter getFormatter() {
        return null;
    }

    @Override
    public void reset(AResetAction resetAction) {
    }

    public void init() {
        this.init(new AInitAction());
    }

    @Override
    public void init(AInitAction initAction) {
        if (this.initInProgress) {
            return;
        }
        this.initInProgress = true;
        if (!this.isModified() && !this.areVariablesModified()) {
            if (this.animationProcessor != null && this.animationProcessor.isAnimationEnabled()) {
                this.animationProcessor.animationFrameUpdate(this.variables);
            }
            this.initInProgress = false;
            return;
        }
        this.unProcessVariables();
        this.rawValueCount = this.initAllVariables(initAction);
        this.rawValueCount = this.orderProcessor.process(this.variables, this.rawValueCount);
        this.rawValueCount = this.subsetProcessor.process(this.variables, this.rawValueCount);
        this.rawValueCount = this.whereProcessor.process(this.variables, this.rawValueCount);
        this.rawValueCount = this.groupProcessor.process(this.variables, this.rawValueCount);
        this.rawValueCount = this.sortProcessor.process(this.variables, this.rawValueCount);
        if (this.animationProcessor != null) {
            this.rawValueCount = this.animationProcessor.process(this.variables, this.rawValueCount);
        }
        this.initInProgress = false;
        this.setModified(false);
        this.setVariablesModified(false);
    }

    public boolean isWhereExpressionValid() {
        return this.whereProcessor.isExpressionValid(this.variables);
    }

    public String getWhereExpressionParseError() {
        return this.whereProcessor.getParseErrorMessage();
    }

    private boolean areVariablesModified() {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (!ve.variable.isModified()) continue;
            return true;
        }
        return false;
    }

    private void setVariablesModified(boolean trueOrFalse) {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            ve.variable.setModified(trueOrFalse);
        }
        if (this.animationProcessor != null) {
            Variable v = this.animationProcessor.getAnimationVariable();
            if (v != null) {
                v.setModified(trueOrFalse);
            }
            if ((v = this.animationProcessor.getAnimationIdVariable()) != null) {
                v.setModified(trueOrFalse);
            }
        }
    }

    private void unProcessVariables() {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            ve.variable.setCalculateUniqueValuesByFormattedValue(ve.origCalculateUniqueValuesByFormattedValue);
            if (ve.variable instanceof NumericVariable) {
                NumericVariable nv = (NumericVariable)ve.variable;
                nv.setProcessedValuePipe(null, 0);
                continue;
            }
            StringVariable sv = (StringVariable)ve.variable;
            sv.setProcessedValuePipe(null, 0);
        }
    }

    public NumericVariable newSelectedPercentageVariable() {
        FrequencyVariable selectedPercentageVariable = new FrequencyVariable();
        String n = "selectedPercentage";
        selectedPercentageVariable.setName(n);
        selectedPercentageVariable.setLabel(n);
        selectedPercentageVariable.setDefaultFrequency(1);
        this.addVariableEntry(selectedPercentageVariable, 0, 3);
        return selectedPercentageVariable;
    }

    public void addVariable(Variable variable) {
        this.addVariable(variable, 6);
    }

    private void validateVariable(Variable v, boolean isGroup) {
        if (this.isAnimationEnabled) {
            if (isGroup) {
                throw new Error("Group variables not allowed on animation VariableProcessor.");
            }
            if (!(v instanceof StringAnimationVariable) && !(v instanceof NumericAnimationVariable)) {
                throw new Error("Must be an animation variable: variable.getName()=" + v.getName() + " " + v);
            }
        }
    }

    public void addVariable(Variable variable, int statistic) {
        this.validateVariable(variable, false);
        int index = this.findVariable(variable);
        if (index < 0) {
            if (variable instanceof FrequencyVariable) {
                switch (statistic) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 13: {
                        break;
                    }
                    default: {
                        statistic = 2;
                    }
                }
            }
            this.addVariableEntry(variable, statistic, 1);
            variable.setCalculateUniqueValuesByFormattedValue(false);
        } else {
            VEntry ve = (VEntry)this.variables.elementAt(index);
            ve.statistic = statistic;
            this.groupVariables.removeElement(variable);
        }
    }

    public void addGroupVariable(Variable groupVariable) {
        this.validateVariable(groupVariable, true);
        groupVariable.setCalculateUniqueValuesByFormattedValue(true);
        int index = this.findVariable(groupVariable);
        if (index >= 0) {
            VEntry ve = (VEntry)this.variables.elementAt(index);
            ve.type = 0;
        } else {
            this.addVariableEntry(groupVariable, 0, 0);
        }
        if (!this.groupVariables.contains(groupVariable)) {
            this.groupVariables.addElement(groupVariable);
        }
    }

    public void setSelectionVariable(NumericVariable selectionVariable) {
        this.validateVariable(selectionVariable, false);
        int index = this.findSelectionVariable();
        if (index >= 0) {
            VEntry ve = (VEntry)this.variables.elementAt(index);
            ve.variable = selectionVariable;
        } else {
            this.addVariableEntry(selectionVariable, 0, 2);
        }
    }

    public NumericVariable getSelectionVariable() {
        NumericVariable result = null;
        int index = this.findSelectionVariable();
        if (index >= 0) {
            VEntry ve = (VEntry)this.variables.elementAt(index);
            result = (NumericVariable)ve.variable;
        }
        return result;
    }

    public void removeAllVariables() {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            this.removeVariableProcessor(ve.variable);
            ve.variable.setCalculateUniqueValuesByFormattedValue(ve.origCalculateUniqueValuesByFormattedValue);
        }
        this.variables.removeAllElements();
        this.groupVariables.removeAllElements();
        this.setModified(true);
    }

    public void removeVariable(Variable variable) {
        int i = this.findVariable(variable);
        if (i >= 0) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (ve.type == 0) {
                this.groupVariables.removeElement(ve.variable);
            }
            this.variables.removeElementAt(i);
            this.removeVariableProcessor(ve.variable);
            ve.variable.setCalculateUniqueValuesByFormattedValue(ve.origCalculateUniqueValuesByFormattedValue);
        }
        this.setModified(true);
    }

    private void removeVariableProcessor(Variable variable) {
        variable.setVariableProcessor(null);
        variable.setModified(true);
        if (variable instanceof NumericVariable) {
            NumericVariable nv = (NumericVariable)variable;
            nv.setProcessedValuePipe(null, 0);
        } else {
            StringVariable sv = (StringVariable)variable;
            sv.setProcessedValuePipe(null, 0);
        }
    }

    public VariableEntry[] getVariables() {
        int n = this.variables.size();
        VariableEntry[] result = new VariableEntry[n];
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            result[i] = new VariableEntry();
            result[i].variable = ve.variable;
            result[i].statistic = ve.statistic;
            result[i].type = ve.type;
        }
        return result;
    }

    public int getVariableCount() {
        return this.variables.size();
    }

    private VEntry addVariableEntry(Variable variable, int statistic, int type) {
        VEntry ve = new VEntry();
        ve.variable = variable;
        ve.type = type;
        ve.statistic = statistic;
        ve.origCalculateUniqueValuesByFormattedValue = variable.isCalculateUniqueValuesByFormattedValue();
        this.variables.addElement(ve);
        if (ve.type == 1 && ve.variable instanceof StringVariable && statistic != 0 && statistic != 12) {
            ve.statistic = 0;
        }
        variable.setModified(true);
        variable.setVariableProcessor(this);
        this.setModified(true);
        return ve;
    }

    private int findVariable(Variable variable) {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (ve.variable != variable) continue;
            return i;
        }
        return -1;
    }

    private int findSelectionVariable() {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (ve.type != 2) continue;
            return i;
        }
        return -1;
    }

    public void setSort(Variable sortVariable, int sortOrder) {
        if (this.findVariable(sortVariable) == -1) {
            this.addVariable(sortVariable);
        }
        this.sortProcessor.setSortVariable(sortVariable);
        this.sortProcessor.setSortOrder(sortOrder);
        this.setModified(true);
    }

    public void setOrder(int order) {
        this.orderProcessor.setOrder(order);
        this.setModified(true);
    }

    public void setWhereExpression(String expression) {
        if (this.isAnimationEnabled() && expression != null && expression.length() > 0) {
            System.out.println("No subsetting allowed on an animation enabled VariableProcessor.");
            return;
        }
        this.whereProcessor.setExpression(expression);
        this.setModified(true);
    }

    public void setSubsetByObservation(int firstObservation, int lastObservation) {
        this.subsetProcessor.setLowObs(firstObservation);
        this.subsetProcessor.setHighObs(lastObservation);
        this.subsetProcessor.setEnabled(true);
        this.setModified(true);
    }

    public void setSubsetByObservation(int[] obsIndexIncludeList, int obsIndexCount) {
        this.subsetProcessor.setObsIncludeList(obsIndexIncludeList, obsIndexCount);
        this.subsetProcessor.setEnabled(true);
        this.setModified(true);
    }

    public void clearSubsetByObservation() {
        this.subsetProcessor.setEnabled(false);
        this.setModified(true);
    }

    public String getWhereExpression() {
        return this.whereProcessor.getExpression();
    }

    public int getGroupVariableCount() {
        return this.groupVariables.size();
    }

    private int initAllVariables(AInitAction initAction) {
        initAction.pushValueCount();
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            Variable temp;
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (ve.variable instanceof NumericVariable) {
                if (ve.variable instanceof NumericAnimationVariable) {
                    temp = (NumericAnimationVariable)ve.variable;
                    ((NumericVariable)temp.getConnection()).formattedValue.init(initAction);
                    continue;
                }
                NumericVariable nv = (NumericVariable)ve.variable;
                nv.formattedValue.init(initAction);
                continue;
            }
            if (ve.variable instanceof StringAnimationVariable) {
                temp = (StringAnimationVariable)ve.variable;
                ((StringVariable)temp.getConnection()).formattedValue.init(initAction);
                continue;
            }
            StringVariable sv = (StringVariable)ve.variable;
            sv.formattedValue.init(initAction);
        }
        int vc = initAction.getValueCount();
        initAction.popValueCount();
        return vc;
    }

    public void cacheData() {
        int nVariables = this.variables.size();
        if (nVariables > 0) {
            int i;
            VEntry ve = (VEntry)this.variables.elementAt(0);
            int nObs = ve.variable.getRawValueCount();
            nVariables = this.variables.size();
            for (i = 0; i < nVariables; ++i) {
                ve = (VEntry)this.variables.elementAt(i);
                if (ve.variable.getRawValueCount() != nObs) {
                    throw new RuntimeException();
                }
                ve.variable.beginDataCache();
            }
            for (i = 0; i < nObs; ++i) {
                for (int j = 0; j < nVariables; ++j) {
                    ve = (VEntry)this.variables.elementAt(j);
                    ve.variable.cacheDataAt(i);
                }
            }
            for (i = 0; i < nVariables; ++i) {
                ve = (VEntry)this.variables.elementAt(i);
                ve.variable.endDataCache();
                ve.variable.setModified(true);
            }
        }
    }

    public int getIndexWithoutWhereProcessing(int index) {
        this.init(this.tempIA);
        return this.whereProcessor.getIndex(index);
    }

    public List getIndicesPriorToProcessing(int valueIndex) {
        int i;
        int n;
        List result;
        this.init(this.tempIA);
        if (this.isAnimationEnabled()) {
            List animationList = this.animationProcessor.getValueIndices(valueIndex);
            if (this.tempSelectList == null) {
                this.tempSelectList = new ArrayList();
            }
            this.tempSelectList.clear();
            result = this.tempSelectList;
            int n2 = animationList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int j = (Integer)animationList.get(i2);
                this.tempSelectList.addAll(this.groupProcessor.getValueIndices(j));
            }
        } else {
            result = this.groupProcessor.getValueIndices(valueIndex);
        }
        if (this.whereProcessor.isWhereProcessingNeeded()) {
            n = result.size();
            for (i = 0; i < n; ++i) {
                Integer bigI = this.whereProcessor.getIndex((Integer)result.get(i));
                result.set(i, bigI);
            }
        }
        if (this.sortProcessor.isSortingNeeded()) {
            n = result.size();
            for (i = 0; i < n; ++i) {
                Integer bigI = (Integer)result.get(i);
                bigI = new Integer(this.sortProcessor.getIndexPriorToSorting(bigI));
                result.set(i, bigI);
            }
        }
        return result;
    }

    public void setSubgroupStyleCumulativeStatistics(boolean trueOrFalse) {
        this.groupProcessor.setPerformCumulativeStatsByObservation(trueOrFalse);
    }

    public boolean isSubgroupStyleCumulativeStatistics() {
        return this.groupProcessor.isPerformCumulativeStatsByObservation();
    }

    public void dumpUniqueValues() {
        StringBuffer dumpBuffer = new StringBuffer();
        int variableCount = this.variables.size();
        String indent = "    ";
        System.out.println("--- Unique Values: " + this + " ------");
        if (variableCount > 0) {
            Variable v = ((VEntry)this.variables.elementAt((int)0)).variable;
            for (int j = 0; j < variableCount; ++j) {
                String sortType;
                VEntry ve = (VEntry)this.variables.elementAt(j);
                v = ve.variable;
                int n = v.getUniqueValueCount();
                switch (v.getUniqueValueSort()) {
                    case 1: {
                        sortType = "ascending";
                        break;
                    }
                    case 2: {
                        sortType = "descending";
                        break;
                    }
                    default: {
                        sortType = "none";
                    }
                }
                dumpBuffer.setLength(0);
                dumpBuffer.append(indent + "--- " + v.getName() + " n=" + n + " sort=" + sortType + " sortByFormattedValue=" + v.getSortByFormattedValues());
                if (this.groupVariables.size() > 0) {
                    if (ve.type == 0) {
                        dumpBuffer.append(" group variable");
                    } else if (ve.type == 1) {
                        dumpBuffer.append(" statistic=" + Statistic.getNames()[ve.statistic]);
                    } else if (ve.type == 2) {
                        dumpBuffer.append(" selection variable");
                    }
                } else {
                    dumpBuffer.append("(no summarization)");
                }
                dumpBuffer.append(" ---");
                System.out.println(dumpBuffer);
                for (int i = 0; i < n; ++i) {
                    try {
                        if (v instanceof NumericVariable) {
                            NumericVariable nv = (NumericVariable)v;
                            System.out.println(indent + nv.formattedUniqueValue.getValue(i));
                            continue;
                        }
                        StringVariable sv = (StringVariable)v;
                        System.out.println(indent + sv.formattedUniqueValue.getValue(i));
                        continue;
                    }
                    catch (MissingValueException e) {
                        System.out.println(indent + e.getMissingValue());
                    }
                }
            }
        }
        System.out.println("---------");
        System.out.println(" ");
    }

    public void dump() {
        StringBuffer dumpBuffer = new StringBuffer();
        int variableCount = this.variables.size();
        String indent = "    ";
        if (variableCount > 0) {
            int i;
            Variable v = ((VEntry)this.variables.elementAt((int)0)).variable;
            int n = v.getValueCount();
            System.out.println("--- Values: n=" + n + " :" + this + " ------");
            String whereExpression = this.getWhereExpression();
            if (whereExpression != null && whereExpression.trim().length() > 0) {
                String s = "--- Where expression: \"" + whereExpression + "\" ------";
                if (!this.isWhereExpressionValid()) {
                    s = s + " expression INVALID!!!! no subsetting will occur";
                }
                System.out.println(s);
            }
            for (i = 0; i < variableCount; ++i) {
                VEntry ve = (VEntry)this.variables.elementAt(i);
                v = ve.variable;
                v.init();
                dumpBuffer.setLength(0);
                dumpBuffer.append("--- column " + i + ": ");
                if (this.groupVariables.size() > 0) {
                    if (ve.type == 0) {
                        dumpBuffer.append(this.labelAndName(v) + " is a group variable");
                    } else if (ve.type == 1) {
                        dumpBuffer.append(this.labelAndName(v) + " statistic=" + Statistic.getNames()[ve.statistic]);
                    } else if (ve.type == 2) {
                        dumpBuffer.append(this.labelAndName(v) + " is a selection variable");
                    } else if (ve.type == 3) {
                        dumpBuffer.append(this.labelAndName(v) + " is a selection percentage variable");
                    }
                } else {
                    dumpBuffer.append(this.labelAndName(v) + " (no summarization)");
                }
                System.out.println(dumpBuffer);
            }
            for (i = 0; i < n; ++i) {
                dumpBuffer.setLength(0);
                dumpBuffer.append(indent);
                for (int j = 0; j < variableCount; ++j) {
                    v = ((VEntry)this.variables.elementAt((int)j)).variable;
                    Formatter formatter = v.getFormatter();
                    try {
                        if (v instanceof NumericVariable) {
                            NumericVariable nv = (NumericVariable)v;
                            dumpBuffer.append(nv.formattedValue.getValue(i) + " ");
                            continue;
                        }
                        StringVariable sv = (StringVariable)v;
                        dumpBuffer.append("\"" + sv.formattedValue.getValue(i) + "\" ");
                        continue;
                    }
                    catch (MissingValueException e) {
                        dumpBuffer.append(formatter.format(e.getMissingValue()) + " ");
                    }
                }
                System.out.println(dumpBuffer.toString());
            }
            System.out.println("---------");
            System.out.println("");
        }
    }

    private String labelAndName(Variable v) {
        return "label=\"" + v.getLabel() + "\" name=\"" + v.getName() + "\"";
    }

    public double[] getMinAndMaxSignedSums() {
        int i;
        double[] result = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        NumericVariable[] nvList = new NumericVariable[this.variables.size() - this.groupVariables.size()];
        int n = this.variables.size();
        int nvCount = 0;
        for (i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (ve.type != 1 || !(ve.variable instanceof NumericVariable)) continue;
            nvList[nvCount] = (NumericVariable)ve.variable;
            ++nvCount;
        }
        if (nvCount > 0) {
            int valueCount = nvList[0].getValueCount();
            for (i = 0; i < valueCount; ++i) {
                double posSum = 0.0;
                double negSum = 0.0;
                for (int j = 0; j < nvCount; ++j) {
                    try {
                        NumericVariable nv = nvList[j];
                        double r = nv.value.getValue(i);
                        if (r >= 0.0) {
                            posSum += r;
                            continue;
                        }
                        negSum += r;
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                result[0] = Math.min(result[0], negSum);
                result[1] = Math.max(result[1], posSum);
            }
        }
        return result;
    }

    private static void initVar(Variable v, AInitAction ia) {
        if (v instanceof NumericVariable) {
            ((NumericVariable)v).value.init(ia);
        } else {
            ((StringVariable)v).value.init(ia);
        }
    }

    public static DataTreeGroupNode[] createRowColumnTrees(Variable[] rowVars, Variable[] columnVars) {
        int i;
        ArrayList<DataTreeGroupNode> columnPath = null;
        ArrayList<DataTreeGroupNode> rowPath = null;
        DataTreeGroupNode[] result = new DataTreeGroupNode[2];
        DataTreeGroupNode columnRoot = null;
        DataTreeGroupNode rowRoot = null;
        AInitAction ia = new AInitAction();
        result[0] = rowRoot = new DataTreeGroupNode();
        ArrayList<Variable> groupList = new ArrayList<Variable>();
        if (rowVars != null) {
            for (i = 0; i < rowVars.length; ++i) {
                VariableProcessor.initVar(rowVars[i], ia);
                groupList.add(rowVars[i]);
            }
        }
        rowRoot.setValue(new DataTreeInfo(groupList, null));
        result[1] = columnRoot = new DataTreeGroupNode();
        groupList = new ArrayList();
        if (columnVars != null) {
            for (i = 0; i < columnVars.length; ++i) {
                VariableProcessor.initVar(columnVars[i], ia);
                groupList.add(columnVars[i]);
            }
        }
        columnRoot.setValue(new DataTreeInfo(groupList, null));
        int valueCount = ia.getValueCount();
        if (columnVars != null) {
            columnPath = new ArrayList<DataTreeGroupNode>(columnVars.length);
            for (i = 0; i < columnVars.length; ++i) {
                columnPath.add(new DataTreeGroupNode());
            }
        }
        if (rowVars != null) {
            rowPath = new ArrayList<DataTreeGroupNode>(rowVars.length);
            for (i = 0; i < rowVars.length; ++i) {
                rowPath.add(new DataTreeGroupNode());
            }
        }
        for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
            String formattedValue;
            Object value;
            DataTreeGroupNode pe;
            if (columnPath != null) {
                for (i = 0; i < columnVars.length; ++i) {
                    pe = (DataTreeGroupNode)columnPath.get(i);
                    value = Variable.getValue(columnVars[i], valueIndex, false);
                    formattedValue = (String)Variable.getValue(columnVars[i], valueIndex, true);
                    pe.setValue(value);
                    pe.setFormattedValue(formattedValue);
                    pe.clearValueIndices();
                    pe.addValueIndex(valueIndex);
                    pe.setLevelIndex(i);
                }
                DataTreeUtil.addGroupPath(columnRoot, columnPath, true);
            }
            if (rowPath == null) continue;
            for (i = 0; i < rowVars.length; ++i) {
                pe = (DataTreeGroupNode)rowPath.get(i);
                value = Variable.getValue(rowVars[i], valueIndex, false);
                formattedValue = (String)Variable.getValue(rowVars[i], valueIndex, true);
                pe.setValue(value);
                pe.setFormattedValue(formattedValue);
                pe.clearValueIndices();
                pe.addValueIndex(valueIndex);
                pe.setLevelIndex(i);
            }
            DataTreeUtil.addGroupPath(rowRoot, rowPath, true);
        }
        GroupProcessor.sort(columnRoot, columnVars);
        GroupProcessor.sort(rowRoot, rowVars);
        return result;
    }

    public void setAnimationFrame(Object byGroup1, Object byGroup2, double interpolationPercentage) {
        if (interpolationPercentage < 0.0 || interpolationPercentage > 1.0) {
            throw new Error("Illegal interpolation percentage: " + interpolationPercentage);
        }
        this.animationProcessor.setAnimationFrame(byGroup1, byGroup2, interpolationPercentage);
    }

    private void allocAnimationProcessor() {
        if (this.animationProcessor == null) {
            this.animationProcessor = new AnimationProcessor();
        }
    }

    public void setAnimationKeyFrameVariable(Variable v) {
        this.allocAnimationProcessor();
        this.validateVariable(v, false);
        this.animationProcessor.setKeyFrameVariable(v);
        this.setModified(true);
    }

    public void setAnimationIdentificationVariable(Variable v) {
        this.allocAnimationProcessor();
        this.validateVariable(v, false);
        this.animationProcessor.setIdentificationVariable(v);
        this.setModified(true);
    }

    public static class VariableEntry {
        public static final int GROUP = 0;
        public static final int RESPONSE = 1;
        public static final int SELECTION = 2;
        public static final int SELECTED_PERCENTAGE = 3;
        public Variable variable;
        public int statistic;
        public int type;
    }

    static class VEntry {
        public Variable variable;
        public int type;
        public int statistic;
        public int responseIndex;
        public int groupIndex;
        public int selectPercentageIndex;
        public int uniqueValueCount;
        public IntegerPipe category;
        public NumericPipe numericValuePriorToGrouping;
        public boolean origCalculateUniqueValuesByFormattedValue;

        VEntry() {
        }
    }
}

