/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Action;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericAnimationVariable;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.PipedFormat;
import com.sas.graphics.util.gtk.PipedVector;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.StringAnimationVariable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringPipeSwitcher;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.UniqueValue;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.VariableException;
import com.sas.text.SASFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public abstract class Variable {
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    private static int nameCounter = 0;
    protected boolean calNumUniqueValues = true;
    private Formatter formatter = Formatter.defaultFormatter;
    private GTKFormat format = null;
    private SASInformat informat = null;
    private String informatName = null;
    protected static String defaultName = "variable";
    private String name;
    private String label;
    private String columnName;
    private int processedValueCount;
    private boolean modified;
    private boolean connected;
    private int sortType = 0;
    private boolean sortByFormattedValues = false;
    private Pipe variableProcessor;
    private boolean calculateUniqueValuesByFormmatedValue = true;
    private long modifiedTime = Action.getTimeStamp();
    private UniqueValue tempUniqueValue = new UniqueValue();
    private Locale locale = Locale.getDefault();
    private int sortStrategy = Sort.getDefaultSortStrategy();
    private boolean formattedValueMissingValueExceptionsEnabled = true;
    private Variable connection;
    private final PipedFormat valueFormat;
    private final PipedFormat uniqueValueFormat;
    public final StringPipe formattedValue;
    private final StringPipeSwitcher formattedUniqueValueSwitcher = new StringPipeSwitcher();
    public final StringPipe formattedUniqueValue;
    private static final char[] illegalNameChars = new char[]{'.', ' ', '*', '/', '%', '<', '>', '=', '&', '|', ':', '?', '-', '+', '(', ')'};

    public Variable(PipedFormat valueFormat, PipedFormat uniqueValueFormat) {
        this.valueFormat = valueFormat;
        this.uniqueValueFormat = uniqueValueFormat;
        this.formattedValue = valueFormat.value;
        this.formattedUniqueValueSwitcher.connectFrom(uniqueValueFormat.value);
        this.formattedUniqueValue = this.formattedUniqueValueSwitcher;
        this.variableProcessor = null;
        this.modified = false;
        this.connected = false;
        this.setName(defaultName + nameCounter++);
    }

    protected StringPipeSwitcher getFormattedUniqueValueSwitcher() {
        return this.formattedUniqueValueSwitcher;
    }

    protected PipedFormat getValueFormat() {
        return this.valueFormat;
    }

    protected PipedFormat getUniqueValueFormat() {
        return this.uniqueValueFormat;
    }

    public static int sortStringToInt(String sortType) {
        int result = 2;
        String name = sortType.toUpperCase();
        if (name.equals("NONE")) {
            result = 0;
        } else if (name.equals("ASCENDING")) {
            result = 1;
        }
        return result;
    }

    protected abstract Map getCategoryHashtable();

    protected abstract CategoryHashtable getCategoryTable();

    public abstract boolean isRawValueMissing(int var1);

    public abstract boolean isMissing(int var1);

    protected void beginDataCache() {
    }

    protected void endDataCache() {
    }

    protected static void clearDataCache(PipedVector cache) {
        if (cache != null) {
            cache.removeAllValues();
        }
    }

    protected void cacheDataAt(int i) {
    }

    protected static boolean isDataCached(PipedVector cache) {
        return cache != null && cache.size() > 0;
    }

    public void setUniqueValueSort(int aSortType) {
        this.sortType = aSortType;
        this.setModified(true);
    }

    public int getUniqueValueSort() {
        return this.sortType;
    }

    public void setSortByFormattedValues(boolean b) {
        this.sortByFormattedValues = b;
        this.setModified(true);
    }

    public boolean getSortByFormattedValues() {
        return this.sortByFormattedValues;
    }

    public boolean isSortByFormattedValues() {
        return this.sortByFormattedValues;
    }

    public void setModified(boolean trueOrFalse) {
        this.setModified(trueOrFalse, Action.getTimeStamp());
    }

    protected void setModified(boolean trueOrFalse, long time) {
        if (trueOrFalse) {
            // empty if block
        }
        this.modified = trueOrFalse;
        if (this.modified) {
            this.calNumUniqueValues = true;
            this.modifiedTime = time;
        }
    }

    protected long getModifiedTime() {
        return this.modifiedTime;
    }

    public boolean isModified() {
        return this.modified;
    }

    protected abstract void addUniqueValue(int var1);

    protected abstract IntegerPipe getCategory();

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Variable names must be non-null.");
        }
        this.name = Variable.convertToNameString(name);
    }

    public static String convertToNameString(String s) {
        if (s != null) {
            if ("obs".equalsIgnoreCase(s)) {
                s = "_" + s;
            } else {
                for (int i = 0; i < illegalNameChars.length; ++i) {
                    s = s.replace(illegalNameChars[i], '_');
                }
            }
        }
        return s;
    }

    public String getName() {
        return this.name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    protected void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.doGetColumnName();
    }

    protected String getColumnName(Variable connectionVariable) {
        String result = connectionVariable == null ? this.doGetColumnName() : connectionVariable.getColumnName();
        return result;
    }

    private String doGetColumnName() {
        String result = this.columnName;
        if (result == null) {
            result = this.getName();
        }
        return result;
    }

    protected void setRawValueCount(int valueCount) {
    }

    protected void setProcessedValueCount(int valueCount) {
        this.processedValueCount = valueCount;
    }

    protected abstract int getRawValueCount();

    public abstract void init();

    public int getValueCount() {
        if (this.isAnimationVariable() || this.modified && this.variableProcessor != null) {
            this.variableProcessor.init(new AInitAction(null));
        }
        int result = this.processedValueCount;
        if (this.processedValueCount == -1) {
            result = this.getRawValueCount();
        }
        return result;
    }

    private boolean isAnimationVariable() {
        return this.variableProcessor != null && (this instanceof StringAnimationVariable || this instanceof NumericAnimationVariable);
    }

    protected void connectFrom() {
        this.connected = true;
        this.setModified(true);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() {
        this.connected = false;
        this.processedValueCount = -1;
        this.setModified(true);
    }

    public abstract int getUniqueValueCount();

    protected void setUniqueValueCount(int valueCount) {
    }

    protected abstract int buildUniqueValueVector();

    protected int buildCategoryTable() {
        if (this.calNumUniqueValues) {
            int n = this.getValueCount();
            this.uniqueValueAddBegin(n);
            for (int i = 0; i < n; ++i) {
                this.addUniqueValue(i);
            }
            this.uniqueValueAddEnd();
        }
        return this.getCategoryHashtable().size();
    }

    protected void uniqueValueAddBegin(int valueCount) {
        this.getCategoryTable().init(valueCount);
    }

    protected void uniqueValueAddEnd() {
        this.sortUniqueValues();
        this.calNumUniqueValues = false;
    }

    private void sortUniqueValues() {
        if (this.sortType == 0) {
            return;
        }
        UniqueValue.UniqueValueComparator comparator = new UniqueValue.UniqueValueComparator(this.isSortByFormattedValues(), this instanceof NumericVariable, this.sortType, this.locale, this.sortStrategy);
        Sort.sortCategoryTable(this.getCategoryHashtable(), this.sortType, comparator);
    }

    public void reset(AResetAction resetAction) {
        if (!this.isConnected()) {
            throw new VariableException("Attempt to reset a variable that is not connected to data.");
        }
    }

    public static Object getValue(Variable v, int index, boolean formattedValue) {
        Object o;
        try {
            if (v instanceof StringVariable) {
                StringVariable sv = (StringVariable)v;
                o = formattedValue ? sv.formattedValue.getValue(index) : sv.value.getValue(index);
            } else {
                NumericVariable nv = (NumericVariable)v;
                o = formattedValue ? nv.formattedValue.getValue(index) : new Double(nv.value.getValue(index));
            }
        }
        catch (MissingValueException e) {
            o = formattedValue ? ValueMap.getDefaultMissingValueLabel(e.getMissingValue()) : e.getMissingValue();
        }
        return o;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public GTKFormat getFormat() {
        return this.format;
    }

    public void setFormat(GTKFormat format) {
        this.formatter = new Formatter(format);
        this.format = format;
        this.setModified(true);
    }

    public Format getJavaFormat() {
        Format[] f;
        Format result = null;
        if (this.format != null && (f = this.format.getFormats()) != null && f.length > 0) {
            result = f[0];
        }
        return result;
    }

    public String getSASFormatName() {
        String result = null;
        Format f = this.getJavaFormat();
        if (f != null && f instanceof SASFormat) {
            SASFormat sf = (SASFormat)f;
            result = sf.getName();
        }
        return result;
    }

    public void setInformat(String informatName) {
        if (informatName != null) {
            informatName = informatName.trim();
        }
        this.informat = SASInformat.getInstance(informatName);
        this.informatName = this.informat == null ? null : informatName;
        this.setModified(true);
    }

    public String getInformat() {
        return this.informatName;
    }

    public Object getInformattedValue(Object o) throws MissingValueException {
        if (o instanceof String && this.informat != null) {
            String s = (String)o;
            try {
                return this.informat.informat(s);
            }
            catch (ParseException parseException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            MissingValueException e = MissingValueException.getDefaultMissingValueExeption();
            e.setMissingValue(MissingValues.Dot);
            throw e;
        }
        return o;
    }

    public void setCalculateUniqueValuesByFormattedValue(boolean calculateUniqueValuesByFormmatedValue) {
        this.calculateUniqueValuesByFormmatedValue = calculateUniqueValuesByFormmatedValue;
    }

    protected boolean isCalculateUniqueValuesByFormattedValue() {
        return this.calculateUniqueValuesByFormmatedValue && this.getFormat() != null;
    }

    protected void init(AInitAction initAction) {
        if (!this.isConnected()) {
            throw new VariableException("Attempt to initialize a variable that is not connected to data.");
        }
        if (this.variableProcessor != null) {
            this.variableProcessor.init(initAction);
        }
        this.setModified(false);
        initAction.setDataChangedTime(this.modifiedTime);
    }

    protected void setVariableProcessor(Pipe aVariableProcessor) {
        this.variableProcessor = aVariableProcessor;
        this.setModified(true);
    }

    protected int getFirstOccurringValueIndex(Object value, String formattedValue, Map categoryTable) {
        int firstOccuringIndex = -1;
        UniqueValue tmpUV = this.tempUniqueValue;
        tmpUV.setValue(value);
        tmpUV.setFormattedValue(formattedValue);
        Map ht = categoryTable;
        Iterator keys = ht.entrySet().iterator();
        while (keys.hasNext() && firstOccuringIndex < 0) {
            Map.Entry entry = keys.next();
            UniqueValue uv = (UniqueValue)entry.getKey();
            if (!uv.equals(tmpUV)) continue;
            firstOccuringIndex = uv.getFirstOccuringIndex();
        }
        return firstOccuringIndex;
    }

    public Variable getRootVariable() {
        Variable result = this;
        while (result.getConnection() != null) {
            result = result.getConnection();
        }
        return result;
    }

    public Variable getConnection() {
        return this.connection;
    }

    protected void setConnection(Variable v) {
        this.connection = v;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setModified(true);
    }

    public int getSortStrategy() {
        return this.sortStrategy;
    }

    public void setSortStrategy(int sortStrategy) {
        this.sortStrategy = sortStrategy;
        this.setModified(true);
    }

    public boolean isFormattedValueMissingValueExceptionsEnabled() {
        return this.formattedValueMissingValueExceptionsEnabled;
    }

    public void setFormattedValueMissingValueExceptionsEnabled(boolean formattedValueMissingValueExceptionsEnabled) {
        this.formattedValueMissingValueExceptionsEnabled = formattedValueMissingValueExceptionsEnabled;
    }

    private static abstract class SASInformat {
        private SASFormat sasinformat;

        private SASInformat() {
        }

        public abstract Object informat(String var1) throws ParseException;

        protected void setInformat(SASFormat sasformat) {
            this.sasinformat = sasformat;
        }

        protected SASFormat getInformat() {
            return this.sasinformat;
        }

        public static SASInformat getInstance(String informatName) {
            SASInformat result = null;
            DateInformatParser parser = new DateInformatParser(informatName);
            String s = parser.getTextPart();
            if (s.equalsIgnoreCase("DATETIME")) {
                result = new SASDateTimeInformat();
            } else if (s.equalsIgnoreCase("TIME")) {
                result = new SASTimeInformat();
            } else if (s.equalsIgnoreCase("DATE")) {
                result = new SASDateInformat();
            }
            result.setInformat(SASFormat.getInstance((String)s));
            return result;
        }

        private static class SASTimeInformat
        extends SASInformat {
            private SimpleDateFormat formatter;
            private String[] patterns;
            private String[] timePatterns = new String[]{"HH:mm", "HH:mm:ss", "HH:mm:ss.SSS"};
            private String userPattern;
            private TimeZone timeZone = new SimpleTimeZone(0, "GMT");
            private int patternIndex;
            ParsePosition status;
            private StringBuffer temp = new StringBuffer();

            public SASTimeInformat() {
                this.userPattern = null;
                this.patternIndex = 1;
                this.patterns = this.timePatterns;
                this.formatter = new SimpleDateFormat(this.patterns[this.patternIndex], Locale.US);
                this.formatter.setTimeZone(this.timeZone);
                this.status = new ParsePosition(0);
            }

            public SASTimeInformat(int patternType) {
                this.userPattern = null;
                switch (patternType) {
                    default: 
                }
                this.patterns = this.timePatterns;
                this.patternIndex = 1;
                this.formatter = new SimpleDateFormat(this.patterns[this.patternIndex], Locale.US);
                this.formatter.setTimeZone(this.timeZone);
                this.status = new ParsePosition(0);
            }

            public SASTimeInformat(String pattern) {
                this.userPattern = pattern;
                this.formatter = new SimpleDateFormat(this.userPattern, Locale.US);
                this.formatter.setTimeZone(this.timeZone);
                this.status = new ParsePosition(0);
            }

            public void setTimeZone(TimeZone newTimeZone) {
                this.formatter.setTimeZone(this.timeZone);
            }

            public TimeZone getTimeZone() {
                return this.formatter.getTimeZone();
            }

            @Override
            public Object informat(String dateString) throws ParseException {
                int index = dateString.indexOf(46);
                String s = this.process(dateString);
                int length = s.length();
                if (this.userPattern == null) {
                    int pi = 1;
                    pi = length <= 7 ? 0 : (length > 8 && index != -1 ? 2 : (length <= 20 ? 1 : 1));
                    if (this.patternIndex != pi) {
                        this.patternIndex = pi;
                        this.formatter.applyPattern(this.patterns[this.patternIndex]);
                    }
                }
                this.status.setIndex(0);
                Date date = this.formatter.parse(s, this.status);
                double d = Double.NaN;
                if (date != null) {
                    d = this.convert(date.getTime());
                }
                return new Double(d);
            }

            private double convert(long javaDateValue) {
                return (double)javaDateValue / 1000.0;
            }

            private String process(String value) {
                String s = value.trim();
                int length = s.length();
                this.temp.setLength(0);
                for (int i = 0; i < length; ++i) {
                    char c = s.charAt(i);
                    if (Character.isDigit(c)) {
                        this.temp.append(c);
                        continue;
                    }
                    if (Character.isLetter(c)) {
                        this.temp.append(c);
                        continue;
                    }
                    if (c == ':') {
                        this.temp.append(c);
                        continue;
                    }
                    if (c != '.') continue;
                    this.temp.append(c);
                }
                return this.temp.toString();
            }
        }

        private static class SASDateTimeInformat
        extends SASInformat {
            private SimpleDateFormat formatter;
            private String[] patterns;
            private String[] dateTimePatterns = new String[]{"ddMMMyy:HH:mm", "ddMMMyy:HH:mm:ss", "ddMMMyyyy:HH:mm:ss", "ddMMMyy:HH:mm:ss.SSS", "ddMMMyyyy:HH:mm:ss.SSS"};
            private String userPattern;
            private TimeZone timeZone = new SimpleTimeZone(0, "GMT");
            private int patternIndex;
            ParsePosition status;
            private StringBuffer temp = new StringBuffer();

            public SASDateTimeInformat() {
                this.userPattern = null;
                this.patternIndex = 1;
                this.patterns = this.dateTimePatterns;
                this.formatter = new SimpleDateFormat(this.patterns[this.patternIndex], Locale.US);
                this.formatter.setTimeZone(this.timeZone);
                this.status = new ParsePosition(0);
            }

            public SASDateTimeInformat(int patternType) {
                this.userPattern = null;
                switch (patternType) {
                    default: 
                }
                this.patterns = this.dateTimePatterns;
                this.patternIndex = 1;
                this.formatter = new SimpleDateFormat(this.patterns[this.patternIndex], Locale.US);
                this.formatter.setTimeZone(this.timeZone);
                this.status = new ParsePosition(0);
            }

            public SASDateTimeInformat(String pattern) {
                this.userPattern = pattern;
                this.formatter = new SimpleDateFormat(this.userPattern, Locale.US);
                this.formatter.setTimeZone(this.timeZone);
                this.status = new ParsePosition(0);
            }

            public void setTimeZone(TimeZone newTimeZone) {
                this.formatter.setTimeZone(this.timeZone);
            }

            public TimeZone getTimeZone() {
                return this.formatter.getTimeZone();
            }

            @Override
            public Object informat(String dateString) throws ParseException {
                int index = dateString.indexOf(46);
                String s = this.process(dateString);
                int length = s.length();
                if (this.userPattern == null) {
                    int pi = 1;
                    pi = index == 16 ? 3 : (index == 18 ? 4 : (length <= 15 ? 0 : (length <= 18 ? 1 : (length <= 40 ? 2 : 1))));
                    if (this.patternIndex != pi) {
                        this.patternIndex = pi;
                        this.formatter.applyPattern(this.patterns[this.patternIndex]);
                    }
                }
                this.status.setIndex(0);
                Date date = this.formatter.parse(s, this.status);
                double d = Double.NaN;
                if (date != null) {
                    d = this.convert(date.getTime());
                }
                return new Double(d);
            }

            private double convert(long javaDateValue) {
                return (double)javaDateValue / 1000.0 + 3.156192E8;
            }

            private String process(String value) {
                String s = value.trim();
                int length = s.length();
                this.temp.setLength(0);
                for (int i = 0; i < length; ++i) {
                    char c = s.charAt(i);
                    if (Character.isDigit(c)) {
                        this.temp.append(c);
                        continue;
                    }
                    if (Character.isLetter(c)) {
                        this.temp.append(c);
                        continue;
                    }
                    if (c == ':') {
                        this.temp.append(c);
                        continue;
                    }
                    if (c != '.') continue;
                    this.temp.append(c);
                }
                return this.temp.toString();
            }
        }

        private static class SASDateInformat
        extends SASInformat {
            private SimpleDateFormat formatter;
            private String[] patterns;
            private String[] datePatterns = new String[]{"ddMMM", "ddMMMyy", "ddMMMyyyy"};
            private String userPattern;
            private TimeZone timeZone = new SimpleTimeZone(0, "GMT");
            private int patternIndex;
            private int patternType;
            ParsePosition status;
            private StringBuffer temp = new StringBuffer();

            public SASDateInformat() {
                this.userPattern = null;
                this.patternIndex = 1;
                this.patternType = 0;
                this.patterns = this.datePatterns;
                this.formatter = new SimpleDateFormat(this.patterns[this.patternIndex], Locale.US);
                this.formatter.setTimeZone(this.timeZone);
                this.status = new ParsePosition(0);
            }

            public SASDateInformat(int patternType) {
                this.userPattern = null;
                this.patternType = patternType;
                switch (patternType) {
                    default: 
                }
                this.patterns = this.datePatterns;
                this.patternIndex = 1;
                this.formatter = new SimpleDateFormat(this.patterns[this.patternIndex], Locale.US);
                this.formatter.setTimeZone(this.timeZone);
                this.status = new ParsePosition(0);
            }

            public SASDateInformat(String pattern) {
                this.patternType = -1;
                this.userPattern = pattern;
                this.formatter = new SimpleDateFormat(this.userPattern, Locale.US);
                this.formatter.setTimeZone(this.timeZone);
                this.status = new ParsePosition(0);
            }

            public void setTimeZone(TimeZone newTimeZone) {
                this.formatter.setTimeZone(this.timeZone);
            }

            public TimeZone getTimeZone() {
                return this.formatter.getTimeZone();
            }

            @Override
            public Object informat(String dateString) throws ParseException {
                int index = dateString.indexOf(58);
                String s = index != -1 ? this.process(dateString.substring(0, index)) : this.process(dateString);
                int length = s.length();
                if (this.userPattern == null) {
                    int pi = 1;
                    pi = length <= 5 ? 0 : (length <= 7 ? 1 : (length <= 9 ? 2 : 1));
                    if (this.patternIndex != pi) {
                        this.patternIndex = pi;
                        this.formatter.applyPattern(this.patterns[this.patternIndex]);
                    }
                }
                this.status.setIndex(0);
                Date date = this.formatter.parse(s, this.status);
                double d = Double.NaN;
                if (date != null) {
                    d = this.convert(date.getTime());
                }
                return new Double(d);
            }

            private double convert(long javaDateValue) {
                return javaDateValue / 86400000L + 3653L;
            }

            private String process(String value) {
                String s = value.trim();
                int length = s.length();
                int size = 2;
                this.temp.setLength(0);
                for (int i = 0; i < length; ++i) {
                    char c = s.charAt(i);
                    if (Character.isDigit(c)) {
                        this.temp.append(c);
                        continue;
                    }
                    if (Character.isLetter(c)) {
                        this.temp.append(c);
                        continue;
                    }
                    if (this.patternType != 1 || c != '/') continue;
                    if (this.temp.length() != size) {
                        this.temp.insert(this.temp.length() - 1, '0');
                    }
                    size = 4;
                }
                return this.temp.toString();
            }
        }

        private static class DateInformatParser {
            private String informat;
            private int numberPart = 0;
            private String textPart = null;
            private String message = null;

            public DateInformatParser(String newInformat) throws IllegalArgumentException {
                if (newInformat == null) {
                    throw new IllegalArgumentException(this.message);
                }
                this.informat = newInformat;
                this._init();
            }

            private void _init() throws IllegalStateException {
                int ii;
                StringBuffer tmpChar = new StringBuffer();
                StringBuffer tmpNum = new StringBuffer();
                String s = this.informat.trim();
                boolean valid = false;
                tmpChar.setLength(0);
                tmpNum.setLength(0);
                int length = s.length();
                for (ii = 0; ii < length; ++ii) {
                    char c = s.charAt(ii);
                    if (Character.isDigit(c)) {
                        tmpNum.append(c);
                    }
                    if (!Character.isLetter(c)) continue;
                    tmpChar.append(c);
                }
                this.textPart = tmpChar.toString();
                try {
                    this.numberPart = new Double(tmpNum.toString()).intValue();
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException();
                }
                ii = this.numberPart;
                if (this.textPart.equalsIgnoreCase("DATETIME") && (ii == 13 || ii == 16 || ii == 18 || ii == 20 || ii == 22)) {
                    valid = true;
                } else if (this.textPart.equalsIgnoreCase("TIME") && (ii == 5 || ii == 8 || ii == 12)) {
                    valid = true;
                } else if (this.textPart.equalsIgnoreCase("DATE") && (ii == 5 || ii == 7 || ii == 9)) {
                    valid = true;
                }
                if (!valid) {
                    throw new IllegalStateException();
                }
            }

            public String getTextPart() {
                return this.textPart;
            }
        }
    }

    static abstract class CategoryHashtable
    extends PropertyContainer
    implements IntegerPipe {
        private Variable container;
        protected Map uvToC = new LinkedHashMap();
        protected UniqueValue tempUV = new UniqueValue();

        public CategoryHashtable(Variable nv) {
            this.container = nv;
        }

        @Override
        public abstract int getValue(int var1) throws MissingValueException;

        @Override
        public void init(AInitAction initAction) {
            super.init(initAction);
            this.container.buildCategoryTable();
        }

        public void init(int valueCount) {
            this.uvToC.clear();
        }

        public Map getHashtable() {
            return this.uvToC;
        }

        private void addUniqueValue(UniqueValue uv, String formattedValue, boolean compareByFormattedValue, int index) {
            uv.setCompareByFormattedValue(compareByFormattedValue);
            uv.setFormattedValue(formattedValue);
            Object o = this.uvToC.get(uv);
            if (o == null) {
                UniqueValue newUV = new UniqueValue(uv, index, this.uvToC.size());
                this.uvToC.put(newUV, newUV);
            }
        }

        public void addUniqueValue(MissingValues value, String formattedValue, boolean compareByFormattedValue, int index) {
            this.tempUV.setValue(value);
            this.addUniqueValue(this.tempUV, formattedValue, compareByFormattedValue, index);
        }

        public void addUniqueValue(double value, String formattedValue, boolean compareByFormattedValue, int index) {
            this.tempUV.setValue(value);
            this.addUniqueValue(this.tempUV, formattedValue, compareByFormattedValue, index);
        }

        public void addUniqueValue(String value, String formattedValue, boolean compareByFormattedValue, int index) {
            this.tempUV.setValue(value);
            this.addUniqueValue(this.tempUV, formattedValue, compareByFormattedValue, index);
        }

        protected int valueToCategory(UniqueValue key) {
            UniqueValue value = (UniqueValue)this.uvToC.get(key);
            return value.getCategory();
        }
    }

    static abstract class FormattedValueHashMap
    extends PropertyContainer
    implements StringPipe {
        private Variable container;
        private Map valueToFormattedValue = new HashMap();

        public FormattedValueHashMap(Variable v) {
            this.container = v;
        }

        @Override
        public void init(AInitAction initAction) {
        }
    }
}

