/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVector;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ValueMap
extends PropertyContainer
implements Pipe {
    protected boolean replaceMissingValues = false;
    protected boolean labelMissingValues = false;
    private static final String defaultMissingLabel = ValueMap.getDefaultMissingValueLabel(MissingValues.Dot);
    private String missingValueLabel = defaultMissingLabel;
    private Map missingValueInfoTable = new LinkedHashMap();
    private GTKFormat format = null;
    private Formatter formatter = Formatter.defaultFormatter;
    private Pipe owner;
    protected StringVector labelVector = new StringVector();
    public final StringPipe label = this.labelVector;

    public ValueMap() {
        this.labelVector.setOwner(this);
    }

    public void setOwner(Pipe owner) {
        this.owner = owner;
    }

    public Pipe getOwner() {
        return this.owner;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    public Formatter getOwnerFormatter() {
        return this.owner == null ? this.formatter : this.owner.getFormatter();
    }

    public GTKFormat getFormat() {
        return this.format;
    }

    public void setFormat(GTKFormat format) {
        this.formatter = format == null ? Formatter.defaultFormatter : new Formatter(format);
        this.format = format;
        this.setModified();
    }

    protected boolean isUserSetFormat() {
        return this.format != null;
    }

    public void setMissingValueLabel(String s) {
        this.missingValueLabel = s;
        this.setModified();
    }

    public String getMissingValueLabel() {
        return this.missingValueLabel;
    }

    private Map newMissingValueInfoMap() {
        return new LinkedHashMap();
    }

    public void setMissingValueLabel(String s, MissingValues missingValue) {
        MissingValueInfoEntry e = this.getMissingValueEntry(missingValue);
        e.setLabel(s);
        this.setModified();
    }

    public String getMissingValueLabel(MissingValues missingValue) {
        String result = null;
        MissingValueInfoEntry e = (MissingValueInfoEntry)this.missingValueInfoTable.get(missingValue);
        if (e != null) {
            result = e.getLabel();
        }
        if (result == null) {
            result = this.missingValueLabel;
        }
        if (result == null) {
            result = ValueMap.getDefaultMissingValueLabel(missingValue);
        }
        return result;
    }

    public static String getDefaultMissingValueLabel(MissingValues mv) {
        String result = mv == MissingValues._BLANK_ ? "" : ".";
        return result;
    }

    protected void setReplaceMissingValues(boolean b) {
        this.replaceMissingValues = b;
        this.setModified();
    }

    protected void setReplaceMissingValues(boolean b, MissingValues mv) {
        MissingValueInfoEntry e = this.getMissingValueEntry(mv);
        e.setReplace(b);
        this.setModified();
    }

    private MissingValueInfoEntry getMissingValueEntry(MissingValues missingValue) {
        MissingValueInfoEntry e = (MissingValueInfoEntry)this.missingValueInfoTable.get(missingValue);
        if (e == null) {
            e = new MissingValueInfoEntry();
            e.missingValue = missingValue;
            e.label = null;
            this.missingValueInfoTable.put(missingValue, e);
        }
        return e;
    }

    public boolean isReplaceMissingValues() {
        return this.replaceMissingValues;
    }

    public boolean isReplaceMissingValues(MissingValues mv) {
        MissingValueInfoEntry e;
        boolean result = this.isReplaceMissingValues();
        if (!result && (e = (MissingValueInfoEntry)this.missingValueInfoTable.get(mv)) != null) {
            result = e.isReplace();
        }
        return result;
    }

    public boolean isLabelMissingValues() {
        return this.labelMissingValues;
    }

    public void setLabelMissingValues(boolean b) {
        this.labelMissingValues = b;
        this.setModified();
    }

    public void setLabelMissingValues(boolean b, MissingValues missingValue) {
        MissingValueInfoEntry e = this.getMissingValueEntry(missingValue);
        e.setLabelVisible(b);
        this.setModified();
    }

    public boolean isLabelMissingValues(MissingValues missingValue) {
        boolean result = this.isLabelMissingValues();
        MissingValueInfoEntry e = (MissingValueInfoEntry)this.missingValueInfoTable.get(missingValue);
        if (e != null) {
            result = e.isLabelVisible();
        }
        if (!result) {
            result = this.isLabelMissingValues();
        }
        return result;
    }

    protected boolean isLabelMissingValuesAny() {
        boolean result = this.labelMissingValues;
        if (!result && this.missingValueInfoTable.size() > 0) {
            Iterator keys = this.missingValueInfoTable.entrySet().iterator();
            while (keys.hasNext() && !result) {
                Map.Entry entry = keys.next();
                MissingValueInfoEntry e = (MissingValueInfoEntry)entry.getValue();
                result |= e.isLabelVisible();
            }
        }
        return result;
    }

    protected boolean isReplaceMissingValuesAny() {
        boolean result = this.replaceMissingValues;
        if (!result) {
            Iterator keys = this.missingValueInfoTable.entrySet().iterator();
            while (keys.hasNext() && !result) {
                Map.Entry entry = keys.next();
                MissingValueInfoEntry e = (MissingValueInfoEntry)entry.getValue();
                result |= e.isReplace();
            }
        }
        return result;
    }

    protected void setMissingReplacementImpl(Object replacement, MissingValues missingValue) {
        MissingValueInfoEntry e = this.getMissingValueEntry(missingValue);
        e.setReplacement(replacement);
        this.setModified();
    }

    protected Object getMissingReplacementImpl(MissingValues missingValue) {
        Object result = null;
        MissingValueInfoEntry e = (MissingValueInfoEntry)this.missingValueInfoTable.get(missingValue);
        if (e != null) {
            result = e.getReplacement();
        }
        return result;
    }

    protected Map getMissingValueInfoTable() {
        return this.missingValueInfoTable;
    }

    protected static class MissingValueInfoEntry {
        private MissingValues missingValue = null;
        private boolean replace = false;
        private boolean labelVisible = false;
        private String label = null;
        private Object replacement = null;

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public MissingValues getMissingValue() {
            return this.missingValue;
        }

        public void setMissingValue(MissingValues missingValue) {
            this.missingValue = missingValue;
        }

        public boolean isReplace() {
            return this.replace;
        }

        public void setReplace(boolean replace) {
            this.replace = replace;
        }

        public Object getReplacement() {
            return this.replacement;
        }

        public void setReplacement(Object replacement) {
            this.replacement = replacement;
        }

        public boolean isLabelVisible() {
            return this.labelVisible;
        }

        public void setLabelVisible(boolean labelVisible) {
            this.labelVisible = labelVisible;
        }
    }
}

