/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeToNumericMap
extends StringToNumericMap {
    private static String[] labelPatterns = new String[]{"yyyy", "MMM yyyy", "MMM yyyy", "dd MMM yy", "dd MMM", "dd MMM", "hh a", "hh:mm a", "mm:ss"};
    protected String pattern = "ddMMMyy";
    protected int interval;
    protected int lastLabel;
    protected Formatter labelFormatter;
    protected Formatter dateFormatter;
    protected int period = 1;
    private SimpleDateFormat sdf = new SimpleDateFormat();
    private SimpleDateFormat dateFormat;
    private ParsePosition pp = new ParsePosition(0);

    public TimeToNumericMap() {
        this.dateFormat = new SimpleDateFormat();
        this.dateFormatter = new Formatter(new GTKFormat(this.dateFormat));
    }

    @Override
    public double getOutputMin() {
        return 0.0;
    }

    @Override
    public double getOutputMax() {
        return 0.0;
    }

    @Override
    public void init(AInitAction ia) {
        int i;
        String labelPattern = null;
        this.sdf.applyPattern(this.pattern);
        int stringPipeCount = this.getStringPipeCount();
        for (i = 0; i < stringPipeCount; ++i) {
            StringPipe sp = this.getStringPipe(i);
            sp.init(ia);
        }
        if (ia.beenInitialized(this)) {
            return;
        }
        this.lastLabel = -1;
        if (this.getFormat() == null) {
            switch (this.interval) {
                case 0: {
                    labelPattern = labelPatterns[0];
                    break;
                }
                case 1: 
                case 2: {
                    labelPattern = labelPatterns[2];
                    break;
                }
                case 3: {
                    labelPattern = labelPatterns[3];
                    break;
                }
                case 4: 
                case 5: {
                    labelPattern = labelPatterns[5];
                    break;
                }
                case 6: {
                    labelPattern = labelPatterns[6];
                    break;
                }
                case 7: {
                    labelPattern = labelPatterns[7];
                    break;
                }
                case 8: {
                    labelPattern = labelPatterns[8];
                    break;
                }
            }
            if (labelPattern != null) {
                this.dateFormat.applyPattern(labelPattern);
                this.labelFormatter = this.dateFormatter;
            } else {
                this.labelFormatter = this.getOwnerFormatter();
            }
        } else {
            this.labelFormatter = this.getOwnerFormatter();
        }
        this.uniqueValueVector.removeAllValues();
        this.labelVector.removeAllValues();
        double start = this.getStartValue();
        double stride = this.getStrideValue();
        int index = 0;
        double mappedValue = start;
        while (index < ia.getValueCount()) {
            try {
                String dateTime = this.getStringPipe(0).getValue(index);
                for (i = 1; i < stringPipeCount; ++i) {
                    dateTime = dateTime + this.getStringPipe(i).getValue(index);
                }
                this.pp.setIndex(0);
                Date parsedDate = this.sdf.parse(dateTime, this.pp);
                if (this.isLabelled(parsedDate)) {
                    this.labelVector.addValue(this.labelFormatter.format(parsedDate).trim());
                    this.uniqueValueVector.addValue(mappedValue);
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            ++index;
            mappedValue += stride;
        }
    }

    public double getValue(int index) throws MissingValueException {
        return this.getStartValue() + this.getStrideValue() * (double)index;
    }

    public int getLabelCount() {
        return this.labelVector.size();
    }

    public void setLabelInterval(int anInterval) {
        this.interval = anInterval;
        this.setModified();
    }

    public int getLabelInterval() {
        return this.interval;
    }

    public void setLabelPeriod(int aPeriod) {
        this.period = aPeriod;
        this.setModified();
    }

    public int getLabelPeriod() {
        return this.period;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String aPattern) {
        this.pattern = aPattern;
        this.setModified();
    }

    protected boolean isLabelled(Date thisDate) {
        int fieldValue;
        Calendar calendar = this.sdf.getCalendar();
        calendar.setTime(thisDate);
        switch (this.interval) {
            case 0: {
                fieldValue = calendar.get(1);
                break;
            }
            case 1: {
                fieldValue = calendar.get(2) / 4;
                break;
            }
            case 2: {
                fieldValue = calendar.get(2);
                break;
            }
            case 3: {
                fieldValue = 2 * calendar.get(2) + calendar.get(5) / 15;
                break;
            }
            case 4: {
                fieldValue = calendar.get(3);
                break;
            }
            case 5: {
                fieldValue = calendar.get(5);
                break;
            }
            case 6: {
                fieldValue = calendar.get(10);
                break;
            }
            case 7: {
                fieldValue = calendar.get(12);
                break;
            }
            case 8: {
                fieldValue = calendar.get(13);
                break;
            }
            default: {
                int fieldValue2 = -1;
                return true;
            }
        }
        if (this.lastLabel != (fieldValue /= this.period)) {
            this.lastLabel = fieldValue;
            return true;
        }
        return false;
    }
}

