/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.gtk.Style;
import java.awt.Color;
import java.awt.Font;

public class TextStyle
extends Style {
    private Color color;
    private Color altColor;
    private Color backgroundColor;
    private Font font;
    private double angle;
    private int horizontalJustification;
    private int verticalJustification;
    private boolean stagger;
    private boolean split;
    private boolean fit;
    private boolean truncate;
    private boolean shadowOn;
    private Color shadowColor;
    private int shadowOffsetX;
    private int shadowOffsetY;
    private float shadowSoftness;

    public TextStyle() {
        this.color = Color.black;
        this.altColor = Color.black;
        this.backgroundColor = null;
        this.font = FontManager.getDefaultFont();
        this.angle = 0.0;
        this.horizontalJustification = 0;
        this.verticalJustification = 2;
        this.stagger = false;
        this.split = false;
        this.fit = false;
        this.truncate = false;
        this.shadowOn = false;
        this.shadowColor = Color.black;
        this.shadowOffsetX = 3;
        this.shadowOffsetY = 3;
    }

    public TextStyle(TextStyle ts) {
        this.color = ts.color;
        this.altColor = ts.altColor;
        this.backgroundColor = ts.backgroundColor;
        this.font = ts.font;
        this.angle = ts.angle;
        this.horizontalJustification = ts.horizontalJustification;
        this.verticalJustification = ts.verticalJustification;
        this.stagger = ts.stagger;
        this.split = ts.split;
        this.fit = ts.fit;
        this.truncate = ts.truncate;
        this.shadowOn = ts.shadowOn;
        this.shadowColor = ts.shadowColor;
        this.shadowOffsetX = ts.shadowOffsetX;
        this.shadowOffsetY = ts.shadowOffsetY;
    }

    public void setColor(Color aColor) {
        if (aColor != null) {
            this.color = aColor;
        }
    }

    public void setAltColor(Color aColor) {
        if (aColor != null) {
            this.altColor = aColor;
        }
    }

    public void setBackgroundColor(Color aColor) {
        if (aColor != null) {
            this.backgroundColor = aColor;
        }
    }

    public void setFont(Font aFont) {
        if (aFont != null) {
            this.font = aFont;
        }
    }

    public void setAngle(double aAngle) {
        if (!Double.isNaN(aAngle)) {
            this.angle = aAngle;
        }
    }

    public void setHorizontalJustification(int hj) {
        if (hj >= 0 && hj <= 2) {
            this.horizontalJustification = hj;
        }
    }

    public void setVerticalJustification(int vj) {
        if (vj >= 0 && vj <= 3) {
            this.verticalJustification = vj;
        }
    }

    public void setStagger(boolean trueOrFalse) {
        this.stagger = trueOrFalse;
    }

    public void setSplit(boolean trueOrFalse) {
        this.split = trueOrFalse;
    }

    public void setFit(boolean trueOrFalse) {
        this.fit = trueOrFalse;
    }

    public void setTruncate(boolean trueOrFalse) {
        this.truncate = trueOrFalse;
    }

    public void setShadowOn(boolean trueOrFalse) {
        this.shadowOn = trueOrFalse;
    }

    public void setShadowColor(Color c) {
        this.shadowColor = c;
    }

    public void setShadowOffsetX(int offset) {
        this.shadowOffsetX = offset;
    }

    public void setShadowOffsetY(int offset) {
        this.shadowOffsetY = offset;
    }

    public void setShadowSoftness(float softness) {
        this.shadowSoftness = softness;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getAltColor() {
        return this.altColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Font getFont() {
        return this.font;
    }

    public double getAngle() {
        return this.angle;
    }

    public int getHorizontalJustification() {
        return this.horizontalJustification;
    }

    public int getVerticalJustification() {
        return this.verticalJustification;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public int getShadowOffsetX() {
        return this.shadowOffsetX;
    }

    public int getShadowOffsetY() {
        return this.shadowOffsetY;
    }

    public float getShadowSoftness() {
        return this.shadowSoftness;
    }

    public boolean isStagger() {
        return this.stagger;
    }

    public boolean isSplit() {
        return this.split;
    }

    public boolean isFit() {
        return this.fit;
    }

    public boolean isTruncate() {
        return this.truncate;
    }

    public boolean isShadowOn() {
        return this.shadowOn;
    }
}

