/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.VariableProcessor;
import java.util.Vector;

class SubsetProcessor {
    private int lowObs;
    private int highObs;
    private int[] obsIncludeList;
    private int obsIncludeListCount;
    private boolean isEnabled = false;

    SubsetProcessor() {
    }

    public void setLowObs(int lowObs) {
        this.obsIncludeList = null;
        this.lowObs = lowObs;
    }

    public int getLowObs() {
        return this.lowObs;
    }

    public void setHighObs(int highObs) {
        this.obsIncludeList = null;
        this.highObs = highObs;
    }

    public int getHighObs() {
        return this.highObs;
    }

    public void setObsIncludeList(int[] obsIncludeList, int obsIncludeListCout) {
        this.obsIncludeList = obsIncludeList;
        this.obsIncludeListCount = obsIncludeListCout;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public int process(Vector allVariables, int aValueCount) {
        int valueCount;
        if (!this.isEnabled || aValueCount == 0) {
            return aValueCount;
        }
        int l = 0;
        if (this.obsIncludeList == null) {
            l = this.lowObs;
            int h = this.highObs;
            if (l < 0) {
                l = 0;
            } else if (l >= aValueCount) {
                l = aValueCount - 1;
            }
            if (h < l) {
                h = l;
            } else if (h >= aValueCount) {
                h = aValueCount - 1;
            }
            valueCount = h - l + 1;
        } else {
            valueCount = this.obsIncludeListCount;
        }
        int variableCount = allVariables.size();
        for (int i = 0; i < variableCount; ++i) {
            SubsetPipe subsetPipe;
            VariableProcessor.VEntry ve = (VariableProcessor.VEntry)allVariables.elementAt(i);
            if (ve.variable instanceof NumericVariable) {
                NumericVariable nv = (NumericVariable)ve.variable;
                NumericSubsetPipe np = new NumericSubsetPipe(nv.getProcessedValuePipe());
                subsetPipe = np;
                nv.setProcessedValuePipe(np, valueCount);
            } else {
                StringVariable sv = (StringVariable)ve.variable;
                StringSubsetPipe sp = new StringSubsetPipe(sv.getProcessedValuePipe());
                subsetPipe = sp;
                sv.setProcessedValuePipe(sp, valueCount);
            }
            subsetPipe.setValueCount(valueCount);
            if (this.obsIncludeList == null) {
                subsetPipe.setStartIndex(l);
                continue;
            }
            subsetPipe.setIncludeList(this.obsIncludeList);
        }
        return valueCount;
    }

    private class StringSubsetPipe
    extends SubsetPipe
    implements StringPipe {
        private StringPipe rawValuePipe;

        public StringSubsetPipe(StringPipe aRawValuePipe) {
            this.rawValuePipe = aRawValuePipe;
        }

        @Override
        public String getValue(int i) throws MissingValueException {
            return this.rawValuePipe.getValue(this.getIndex(i));
        }
    }

    private class NumericSubsetPipe
    extends SubsetPipe
    implements NumericPipe {
        private NumericPipe rawValuePipe;

        public NumericSubsetPipe(NumericPipe aRawValuePipe) {
            this.rawValuePipe = aRawValuePipe;
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            return this.rawValuePipe.getValue(this.getIndex(i));
        }
    }

    private class SubsetPipe
    implements Pipe {
        protected int startIndex;
        protected int subsetValueCount;
        protected int[] includeList;

        private SubsetPipe() {
        }

        public void setIncludeList(int[] includeList) {
            this.includeList = includeList;
        }

        public void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            this.includeList = null;
        }

        public void setValueCount(int subsetValueCount) {
            this.subsetValueCount = subsetValueCount;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.subsetValueCount);
        }

        protected int getIndex(int i) throws MissingValueException {
            if (this.includeList == null) {
                return this.startIndex + i;
            }
            if (i < 0 || i >= this.subsetValueCount) {
                throw MissingValueException.getDefaultMissingValueExeption();
            }
            return this.includeList[i];
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }
    }
}

