/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import java.util.Vector;

public class StringVectorVariable
extends StringVariable {
    private StringVectorConnection connection = new StringVectorConnection();

    public void setBlankMissing(boolean trueOrFalse) {
        this.connection.setBlankMissing(trueOrFalse);
        this.setModified(true);
    }

    public boolean isBlankMissing() {
        return this.connection.isBlankMissing();
    }

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(String[] data) {
        this.connection.connectFrom(data);
        this.connectFrom();
    }

    public void connectFrom(Vector data) {
        this.connection.connectFrom(data);
        this.connectFrom();
    }

    public void connectFrom(StringPipe aStringPipe) {
        this.connection.connectFrom(aStringPipe);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, -1);
        super.connectFrom();
    }

    public String[] getConnectionData() {
        return this.connection.getConnectionData();
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isRawValueMissing(int index) {
        return this.connection.isMissing(index);
    }

    private static class StringVectorConnection
    implements StringPipe {
        private String[] array;
        private Vector vector;
        private StringPipe stringPipe;
        private boolean blankMissing = true;

        private StringVectorConnection() {
        }

        public String[] getConnectionData() {
            Object[] result;
            if (this.array != null) {
                result = this.array;
            } else if (this.vector != null) {
                result = new String[this.vector.size()];
                this.vector.copyInto(result);
            } else {
                result = new String[]{};
            }
            return result;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.getValueCount(initAction));
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        private int getValueCount(AInitAction ia) {
            if (this.vector != null) {
                return this.vector.size();
            }
            if (this.array != null) {
                return this.array.length;
            }
            if (ia == null) {
                ia = new AInitAction();
            }
            this.stringPipe.init(ia);
            return ia.getValueCount();
        }

        public int getValueCount() {
            return this.getValueCount(null);
        }

        public void connectFrom(StringPipe aStringPipe) {
            this.disconnect();
            if (aStringPipe == null) {
                throw new RuntimeException("Attempt to connect a null data source.");
            }
            this.stringPipe = aStringPipe;
        }

        public void connectFrom(String[] anArray) {
            this.disconnect();
            if (anArray == null) {
                throw new RuntimeException("Attempt to connect a null data source.");
            }
            this.array = anArray;
        }

        public void connectFrom(Vector aVector) {
            this.disconnect();
            if (aVector == null) {
                throw new RuntimeException("Attempt to connect a null data source.");
            }
            this.vector = aVector;
        }

        public void disconnect() {
            this.array = null;
            this.vector = null;
            this.stringPipe = null;
        }

        public void setBlankMissing(boolean trueOrFalse) {
            this.blankMissing = trueOrFalse;
        }

        public boolean isBlankMissing() {
            return this.blankMissing;
        }

        private Object getStringValue(int i) throws MissingValueException {
            if (this.array != null) {
                return this.array[i];
            }
            if (this.vector != null) {
                return this.vector.elementAt(i);
            }
            return this.stringPipe.getValue(i);
        }

        @Override
        public String getValue(int i) throws MissingValueException {
            String s;
            boolean isMissing = false;
            MissingValues mv = MissingValues._BLANK_;
            Object o = this.getStringValue(i);
            if (o instanceof String && this.blankMissing) {
                s = (String)o;
                int n = s.length();
                if (n <= 0) {
                    isMissing = true;
                } else if (s.charAt(0) == ' ') {
                    isMissing = true;
                    for (int j = 1; j < n; ++j) {
                        if (s.charAt(j) == ' ') continue;
                        isMissing = false;
                        break;
                    }
                }
            } else if (o instanceof MissingValues) {
                isMissing = true;
                mv = (MissingValues)o;
            } else if (o == null) {
                isMissing = true;
            } else {
                o = o.toString();
            }
            if (isMissing) {
                MissingValueException e = new MissingValueException();
                e.setMissingValue(mv);
                throw e;
            }
            s = (String)o;
            return s;
        }

        public boolean isMissing(int i) {
            Object o;
            boolean isMissing = false;
            try {
                o = this.getStringValue(i);
            }
            catch (MissingValueException e) {
                o = e.getMissingValue();
            }
            if (o instanceof String && this.blankMissing) {
                String s = (String)o;
                int n = s.length();
                if (n <= 0) {
                    isMissing = true;
                } else if (s.charAt(0) == ' ') {
                    isMissing = true;
                    for (int j = 1; j < n; ++j) {
                        if (s.charAt(j) == ' ') continue;
                        isMissing = false;
                        break;
                    }
                }
            } else if (o instanceof MissingValues) {
                isMissing = true;
            } else if (o == null) {
                isMissing = true;
            }
            return isMissing;
        }
    }
}

