/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringPipeSwitcher;
import com.sas.graphics.util.gtk.StringPipedFormat;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.UniqueValue;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.text.SASFormat;
import java.text.Format;
import java.util.Map;

public class StringVariable
extends Variable {
    private StringPipe rawValuePipe;
    private StringPipedFormat valueFormat;
    private StringPipedFormat uniqueValueFormat;
    private StringVariablePipeSwitcher valueSwitcher = new StringVariablePipeSwitcher(this);
    private StringUniqueValueVector uniqueValueVector = new StringUniqueValueVector(0, this);
    private StringCategoryHashtable categoryTable = new StringCategoryHashtable(this);
    public final StringPipe value = this.valueSwitcher;
    private final StringPipeSwitcher uniqueValueSwitcher = new StringPipeSwitcher();
    public final StringPipe uniqueValue = this.uniqueValueSwitcher;
    public final IntegerPipe category = this.categoryTable;

    public StringVariable() {
        super(new StringPipedFormat(), new StringPipedFormat());
        this.categoryTable.input.connectFrom(this.value);
        this.uniqueValueVector.setOwner(this.valueSwitcher);
        this.uniqueValueSwitcher.connectFrom(this.uniqueValueVector);
        this.valueFormat = (StringPipedFormat)this.getValueFormat();
        this.uniqueValueFormat = (StringPipedFormat)this.getUniqueValueFormat();
        this.valueFormat.input.connectFrom(this.value);
        this.uniqueValueFormat.input.connectFrom(this.uniqueValue);
        this.setFormattedValueMissingValueExceptionsEnabled(this.isFormattedValueMissingValueExceptionsEnabled());
    }

    @Override
    public void setFormattedValueMissingValueExceptionsEnabled(boolean formattedValueMissingValueExceptionsEnabled) {
        super.setFormattedValueMissingValueExceptionsEnabled(formattedValueMissingValueExceptionsEnabled);
        this.valueFormat.setMissingValueExceptionsEnabled(this.isFormattedValueMissingValueExceptionsEnabled());
        this.uniqueValueFormat.setMissingValueExceptionsEnabled(this.isFormattedValueMissingValueExceptionsEnabled());
    }

    protected StringPipeSwitcher getUniqueValueSwitcher() {
        return this.uniqueValueSwitcher;
    }

    @Override
    protected IntegerPipe getCategory() {
        return this.category;
    }

    protected void setRawValuePipe(StringPipe sp, int valueCount) {
        this.rawValuePipe = sp;
        this.valueSwitcher.connectFrom(this.rawValuePipe);
        this.setRawValueCount(valueCount);
        this.setProcessedValueCount(-1);
    }

    protected StringPipe getRawValuePipe() {
        return this.rawValuePipe;
    }

    protected void setProcessedValuePipe(StringPipe sp, int valueCount) {
        if (sp == null) {
            if (this.rawValuePipe != null) {
                this.valueSwitcher.connectFrom(this.rawValuePipe);
            }
            this.setProcessedValueCount(-1);
        } else {
            this.valueSwitcher.connectFrom(sp);
            this.setProcessedValueCount(valueCount);
        }
    }

    protected StringPipe getProcessedValuePipe() {
        return this.valueSwitcher.getConnection();
    }

    @Override
    protected Map getCategoryHashtable() {
        return this.categoryTable.getHashtable();
    }

    @Override
    protected Variable.CategoryHashtable getCategoryTable() {
        return this.categoryTable;
    }

    @Override
    protected void addUniqueValue(int i) {
        boolean needFormattedValue = this.isCalculateUniqueValuesByFormattedValue() || this.isSortByFormattedValues();
        String fv = null;
        try {
            if (needFormattedValue) {
                fv = this.formattedValue.getValue(i);
            }
            this.categoryTable.addUniqueValue(this.value.getValue(i), fv, this.isCalculateUniqueValuesByFormattedValue(), i);
        }
        catch (MissingValueException e) {
            MissingValues mv = e.getMissingValue();
            if (needFormattedValue) {
                fv = this.value.getFormatter().format(mv);
            }
            this.categoryTable.addUniqueValue(mv, fv, this.isCalculateUniqueValuesByFormattedValue(), i);
        }
    }

    @Override
    protected int buildUniqueValueVector() {
        this.buildCategoryTable();
        return this.uniqueValueVector.build();
    }

    @Override
    public void disconnect() {
        this.calNumUniqueValues = true;
        super.disconnect();
    }

    @Override
    public void init() {
        StringVariable v = this;
        v.category.init(new AInitAction());
        v.formattedValue.init(new AInitAction());
        v.formattedUniqueValue.init(new AInitAction());
    }

    @Override
    protected void init(AInitAction initAction) {
        if (this.getConnection() != null) {
            boolean icr = initAction.isCategoryRequest();
            this.getConnection().init(initAction);
            initAction.setCategoryRequest(icr);
            long connectionModifiedTime = initAction.getDataChangedTime();
            long myModifiedTime = this.getModifiedTime();
            if (connectionModifiedTime > myModifiedTime) {
                this.setModified(true, connectionModifiedTime);
            }
        }
        if (initAction.isCategoryRequest()) {
            initAction.setCategoryRequest(false);
            initAction.pushValueCount();
            this.uniqueValueVector.init(initAction);
            initAction.popValueCount();
            initAction.setCategoryPipe(this.categoryTable);
            initAction.setUniqueValueVector(this.uniqueValueVector);
        }
        super.init(initAction);
    }

    @Override
    public void setFormat(GTKFormat format) {
        SASFormat sf;
        Format[] f;
        if (format != null && (f = format.getFormats())[0] instanceof SASFormat && !(sf = (SASFormat)f[0]).isCharacterFormat()) {
            return;
        }
        super.setFormat(format);
    }

    public void connectFrom(StringVariable connectionVariable) {
        this.setConnection(connectionVariable);
        this.setRawValuePipe(connectionVariable.value, -1);
        if (this.getName().startsWith(defaultName)) {
            this.setName(connectionVariable.getName());
        }
        this.connectFrom();
        this.setModified(true);
    }

    public void connectFrom(NumericVariable connectionVariable) {
        this.setConnection(connectionVariable);
        int vc = connectionVariable.getValueCount();
        this.setRawValuePipe(connectionVariable.formattedValue, vc);
        if (this.getName().startsWith(defaultName)) {
            this.setName(connectionVariable.getName());
        }
        this.connectFrom();
        this.setModified(true);
    }

    @Override
    public String getColumnName() {
        return super.getColumnName(this.getConnection());
    }

    @Override
    public boolean isRawValueMissing(int i) {
        if (this.getConnection() != null) {
            return this.isMissing(i);
        }
        throw new IllegalStateException("isRawValueMissing(int) should be overriden by Variable subclasses.");
    }

    @Override
    public boolean isMissing(int i) {
        boolean result;
        try {
            if (this.getConnection() == null) {
                this.value.getValue(i);
            } else if (this.getConnection() instanceof StringVariable) {
                StringVariable sv = (StringVariable)this.getConnection();
                sv.value.getValue(i);
            } else {
                NumericVariable nv = (NumericVariable)this.getConnection();
                nv.value.getValue(i);
            }
            result = false;
        }
        catch (MissingValueException e) {
            result = true;
        }
        return result;
    }

    @Override
    protected int getRawValueCount() {
        if (this.getConnection() == null) {
            throw new RuntimeException("No data connection.");
        }
        return this.getConnection().getValueCount();
    }

    @Override
    public int getUniqueValueCount() {
        AInitAction ia = new AInitAction();
        this.uniqueValue.init(ia);
        return ia.getValueCount();
    }

    public int getFirstOccurringValueIndex(int uniqueValueIndex) {
        String v;
        int uniqueValueCount = this.getUniqueValueCount();
        if (uniqueValueIndex < 0 || uniqueValueIndex > uniqueValueCount - 1) {
            throw new IllegalArgumentException("UniqueValueIndex out of range.");
        }
        String fv = null;
        try {
            v = this.uniqueValue.getValue(uniqueValueIndex);
            if (this.isCalculateUniqueValuesByFormattedValue()) {
                fv = this.value.getFormatter().format(v);
            }
        }
        catch (MissingValueException e) {
            v = e.getMissingValue();
        }
        return this.getFirstOccurringValueIndex(v, fv, this.categoryTable.getHashtable());
    }

    private static class StringUniqueValueVector
    extends StringVector {
        private StringVariable container;

        public StringUniqueValueVector(int size, StringVariable nv) {
            super(size);
            this.container = nv;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.pushValueCount();
            this.container.category.init(initAction);
            initAction.popValueCount();
            int valueCount = this.build();
            initAction.setValueCount(valueCount);
        }

        public int build() {
            Map categoryTable = this.container.getCategoryHashtable();
            this.setSize(categoryTable.size());
            Sort.makeOrderedVector(this, categoryTable);
            return this.size();
        }
    }

    static class StringCategoryHashtable
    extends Variable.CategoryHashtable {
        private StringVariable sv;
        public final StringProperty input = new StringProperty(this, true);

        public StringCategoryHashtable(StringVariable sv) {
            super(sv);
            this.sv = sv;
        }

        @Override
        public int getValue(int i) throws MissingValueException {
            UniqueValue key = this.tempUV;
            key.setCompareByFormattedValue(this.sv.isCalculateUniqueValuesByFormattedValue());
            try {
                if (this.sv.isCalculateUniqueValuesByFormattedValue()) {
                    key.setFormattedValue(this.sv.formattedValue.getValue(i));
                } else {
                    key.setValue(this.sv.value.getValue(i));
                }
            }
            catch (MissingValueException e) {
                if (this.sv.isCalculateUniqueValuesByFormattedValue()) {
                    MissingValues mv = e.getMissingValue();
                    GTKFormat f = this.sv.getFormat();
                    if (f != null && f.getFormats()[0] instanceof SASFormat) {
                        key.setFormattedValue(f.format(mv));
                    } else {
                        key.setFormattedValue(ValueMap.getDefaultMissingValueLabel(mv));
                    }
                }
                key.setValue(e.getMissingValue());
            }
            return this.valueToCategory(key);
        }
    }

    private static class StringVariablePipeSwitcher
    extends StringPipeSwitcher {
        private StringVariable container;

        public StringVariablePipeSwitcher(StringVariable variable) {
            this.container = variable;
        }

        @Override
        public void init(AInitAction initAction) {
            this.container.init(initAction);
            super.init(initAction);
        }

        @Override
        public void reset(AResetAction resetAction) {
            this.container.reset(resetAction);
            super.reset(resetAction);
        }

        @Override
        public Formatter getFormatter() {
            return this.container.getFormatter();
        }
    }
}

