/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerPipeSwitcher;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.StringHashtable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVector;
import java.util.Map;
import java.util.Vector;

public class StringToNumericMap
extends NumericMap {
    private Vector stringPipes = new Vector();
    private int sortType = 0;
    private double stride = 0.0;
    private double start = 0.0;
    private StringVector rawLabels;
    private StringVector combinedLabels = new StringVector();
    private StringHashtable combinedLabelsToCategory = new StringHashtable();
    private StringHashtable valueToCategoryTable;
    private IntegerPipeSwitcher categorySwitcher = new IntegerPipeSwitcher(this);
    public final IntegerPipe category = this.categorySwitcher;
    private boolean missingValueLabelUserModified = false;
    private boolean trimTrailing = false;

    public StringToNumericMap() {
        this.categorySwitcher.setOwner(this);
        super.setMissingValueLabel(StringToNumericMap.getDefaultMissingValueLabel(MissingValues._BLANK_));
    }

    @Override
    public void setMissingValueLabel(String s) {
        super.setMissingValueLabel(s);
        this.missingValueLabelUserModified = true;
    }

    private boolean useMissingValueLabelOverride(MissingValues mv) {
        boolean result = false;
        if (this.missingValueLabelUserModified || this.getMissingValueInfoTable().get(mv) != null) {
            result = true;
        }
        return result;
    }

    @Override
    public void init(AInitAction ia) {
        boolean beenInitialized = false;
        beenInitialized = this.multiPipeInit(ia);
        int labelCount = this.rawLabels.size();
        ia.setValueCount(labelCount);
        if (beenInitialized) {
            return;
        }
        Formatter labelFormatter = this.getOwnerFormatter();
        this.uniqueValueVector.removeAllValues();
        this.labelVector.removeAllValues();
        this.uniqueValueVector.setSize(labelCount);
        this.labelVector.setSize(labelCount);
        int keyIndex = 0;
        double mappedValue = this.start;
        while (keyIndex < labelCount) {
            block4: {
                String key;
                try {
                    key = labelFormatter.format(this.rawLabels.getValue(keyIndex));
                    this.labelVector.setValueAt(key, keyIndex);
                }
                catch (MissingValueException e) {
                    if (!this.isLabelMissingValues(e.getMissingValue())) break block4;
                    Object o = this.useMissingValueLabelOverride(e.getMissingValue()) ? this.getMissingValueLabel(e.getMissingValue()) : e.getMissingValue();
                    key = labelFormatter.format(o);
                    this.labelVector.setValueAt(key, keyIndex);
                }
            }
            this.uniqueValueVector.setValueAt(mappedValue, keyIndex);
            ++keyIndex;
            mappedValue += this.stride;
        }
    }

    private boolean multiPipeInit(AInitAction ia) {
        int pipeIndex;
        boolean beenInitialized = true;
        String s = null;
        int pipeCount = this.stringPipes.size();
        StringVector[] uniqueValueVectors = new StringVector[pipeCount];
        for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
            StringPipe sp = (StringPipe)this.stringPipes.elementAt(pipeIndex);
            ia.setCategoryRequest(true);
            ia.pushValueCount();
            sp.init(ia);
            uniqueValueVectors[pipeIndex] = (StringVector)ia.getUniqueValueVector();
            ia.popValueCount();
            beenInitialized &= ia.beenInitialized(this);
        }
        if (!beenInitialized) {
            this.combinedLabels.removeAllValues();
            this.combinedLabelsToCategory.removeAllValues();
            int category = 0;
            for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
                StringVector sv = uniqueValueVectors[pipeIndex];
                int valueCount = sv.size();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    boolean missing;
                    Object key;
                    try {
                        s = sv.getValue(valueIndex);
                        key = s;
                        missing = false;
                    }
                    catch (MissingValueException e) {
                        key = e.getMissingValue();
                        missing = true;
                    }
                    if (missing && (!missing || !this.isLabelMissingValues()) || this.combinedLabelsToCategory.containsKey(key)) continue;
                    if (this.sortType == 0) {
                        if (missing) {
                            this.combinedLabels.addValue((MissingValues)key);
                        } else {
                            this.combinedLabels.addValue(s);
                        }
                    }
                    this.combinedLabelsToCategory.putIndex(key, category);
                    ++category;
                }
            }
            if (this.sortType != 0) {
                Sort.StringComparator comparator = new Sort.StringComparator(this.sortType, ia.getLocale(), ia.getSortStrategy());
                Sort.sortCategoryTable(this.combinedLabelsToCategory.table, this.sortType, comparator);
                Sort.makeOrderedVector(this.combinedLabels, (Map)this.combinedLabelsToCategory.table);
            }
        }
        this.rawLabels = this.combinedLabels;
        this.categorySwitcher.connectFrom(this.combinedLabelsToCategory);
        this.valueToCategoryTable = this.combinedLabelsToCategory;
        return beenInitialized;
    }

    public double getValue(Object o) throws MissingValueException {
        return this.getValue(o, true);
    }

    double getValue(Object o, boolean doInit) throws MissingValueException {
        if (this.trimTrailing && o instanceof String) {
            o = StringToNumericMap.trimTrailing((String)o);
        }
        if (doInit) {
            this.init(new AInitAction());
        }
        if (this.valueToCategoryTable == null) {
            throw new RuntimeException("Mapper must be initialized before calling getValue().");
        }
        return this.uniqueValueVector.getValue(this.valueToCategoryTable.getIndex(o));
    }

    public String[] getInverseValues(double lowerBound, double upperBound) {
        double upper;
        double lower;
        String[] result = null;
        if (lowerBound <= upperBound) {
            lower = lowerBound;
            upper = upperBound;
        } else {
            lower = upperBound;
            upper = lowerBound;
        }
        int minIdx = 0;
        int maxIdx = this.uniqueValueVector.size() - 1;
        double min = (lower - this.start) / this.stride;
        double max = (upper - this.start) / this.stride;
        if (lower > this.getOutputMin()) {
            if (this.stride >= 0.0) {
                minIdx = (int)Math.ceil(min);
            } else {
                maxIdx = (int)Math.floor(min);
            }
        }
        if (upper < this.getOutputMax()) {
            if (this.stride >= 0.0) {
                maxIdx = (int)Math.floor(max);
            } else {
                minIdx = (int)Math.ceil(max);
            }
        }
        if (minIdx <= maxIdx) {
            result = new String[maxIdx - minIdx + 1];
            for (int i = minIdx; i <= maxIdx; ++i) {
                try {
                    result[i - minIdx] = this.labelVector.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    result[i - minIdx] = " . ";
                }
            }
        }
        return result;
    }

    @Override
    public double getOutputMin() {
        if (this.stride > 0.0) {
            return this.start;
        }
        AInitAction ia = new AInitAction(null);
        this.init(ia);
        return this.start + this.stride * (double)(ia.getValueCount() - 1);
    }

    @Override
    public double getOutputMax() {
        if (this.stride < 0.0) {
            return this.start;
        }
        AInitAction ia = new AInitAction(null);
        this.init(ia);
        return this.start + this.stride * (double)(ia.getValueCount() - 1);
    }

    public int getUniqueValueCount() {
        AInitAction ia = new AInitAction(null);
        this.uniqueValue.init(ia);
        return ia.getValueCount();
    }

    public double getStrideValue() {
        return this.stride;
    }

    public double getStartValue() {
        return this.start;
    }

    public void setStrideValue(double value) {
        this.stride = value;
        this.setModified();
    }

    public void setStartValue(double value) {
        this.start = value;
        this.setModified();
    }

    public void addStringPipe(StringPipe pipe) {
        if (!this.stringPipes.contains(pipe)) {
            this.stringPipes.addElement(pipe);
            this.setModified();
        }
    }

    public void removeAllStringPipes() {
        this.stringPipes.removeAllElements();
    }

    public void removeStringPipe(StringPipe pipe) {
        this.stringPipes.removeElement(pipe);
    }

    public int getStringPipeCount() {
        return this.stringPipes.size();
    }

    public StringPipe getStringPipe(int i) {
        return (StringPipe)this.stringPipes.elementAt(i);
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
        this.setModified();
    }

    public int getSortType() {
        return this.sortType;
    }

    public boolean isTrimTrailing() {
        return this.trimTrailing;
    }

    public void setTrimTrailing(boolean trimTrailing) {
        this.trimTrailing = trimTrailing;
    }

    public static String trimTrailing(String s) {
        if (s == null) {
            return s;
        }
        return s.replaceAll("\\s+$", "");
    }
}

