/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringToNumberMap;
import com.sas.graphics.util.gtk.ValueMap;

public class StringToNumberMapper
extends NumericMapper {
    private StringToNumberMap map;
    public final StringProperty input = new StringProperty(this, true);

    public StringToNumberMapper() {
        StringToNumberMap defaultMap = new StringToNumberMap();
        defaultMap.addStringPipe(this.input);
        this.setMap(defaultMap);
    }

    public void setMap(StringToNumberMap map) {
        if (map == null) {
            throw new RuntimeException("null map");
        }
        this.map = map;
        map.setOwner(this);
        this.uniqueValueSwitcher.connectFrom(map.uniqueValue);
        this.labelSwitcher.connectFrom(map.label);
        super.setMap(map);
    }

    @Override
    public ValueMap getValueMap() {
        return this.map;
    }

    public void shareMap(StringToNumberMapper mapper) {
        this.setMap(mapper.map);
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        double d;
        try {
            d = this.map.getValue(index, this.input);
        }
        catch (MissingValueException e) {
            if (this.isLabelMissingValues(e.getMissingValue())) {
                return this.getMissingReplacement(e.getMissingValue());
            }
            throw e;
        }
        return d;
    }

    public void add(String key, Number value) {
        this.map.add(key, value);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void removeAll() {
        this.map.removeAll();
    }

    @Override
    public double getOutputMin() {
        return this.map.getOutputMin();
    }

    @Override
    public double getOutputMax() {
        return this.map.getOutputMax();
    }

    @Override
    public void setReplaceMissingValues(boolean b) {
        super.setReplaceMissingValues(b);
    }

    @Override
    public void setReplaceMissingValues(boolean b, MissingValues mv) {
        super.setReplaceMissingValues(b, mv);
    }
}

