/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.PipedFormat;
import com.sas.graphics.util.gtk.StringHashtable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringVector;

public class StringPipedFormat
extends PipedFormat {
    private StringVector uniqueValueVector = new StringVector();
    public final StringProperty input = new StringProperty(this, true);
    public final StringPipe uniqueValue = this.uniqueValueVector;

    public StringPipedFormat() {
        this.uniqueValueVector.setOwner(this);
    }

    @Override
    public String getValue(int index) throws MissingValueException {
        String o;
        try {
            o = this.input.getValue(index);
        }
        catch (MissingValueException e) {
            if (this.isMissingValueExceptionsEnabled()) {
                throw e;
            }
            o = e.getMissingValue();
        }
        String result = this.getCurrentFormatter().format(o);
        return result;
    }

    @Override
    public void init(AInitAction initAction) {
        boolean icr = initAction.isCategoryRequest();
        super.init(initAction);
        if (icr) {
            if (!initAction.beenInitialized(this)) {
                Formatter formatter = this.getCurrentFormatter();
                StringVector uv = (StringVector)initAction.getUniqueValueVector();
                int n = uv.size();
                this.uniqueValueVector.setSize(n);
                for (int i = 0; i < n; ++i) {
                    String o;
                    try {
                        o = uv.getValue(i);
                    }
                    catch (MissingValueException e) {
                        o = e.getMissingValue();
                    }
                    String s = formatter.format(o);
                    this.uniqueValueVector.setValueAt(s, i);
                }
            }
            if (this.categoryTable == null) {
                this.categoryTable = new StringHashtable();
            } else {
                this.categoryTable.removeAllValues();
            }
            this.categoryTable.input.connectFrom(this.uniqueValueVector);
            initAction.pushValueCount();
            this.categoryTable.init(initAction);
            initAction.popValueCount();
            initAction.setUniqueValueVector(this.uniqueValueVector);
            initAction.setCategoryPipe(this.categoryTable);
            initAction.setValueToCategoryTable(this.categoryTable);
        }
    }
}

