/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.Debug;
import com.sas.graphics.util.gtk.MissingValueException;
import java.util.Hashtable;

public class Statistic {
    public static final int LAST = 0;
    public static final int MEAN = 1;
    public static final int FREQ = 2;
    public static final int PERCENTAGE_FREQ = 3;
    public static final int CUMULATIVE_FREQ = 4;
    public static final int CUMULATIVE_PERCENTAGE_FREQ = 5;
    public static final int SUM = 6;
    public static final int PERCENTAGE_SUM = 7;
    public static final int CUMULATIVE_SUM = 8;
    public static final int CUMULATIVE_PERCENTAGE_SUM = 9;
    public static final int MIN = 10;
    public static final int MAX = 11;
    public static final int FIRST = 12;
    public static final int TRUE_PERCENTAGE_FREQ = 13;
    public static final int MISSING_FREQ = 14;
    protected static final int GREATEST_STATISTIC = 14;
    private static final String[] names = new String[]{"LAST", "MEAN", "FREQ", "% FREQ", "CUMM FREQ", "CUMM % FREQ", "SUM", "% SUM", "CUMM SUM", "CUMM % SUM", "MIN", "MAX", "FIRST", "MISSING FREQ"};
    private static Hashtable statTable;

    public static String[] getNames() {
        return names;
    }

    public static int stringToInt(String statisticName) {
        Integer io;
        if (statTable == null) {
            statTable = new Hashtable(names.length);
            for (int i = 0; i < names.length; ++i) {
                statTable.put(names[i], new Integer(i));
            }
        }
        if ((io = (Integer)statTable.get(statisticName)) == null) {
            throw new IllegalArgumentException();
        }
        return io;
    }

    public static String getStringValue(Bucket bucket, int statistic, double grandTotal, int observationCount) throws MissingValueException {
        String result = null;
        switch (statistic) {
            case 12: {
                result = bucket.firstStringValue;
                break;
            }
            default: {
                result = bucket.lastStringValue;
            }
        }
        if (result == null) {
            MissingValueException mve = MissingValueException.getDefaultMissingValueExeption();
            MissingValues mv = statistic == 12 ? bucket.firstMissingValue : bucket.lastMissingValue;
            if (mv == null) {
                mv = MissingValues._BLANK_;
            }
            mve.setMissingValue(mv);
            throw mve;
        }
        return result;
    }

    public static double getValue(Bucket bucket, int statistic, double grandTotal, int observationCount) throws MissingValueException {
        double result;
        boolean statisticCanBeMissing = true;
        switch (statistic) {
            case 12: {
                result = bucket.firstDoubleValue;
                break;
            }
            case 0: {
                result = bucket.lastDoubleValue;
                break;
            }
            default: {
                Debug.println((String)"Invalid Statistic type, using SUM.");
            }
            case 6: {
                result = bucket.sum;
                break;
            }
            case 10: {
                result = bucket.min;
                break;
            }
            case 11: {
                result = bucket.max;
                break;
            }
            case 2: {
                result = bucket.count;
                statisticCanBeMissing = false;
                break;
            }
            case 14: {
                result = bucket.missingCount;
                statisticCanBeMissing = false;
                break;
            }
            case 1: {
                result = bucket.sum / (double)bucket.count;
                break;
            }
            case 7: {
                result = bucket.sum / grandTotal;
                break;
            }
            case 3: {
                result = (double)bucket.count / (double)observationCount;
                break;
            }
            case 13: {
                result = (double)bucket.count / (double)observationCount * 100.0;
                break;
            }
            case 4: {
                result = bucket.runningCount;
                statisticCanBeMissing = false;
                break;
            }
            case 5: {
                result = (double)bucket.runningCount / (double)observationCount;
                statisticCanBeMissing = false;
                break;
            }
            case 9: {
                result = bucket.runningSum / grandTotal;
                statisticCanBeMissing = false;
                break;
            }
            case 8: {
                result = bucket.runningSum;
                statisticCanBeMissing = false;
            }
        }
        if (statisticCanBeMissing && bucket.count == 0) {
            MissingValueException mve = MissingValueException.getDefaultMissingValueExeption();
            mve.setMissingValue(bucket.lastMissingValue);
            throw mve;
        }
        return result;
    }

    public static class Bucket {
        public String firstStringValue;
        public String lastStringValue;
        public MissingValues firstMissingValue;
        public MissingValues lastMissingValue;
        public double sum;
        public double min;
        public double max;
        public double runningSum;
        public double firstDoubleValue;
        public double lastDoubleValue;
        public int count;
        public int missingCount;
        public int runningCount;

        public Bucket() {
            this.sum = 0.0;
            this.runningSum = 0.0;
            this.count = 0;
            this.missingCount = 0;
            this.runningCount = 0;
            this.min = Double.MAX_VALUE;
            this.max = -1.7976931348623157E308;
        }

        public Bucket(Bucket b) {
            this.firstStringValue = b.firstStringValue;
            this.lastStringValue = b.lastStringValue;
            this.firstMissingValue = b.firstMissingValue;
            this.lastMissingValue = b.lastMissingValue;
            this.sum = b.sum;
            this.min = b.min;
            this.max = b.max;
            this.runningSum = b.runningSum;
            this.firstDoubleValue = b.firstDoubleValue;
            this.lastDoubleValue = b.lastDoubleValue;
            this.count = b.count;
            this.missingCount = b.missingCount;
            this.runningCount = b.runningCount;
        }

        public void accumulate(double value, int statistic) {
            this.sum += value;
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
            if (this.count == 0) {
                this.firstDoubleValue = value;
            }
            this.lastDoubleValue = value;
            ++this.count;
        }

        public void accumulate(String value) {
            if (this.count == 0) {
                this.firstStringValue = value;
            }
            this.lastStringValue = value;
            ++this.count;
        }

        public void accumulateMissing(MissingValues mv) {
            if (this.missingCount == 0) {
                this.firstMissingValue = mv;
            }
            this.lastMissingValue = this.lastMissingValue == null ? mv : (mv.getIndex() > this.lastMissingValue.getIndex() ? mv : this.lastMissingValue);
            ++this.missingCount;
        }
    }
}

