/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.MutableInteger;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;

class SortProcessor {
    private ArrayList sortedIndex = new ArrayList();
    private IndexedValueComparator comparator = new IndexedValueComparator();

    SortProcessor() {
    }

    public void setSortVariable(Variable v) {
        this.comparator.setSortVariable(v);
    }

    public Variable getSortVariable() {
        return this.comparator.getSortVariable();
    }

    public void setSortOrder(int sortOrder) {
        this.comparator.setSortOrder(sortOrder);
    }

    public int process(Vector allVariables, int valueCount) {
        int i;
        if (!this.isSortingNeeded() || valueCount == 0) {
            return valueCount;
        }
        this.sortedIndex.ensureCapacity(valueCount);
        int size = this.sortedIndex.size();
        for (i = 0; i < valueCount; ++i) {
            MutableInteger index;
            if (i > size - 1) {
                index = new MutableInteger(i);
                this.sortedIndex.add(index);
                continue;
            }
            index = (MutableInteger)this.sortedIndex.get(i);
            index.setValue(i);
        }
        this.sortedIndex.trimToSize();
        Collections.sort(this.sortedIndex, this.comparator);
        NumericVariable nv = null;
        StringVariable sv = null;
        int variableCount = allVariables.size();
        for (i = 0; i < variableCount; ++i) {
            VariableProcessor.VEntry ve = (VariableProcessor.VEntry)allVariables.elementAt(i);
            if (ve.variable instanceof NumericVariable) {
                nv = (NumericVariable)ve.variable;
                NumericSortPipe np = new NumericSortPipe(nv.getProcessedValuePipe(), valueCount);
                nv.setProcessedValuePipe(np, valueCount);
                continue;
            }
            sv = (StringVariable)ve.variable;
            StringSortPipe sp = new StringSortPipe(sv.getProcessedValuePipe(), valueCount);
            sv.setProcessedValuePipe(sp, valueCount);
        }
        return valueCount;
    }

    public boolean isSortingNeeded() {
        return this.comparator.getSortVariable() != null && this.comparator.getSortOrder() != 0;
    }

    public int getIndexPriorToSorting(int index) {
        return ((MutableInteger)this.sortedIndex.get(index)).intValue();
    }

    private static class IndexedValueComparator
    extends Sort.SortComparator {
        private Variable sortVariable = null;
        private StringPipe sp;
        private NumericPipe np;

        public IndexedValueComparator() {
            super(0, Locale.getDefault(), Sort.getDefaultSortStrategy());
        }

        public void setSortVariable(Variable v) {
            this.sortVariable = v;
            this.sp = null;
            this.np = null;
            if (v instanceof NumericVariable) {
                if (v.getSortByFormattedValues()) {
                    this.sp = ((NumericVariable)v).formattedValue;
                } else {
                    this.np = ((NumericVariable)v).value;
                }
            } else if (v instanceof StringVariable) {
                this.sp = v.getSortByFormattedValues() ? ((StringVariable)v).formattedValue : ((StringVariable)v).value;
            }
            if (v != null) {
                this.setLocale(v.getLocale());
            }
        }

        public Variable getSortVariable() {
            return this.sortVariable;
        }

        public int compare(Object o1, Object o2) {
            Object v2;
            double d;
            Object v1;
            int i1 = ((MutableInteger)o1).intValue();
            int i2 = ((MutableInteger)o2).intValue();
            try {
                if (this.sp != null) {
                    v1 = this.sp.getValue(i1);
                } else {
                    d = this.np.getValue(i1);
                    v1 = new Double(d);
                }
            }
            catch (MissingValueException e) {
                v1 = e.getMissingValue();
            }
            try {
                if (this.sp != null) {
                    v2 = this.sp.getValue(i2);
                } else {
                    d = this.np.getValue(i2);
                    v2 = new Double(d);
                }
            }
            catch (MissingValueException e) {
                v2 = e.getMissingValue();
            }
            boolean isNumeric = this.sp == null;
            int result = Sort.compare(v1, v2, isNumeric, this);
            return result;
        }
    }

    private class StringSortPipe
    extends SortPipe
    implements StringPipe {
        private StringPipe rawValuePipe;

        public StringSortPipe(StringPipe aRawValuePipe, int valueCount) {
            super(valueCount);
            this.rawValuePipe = aRawValuePipe;
        }

        @Override
        public String getValue(int i) throws MissingValueException {
            int index = SortProcessor.this.getIndexPriorToSorting(i);
            String s = this.rawValuePipe.getValue(index);
            return s;
        }
    }

    private class NumericSortPipe
    extends SortPipe
    implements NumericPipe {
        private NumericPipe rawValuePipe;

        public NumericSortPipe(NumericPipe aRawValuePipe, int valueCount) {
            super(valueCount);
            this.rawValuePipe = aRawValuePipe;
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            int index = SortProcessor.this.getIndexPriorToSorting(i);
            double d = this.rawValuePipe.getValue(index);
            return d;
        }
    }

    private class SortPipe
    implements Pipe {
        private int valueCount;

        public SortPipe(int valueCount) {
            this.valueCount = valueCount;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.valueCount);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }
    }
}

