/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.ComparatorFactory;
import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.UniqueValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class Sort {
    public static final int NONE = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int STRATEGY_LINGUISTIC = 1001;
    public static final int STRATEGY_BINARY = 1002;

    public static int sortStringToInt(String sortType) {
        int result = 2;
        String name = sortType.toUpperCase();
        if (name.equals("NONE")) {
            result = 0;
        } else if (name.equals("ASCENDING")) {
            result = 1;
        }
        return result;
    }

    public static void sortCategoryTable(Map map, int sortType, Comparator comparator) {
        if (sortType == 0) {
            return;
        }
        ArrayList l = new ArrayList(map.size());
        l.addAll(map.keySet());
        map.clear();
        Collections.sort(l, comparator);
        int n = l.size();
        for (int i = 0; i < n; ++i) {
            UniqueValue uv = (UniqueValue)l.get(i);
            uv.setCategory(i);
            map.put(uv, uv);
        }
    }

    public static void makeOrderedVector(StringVector v, Map ht) {
        v.setSize(ht.size());
        int index = 0;
        Iterator keys = ht.entrySet().iterator();
        while (keys.hasNext()) {
            if (Thread.currentThread().isInterrupted()) {
                v.removeAllValues();
                break;
            }
            Map.Entry entry = keys.next();
            Object key = entry.getKey();
            if (key instanceof String) {
                v.setValueAt((String)key, index);
            } else if (key instanceof UniqueValue) {
                UniqueValue uv = (UniqueValue)key;
                if (uv.isMissing()) {
                    v.setValueAt(uv.getMissingValue(), index);
                } else {
                    v.setValueAt(uv.getStringValue(), index);
                }
            } else {
                v.setValueAt((MissingValues)key, index);
            }
            ++index;
        }
    }

    public static void makeOrderedVector(NumericVector v, Map ht) {
        v.setSize(ht.size());
        int index = 0;
        Iterator keys = ht.entrySet().iterator();
        while (keys.hasNext()) {
            if (Thread.currentThread().isInterrupted()) {
                v.removeAllValues();
                break;
            }
            Map.Entry entry = keys.next();
            Object key = entry.getKey();
            if (key instanceof ReusableDouble) {
                v.setValueAt(((ReusableDouble)key).value, index);
            } else if (key instanceof Double) {
                v.setValueAt((double)((Double)key), index);
            } else if (key instanceof UniqueValue) {
                UniqueValue uv = (UniqueValue)key;
                if (uv.isMissing()) {
                    v.setValueAt(uv.getMissingValue(), index);
                } else {
                    v.setValueAt(uv.getDoubleValue(), index);
                }
            } else {
                v.setValueAt((MissingValues)key, index);
            }
            ++index;
        }
    }

    public static int compare(Object v1, Object v2, boolean isNumeric, SortComparator sortComparator) {
        int result;
        if (isNumeric) {
            result = v1 instanceof MissingValues ? (v2 instanceof MissingValues ? Sort.compare(((MissingValues)v1).getIndex(), ((MissingValues)v2).getIndex()) : -1) : (v2 instanceof MissingValues ? 1 : ((Double)v1).compareTo((Double)v2));
        } else if (v1 instanceof MissingValues) {
            result = v2 instanceof MissingValues ? Sort.compare(((MissingValues)v1).getIndex(), ((MissingValues)v2).getIndex()) : -1;
        } else if (v2 instanceof MissingValues) {
            result = 1;
        } else if (sortComparator.getSortStrategy() == 1001) {
            Comparator comparator = ComparatorFactory.createComparator((Locale)sortComparator.getLocale());
            result = comparator.compare(v1, v2);
        } else {
            result = ((String)v1).compareTo((String)v2);
        }
        if (sortComparator.getSortOrder() == 2) {
            if (result > 0) {
                result = -1;
            } else if (result < 0) {
                result = 1;
            }
        }
        return result;
    }

    private static int compare(int i1, int i2) {
        return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
    }

    public static int getDefaultSortStrategy() {
        return 1001;
    }

    public static class NumericComparator
    extends SortComparator {
        public NumericComparator(int sortOrder, Locale locale, int sortStrategy) {
            super(sortOrder, locale, sortStrategy);
        }

        public int compare(Object o1, Object o2) {
            return Sort.compare(o1, o2, true, this);
        }
    }

    public static class StringComparator
    extends SortComparator {
        public StringComparator(int sortOrder, Locale locale, int sortStrategy) {
            super(sortOrder, locale, sortStrategy);
        }

        public int compare(Object o1, Object o2) {
            return Sort.compare(o1, o2, false, this);
        }
    }

    public static abstract class SortComparator
    implements Comparator {
        private int sortOrder;
        private Locale locale;
        private int sortStrategy;

        protected SortComparator(int sortOrder, Locale locale, int sortStrategy) {
            this.sortOrder = sortOrder;
            this.locale = locale;
            this.sortStrategy = sortStrategy;
        }

        public void setSortOrder(int sortOrder) {
            this.sortOrder = sortOrder;
        }

        public int getSortOrder() {
            return this.sortOrder;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public int getSortStrategy() {
            return this.sortStrategy;
        }

        public void setSortStrategy(int sortStrategy) {
            this.sortStrategy = sortStrategy;
        }
    }
}

