/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

public class RangeTable {
    protected double[] rangeValues;
    protected boolean excludeLowerBound = true;

    public void setRanges(double[] value) {
        if (value.length == 0) {
            throw new Error("No range values specified for the Range array in the range_to_num/color_mapper.");
        }
        this.rangeValues = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.rangeValues[i] = value[i];
        }
    }

    public double[] getRanges() {
        return this.rangeValues;
    }

    public int size() {
        return this.rangeValues == null ? 0 : this.rangeValues.length;
    }

    public void removeAllRanges() {
        this.rangeValues = null;
    }

    public void setLowerExclude(boolean trueOrFalse) {
        this.excludeLowerBound = trueOrFalse;
    }

    public boolean isLowerExclude() {
        return this.excludeLowerBound;
    }

    public int getValue(double value) {
        int i;
        if (this.rangeValues != null) {
            if (this.excludeLowerBound) {
                for (i = 0; i < this.rangeValues.length && value > this.rangeValues[i]; ++i) {
                }
            } else {
                while (i < this.rangeValues.length && value >= this.rangeValues[i]) {
                    ++i;
                }
                if (i == this.rangeValues.length && value == this.rangeValues[this.rangeValues.length - 1]) {
                    i = this.rangeValues.length - 1;
                }
            }
        }
        return i;
    }
}

