/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.Property;
import java.util.ArrayList;
import java.util.List;

public class PropertyContainer {
    private List property;
    private long initTime;
    private int initialSize = 1;

    public PropertyContainer() {
        if (this instanceof Element) {
            this.initialSize = 48;
        } else if (this instanceof Calculator) {
            this.initialSize = 8;
        }
    }

    protected int getPropertyCount() {
        if (this.property == null) {
            return 0;
        }
        return this.property.size();
    }

    public boolean containsProperty(Property p) {
        if (this.property == null) {
            return false;
        }
        return this.property.contains(p);
    }

    public void removeProperty(Property p) {
        if (this.property != null) {
            this.property.remove(p);
        }
    }

    protected Property getProperty(int index) {
        if (this.property == null) {
            return null;
        }
        return (Property)this.property.get(index);
    }

    protected void addProperty(Property aProperty) {
        if (this.property == null) {
            this.property = new ArrayList(this.initialSize);
        }
        this.property.add(aProperty);
    }

    public void init(AInitAction initAction) {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Property p = this.getProperty(i);
            p.init(initAction);
        }
    }

    public void reset(AResetAction resetAction) {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Property p = this.getProperty(i);
            p.reset(resetAction);
        }
    }

    public Formatter getFormatter() {
        Formatter result = null;
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Property p = this.getProperty(i);
            if (!p.isConnected()) continue;
            result = p.getFormatter();
            break;
        }
        if (result == null) {
            result = Formatter.defaultFormatter;
        }
        return result;
    }

    public void setInitTime(long t) {
        this.initTime = t;
    }

    public long getInitTime() {
        return this.initTime;
    }

    protected void setModified() {
        this.initTime = 0L;
    }
}

