/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.VariableProcessor;
import java.util.Vector;

class OrderProcessor {
    int order = 0;
    int valueCount;

    OrderProcessor() {
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public int process(Vector variables, int aValueCount) {
        this.valueCount = aValueCount;
        if (this.order == 1) {
            int variableCount = variables.size();
            for (int i = 0; i < variableCount; ++i) {
                VariableProcessor.VEntry ve = (VariableProcessor.VEntry)variables.elementAt(i);
                if (ve.variable instanceof NumericVariable) {
                    NumericVariable nv = (NumericVariable)ve.variable;
                    NumericOrderPipe np = new NumericOrderPipe(nv.getProcessedValuePipe());
                    nv.setProcessedValuePipe(np, this.valueCount);
                    continue;
                }
                StringVariable sv = (StringVariable)ve.variable;
                StringOrderPipe sp = new StringOrderPipe(sv.getProcessedValuePipe());
                sv.setProcessedValuePipe(sp, this.valueCount);
            }
        }
        return this.valueCount;
    }

    int getIndex(int i) {
        return this.valueCount - i - 1;
    }

    private class StringOrderPipe
    extends OrderPipe
    implements StringPipe {
        private StringPipe values;

        public StringOrderPipe(StringPipe values) {
            this.values = values;
        }

        @Override
        public String getValue(int i) throws MissingValueException {
            return this.values.getValue(this.getOrderIndex(i));
        }
    }

    private class NumericOrderPipe
    extends OrderPipe
    implements NumericPipe {
        private NumericPipe values;

        public NumericOrderPipe(NumericPipe values) {
            this.values = values;
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            return this.values.getValue(this.getOrderIndex(i));
        }
    }

    private class OrderPipe
    implements Pipe {
        private OrderPipe() {
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(OrderProcessor.this.valueCount);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public int getOrderIndex(int i) {
            return OrderProcessor.this.getIndex(i);
        }
    }
}

