/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.PipedVector;
import java.util.Vector;

public abstract class ObjectVector
extends PipedVector {
    protected Vector vector;

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    public void removeAllValues() {
        this.vector.removeAllElements();
    }

    @Override
    public void removeValueAt(int index) {
        this.vector.removeElementAt(index);
    }

    @Override
    public void setSize(int newsize) {
        int sizeBeforeResize = this.vector.size();
        this.vector.setSize(newsize);
        if (newsize > sizeBeforeResize) {
            int i;
            int n = i = sizeBeforeResize == 0 ? 0 : sizeBeforeResize - 1;
            while (i < newsize) {
                if (this.vector.elementAt(i) == null) {
                    this.vector.setElementAt(MissingValues.Dot, i);
                }
                ++i;
            }
        }
    }

    @Override
    public void insertValueAt(MissingValues value, int index) {
        this.vector.insertElementAt(value, index);
    }

    @Override
    public void addValue(MissingValues value) {
        this.vector.addElement(value);
    }

    @Override
    public void setValueAt(MissingValues value, int index) {
        this.vector.setElementAt(value, index);
    }

    @Override
    public int capacity() {
        return this.vector.capacity();
    }

    @Override
    public final boolean isEmpty() {
        return this.vector.isEmpty();
    }

    @Override
    public int getValueCount() {
        return this.vector.size();
    }

    @Override
    public void trimToSize() {
        this.vector.trimToSize();
    }

    @Override
    public boolean isMissing(int i) {
        boolean result = false;
        Object o = this.vector.elementAt(i);
        if (o == null || o instanceof MissingValues) {
            result = true;
        }
        return result;
    }

    protected Object get(int index) throws MissingValueException {
        Object value = null;
        if (index >= 0 && index < this.vector.size()) {
            value = this.vector.elementAt(index);
            if (value instanceof MissingValues) {
                MissingValueException e = MissingValueException.getDefaultMissingValueExeption();
                e.setMissingValue(value);
                throw MissingValueException.getDefaultMissingValueExeption();
            }
        } else {
            throw new MissingValueException("Index out of Range");
        }
        return value;
    }

    public boolean contains(MissingValues mv) {
        int n = this.vector.size();
        for (int i = 0; i < n; ++i) {
            Object o = this.vector.elementAt(i);
            if (o != mv) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsMissing() {
        int n = this.vector.size();
        for (int i = 0; i < n; ++i) {
            Object o = this.vector.elementAt(i);
            if (o != null && !(o instanceof MissingValues)) continue;
            return true;
        }
        return false;
    }
}

