/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import java.text.Format;

public class OLAPStringMeasureVariable
extends StringVariable {
    private MeasureConnection connection = new MeasureConnection();

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(OLAPVariableFactory olapVariableFactory, String measureName) {
        this.connection.connectFrom(olapVariableFactory, measureName);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        this.setColumnName(this.connection.getVariableName());
        if (this.getName().startsWith(defaultName)) {
            this.setName(this.connection.getVariableName());
            this.setLabel(this.connection.getVariableLabel());
        }
        super.connectFrom();
        if (this.connection.getFormat() != null) {
            this.setFormat(this.connection.getFormat());
        }
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isRawValueMissing(int index) {
        return this.connection.isMissing(index);
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified && this.connection != null) {
            this.connection.setModified();
        }
    }

    private static class MeasureConnection
    implements StringPipe {
        private int valueCount = 0;
        private String label = null;
        private String name;
        private int measureIndex;
        private String formatName = null;
        private GTKFormat format = null;
        private OLAPVariableFactory factory;

        private MeasureConnection() {
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.valueCount);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public void connectFrom(OLAPVariableFactory factory, String measureName) {
            this.factory = factory;
            this.label = factory.getLabel(measureName);
            this.measureIndex = factory.getMeasureIndex(measureName);
            this.name = measureName;
            Format f = factory.getFormatInstance(measureName);
            if (f != null) {
                this.format = new GTKFormat(f);
            }
            this.valueCount = factory.getValueCount();
        }

        public void disconnect() {
            this.valueCount = 0;
            this.factory = null;
            this.format = null;
        }

        public String getVariableLabel() {
            return this.label;
        }

        public String getVariableName() {
            return this.name;
        }

        public GTKFormat getFormat() {
            return this.format;
        }

        public void setModified() {
        }

        public boolean isMissing(int valueIndex) {
            boolean result = false;
            try {
                this.getValue(valueIndex);
            }
            catch (MissingValueException e) {
                result = true;
            }
            return result;
        }

        @Override
        public String getValue(int valueIndex) throws MissingValueException {
            return this.factory.getStringValue(this.measureIndex, valueIndex);
        }

        public int getValueCount() {
            return this.valueCount;
        }
    }
}

