/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import javax.swing.ListSelectionModel;

public class OLAPListSelectionVariable
extends NumericVariable {
    private OLAPListSelectionConnection connection = new OLAPListSelectionConnection(this);

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(OLAPVariableFactory factory, ListSelectionModel selectionModel, String measureName) {
        this.connection.connectFrom(factory, selectionModel, measureName);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        if (this.getName().startsWith(defaultName)) {
            this.setName(this.connection.getVariableName());
            this.setLabel(this.connection.getVariableLabel());
        }
        super.connectFrom();
        if (this.connection.getFormat() != null) {
            this.setFormat(this.connection.getFormat());
        }
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isRawValueMissing(int index) {
        return this.connection.isMissing(index);
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified && this.connection != null) {
            this.connection.setModified();
        }
    }

    public int getCellIndex(int valueIndex) {
        return this.connection.getCellIndex(valueIndex);
    }

    private static class OLAPListSelectionConnection
    implements NumericPipe {
        private OLAPVariableFactory factory;
        private ListSelectionModel selectionModel;
        private int measureIndex;
        private String label = null;
        private String name;

        @Override
        public void init(AInitAction initAction) {
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public void setModified() {
        }

        public int getValueCount() {
            return -1;
        }

        public GTKFormat getFormat() {
            return null;
        }

        public void disconnect() {
        }

        public OLAPListSelectionConnection(NumericVariable variable) {
        }

        public String getVariableLabel() {
            return this.label;
        }

        public String getVariableName() {
            return this.name;
        }

        public void connectFrom(OLAPVariableFactory factory, ListSelectionModel selectionModel, String measureName) {
            this.factory = factory;
            this.selectionModel = selectionModel;
            this.label = "select_" + factory.getLabel(measureName);
            this.name = "select" + measureName;
            this.measureIndex = factory.getMeasureIndex(measureName);
        }

        public OLAPVariableFactory getFactory() {
            return this.factory;
        }

        @Override
        public double getValue(int valueIndex) throws MissingValueException {
            int cellIndex = this.factory.getCellIndex(this.measureIndex, valueIndex);
            boolean isSelected = this.selectionModel.isSelectedIndex(cellIndex);
            return isSelected ? 1.0 : 0.0;
        }

        public boolean isMissing(int index) {
            return false;
        }

        public int getCellIndex(int valueIndex) {
            int result = this.factory.getCellIndex(valueIndex, this.measureIndex);
            return result;
        }
    }
}

