/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import java.util.Vector;

public class NumericVectorVariable
extends NumericVariable {
    private NumericVectorConnection connection = new NumericVectorConnection();

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(double[] data) {
        this.connection.connectFrom(data);
        this.connectFrom();
    }

    public void connectFrom(Vector data) {
        this.connection.connectFrom(data);
        this.connectFrom();
    }

    public void connectFrom(BooleanPipe booleanPipe) {
        this.connection.connectFrom(booleanPipe);
        this.connectFrom();
    }

    public void connectFrom(IntegerPipe integerPipe) {
        this.connection.connectFrom(integerPipe);
        this.connectFrom();
    }

    public void connectFrom(NumericPipe numericPipe) {
        this.connection.connectFrom(numericPipe);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, -1);
        super.connectFrom();
    }

    public double[] getConnectionData() {
        return this.connection.getConnectionData();
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isRawValueMissing(int index) {
        return this.connection.isMissing(index);
    }

    private class NumericVectorConnection
    implements NumericPipe {
        private double[] array;
        private Vector vector;
        private BooleanPipe booleanPipe;
        private NumericPipe numericPipe;
        private IntegerPipe integerPipe;

        private NumericVectorConnection() {
        }

        public double[] getConnectionData() {
            double[] result;
            if (this.array != null) {
                result = this.array;
            } else if (this.vector != null) {
                int n = this.vector.size();
                result = new double[n];
                for (int i = 0; i < n; ++i) {
                    result[i] = (Double)this.vector.elementAt(i);
                }
            } else {
                result = new double[]{};
            }
            return result;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.getValueCount(initAction));
        }

        private int getValueCount(AInitAction ia) {
            if (this.array != null) {
                return this.array.length;
            }
            if (this.vector != null) {
                return this.vector.size();
            }
            if (ia == null) {
                ia = new AInitAction();
            }
            if (this.booleanPipe != null) {
                this.booleanPipe.init(ia);
            } else if (this.integerPipe != null) {
                this.integerPipe.init(ia);
            } else {
                this.numericPipe.init(ia);
            }
            return ia.getValueCount();
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public int getValueCount() {
            return this.getValueCount(null);
        }

        public void connectFrom(double[] anArray) {
            this.disconnect();
            if (anArray == null) {
                throw new RuntimeException("Attempt to connect a null data source.");
            }
            this.array = anArray;
        }

        public void connectFrom(BooleanPipe aBooleanPipe) {
            this.disconnect();
            if (aBooleanPipe == null) {
                throw new RuntimeException("Attempt to connect a null data source.");
            }
            this.booleanPipe = aBooleanPipe;
        }

        public void connectFrom(IntegerPipe aIntegerPipe) {
            this.disconnect();
            if (aIntegerPipe == null) {
                throw new RuntimeException("Attempt to connect a null data source.");
            }
            this.integerPipe = aIntegerPipe;
        }

        public void connectFrom(NumericPipe aNumericPipe) {
            this.disconnect();
            if (aNumericPipe == null) {
                throw new RuntimeException("Attempt to connect a null data source.");
            }
            this.numericPipe = aNumericPipe;
        }

        public void connectFrom(Vector aVector) {
            this.disconnect();
            if (aVector == null) {
                throw new RuntimeException("Attempt to connect a null data source.");
            }
            this.vector = aVector;
        }

        public void disconnect() {
            this.array = null;
            this.vector = null;
            this.booleanPipe = null;
            this.numericPipe = null;
            this.integerPipe = null;
        }

        private double getDoubleValue(int i) throws MissingValueException {
            boolean b;
            double d = this.array != null ? this.array[i] : (this.vector != null ? (Double)this.vector.elementAt(i) : (this.booleanPipe != null ? ((b = this.booleanPipe.getValue(i)) ? 1.0 : 0.0) : (this.integerPipe != null ? (double)this.integerPipe.getValue(i) : this.numericPipe.getValue(i))));
            return d;
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            double d = this.getDoubleValue(i);
            if (NumericVectorVariable.this.isFreqVariable()) {
                d = NumericVectorVariable.this.transformFrequencyValue(d);
            } else if (d != d) {
                MissingValueException e = MissingValueException.getDefaultMissingValueExeption();
                e.setMissingValue(MissingValues.Dot);
                throw e;
            }
            return d;
        }

        public boolean isMissing(int i) {
            try {
                double d = this.getDoubleValue(i);
                return d != d;
            }
            catch (MissingValueException e) {
                return true;
            }
        }
    }
}

