/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericPipeSwitcher;
import com.sas.graphics.util.gtk.NumericPipedFormat;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.SimpleStatisticInterface;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.UniqueValue;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.text.SASFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;

public class NumericVariable
extends Variable
implements SimpleStatisticInterface {
    private boolean freqVariable = false;
    private NumericPipe rawValuePipe;
    private NumericPipedFormat valueFormat;
    private NumericPipedFormat uniqueValueFormat;
    private NumericVariablePipeSwitcher valueSwitcher = new NumericVariablePipeSwitcher(this);
    private NumericUniqueValueVector uniqueValueVector = new NumericUniqueValueVector(0, this);
    private NumericCategoryHashtable categoryTable = new NumericCategoryHashtable(this);
    public final NumericPipe value = this.valueSwitcher;
    private final NumericPipeSwitcher uniqueValueSwitcher = new NumericPipeSwitcher();
    public final NumericPipe uniqueValue = this.uniqueValueSwitcher;
    public final IntegerPipe category = this.categoryTable;
    private double mean;
    private double max;
    private double min;
    private double sum;
    private int nonMissingValueCount;
    private boolean isCalculated;

    public NumericVariable() {
        super(new NumericPipedFormat(), new NumericPipedFormat());
        this.categoryTable.input.connectFrom(this.value);
        this.uniqueValueVector.setOwner(this.valueSwitcher);
        this.uniqueValueSwitcher.connectFrom(this.uniqueValueVector);
        this.setFormat(new GTKFormat(NumberFormat.getInstance(Locale.getDefault())));
        this.valueFormat = (NumericPipedFormat)this.getValueFormat();
        this.uniqueValueFormat = (NumericPipedFormat)this.getUniqueValueFormat();
        this.valueFormat.input.connectFrom(this.value);
        this.uniqueValueFormat.input.connectFrom(this.uniqueValue);
        this.setFormattedValueMissingValueExceptionsEnabled(this.isFormattedValueMissingValueExceptionsEnabled());
        this.isCalculated = false;
    }

    @Override
    public void setFormattedValueMissingValueExceptionsEnabled(boolean formattedValueMissingValueExceptionsEnabled) {
        super.setFormattedValueMissingValueExceptionsEnabled(formattedValueMissingValueExceptionsEnabled);
        this.valueFormat.setMissingValueExceptionsEnabled(this.isFormattedValueMissingValueExceptionsEnabled());
        this.uniqueValueFormat.setMissingValueExceptionsEnabled(this.isFormattedValueMissingValueExceptionsEnabled());
    }

    @Override
    protected IntegerPipe getCategory() {
        return this.category;
    }

    @Override
    protected void connectFrom() {
        this.initialize();
        super.connectFrom();
    }

    public GTKFormat newDataDependentFormat() {
        double d = 100.0;
        boolean missing = true;
        for (int i = 0; missing && i < this.getValueCount(); ++i) {
            try {
                d = this.value.getValue(i);
                missing = false;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        String formatName = d >= 99.99 ? "32.0" : (d > 9.9 ? "32.1" : (d > 0.99 ? "32.2" : (d > 0.099 ? "32.3" : (d > 0.0099 ? "32.4" : "BEST"))));
        return new GTKFormat((Format)SASFormat.getInstance((String)formatName));
    }

    public double[] newValueArray() {
        AInitAction ia = new AInitAction();
        this.value.init(ia);
        int n = ia.getValueCount();
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            try {
                double d;
                result[i] = d = this.value.getValue(i);
                continue;
            }
            catch (MissingValueException e) {
                result[i] = Double.NaN;
            }
        }
        return result;
    }

    @Override
    public void disconnect() {
        this.initialize();
        super.disconnect();
    }

    @Override
    public void setModified(boolean trueOrFalse) {
        if (trueOrFalse) {
            this.initialize();
        }
        super.setModified(trueOrFalse);
    }

    @Override
    protected Map getCategoryHashtable() {
        return this.categoryTable.getHashtable();
    }

    @Override
    protected Variable.CategoryHashtable getCategoryTable() {
        return this.categoryTable;
    }

    @Override
    protected void addUniqueValue(int i) {
        boolean needFormattedValue = this.isCalculateUniqueValuesByFormattedValue() || this.isSortByFormattedValues();
        String fv = null;
        try {
            if (needFormattedValue) {
                fv = this.formattedValue.getValue(i);
            }
            this.categoryTable.addUniqueValue(this.value.getValue(i), fv, this.isCalculateUniqueValuesByFormattedValue(), i);
        }
        catch (MissingValueException e) {
            MissingValues mv = e.getMissingValue();
            if (needFormattedValue) {
                fv = this.value.getFormatter().format(mv);
            }
            this.categoryTable.addUniqueValue(mv, fv, this.isCalculateUniqueValuesByFormattedValue(), i);
        }
    }

    @Override
    protected int buildUniqueValueVector() {
        this.buildCategoryTable();
        return this.uniqueValueVector.build();
    }

    protected void setRawValuePipe(NumericPipe np, int valueCount) {
        this.rawValuePipe = np;
        this.valueSwitcher.connectFrom(np);
        this.setRawValueCount(valueCount);
        this.setProcessedValueCount(-1);
    }

    protected NumericPipe getRawValuePipe() {
        return this.rawValuePipe;
    }

    protected void setProcessedValuePipe(NumericPipe np, int valueCount) {
        if (np == null) {
            if (this.rawValuePipe != null) {
                this.valueSwitcher.connectFrom(this.rawValuePipe);
            }
            this.setProcessedValueCount(-1);
        } else {
            this.valueSwitcher.connectFrom(np);
            this.setProcessedValueCount(valueCount);
        }
    }

    protected NumericPipe getProcessedValuePipe() {
        return this.valueSwitcher.getConnection();
    }

    @Override
    public void setFormat(GTKFormat format) {
        SASFormat sf;
        Format[] f;
        if (format != null && (f = format.getFormats())[0] instanceof SASFormat && (sf = (SASFormat)f[0]).isCharacterFormat()) {
            return;
        }
        super.setFormat(format);
    }

    private void calculateValues() {
        int valueCount = this.getValueCount();
        this.calculateValuesBegin();
        for (int i = 0; i < valueCount; ++i) {
            try {
                double d = this.value.getValue(i);
                this.calculateValues(d);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.calculateValuesEnd();
    }

    protected void calculateValuesBegin() {
        this.initialize();
        this.nonMissingValueCount = 0;
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
    }

    protected void calculateValues(double v) {
        if (v != Double.NaN) {
            this.min = Math.min(this.min, v);
            this.max = Math.max(this.max, v);
            this.sum += v;
            ++this.nonMissingValueCount;
        }
    }

    protected void calculateValuesEnd() {
        if (this.nonMissingValueCount > 0) {
            this.mean = this.sum / (double)this.nonMissingValueCount;
        } else {
            this.min = Double.MAX_VALUE;
            this.max = -1.7976931348623157E308;
        }
        this.isCalculated = true;
    }

    private void initialize() {
        this.isCalculated = false;
        this.max = 0.0;
        this.min = 0.0;
        this.mean = 0.0;
        this.sum = 0.0;
    }

    @Override
    public double getSum() {
        if (!this.isCalculated) {
            this.calculateValues();
        }
        return this.sum;
    }

    @Override
    public double getMin() {
        if (!this.isCalculated) {
            this.calculateValues();
        }
        return this.min;
    }

    @Override
    public double getMean() {
        if (!this.isCalculated) {
            this.calculateValues();
        }
        return this.mean;
    }

    @Override
    public double getMax() {
        if (!this.isCalculated) {
            this.calculateValues();
        }
        return this.max;
    }

    @Override
    public void init() {
        NumericVariable v = this;
        v.category.init(new AInitAction());
        v.formattedValue.init(new AInitAction());
        v.formattedUniqueValue.init(new AInitAction());
    }

    @Override
    protected void init(AInitAction initAction) {
        if (this.getConnection() != null) {
            boolean icr = initAction.isCategoryRequest();
            this.getConnection().init(initAction);
            initAction.setCategoryRequest(icr);
            long connectionModifiedTime = initAction.getDataChangedTime();
            long myModifiedTime = this.getModifiedTime();
            if (connectionModifiedTime > myModifiedTime) {
                this.setModified(true, connectionModifiedTime);
            }
        }
        if (initAction.isCategoryRequest()) {
            initAction.setCategoryRequest(false);
            initAction.pushValueCount();
            this.uniqueValueVector.init(initAction);
            initAction.popValueCount();
            initAction.setCategoryPipe(this.categoryTable);
            initAction.setUniqueValueVector(this.uniqueValueVector);
        }
        super.init(initAction);
    }

    public void connectFrom(NumericVariable nv) {
        if (nv == null) {
            throw new IllegalArgumentException("Variable to connectFrom may not be null.");
        }
        this.setConnection(nv);
        this.setRawValuePipe(nv.value, -1);
        if (this.getName().startsWith(defaultName)) {
            this.setName(nv.getName());
        }
        this.connectFrom();
    }

    @Override
    public String getColumnName() {
        return super.getColumnName(this.getConnection());
    }

    @Override
    public boolean isRawValueMissing(int i) {
        if (this.getConnection() != null) {
            return this.isMissing(i);
        }
        throw new IllegalStateException("isRawValueMissing(int) should be overriden by Variable subclasses.");
    }

    @Override
    public boolean isMissing(int i) {
        boolean result;
        try {
            if (this.getConnection() == null) {
                this.value.getValue(i);
            } else {
                ((NumericVariable)this.getConnection()).value.getValue(i);
            }
            result = false;
        }
        catch (MissingValueException e) {
            result = true;
        }
        return result;
    }

    @Override
    protected int getRawValueCount() {
        if (this.getConnection() == null) {
            throw new RuntimeException("No data connection.");
        }
        return this.getConnection().getValueCount();
    }

    @Override
    public int getUniqueValueCount() {
        AInitAction ia = new AInitAction();
        this.uniqueValue.init(ia);
        return ia.getValueCount();
    }

    public int getFirstOccurringValueIndex(int uniqueValueIndex) {
        Object v;
        String fv;
        block4: {
            int uniqueValueCount = this.getUniqueValueCount();
            if (uniqueValueIndex < 0 || uniqueValueIndex > uniqueValueCount - 1) {
                throw new IllegalArgumentException("UniqueValueIndex out of range.");
            }
            fv = null;
            try {
                double d = this.uniqueValue.getValue(uniqueValueIndex);
                v = new Double(d);
                if (this.isCalculateUniqueValuesByFormattedValue()) {
                    fv = this.value.getFormatter().format(v);
                }
            }
            catch (MissingValueException e) {
                v = e.getMissingValue();
                if (!this.isCalculateUniqueValuesByFormattedValue()) break block4;
                fv = this.value.getFormatter().format(v);
            }
        }
        return this.getFirstOccurringValueIndex(v, fv, this.categoryTable.getHashtable());
    }

    public boolean isFreqVariable() {
        return this.freqVariable;
    }

    public void setFreqVariable(boolean trueOrFalse) {
        this.freqVariable = trueOrFalse;
    }

    public double transformFrequencyValue(double d) {
        return d < 0.0 || d != d ? 0.0 : Math.floor(d);
    }

    private static class NumericUniqueValueVector
    extends NumericVector {
        private NumericVariable container;

        public NumericUniqueValueVector(int size, NumericVariable nv) {
            super(size);
            this.container = nv;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.pushValueCount();
            this.container.category.init(initAction);
            initAction.popValueCount();
            int valueCount = this.build();
            initAction.setValueCount(valueCount);
        }

        public int build() {
            Map categoryTable = this.container.getCategoryHashtable();
            this.setSize(categoryTable.size());
            Sort.makeOrderedVector(this, categoryTable);
            return this.size();
        }
    }

    static class NumericCategoryHashtable
    extends Variable.CategoryHashtable {
        NumericVariable container;
        public final NumericProperty input = new NumericProperty(this, true);

        public NumericCategoryHashtable(NumericVariable nv) {
            super(nv);
            this.container = nv;
        }

        @Override
        public int getValue(int i) throws MissingValueException {
            NumericVariable nv = this.container;
            UniqueValue key = this.tempUV;
            key.setCompareByFormattedValue(nv.isCalculateUniqueValuesByFormattedValue());
            try {
                if (nv.isCalculateUniqueValuesByFormattedValue()) {
                    key.setFormattedValue(nv.formattedValue.getValue(i));
                } else {
                    key.setValue(nv.value.getValue(i));
                }
            }
            catch (MissingValueException e) {
                if (nv.isCalculateUniqueValuesByFormattedValue()) {
                    MissingValues mv = e.getMissingValue();
                    GTKFormat f = nv.getFormat();
                    if (f != null && f.getFormats()[0] instanceof SASFormat) {
                        key.setFormattedValue(f.format(mv));
                    } else {
                        key.setFormattedValue(ValueMap.getDefaultMissingValueLabel(mv));
                    }
                }
                key.setValue(e.getMissingValue());
            }
            return this.valueToCategory(key);
        }
    }

    private static class NumericVariablePipeSwitcher
    extends NumericPipeSwitcher {
        private NumericVariable container;

        public NumericVariablePipeSwitcher(NumericVariable nv) {
            this.container = nv;
        }

        @Override
        public void init(AInitAction initAction) {
            this.container.init(initAction);
            super.init(initAction);
        }

        @Override
        public void reset(AResetAction resetAction) {
            this.container.reset(resetAction);
            super.reset(resetAction);
        }

        @Override
        public Formatter getFormatter() {
            return this.container.getFormatter();
        }
    }
}

