/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerPipeSwitcher;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericToNumericMap;
import com.sas.graphics.util.gtk.ValueMap;

public class NumericToNumericMapper
extends NumericMapper {
    private NumericToNumericMap map;
    private IntegerPipeSwitcher categorySwitcher = new IntegerPipeSwitcher();
    public final NumericProperty input = new NumericProperty(this, true);
    public final IntegerPipe category = this.categorySwitcher;

    public NumericToNumericMapper() {
        NumericToNumericMap m = new NumericToNumericMap();
        m.addNumericPipe(this.input);
        this.setMap(m);
    }

    public void setMap(NumericToNumericMap map) {
        if (map == null) {
            throw new RuntimeException("null map");
        }
        this.map = map;
        map.setOwner(this);
        this.uniqueValueSwitcher.connectFrom(map.uniqueValue);
        this.labelSwitcher.connectFrom(map.label);
        this.categorySwitcher.connectFrom(map.category);
        super.setMap(map);
    }

    public void shareMap(NumericToNumericMapper mapper) {
        this.setMap(mapper.map);
    }

    @Override
    protected ValueMap getValueMap() {
        return this.map;
    }

    @Override
    public double getValue(int i) throws MissingValueException {
        double d;
        try {
            d = this.input.getValue(i);
            d = this.map.getValue(d);
        }
        catch (MissingValueException e) {
            if (this.map.isReplaceMissingValues()) {
                d = this.getMissingReplacement(e.getMissingValue());
            }
            throw e;
        }
        return d;
    }

    public double getStrideValue() {
        return this.map.getStrideValue();
    }

    public double getStartValue() {
        return this.map.getStartValue();
    }

    public void setStrideValue(double value) {
        this.map.setStrideValue(value);
    }

    public void setStartValue(double value) {
        this.map.setStartValue(value);
    }

    public void addNumericPipe(NumericPipe pipe) {
        this.map.addNumericPipe(pipe);
    }

    public void removeAllStringPipes() {
        this.map.removeAllNumericPipes();
    }

    public void removeNumericPipe(NumericPipe pipe) {
        this.map.removeNumericPipe(pipe);
    }

    public int getNumericPipeCount() {
        return this.map.getNumericPipeCount();
    }

    public NumericPipe getNumericPipe(int i) {
        return this.map.getNumericPipe(i);
    }

    public void setSortType(int sortType) {
        this.map.setSortType(sortType);
    }

    public int getSortType() {
        return this.map.getSortType();
    }

    public int getUniqueValueCount() {
        return this.map.getUniqueValueCount();
    }

    @Override
    public double getOutputMin() {
        return this.map.getOutputMin();
    }

    @Override
    public double getOutputMax() {
        return this.map.getOutputMax();
    }
}

