/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerPipeSwitcher;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericHashtable;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.Sort;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class NumericToColorMap
extends ColorMap {
    private Hashtable table;
    private Hashtable gtable;
    private Hashtable ttable;
    private Vector pipes = new Vector();
    private int sortType;
    private NumericVector rawLabels;
    private NumericVector combinedLabels = new NumericVector();
    private NumericHashtable combinedLabelsToCategory = new NumericHashtable();
    private NumericHashtable valueToCategoryTable;
    private IntegerPipeSwitcher categorySwitcher = new IntegerPipeSwitcher(this);
    public final IntegerPipe category = this.categorySwitcher;
    private ReusableDouble rdouble = new ReusableDouble();

    public NumericToColorMap() {
        this.table = new Hashtable(101, 0.85f);
        this.gtable = new Hashtable(101, 0.85f);
        this.categorySwitcher.setOwner(this);
    }

    public NumericToColorMap(double[] keys, Color[] values) {
        this.table = new Hashtable(101, 0.85f);
        this.gtable = new Hashtable(101, 0.85f);
        this.categorySwitcher.setOwner(this);
        for (int i = 0; i < keys.length; ++i) {
            if (values.length > i) {
                this.table.put(new ReusableDouble(keys[i]), values[i]);
                continue;
            }
            Color color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            this.table.put(new ReusableDouble(keys[i]), color);
        }
    }

    @Override
    public void init(AInitAction initAction) {
        int index;
        boolean beenInitialized = false;
        beenInitialized = this.pipes.size() == 1 ? this.singlePipeInit(initAction) : this.multiPipeInit(initAction);
        int labelCount = this.rawLabels.size();
        initAction.setValueCount(labelCount);
        if (beenInitialized) {
            return;
        }
        Formatter labelFormatter = this.getOwnerFormatter();
        this.uniqueValueVector.removeAllValues();
        this.labelVector.removeAllValues();
        this.ttable = new Hashtable(101, 0.85f);
        for (index = 0; index < labelCount; ++index) {
            try {
                this.rdouble.value = this.rawLabels.getValue(index);
                Color color = this.table.containsKey(this.rdouble) ? (Color)this.table.get(this.rdouble) : (this.gtable.containsKey(this.rdouble) ? (Color)this.gtable.get(this.rdouble) : new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
                String fLabel = labelFormatter.format(new Double(this.rdouble.value));
                String tLabel = fLabel.trim();
                if (tLabel.length() == 0) {
                    tLabel = fLabel;
                }
                this.labelVector.addValue(tLabel);
                this.uniqueValueVector.addValue(color);
                this.ttable.put(new ReusableDouble(this.rdouble.value), color);
                continue;
            }
            catch (MissingValueException fLabel) {
                // empty catch block
            }
        }
        for (index = 0; index < labelCount; ++index) {
            try {
                this.rdouble.value = this.rawLabels.getValue(index);
                continue;
            }
            catch (MissingValueException e) {
                MissingValues mv = e.getMissingValue();
                if (!this.isReplaceMissingValues(mv) || !this.isLabelMissingValues(mv)) continue;
                this.labelVector.addValue(this.getMissingValueLabel(mv));
                this.uniqueValueVector.addValue(this.getMissingReplacement(mv));
            }
        }
        this.gtable.clear();
        this.gtable = this.ttable;
    }

    private boolean singlePipeInit(AInitAction ia) {
        NumericPipe sp = (NumericPipe)this.pipes.elementAt(0);
        ia.setCategoryRequest(true);
        ia.pushValueCount();
        sp.init(ia);
        ia.popValueCount();
        this.categorySwitcher.connectFrom(ia.getCategoryPipe());
        this.rawLabels = (NumericVector)ia.getUniqueValueVector();
        this.valueToCategoryTable = (NumericHashtable)ia.getValueToCategoryTable();
        if (this.rawLabels.containsMissing()) {
            return this.multiPipeInit(ia);
        }
        return ia.beenInitialized(this);
    }

    private boolean multiPipeInit(AInitAction ia) {
        int pipeIndex;
        boolean beenInitialized = true;
        double value = 0.0;
        int pipeCount = this.pipes.size();
        NumericVector[] uniqueValueVectors = new NumericVector[pipeCount];
        for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
            NumericPipe np = (NumericPipe)this.pipes.elementAt(pipeIndex);
            ia.setCategoryRequest(true);
            ia.pushValueCount();
            np.init(ia);
            uniqueValueVectors[pipeIndex] = (NumericVector)ia.getUniqueValueVector();
            ia.popValueCount();
            beenInitialized &= ia.beenInitialized(this);
        }
        if (!beenInitialized) {
            this.combinedLabels.removeAllValues();
            this.combinedLabelsToCategory.removeAllValues();
            MissingValues mv = null;
            int category = 0;
            for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
                NumericVector nv = uniqueValueVectors[pipeIndex];
                int valueCount = nv.size();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    boolean missing;
                    MissingValues key;
                    try {
                        this.rdouble.value = nv.getValue(valueIndex);
                        key = this.rdouble;
                        missing = false;
                    }
                    catch (MissingValueException e) {
                        key = mv = e.getMissingValue();
                        missing = true;
                    }
                    if (missing && (!missing || !this.isLabelMissingValues(mv) || !this.isReplaceMissingValues(mv)) || this.combinedLabelsToCategory.containsKey(this.rdouble)) continue;
                    if (this.sortType == 0) {
                        if (missing) {
                            this.combinedLabels.addValue(mv);
                        } else {
                            this.combinedLabels.addValue(this.rdouble.value);
                        }
                    }
                    this.combinedLabelsToCategory.putIndex(key, category++);
                }
            }
            if (this.sortType != 0) {
                Sort.NumericComparator comparator = new Sort.NumericComparator(this.sortType, ia.getLocale(), ia.getSortStrategy());
                Sort.sortCategoryTable(this.combinedLabelsToCategory.table, this.sortType, comparator);
                Sort.makeOrderedVector(this.combinedLabels, (Map)this.combinedLabelsToCategory.table);
            }
        }
        this.rawLabels = this.combinedLabels;
        this.categorySwitcher.connectFrom(this.combinedLabelsToCategory);
        this.valueToCategoryTable = this.combinedLabelsToCategory;
        return beenInitialized;
    }

    public Color getValue(int index, NumericPipe input) throws MissingValueException {
        Color result = null;
        try {
            if (this.gtable != null) {
                this.rdouble.value = input.getValue(index);
                result = (Color)this.gtable.get(this.rdouble);
            }
        }
        catch (MissingValueException e) {
            if (this.isReplaceMissingValues(e.getMissingValue())) {
                result = this.getMissingReplacement(e.getMissingValue());
            }
            throw e;
        }
        return result;
    }

    public void add(double d, Color value) {
        if (value == null) {
            value = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
        }
        this.table.put(new ReusableDouble(d), value);
        this.setModified();
    }

    public void remove(double key) {
        this.rdouble.value = key;
        this.table.remove(this.rdouble);
        this.setModified();
    }

    public void removeAll() {
        this.table.clear();
        this.setModified();
    }

    protected void addNumericPipe(NumericPipe pipe) {
        this.pipes.addElement(pipe);
        this.setModified();
    }

    protected void removeAllNumericPipes() {
        this.pipes.removeAllElements();
        this.setModified();
    }

    protected void removeNumericPipe(NumericPipe pipe) {
        this.pipes.removeElement(pipe);
        this.setModified();
    }

    protected int getNumericPipeCount() {
        return this.pipes.size();
    }

    protected NumericPipe getNumericPipe(int i) {
        return (NumericPipe)this.pipes.elementAt(i);
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
        this.setModified();
    }

    public int getSortType() {
        return this.sortType;
    }

    @Override
    public void setLabelMissingValues(boolean b) {
        super.setLabelMissingValues(b);
    }

    @Override
    public void setLabelMissingValues(boolean b, MissingValues missingValue) {
        super.setLabelMissingValues(b, missingValue);
    }
}

