/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.TableModelConnection;
import com.sas.graphics.util.gtk.Variable;
import com.sas.text.SASDateTimeFormat;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.util.Date;

class NumericTableModelConnection
extends TableModelConnection
implements NumericPipe {
    private NumericVariable numericVariable;

    public NumericTableModelConnection(Variable variable) {
        super(variable);
        this.numericVariable = (NumericVariable)variable;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        Object o = this.getTableValue(index);
        return this.getValue(o);
    }

    public double getValue(Object o) throws MissingValueException {
        boolean isMissing;
        double d = 0.0;
        if ((o = this.numericVariable.getInformattedValue(o)) instanceof Number) {
            isMissing = false;
            d = ((Number)o).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                isMissing = true;
                o = MissingValues.Dot;
            }
        } else if (o instanceof MissingValues) {
            isMissing = true;
            if (o == MissingValues.UNDERSCORE || o == MissingValues._BLANK_) {
                o = MissingValues.Dot;
            }
        } else if (o instanceof Date) {
            SASDateTimeFormat dateFormat;
            Date date = (Date)o;
            Format format = this.getVariable().getJavaFormat();
            d = format instanceof SASDateTimeFormat ? ((dateFormat = (SASDateTimeFormat)format).isDateFormat() ? SASDateTimeFormat.javaDateToSASDate((long)date.getTime()) : SASDateTimeFormat.javaDateToSASDateTime((long)date.getTime())) : (date instanceof Time || date instanceof Timestamp ? SASDateTimeFormat.javaDateToSASDateTime((long)date.getTime()) : SASDateTimeFormat.javaDateToSASDate((long)date.getTime()));
            isMissing = false;
        } else if (o instanceof String) {
            try {
                isMissing = false;
                d = Double.parseDouble(((String)o).trim());
            }
            catch (NumberFormatException e) {
                isMissing = true;
                o = MissingValues.Dot;
            }
        } else {
            isMissing = true;
            o = MissingValues.Dot;
        }
        if (this.numericVariable.isFreqVariable()) {
            d = this.numericVariable.transformFrequencyValue(d);
        } else if (isMissing) {
            MissingValueException e = MissingValueException.getDefaultMissingValueExeption();
            e.setMissingValue((MissingValues)o);
            throw e;
        }
        return d;
    }

    public boolean isMissing(int index) {
        boolean isMissing;
        Object o = this.getTableValue(index);
        try {
            o = this.numericVariable.getInformattedValue(o);
        }
        catch (MissingValueException e) {
            o = e.getMissingValue();
        }
        if (o instanceof String) {
            try {
                isMissing = false;
                double d = Double.parseDouble(((String)o).trim());
                o = new Double(d);
            }
            catch (NumberFormatException e) {
                o = MissingValues.Dot;
            }
        }
        if (o instanceof Number) {
            isMissing = false;
            double d = ((Number)o).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                isMissing = true;
            }
        } else {
            isMissing = o instanceof Date ? false : (o instanceof MissingValues ? true : true);
        }
        return isMissing;
    }

    public Class getColumnClass() {
        Class<?> result = null;
        if (this.data != null && this.variableIndex >= 0) {
            result = this.data.getColumnClass(this.variableIndex);
        }
        return result;
    }
}

