/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.PipedFormat;
import com.sas.graphics.util.gtk.StringHashtable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVector;

public class NumericPipedFormat
extends PipedFormat {
    public StringVector uniqueValueVector = new StringVector();
    public final NumericProperty input = new NumericProperty(this, true);
    public final StringPipe uniqueValue = this.uniqueValueVector;

    public NumericPipedFormat() {
        this.uniqueValueVector.setOwner(this);
    }

    @Override
    public String getValue(int index) throws MissingValueException {
        Double o;
        try {
            o = new Double(this.input.getValue(index));
        }
        catch (MissingValueException e) {
            if (this.isMissingValueExceptionsEnabled()) {
                throw e;
            }
            o = e.getMissingValue();
        }
        String result = this.getCurrentFormatter().format(o);
        return result;
    }

    @Override
    public void init(AInitAction initAction) {
        boolean icr = initAction.isCategoryRequest();
        super.init(initAction);
        if (icr) {
            if (!initAction.beenInitialized(this)) {
                Formatter formatter = this.getCurrentFormatter();
                NumericVector uv = (NumericVector)initAction.getUniqueValueVector();
                int n = uv.size();
                this.uniqueValueVector.setSize(n);
                for (int i = 0; i < n; ++i) {
                    Object o;
                    try {
                        o = new Double(uv.getValue(i));
                    }
                    catch (MissingValueException e) {
                        o = e.getMissingValue();
                    }
                    String s = formatter.format(o);
                    this.uniqueValueVector.setValueAt(s, i);
                }
            }
            if (this.categoryTable == null) {
                this.categoryTable = new StringHashtable();
            } else {
                this.categoryTable.removeAllValues();
            }
            this.categoryTable.input.connectFrom(this.uniqueValueVector);
            initAction.pushValueCount();
            this.categoryTable.init(initAction);
            initAction.popValueCount();
            initAction.setUniqueValueVector(this.uniqueValueVector);
            initAction.setCategoryPipe(this.categoryTable);
            initAction.setValueToCategoryTable(this.categoryTable);
        }
    }
}

