/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.SelectDetail;
import java.util.Vector;

public class LineConnectorDetail
extends SelectDetail {
    private Vector lineGroup;
    private boolean interpolationAvailable = false;
    private double interpolationPercent;
    private FilledLineConnector.PolylineGroup group;

    public LineConnectorDetail(FilledLineConnector.PolylineGroup group) {
        this.group = group;
    }

    public LineConnectorDetail(Vector lineGroup, Double interpolationPercent) {
        this.lineGroup = lineGroup;
        this.interpolationAvailable = false;
        if (interpolationPercent != null) {
            this.interpolationPercent = interpolationPercent;
            this.interpolationAvailable = true;
        }
    }

    public double getInterpolationPercent() {
        return this.interpolationPercent;
    }

    public boolean isInterpolationAvailable() {
        return this.interpolationAvailable;
    }

    @Override
    public void computeDetails() {
    }

    public int getGroupValueIndexCount() {
        if (this.group == null) {
            return this.lineGroup.size();
        }
        return this.group.getPolylineCount();
    }

    public int getGroupValueIndexAt(int index) {
        if (this.group == null) {
            return (Integer)this.lineGroup.get(index);
        }
        int previous = 0;
        for (int i = 0; i < this.group.getPolylineCount(); ++i) {
            Vector line = this.group.getPolyline(i);
            int current = line.size();
            if (index < previous + current) {
                return (Integer)line.elementAt(index - previous);
            }
            previous += current;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }
}

