/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Property;
import com.sas.graphics.util.gtk.PropertyContainer;

public class IntegerProperty
extends Property
implements IntegerPipe {
    private int constant;
    private IntegerPipe integerPipe;
    private NumericPipe numericPipe;

    public IntegerProperty() {
    }

    public IntegerProperty(PropertyContainer aContainer, boolean initByContainer) {
        super(aContainer, initByContainer);
        this.numericPipe = null;
        this.integerPipe = null;
        this.constant = 0;
    }

    @Override
    protected Pipe getPipe() {
        return this.numericPipe == null ? this.integerPipe : this.numericPipe;
    }

    public void connectFrom(IntegerPipe aPipe) {
        if (aPipe == null) {
            throw new IllegalArgumentException("Attempt to connect a null pipe.");
        }
        this.integerPipe = aPipe;
        this.numericPipe = null;
        this.setModified();
    }

    public void connectFrom(NumericPipe aPipe) {
        if (aPipe == null) {
            throw new IllegalArgumentException("Attempt to connect a null pipe.");
        }
        this.numericPipe = aPipe;
        this.integerPipe = null;
        this.setModified();
    }

    @Override
    public void disconnect() {
        this.numericPipe = null;
        this.integerPipe = null;
        this.setModified();
    }

    public Pipe getConnection() {
        return this.getPipe();
    }

    @Override
    public int getValue(int index) throws MissingValueException {
        if (this.integerPipe != null) {
            return this.integerPipe.getValue(index);
        }
        if (this.numericPipe != null) {
            return (int)this.numericPipe.getValue(index);
        }
        return this.constant;
    }

    public void setValue(int anInt) {
        this.disconnect();
        this.constant = anInt;
        this.setModified();
    }

    public int getValue() {
        return this.constant;
    }
}

