/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Statistic;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.datatree.DataTreeResponseNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class GroupProcessor {
    private List tempValueIndices = new ArrayList();
    private List tempSelectedIndices = new ArrayList();
    public final CategoryPipe category = new CategoryPipe();
    private Statistic.Bucket[] totals;
    private Vector variables;
    private int[] groupVariableIndices;
    private int groupVariableCount;
    private int[] responseVariableIndices;
    private int responseVariableCount;
    private VariableProcessor.VEntry selectionVariableEntry;
    private List groupIndices = new ArrayList();
    private List responseIndices = new ArrayList();
    private List selectPercenageIndices = new ArrayList();
    private List selectIndices = new ArrayList();
    private int valueCount;
    private DataTreeGroupNode root = null;
    private DefaultMutableTreeNode[] valueIndexToLeafNode;
    private boolean subgroupStyleCumulativeStatistics = false;
    private static final int[] EMPTY_ARRAY = new int[0];

    GroupProcessor() {
    }

    public int getGroupVariableCount() {
        this.createVariableIndices();
        return this.groupVariableCount;
    }

    public int process(Vector allVariables, int aValueCount) {
        this.variables = allVariables;
        this.valueCount = aValueCount;
        this.createVariableIndices();
        this.root = null;
        if (this.groupVariableCount == 0) {
            return aValueCount;
        }
        this.totals = new Statistic.Bucket[this.responseVariableCount];
        for (int i = 0; i < this.responseVariableCount; ++i) {
            this.totals[i] = new Statistic.Bucket();
        }
        this.valueCount = this.createTree(allVariables);
        this.redirect();
        this.forceGroupUVCalculation();
        return this.valueCount;
    }

    private int createTree(Vector allVariables) {
        int groupIndex;
        VariableProcessor.VEntry ve;
        this.root = new DataTreeGroupNode();
        ArrayList<Variable> groupVariables = new ArrayList<Variable>();
        ArrayList<Variable> responseVariables = new ArrayList<Variable>();
        for (int i = 0; i < allVariables.size(); ++i) {
            ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (ve.groupIndex >= 1) {
                groupVariables.add(ve.variable);
                continue;
            }
            responseVariables.add(ve.variable);
        }
        DataTreeInfo info = new DataTreeInfo(groupVariables, responseVariables);
        this.root.setValue(info);
        ArrayList<DataTreeGroupNode> path = new ArrayList<DataTreeGroupNode>(this.groupVariableCount);
        for (groupIndex = 0; groupIndex < this.groupVariableCount; ++groupIndex) {
            path.add(new DataTreeGroupNode());
        }
        for (int valueIndex = 0; valueIndex < this.valueCount; ++valueIndex) {
            DataTreeSummarizationResponseNode srn;
            StringVariable sv;
            NumericVariable nv;
            for (groupIndex = 0; groupIndex < this.groupVariableCount; ++groupIndex) {
                Object value;
                ve = (VariableProcessor.VEntry)this.variables.get(this.groupVariableIndices[groupIndex]);
                String formattedValue = null;
                try {
                    if (ve.variable instanceof NumericVariable) {
                        nv = (NumericVariable)ve.variable;
                        formattedValue = nv.formattedValue.getValue(valueIndex);
                        value = new Double(nv.value.getValue(valueIndex));
                    } else {
                        sv = (StringVariable)ve.variable;
                        formattedValue = sv.formattedValue.getValue(valueIndex);
                        value = sv.value.getValue(valueIndex);
                    }
                }
                catch (MissingValueException mve) {
                    value = mve.getMissingValue();
                    formattedValue = ve.variable.getFormatter().format(mve.getMissingValue());
                }
                DataTreeGroupNode pe = (DataTreeGroupNode)path.get(groupIndex);
                pe.setValue(value);
                pe.setFormattedValue(formattedValue);
                pe.clearValueIndices();
                pe.addValueIndex(valueIndex);
                pe.setLevelIndex(groupIndex);
            }
            DataTreeGroupNode lastGroupNode = DataTreeUtil.addGroupPath(this.root, path, true);
            if (lastGroupNode.getChildCount() == 0) {
                srn = new DataTreeSummarizationResponseNode(this.responseVariableCount);
                lastGroupNode.add(srn);
            } else {
                srn = (DataTreeSummarizationResponseNode)lastGroupNode.getChildAt(0);
            }
            Statistic.Bucket[] responseArray = srn.getResponseArray();
            for (int resp = 0; resp < this.responseVariableCount; ++resp) {
                boolean isNumeric;
                ve = (VariableProcessor.VEntry)this.variables.elementAt(this.responseVariableIndices[resp]);
                nv = null;
                sv = null;
                if (ve.variable instanceof NumericVariable) {
                    isNumeric = true;
                    nv = (NumericVariable)ve.variable;
                } else {
                    isNumeric = false;
                    sv = (StringVariable)ve.variable;
                }
                Statistic.Bucket bucket = responseArray[resp];
                try {
                    if (isNumeric) {
                        double doubleValue = nv.value.getValue(valueIndex);
                        this.totals[resp].accumulate(doubleValue, 6);
                        bucket.accumulate(doubleValue, ve.statistic);
                        continue;
                    }
                    String stringValue = sv.value.getValue(valueIndex);
                    this.totals[resp].accumulate(stringValue);
                    bucket.accumulate(stringValue);
                    continue;
                }
                catch (MissingValueException e) {
                    this.totals[resp].accumulateMissing(e.getMissingValue());
                    bucket.accumulateMissing(e.getMissingValue());
                }
            }
        }
        if (this.isCummulativeStatisticsNeeded() && this.isSubgroupStyleCumulativeStatisticsNeeded()) {
            this.calculateCummulativeStatisticsSubgroupStyle();
        }
        this.sort();
        this.valueIndexToLeafNode = DataTreeUtil.createLeafNodeArray(this.root);
        if (this.isCummulativeStatisticsNeeded() && !this.isSubgroupStyleCumulativeStatisticsNeeded()) {
            this.calculateCummulativeStatisticsByObservation();
        }
        this.postProcessLeafNodes();
        return this.valueIndexToLeafNode.length;
    }

    private void postProcessLeafNodes() {
        int n = this.valueIndexToLeafNode.length;
        for (int i = 0; i < n; ++i) {
            DataTreeSummarizationResponseNode srn = (DataTreeSummarizationResponseNode)this.valueIndexToLeafNode[i];
            Statistic.Bucket[] ra = srn.getResponseArray();
            DataTreeResponseNode rn = new DataTreeResponseNode(ra.length);
            for (int j = 0; j < ra.length; ++j) {
                Object v;
                VariableProcessor.VEntry ve = (VariableProcessor.VEntry)this.variables.elementAt(this.responseVariableIndices[j]);
                Statistic.Bucket bucket = ra[j];
                try {
                    if (ve.variable instanceof NumericVariable) {
                        double d = Statistic.getValue(bucket, ve.statistic, this.totals[ve.responseIndex].sum, this.totals[ve.responseIndex].count);
                        v = new Double(d);
                    } else {
                        v = Statistic.getStringValue(bucket, ve.statistic, this.totals[ve.responseIndex].sum, this.totals[ve.responseIndex].count);
                    }
                }
                catch (MissingValueException mve) {
                    v = mve.getMissingValue();
                }
                rn.setValue(v, j);
            }
            DataTreeGroupNode parent = (DataTreeGroupNode)srn.getParent();
            parent.removeAllChildren();
            parent.add(rn);
            this.valueIndexToLeafNode[i] = rn;
        }
    }

    public DataTreeGroupNode getTree() {
        DataTreeGroupNode gn;
        if (this.root == null) {
            return null;
        }
        DataTreeGroupNode r = DataTreeUtil.copyTree(this.valueIndexToLeafNode);
        Enumeration<TreeNode> enumeration = r.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(n instanceof DataTreeGroupNode)) continue;
            gn = (DataTreeGroupNode)n;
            gn.clearValueIndices();
        }
        DefaultMutableTreeNode[] leaves = DataTreeUtil.createLeafNodeArray(r);
        for (int i = 0; i < leaves.length; ++i) {
            Integer valueIndex = new Integer(i);
            DataTreeResponseNode rn = (DataTreeResponseNode)leaves[i];
            for (gn = (DataTreeGroupNode)rn.getParent(); gn != null; gn = (DataTreeGroupNode)gn.getParent()) {
                gn.addValueIndex(valueIndex);
            }
        }
        return r;
    }

    private void calculateCummulativeStatisticsSubgroupStyle() {
        int cat = 0;
        HashMap<String, CummulativeByResponseValues> subgroupToCumm = new HashMap<String, CummulativeByResponseValues>();
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        DefaultMutableTreeNode lcn = null;
        DataTreeGroupNode cn = (DataTreeGroupNode)this.root.getFirstChild();
        while (cn != null) {
            DataTreeSummarizationResponseNode rn2;
            DataTreeGroupNode sn2;
            int i;
            children.clear();
            if (lcn != null) {
                int n = lcn.getChildCount();
                for (i = 0; i < n; ++i) {
                    DataTreeGroupNode sn1 = (DataTreeGroupNode)lcn.getChildAt(i);
                    DataTreeSummarizationResponseNode rn1 = (DataTreeSummarizationResponseNode)sn1.getChildAt(0);
                    sn2 = cn.findGroupNodeChild(sn1);
                    if (sn2 != null) {
                        cn.remove(sn2);
                        rn2 = (DataTreeSummarizationResponseNode)sn2.getChildAt(0);
                    } else {
                        sn2 = sn1.copy();
                        rn2 = new DataTreeSummarizationResponseNode(rn1.getResponseCount());
                        sn2.add(rn2);
                    }
                    children.add(sn2);
                }
                for (i = 0; i < cn.getChildCount(); ++i) {
                    children.add(cn.getChildAt(i));
                }
                cn.removeAllChildren();
                for (i = 0; i < children.size(); ++i) {
                    cn.add((DataTreeGroupNode)children.get(i));
                }
            }
            for (i = 0; i < cn.getChildCount(); ++i) {
                sn2 = (DataTreeGroupNode)cn.getChildAt(i);
                rn2 = (DataTreeSummarizationResponseNode)sn2.getChildAt(0);
                Statistic.Bucket[] ra = rn2.getResponseArray();
                for (int resp = 0; resp < ra.length; ++resp) {
                    Statistic.Bucket bucket = ra[resp];
                    CummulativeByResponseValues cumm = (CummulativeByResponseValues)subgroupToCumm.get(sn2.getFormattedValue());
                    if (cumm == null) {
                        cumm = new CummulativeByResponseValues(this.responseVariableCount);
                        subgroupToCumm.put(sn2.getFormattedValue(), cumm);
                    }
                    int n = resp;
                    cumm.sum[n] = cumm.sum[n] + bucket.sum;
                    int n2 = resp;
                    cumm.freq[n2] = cumm.freq[n2] + bucket.count;
                    this.totals[resp].runningCount += bucket.count;
                    this.totals[resp].runningSum += bucket.sum;
                    bucket.runningCount = cumm.freq[resp];
                    bucket.runningSum = cumm.sum[resp];
                }
            }
            lcn = cn;
            cn = (DataTreeGroupNode)cn.getNextSibling();
            ++cat;
        }
    }

    private void calculateCummulativeStatisticsByObservation() {
        int n = this.valueIndexToLeafNode.length;
        for (int i = 0; i < n; ++i) {
            DataTreeSummarizationResponseNode rn = (DataTreeSummarizationResponseNode)this.valueIndexToLeafNode[i];
            Statistic.Bucket[] ra = rn.getResponseArray();
            for (int resp = 0; resp < this.responseVariableCount; ++resp) {
                Statistic.Bucket bucket = ra[resp];
                this.totals[resp].runningCount += bucket.count;
                this.totals[resp].runningSum += bucket.sum;
                bucket.runningCount = this.totals[resp].runningCount;
                bucket.runningSum = this.totals[resp].runningSum;
            }
        }
    }

    private void createVariableIndices() {
        int n = this.variables.size();
        this.groupIndices.clear();
        this.responseIndices.clear();
        this.selectPercenageIndices.clear();
        this.selectIndices.clear();
        for (int i = 0; i < n; ++i) {
            VariableProcessor.VEntry ve = (VariableProcessor.VEntry)this.variables.get(i);
            if (ve.type == 0) {
                ve.groupIndex = this.groupIndices.size();
                this.groupIndices.add(new Integer(i));
                ve.category = ve.variable.getCategory();
                continue;
            }
            if (ve.type == 1) {
                ve.responseIndex = this.responseIndices.size();
                this.responseIndices.add(new Integer(i));
                continue;
            }
            if (ve.type == 3) {
                ve.selectPercentageIndex = this.selectPercenageIndices.size();
                this.selectPercenageIndices.add(new Integer(i));
                continue;
            }
            if (ve.type != 2) continue;
            ve.selectPercentageIndex = this.selectPercenageIndices.size();
            this.selectPercenageIndices.add(new Integer(i));
            this.selectionVariableEntry = ve;
            ve.numericValuePriorToGrouping = ((NumericVariable)ve.variable).getProcessedValuePipe();
        }
        this.groupVariableIndices = this.bigIntegerListToArray(this.groupIndices);
        this.groupVariableCount = this.groupVariableIndices.length;
        this.responseVariableIndices = this.bigIntegerListToArray(this.responseIndices);
        this.responseVariableCount = this.responseVariableIndices.length;
    }

    private int[] bigIntegerListToArray(List list) {
        int[] result = EMPTY_ARRAY;
        if (list.size() > 0) {
            result = new int[list.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (Integer)list.get(i);
            }
        }
        return result;
    }

    private boolean isCummulativeStatisticsNeeded() {
        boolean result = false;
        for (int resp = 0; resp < this.responseVariableCount; ++resp) {
            VariableProcessor.VEntry ve = (VariableProcessor.VEntry)this.variables.elementAt(this.responseVariableIndices[resp]);
            if (ve.statistic != 4 && ve.statistic != 5 && ve.statistic != 8 && ve.statistic != 9) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isSubgroupStyleCumulativeStatisticsNeeded() {
        boolean result = false;
        if (this.subgroupStyleCumulativeStatistics && this.groupVariableCount == 2) {
            result = true;
        }
        return result;
    }

    private void redirect() {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VariableProcessor.VEntry ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (ve.variable instanceof NumericVariable) {
                NumericVariable nv = (NumericVariable)ve.variable;
                NumericGroupPipe ngp = new NumericGroupPipe(this, ve);
                nv.setProcessedValuePipe(ngp, this.valueCount);
                continue;
            }
            StringVariable sv = (StringVariable)ve.variable;
            StringGroupPipe sgp = new StringGroupPipe(this, ve);
            sv.setProcessedValuePipe(sgp, this.valueCount);
        }
    }

    private void forceGroupUVCalculation() {
        for (int i = 0; i < this.groupVariableCount; ++i) {
            VariableProcessor.VEntry ve = (VariableProcessor.VEntry)this.variables.elementAt(this.groupVariableIndices[i]);
            ve.variable.calNumUniqueValues = true;
            ve.variable.getUniqueValueCount();
        }
    }

    private void sort() {
        Variable[] gv = new Variable[this.groupVariableCount];
        for (int i = 0; i < this.groupVariableCount; ++i) {
            VariableProcessor.VEntry ve = (VariableProcessor.VEntry)this.variables.elementAt(this.groupVariableIndices[i]);
            gv[i] = ve.variable;
        }
        GroupProcessor.sort(this.root, gv);
    }

    static void sort(DataTreeGroupNode root, Variable[] groupVariables) {
        GroupProcessor.sortTree(root, groupVariables, 0);
    }

    public static void sortTree(DataTreeGroupNode node, Variable[] vars, int level) {
        if (node == null || vars == null || level >= vars.length || node.children() == null) {
            return;
        }
        node.sortChildren(vars[level].getUniqueValueSort(), vars[level].getSortByFormattedValues(), vars[level] instanceof NumericVariable, new ArrayList());
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            TreeNode obj = en.nextElement();
            if (!(obj instanceof DataTreeGroupNode)) continue;
            GroupProcessor.sortTree((DataTreeGroupNode)obj, vars, level + 1);
        }
    }

    public boolean isPerformCumulativeStatsByObservation() {
        return this.subgroupStyleCumulativeStatistics;
    }

    public void setPerformCumulativeStatsByObservation(boolean trueOrFalse) {
        this.subgroupStyleCumulativeStatistics = trueOrFalse;
    }

    private VariableProcessor.VEntry getSelectionVariableEntry() {
        return this.selectionVariableEntry;
    }

    private List computeSelectedIndices(VariableProcessor.VEntry aSelectionVariableEntry, DataTreeGroupNode gn) {
        Iterator iter = gn.getValueIndexIterator();
        this.tempSelectedIndices.clear();
        while (iter.hasNext()) {
            Integer index = (Integer)iter.next();
            int i = index;
            try {
                double d = aSelectionVariableEntry.numericValuePriorToGrouping.getValue(i);
                if (!(d > 0.0)) continue;
                this.tempSelectedIndices.add(new Integer(i));
            }
            catch (MissingValueException missingValueException) {}
        }
        return this.tempSelectedIndices;
    }

    public List getValueIndices(int valueIndex) {
        this.tempValueIndices.clear();
        if (valueIndex > this.valueCount - 1) {
            throw new IllegalArgumentException("Value index out of range.");
        }
        if (this.groupVariableCount > 0) {
            DataTreeResponseNode rn = (DataTreeResponseNode)this.valueIndexToLeafNode[valueIndex];
            DataTreeGroupNode gn = (DataTreeGroupNode)rn.getParent();
            Iterator iter = gn.getValueIndexIterator();
            while (iter.hasNext()) {
                this.tempValueIndices.add(iter.next());
            }
        } else {
            this.tempValueIndices.add(new Integer(valueIndex));
        }
        return this.tempValueIndices;
    }

    public class DataTreeSummarizationResponseNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private Statistic.Bucket[] responseArray;

        public DataTreeSummarizationResponseNode(int responseArrayLength) {
            this.responseArray = new Statistic.Bucket[responseArrayLength];
            for (int i = 0; i < responseArrayLength; ++i) {
                this.responseArray[i] = new Statistic.Bucket();
            }
        }

        public DataTreeSummarizationResponseNode(DataTreeSummarizationResponseNode rn) {
            Statistic.Bucket[] ra = rn.getResponseArray();
            this.responseArray = new Statistic.Bucket[ra.length];
            for (int i = 0; i < ra.length; ++i) {
                this.responseArray[i] = new Statistic.Bucket(ra[i]);
            }
        }

        public Statistic.Bucket[] getResponseArray() {
            return this.responseArray;
        }

        public int getResponseCount() {
            return this.responseArray.length;
        }
    }

    private class CummulativeByResponseValues {
        public double[] sum;
        public int[] freq;

        public CummulativeByResponseValues(int responseCount) {
            this.sum = new double[responseCount];
            this.freq = new int[responseCount];
        }
    }

    private class CategoryPipe
    implements IntegerPipe {
        private CategoryPipe() {
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(GroupProcessor.this.valueCount);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public int getValue(int i) {
            return 0;
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }
    }

    private static class StringGroupPipe
    extends GroupPipe
    implements StringPipe {
        public StringGroupPipe(GroupProcessor gp, VariableProcessor.VEntry ve) {
            super(gp, ve);
        }

        @Override
        public String getValue(int i) throws MissingValueException {
            String result;
            if (i < 0 || i > this.container.valueCount - 1) {
                throw new RuntimeException("valueIndex out of range: " + i + " > " + (this.container.valueCount - 1));
            }
            if (this.ve.type == 0) {
                DataTreeGroupNode gn = DataTreeUtil.findGroupAtLevel((DataTreeResponseNode)this.container.valueIndexToLeafNode[i], this.ve.groupIndex);
                result = gn.getStringValue();
            } else if (this.ve.type == 1) {
                DataTreeResponseNode rn = (DataTreeResponseNode)this.container.valueIndexToLeafNode[i];
                result = rn.getStringValue(this.ve.responseIndex);
            } else {
                throw MissingValueException.getDefaultMissingValueExeption();
            }
            return result;
        }
    }

    private static class NumericGroupPipe
    extends GroupPipe
    implements NumericPipe {
        public NumericGroupPipe(GroupProcessor gp, VariableProcessor.VEntry ve) {
            super(gp, ve);
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            double result;
            if (i < 0 || i > this.container.valueCount - 1) {
                throw new RuntimeException("valueIndex out of range: " + i + " > " + (this.container.valueCount - 1));
            }
            if (this.ve.type == 0) {
                DataTreeGroupNode gn = DataTreeUtil.findGroupAtLevel((DataTreeResponseNode)this.container.valueIndexToLeafNode[i], this.ve.groupIndex);
                result = gn.getNumericValue();
            } else if (this.ve.type == 1) {
                DataTreeResponseNode rn = (DataTreeResponseNode)this.container.valueIndexToLeafNode[i];
                result = rn.getDoubleValue(this.ve.responseIndex);
            } else if (this.ve.type == 2) {
                DataTreeResponseNode rn = (DataTreeResponseNode)this.container.valueIndexToLeafNode[i];
                DataTreeGroupNode gn = (DataTreeGroupNode)rn.getParent();
                List selectedIndices = this.container.computeSelectedIndices(this.ve, gn);
                result = selectedIndices.size() > 0 ? 1.0 : 0.0;
            } else if (this.ve.type == 3) {
                DataTreeResponseNode rn = (DataTreeResponseNode)this.container.valueIndexToLeafNode[i];
                DataTreeGroupNode gn = (DataTreeGroupNode)rn.getParent();
                result = 0.0;
                VariableProcessor.VEntry sve = this.container.getSelectionVariableEntry();
                int valueIndexCount = gn.getValueIndexCount();
                if (sve != null && valueIndexCount > 0) {
                    List selectedIndices = this.container.computeSelectedIndices(sve, gn);
                    result = (double)selectedIndices.size() / (double)valueIndexCount;
                }
            } else {
                throw MissingValueException.getDefaultMissingValueExeption();
            }
            return result;
        }
    }

    private static class GroupPipe
    implements Pipe {
        protected GroupProcessor container;
        protected VariableProcessor.VEntry ve;

        public GroupPipe(GroupProcessor gp, VariableProcessor.VEntry ve) {
            this.container = gp;
            this.ve = ve;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.container.valueCount);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }
    }
}

