/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.Style;
import java.awt.Color;
import java.awt.Image;

public class GridStyle
extends Style {
    private boolean linkedLineAttributes = true;
    private LineStyle horizontalMajorLineStyle = new LineStyle();
    private LineStyle verticalMajorLineStyle = new LineStyle();
    private LineStyle horizontalMinorLineStyle = new LineStyle();
    private LineStyle verticalMinorLineStyle = new LineStyle();
    private LineStyle borderLineStyle = new LineStyle();
    private int minorGridLineCount;
    private boolean backgroundOn;
    private Color backgroundColor;
    private Color backgroundColor2;
    private boolean gradientOn = false;
    private int gradientDirection = 0;
    private Image backgroundImage;

    public GridStyle() {
        this.horizontalMajorLineStyle.setVisible(true);
        this.verticalMajorLineStyle.setVisible(true);
        this.horizontalMinorLineStyle.setVisible(false);
        this.verticalMinorLineStyle.setVisible(false);
        this.borderLineStyle.setVisible(true);
        this.backgroundOn = true;
        this.backgroundColor = Color.lightGray;
        this.backgroundColor2 = Color.lightGray;
        this.minorGridLineCount = 1;
    }

    public GridStyle(GridStyle style) {
        this.horizontalMajorLineStyle.set(style.horizontalMajorLineStyle);
        this.verticalMajorLineStyle.set(style.verticalMajorLineStyle);
        this.horizontalMinorLineStyle.set(style.horizontalMinorLineStyle);
        this.verticalMinorLineStyle.set(style.verticalMinorLineStyle);
        this.borderLineStyle.set(style.borderLineStyle);
        this.minorGridLineCount = style.minorGridLineCount;
        this.backgroundOn = style.backgroundOn;
        this.backgroundColor = style.backgroundColor;
        this.backgroundColor2 = style.backgroundColor2;
        this.gradientOn = style.gradientOn;
        this.gradientDirection = style.gradientDirection;
        this.linkedLineAttributes = style.linkedLineAttributes;
    }

    public LineStyle getHorizontalMajorLineStyle() {
        return this.horizontalMajorLineStyle;
    }

    public LineStyle getVerticalMajorLineStyle() {
        return this.verticalMajorLineStyle;
    }

    public LineStyle getHorizontalMinorLineStyle() {
        return this.horizontalMinorLineStyle;
    }

    public LineStyle getVerticalMinorLineStyle() {
        return this.verticalMinorLineStyle;
    }

    public LineStyle getBorderLineStyle() {
        return this.borderLineStyle;
    }

    public void setVerticalMinorLinesOn(boolean trueOrFalse) {
        this.verticalMinorLineStyle.setVisible(trueOrFalse);
    }

    public void setHorizontalMinorLinesOn(boolean trueOrFalse) {
        this.horizontalMinorLineStyle.setVisible(trueOrFalse);
    }

    public void setBackgroundOn(boolean trueOrFalse) {
        this.backgroundOn = trueOrFalse;
    }

    public void setBorderOn(boolean trueOrFalse) {
        this.borderLineStyle.setVisible(trueOrFalse);
    }

    public void setMajorLineColor(Color color) {
        if (color != null) {
            this.horizontalMajorLineStyle.setColor(color);
        }
    }

    public void setMinorLineColor(Color color) {
        if (color != null) {
            this.horizontalMinorLineStyle.setColor(color);
        }
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.backgroundColor = color;
        }
    }

    public void setBackgroundColor2(Color color) {
        if (color != null) {
            this.backgroundColor2 = color;
        }
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setMinorGridLineCount(int count) {
        this.minorGridLineCount = count >= 0 ? count : 0;
    }

    public void setLineWidth(int width) {
        this.horizontalMajorLineStyle.setWidth(width);
    }

    public void setStipple(int pattern, int factor) {
        this.horizontalMajorLineStyle.setStipplePattern(pattern);
        this.horizontalMajorLineStyle.setStippleFactor(factor);
    }

    public void setMinorLineWidth(int width) {
        this.horizontalMinorLineStyle.setWidth(width);
    }

    public void setMinorStipple(int pattern, int factor) {
        this.horizontalMinorLineStyle.setStipplePattern(pattern);
        this.horizontalMinorLineStyle.setStippleFactor(factor);
    }

    public boolean isVerticalMinorLinesOn() {
        return this.verticalMinorLineStyle.isVisible();
    }

    public boolean isHorizontalMinorLinesOn() {
        return this.horizontalMinorLineStyle.isVisible();
    }

    public boolean isBackgroundOn() {
        return this.backgroundOn;
    }

    public boolean isBorderOn() {
        return this.borderLineStyle.isVisible();
    }

    public Color getMajorLineColor() {
        return this.horizontalMajorLineStyle.getColor();
    }

    public Color getMinorLineColor() {
        return this.horizontalMinorLineStyle.getColor();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getMinorGridLineCount() {
        return this.minorGridLineCount;
    }

    public int getLineWidth() {
        return this.horizontalMajorLineStyle.getWidth();
    }

    public int getStipplePattern() {
        return this.horizontalMajorLineStyle.getStipplePattern();
    }

    public int getStippleFactor() {
        return this.horizontalMajorLineStyle.getStippleFactor();
    }

    public int getMinorLineWidth() {
        return this.horizontalMinorLineStyle.getWidth();
    }

    public int getMinorStipplePattern() {
        return this.horizontalMinorLineStyle.getStipplePattern();
    }

    public int getMinorStippleFactor() {
        return this.horizontalMinorLineStyle.getStippleFactor();
    }

    public int getGradientDirection() {
        return this.gradientDirection;
    }

    public boolean isGradientOn() {
        return this.gradientOn;
    }

    public void setGradientDirection(int gradientDirection) {
        this.gradientDirection = gradientDirection;
    }

    public void setGradientOn(boolean gradientOn) {
        this.gradientOn = gradientOn;
    }

    public Color getBackgroundColor2() {
        return this.backgroundColor2;
    }

    public boolean isLinkedLineAttributes() {
        return this.linkedLineAttributes;
    }

    public void setLinkedLineAttributes(boolean majorHorizontalAndVerticalAttributesLinked) {
        this.linkedLineAttributes = majorHorizontalAndVerticalAttributesLinked;
    }
}

