/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Plane;
import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.Action;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Connector;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.LineConnectorDetail;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.Property;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.gl.BuildAction;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public abstract class FilledLineConnector
extends Connector {
    public static final int CONNECTION_ORDER_DATA = 0;
    public static final int CONNECTION_ORDER_X = 1;
    public static final int CONNECTION_ORDER_Y = 2;
    public static final int CONNECTION_ORDER_Z = 3;
    private int connectionOrder = 0;
    private IndexedValueComparator comparator;
    protected Vector renderIndices = new Vector();
    private int current = 0;
    public final ColorProperty fillColor = new ColorProperty(this, true);
    public final NumericProperty lineWidth = new NumericProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final BooleanProperty lineOn = new BooleanProperty(this, true);
    public final IntegerProperty linePattern = new IntegerProperty(this, true);
    public final BooleanProperty highlightOn = new BooleanProperty(this, true);
    public final ColorProperty highlightColor = new ColorProperty(this, true);
    public final NumericProperty numericGroup = new NumericProperty(this, true);
    public final StringProperty stringGroup = new StringProperty(this, true);
    public final BooleanProperty specificationLimitsOn = new BooleanProperty(this, true);
    public final NumericProperty specificationLimitLow = new NumericProperty(this, true);
    public final NumericProperty specificationLimitHigh = new NumericProperty(this, true);
    public final ColorProperty specificationLimitBelowLowColor = new ColorProperty(this, true);
    public final ColorProperty specificationLimitAboveHighColor = new ColorProperty(this, true);
    public final BooleanProperty markerOn = new BooleanProperty();
    public final ColorProperty markerColor = new ColorProperty(this, true);
    public final ColorProperty markerEdgeColor = new ColorProperty(this, true);
    public final IntegerProperty markerType = new IntegerProperty(this, true);
    public final IntegerProperty markerSize = new IntegerProperty(this, true);
    public final BooleanProperty dataLabelTopOn = new BooleanProperty();
    public final BooleanProperty dataLabelBottomOn = new BooleanProperty();
    public final BooleanProperty dataLabelTrimOn = new BooleanProperty(this, true);
    public final StringProperty dataLabelTop = new StringProperty(this, true);
    public final StringProperty dataLabelBottom = new StringProperty(this, true);
    public final ColorProperty dataLabelColor = new ColorProperty(this, true);
    public final IntegerProperty dataLabelHorizontalJustification = new IntegerProperty(this, true);
    public final NumericProperty pointX2 = new NumericProperty(this, true);
    public final NumericProperty pointY2 = new NumericProperty(this, true);
    public final NumericProperty pointZ2 = new NumericProperty(this, true);
    protected double beginPointX;
    protected double beginPointY;
    protected double beginPointZ;
    protected double endPointX;
    protected double endPointY;
    protected double endPointZ;
    protected boolean skipMissing;
    protected boolean skipMissingOnXAxis;
    protected BoundingBox fillBoundingBox;
    protected Plane fillToPlane;
    protected Vec3d depth;
    protected int stipplePattern;
    protected int stippleFactor;
    protected int capStyle;
    protected int joinStyle;
    protected Vec3d minBBox;
    protected Vec3d maxBBox;
    protected boolean makeNewv1;
    protected boolean makeNewv2;
    protected boolean reverseAreaNormal;
    private Vec3d v1;
    private Vec3d v2;
    private Vec3d v3;
    private Vec3d v4;
    private Vec3d v5;
    private Vec3d point;
    private Vec3d newv1;
    private Vec3d newv2;
    private Vec3d newv3;
    private Vec3d newv4;
    private Vec3d specv1;
    private Vec3d specv2;
    private Vec3d specv3;
    private Vec3d specv4;
    private final ReusableDouble scratchGroupKey = new ReusableDouble();
    private int myValueCount;
    private List customLinePatterns;
    private Property groupPipe;
    protected final HashMap perGroupPolylines = new LinkedHashMap();
    protected boolean multipleGroup = false;
    protected boolean missingGroupOn = true;
    protected PolylineGroup currentGroup;
    private float polygonOffsetFactor = 0.001f;
    private float polygonOffsetUnits = 0.0f;
    private double stippleScaleFactor = 1.0;
    private Font dataLabelFont = FontManager.getDefaultFont();
    private boolean renderSpecLimit = false;
    protected int skinType = 0;
    protected float DPIScaleFactor = 1.0f;
    protected boolean presortRequired = false;
    protected boolean subpixelRendering = false;
    public static final int ARROW_SHAPE_OPEN = 0;
    public static final int ARROW_SHAPE_FILLED = 1;
    public static final int ARROW_SHAPE_BARBED = 2;
    public static final int ARROW_HEAD_NONE = 0;
    public static final int ARROW_HEAD_START = 1;
    public static final int ARROW_HEAD_END = 3;
    public static final int ARROW_HEAD_BOTH = 4;
    public final IntegerProperty arrowHeadShape = new IntegerProperty(this, true);
    public final IntegerProperty arrowHeadPosition = new IntegerProperty(this, true);
    public final NumericProperty arrowHeadScale = new NumericProperty(this, true);
    protected boolean isSpecLimitLower = false;
    protected boolean isSpecLimitUpper = false;
    protected ArrayList specLimitLower;
    protected ArrayList specLimitUpper;
    protected ArrayList middle;
    protected double adjX;
    protected double adjY;
    protected Vec3d arrowV1 = null;
    protected Vec3d arrowV2 = null;
    protected int index_s;
    protected double adjXend;
    protected double adjYend;
    protected Vec3d arrowV1end = null;
    protected Vec3d arrowV2end = null;
    protected int index_e;
    protected boolean startArrow;
    protected boolean endArrow;
    protected int arrowShape;
    protected double arrowScale;
    public final BooleanProperty fillPatternOn = new BooleanProperty(this, true);
    public final IntegerProperty fillPatternType = new IntegerProperty(this, true);
    public final ColorProperty fillPatternColor = new ColorProperty(this, true);
    public final NumericProperty fillPatternWidth = new NumericProperty(this, true);
    public final NumericProperty fillPatternScaleFactor = new NumericProperty(this, true);
    static double MY_ZERO = 1.0E-8;

    public FilledLineConnector(ATransform transform) {
        super(transform);
        this.markerOn.setValue(false);
        this.markerSize.setValue(10);
        this.markerType.setValue(3);
        this.markerColor.setValue(Color.BLACK);
        this.dataLabelTopOn.setValue(false);
        this.dataLabelBottomOn.setValue(false);
        this.dataLabelHorizontalJustification.setValue(1);
        this.reverseAreaNormal = false;
        this.fillOn.setValue(false);
        this.lineOn.setValue(true);
        this.fillBoundingBox = new BoundingBox();
        this.fillToPlane = Plane.ZX;
        this.lineWidth.setValue(1.0);
        this.linePattern.setValue(-1);
        this.color.setValue(Color.blue);
        this.fillColor.setValue(Color.blue);
        this.highlightOn.setValue(false);
        this.highlightColor.setValue(Color.yellow);
        this.depth = new Vec3d(0.0, 0.0, 0.0);
        this.stippleFactor = 0;
        this.stipplePattern = -1;
        this.capStyle = 0;
        this.joinStyle = 1;
        this.point = new Vec3d();
        this.v1 = new Vec3d();
        this.v2 = new Vec3d();
        this.v3 = new Vec3d();
        this.v4 = new Vec3d();
        this.v5 = new Vec3d();
        this.newv1 = new Vec3d();
        this.newv2 = new Vec3d();
        this.newv3 = new Vec3d();
        this.newv4 = new Vec3d();
        this.specv1 = new Vec3d();
        this.specv2 = new Vec3d();
        this.specv3 = new Vec3d();
        this.specv4 = new Vec3d();
        this.skipMissing = false;
        this.skipMissingOnXAxis = false;
        this.groupPipe = this.numericGroup;
        ((NumericProperty)this.groupPipe).setValue(0.0);
        this.arrowHeadShape.setValue(0);
        this.arrowHeadPosition.setValue(0);
        this.arrowHeadScale.setValue(1.0);
        this.fillPatternOn.setValue(false);
        this.fillPatternType.setValue(-1);
        this.fillPatternColor.setValue(Color.black);
        this.fillPatternWidth.setValue(1.0);
        this.fillPatternScaleFactor.setValue(1.0);
    }

    private void calculateWorldPixelHeight() {
    }

    @Override
    public void init(AInitAction initAction) {
        if (this.connectionOrder != 0) {
            initAction.setAnimationInitRequired(true);
        }
        if (this.multipleGroup) {
            initAction.pushValueCount();
            super.init(initAction);
            boolean beenInitialized = initAction.beenInitialized(this);
            this.myValueCount = initAction.getValueCount();
            initAction.popValueCount();
            initAction.setValueCount(1);
            this.setValueCount(1);
            this.calculateWorldPixelHeight();
            if (beenInitialized) {
                return;
            }
            if (this.numericGroup.isConnected() && this.stringGroup.isConnected()) {
                throw new IllegalStateException("Group values are connected to both numeric and string pipes.");
            }
            this.groupPipe = this.stringGroup.isConnected() ? this.stringGroup : this.numericGroup;
            if (this.presortRequired) {
                this.presortAndLoadPolylines();
            } else {
                this.loadPolylines();
                this.sort();
            }
        } else {
            super.init(initAction);
        }
        initAction.setAnimationInitRequired(false);
    }

    protected void loadPolylines() {
        this.perGroupPolylines.clear();
        for (int i = 0; i < this.myValueCount; ++i) {
            Object key = this.getGroupKey(i);
            if (key == null) continue;
            PolylineGroup group = (PolylineGroup)this.perGroupPolylines.get(key);
            if (group == null) {
                group = new PolylineGroup(this.depth.length() > 0.0);
                this.perGroupPolylines.put(key, group);
                group.setHighlightColor(this.highlightColor.getValue());
            }
            try {
                boolean arrowEnd;
                boolean arrowStart;
                this.pointX.getValue(i);
                this.pointY.getValue(i);
                this.pointZ.getValue(i);
                Color fc = this.fillColor.getValue(i);
                Color lc = this.color.getValue(i);
                double lw = this.lineWidth.getValue(i);
                int lpi = this.linePattern.getValue(i);
                Color fpc = this.fillPatternColor.getValue(i);
                int fpt = this.fillPatternType.getValue(i);
                double fpw = this.fillPatternWidth.getValue(i);
                double fpsf = this.fillPatternScaleFactor.getValue(i);
                int arrowShape = this.arrowHeadShape.getValue(i);
                double arrowScale = this.arrowHeadScale.getValue(i);
                int pos = this.arrowHeadPosition.getValue(i);
                switch (pos) {
                    default: {
                        arrowStart = false;
                        arrowEnd = false;
                        break;
                    }
                    case 1: {
                        arrowStart = true;
                        arrowEnd = false;
                        break;
                    }
                    case 3: {
                        arrowStart = false;
                        arrowEnd = true;
                        break;
                    }
                    case 4: {
                        arrowStart = true;
                        arrowEnd = true;
                    }
                }
                group.setFillColor(fc);
                group.setLineColor(lc);
                group.setLineWidth(lw);
                group.setLinePatternIndex(lpi);
                group.setFillPatternColor(fpc);
                group.setFillPatternType(fpt);
                group.setFillPatternWidth(fpw);
                group.setFillPatternScaleFactor(fpsf);
                group.setStartArrowOn(arrowStart);
                group.setEndArrowOn(arrowEnd);
                group.setArrowHeadShape(arrowShape);
                group.setArrowHeadScale(arrowScale);
                Vector line = group.getCurrentPolyline();
                line.addElement(new Integer(i));
                group.addVertex();
                continue;
            }
            catch (MissingValueException e) {
                if (!this.getSkipMissingOn()) continue;
                group.addPolyline();
            }
        }
    }

    protected void presortAndLoadPolylines() {
        PolylineGroup group;
        Object key;
        this.perGroupPolylines.clear();
        Vector<Integer> sortIndices = new Vector<Integer>();
        for (int i = 0; i < this.myValueCount; ++i) {
            sortIndices.addElement(new Integer(i));
        }
        int order = this.getConnectionOrder();
        if (order != 0) {
            NumericProperty p = order == 3 ? this.pointZ : (order == 2 ? this.pointY : this.pointX);
            if (this.comparator == null) {
                this.comparator = new IndexedValueComparator();
                this.comparator.setSortOrder(1);
            }
            this.comparator.setSortPipe(p);
            Collections.sort(sortIndices, this.comparator);
        }
        for (int i = 0; i < this.myValueCount; ++i) {
            key = this.getGroupKey(i);
            if (key == null || (group = (PolylineGroup)this.perGroupPolylines.get(key)) != null) continue;
            group = new PolylineGroup(this.depth.length() > 0.0);
            this.perGroupPolylines.put(key, group);
            group.setHighlightColor(this.highlightColor.getValue());
        }
        for (int j = 0; j < this.myValueCount; ++j) {
            int i = (Integer)sortIndices.get(j);
            key = this.getGroupKey(i);
            if (key == null) continue;
            group = (PolylineGroup)this.perGroupPolylines.get(key);
            if (group == null) {
                group = new PolylineGroup(this.depth.length() > 0.0);
                this.perGroupPolylines.put(key, group);
                group.setHighlightColor(this.highlightColor.getValue());
            }
            try {
                boolean arrowEnd;
                boolean arrowStart;
                if (this.skipMissingOnXAxis) {
                    this.pointX.getValue(i);
                    try {
                        this.pointY.getValue(i);
                    }
                    catch (MissingValueException e) {
                        continue;
                    }
                }
                this.pointY.getValue(i);
                try {
                    this.pointX.getValue(i);
                }
                catch (MissingValueException e) {
                    continue;
                }
                this.pointZ.getValue(i);
                Color fc = this.fillColor.getValue(i);
                Color lc = this.color.getValue(i);
                double lw = this.lineWidth.getValue(i);
                int lpi = this.linePattern.getValue(i);
                Color fpc = this.fillPatternColor.getValue(i);
                int fpt = this.fillPatternType.getValue(i);
                double fpw = this.fillPatternWidth.getValue(i);
                double fpsf = this.fillPatternScaleFactor.getValue(i);
                int arrowShape = this.arrowHeadShape.getValue(i);
                double arrowScale = this.arrowHeadScale.getValue(i);
                int pos = this.arrowHeadPosition.getValue(i);
                switch (pos) {
                    default: {
                        arrowStart = false;
                        arrowEnd = false;
                        break;
                    }
                    case 1: {
                        arrowStart = true;
                        arrowEnd = false;
                        break;
                    }
                    case 3: {
                        arrowStart = false;
                        arrowEnd = true;
                        break;
                    }
                    case 4: {
                        arrowStart = true;
                        arrowEnd = true;
                    }
                }
                group.setFillColor(fc);
                group.setLineColor(lc);
                group.setLineWidth(lw);
                group.setLinePatternIndex(lpi);
                group.setFillPatternColor(fpc);
                group.setFillPatternType(fpt);
                group.setFillPatternWidth(fpw);
                group.setFillPatternScaleFactor(fpsf);
                group.setStartArrowOn(arrowStart);
                group.setEndArrowOn(arrowEnd);
                group.setArrowHeadShape(arrowShape);
                group.setArrowHeadScale(arrowScale);
                Vector line = group.getCurrentPolyline();
                line.addElement(new Integer(i));
                group.addVertex();
                continue;
            }
            catch (MissingValueException e) {
                if (!this.getSkipMissingOn()) continue;
                group.addPolyline();
            }
        }
    }

    private Object getGroupKey(int valueIndex) {
        Object key;
        try {
            if (this.groupPipe instanceof NumericProperty) {
                double g;
                this.scratchGroupKey.value = g = ((NumericProperty)this.groupPipe).getValue(valueIndex);
                key = this.scratchGroupKey;
            } else {
                String g = ((StringProperty)this.groupPipe).getValue(valueIndex);
                key = g;
            }
        }
        catch (MissingValueException e) {
            key = this.missingGroupOn ? e.getMissingValue() : null;
        }
        return key;
    }

    public void setReverseAreaNormalOn(boolean flag) {
        this.reverseAreaNormal = flag;
    }

    public boolean getReverseAreaNormalOn() {
        return this.reverseAreaNormal;
    }

    public void setSkipMissingOn(boolean flag) {
        this.skipMissing = flag;
    }

    public boolean getSkipMissingOn() {
        return this.skipMissing;
    }

    public void setSkipMissingOnXAxis(boolean onXAxis) {
        this.skipMissingOnXAxis = onXAxis;
    }

    public boolean isSkipMissingOnXAxis() {
        return this.skipMissingOnXAxis;
    }

    public void setFillBoundingBox(BoundingBox boundingBox) {
        this.fillBoundingBox = boundingBox;
    }

    public BoundingBox getFillBoundingBox() {
        return this.fillBoundingBox;
    }

    public void setFillToPlane(Plane plane) {
        if (plane.isParallelTo(Plane.XY) || plane.isParallelTo(Plane.YZ) || plane.isParallelTo(Plane.ZX)) {
            this.fillToPlane = new Plane(plane);
        }
    }

    public Plane getFillToPlane() {
        return this.fillToPlane;
    }

    public void setDepth(Vec3d depth) {
        this.depth.set(depth);
    }

    public Vec3d getDepth() {
        return this.depth;
    }

    public void setStipple(int pattern, int factor) {
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
    }

    public int getStipplePattern() {
        return this.stipplePattern;
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }

    public void setJoinStyle(int style) {
        this.joinStyle = style;
    }

    public int getJoinStyle() {
        return this.joinStyle;
    }

    public void setCapStyle(int style) {
        this.capStyle = style;
    }

    public int getCapStyle() {
        return this.capStyle;
    }

    public void setCustomLinePatterns(List patternFactorPairs) {
        if (patternFactorPairs == null || patternFactorPairs.size() == 0) {
            return;
        }
        String message = "The patternFactorPairs list must contain integer arrays.";
        for (int i = 0; i < patternFactorPairs.size(); ++i) {
            Object o = patternFactorPairs.get(i);
            if (!(o instanceof int[])) {
                throw new IllegalArgumentException(message);
            }
            int[] a = (int[])o;
            if (a.length == 2) continue;
            throw new IllegalArgumentException(message);
        }
        this.customLinePatterns = patternFactorPairs;
    }

    public List getCustomLinePatterns() {
        return this.customLinePatterns;
    }

    public void setMultipleGroup(boolean b) {
        this.multipleGroup = b;
    }

    public void setMissingGroupOn(boolean b) {
        this.missingGroupOn = b;
    }

    public boolean isMissingGroupOn() {
        return this.missingGroupOn;
    }

    public void setStippleScaleFactor(double fac) {
        this.stippleScaleFactor = fac;
    }

    public double getStippleScaleFactor() {
        return this.stippleScaleFactor;
    }

    protected void drawFillUnder(Action action) {
        if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointZ) || Double.isNaN(this.endPointX) || Double.isNaN(this.endPointY) || Double.isNaN(this.endPointZ)) {
            return;
        }
        this.v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
        this.v2.set(this.endPointX, this.endPointY, this.endPointZ);
        Channel channel = (Channel)action.getGraphicsContext();
        this.drawFillUnder(channel, this.v1, this.v2);
    }

    protected void drawFillUnder(Channel channel, Vec3d begin, Vec3d end) {
        this.minBBox = this.fillBoundingBox.getMinimum();
        this.maxBBox = this.fillBoundingBox.getMaximum();
        this.v1.set(begin);
        this.v2.set(end);
        this.v3.set(0.0, 0.0, 0.0);
        this.v4.set(0.0, 0.0, 0.0);
        this.newv1.set(0.0, 0.0, 0.0);
        this.newv2.set(0.0, 0.0, 0.0);
        this.newv3.set(0.0, 0.0, 0.0);
        this.newv4.set(0.0, 0.0, 0.0);
        if (this.fillBoundingBox.isEmpty()) {
            this.projectToPlaneAndDraw(channel, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
        } else {
            this.makeNewv1 = false;
            this.makeNewv2 = false;
            if (this.fillBoundingBox.isPointContained(this.v1)) {
                if (!this.fillBoundingBox.isPointContained(this.v2)) {
                    Vector points = FilledLineConnector.getPointsOfIntersection(this.fillBoundingBox, this.v1, this.v2);
                    for (int i = 0; i < points.size(); ++i) {
                        this.point = (Vec3d)points.elementAt(i);
                        if (!this.isPointContainedInLine(this.v1, this.v2, this.point)) continue;
                        if (this.fillBoundingBox.isPointContained(this.point)) {
                            this.newv2 = this.point;
                            continue;
                        }
                        this.v2 = this.point;
                    }
                    this.makeNewv2 = true;
                    this.projectToPlaneAndDraw(channel, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                } else {
                    this.projectToPlaneAndDraw(channel, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                }
            } else if (this.fillBoundingBox.isPointContained(this.v2)) {
                Vector points = FilledLineConnector.getPointsOfIntersection(this.fillBoundingBox, this.v1, this.v2);
                for (int i = 0; i < points.size(); ++i) {
                    this.point = (Vec3d)points.elementAt(i);
                    if (!this.isPointContainedInLine(this.v1, this.v2, this.point)) continue;
                    if (this.fillBoundingBox.isPointContained(this.point)) {
                        this.newv1 = this.point;
                        continue;
                    }
                    this.v1 = this.point;
                }
                this.makeNewv1 = true;
                this.projectToPlaneAndDraw(channel, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
            } else {
                Vec3d internalPoint = FilledLineConnector.getInternalPoint(this.fillBoundingBox, this.v1, this.v2);
                if (internalPoint != null) {
                    Vec3d v1Keep = new Vec3d(this.v1);
                    Vec3d v2Keep = new Vec3d(this.v2);
                    Vector points = FilledLineConnector.getPointsOfIntersection(this.fillBoundingBox, this.v1, internalPoint);
                    Vec3d[] values = this.modifyIntersectingValues(points, this.v1, this.newv1);
                    this.newv1.set(values[0]);
                    this.v1.set(values[1]);
                    this.v2.set(internalPoint);
                    this.makeNewv1 = true;
                    this.projectToPlaneAndDraw(channel, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                    this.v1.set(v1Keep);
                    this.v2.set(v2Keep);
                    points = FilledLineConnector.getPointsOfIntersection(this.fillBoundingBox, internalPoint, this.v2);
                    values = this.modifyIntersectingValues(points, this.v2, this.newv2);
                    this.newv2.set(values[0]);
                    this.v2.set(values[1]);
                    this.v1.set(internalPoint);
                    this.makeNewv1 = false;
                    this.makeNewv2 = true;
                    this.projectToPlaneAndDraw(channel, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                } else {
                    int i;
                    Vector<Plane> boundingPlanes = new Vector<Plane>(2, 2);
                    Vector<Vec3d> points = new Vector<Vec3d>(2, 2);
                    Vec3d min = this.fillBoundingBox.getMinimum();
                    Vec3d max = this.fillBoundingBox.getMaximum();
                    Plane[] planes = FilledLineConnector.getPlanesOfBoundingBox(this.fillBoundingBox);
                    for (i = 0; i < planes.length; ++i) {
                        if (planes[i].isParallelTo(this.fillToPlane)) continue;
                        boundingPlanes.addElement(planes[i]);
                    }
                    for (i = 0; i < boundingPlanes.size(); ++i) {
                        this.point = ((Plane)boundingPlanes.elementAt(i)).getPointOfIntersection(this.v1, this.v2);
                        if (this.point == null || !this.isPointContainedInLine(this.v1, this.v2, this.point) || !this.isPointContainedWithinPlanes(min, max, this.point)) continue;
                        points.addElement(new Vec3d(this.point.x, this.point.y, this.point.z));
                    }
                    if (!points.isEmpty()) {
                        if (this.isPointContainedWithinPlanes(min, max, this.v1)) {
                            if (!this.isPointContainedWithinPlanes(min, max, this.v2)) {
                                this.v2 = (Vec3d)points.elementAt(0);
                            }
                        } else if (this.isPointContainedWithinPlanes(min, max, this.v2)) {
                            this.v1 = (Vec3d)points.elementAt(0);
                        } else {
                            this.v1 = (Vec3d)points.elementAt(0);
                            this.v2 = (Vec3d)points.elementAt(1);
                        }
                        this.projectToPlaneAndDraw(channel, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                    } else if (this.isPointContainedWithinPlanes(min, max, this.v1) && this.isPointContainedWithinPlanes(min, max, this.v2)) {
                        this.projectToPlaneAndDraw(channel, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                    }
                }
            }
        }
    }

    protected boolean isPointContainedInLine(Vec3d lineMin, Vec3d lineMax, Vec3d pnt) {
        double SMALL_VALUE = 1.0E-6;
        boolean contained = false;
        Vec3d t = new Vec3d();
        double denom = lineMax.x - lineMin.x;
        if (denom > 0.0) {
            t.x = (pnt.x - lineMin.x) / denom;
        }
        if ((denom = lineMax.y - lineMin.y) > 0.0) {
            t.y = (pnt.y - lineMin.y) / denom;
        }
        if ((denom = lineMax.z - lineMin.z) > 0.0) {
            t.z = (pnt.z - lineMin.z) / denom;
        }
        if (t.x >= 0.0 - SMALL_VALUE && t.x <= 1.0 + SMALL_VALUE && t.y >= 0.0 - SMALL_VALUE && t.y <= 1.0 + SMALL_VALUE && t.z >= 0.0 - SMALL_VALUE && t.z <= 1.0 + SMALL_VALUE) {
            contained = true;
        }
        return contained;
    }

    protected boolean isPointContainedWithinPlanes(Vec3d min, Vec3d max, Vec3d pt) {
        boolean contained = false;
        double SMALL_VALUE = 1.0E-6;
        if (this.fillToPlane.isParallelTo(Plane.XY)) {
            if (pt.x >= min.x - SMALL_VALUE && pt.x <= max.x + SMALL_VALUE && pt.y >= min.y - SMALL_VALUE && pt.y <= max.y + SMALL_VALUE) {
                contained = true;
            }
        } else if (this.fillToPlane.isParallelTo(Plane.YZ)) {
            if (pt.y >= min.y - SMALL_VALUE && pt.y <= max.y + SMALL_VALUE && pt.z >= min.z - SMALL_VALUE && pt.z <= max.z + SMALL_VALUE) {
                contained = true;
            }
        } else if (this.fillToPlane.isParallelTo(Plane.ZX) && pt.x >= min.x - SMALL_VALUE && pt.x <= max.x + SMALL_VALUE && pt.z >= min.z - SMALL_VALUE && pt.z <= max.z + SMALL_VALUE) {
            contained = true;
        }
        return contained;
    }

    protected Vec3d[] modifyIntersectingValues(Vector points, Vec3d v, Vec3d newv) {
        Vec3d[] pt = new Vec3d[2];
        int count = points.size();
        if (count == 1) {
            newv = (Vec3d)points.elementAt(0);
        } else if (count == 2) {
            double d1 = v.getDistance((Vec3d)points.elementAt(0));
            double d2 = v.getDistance((Vec3d)points.elementAt(1));
            if (d2 >= d1) {
                newv = (Vec3d)points.elementAt(1);
                v = (Vec3d)points.elementAt(0);
            } else {
                newv = (Vec3d)points.elementAt(0);
                v = (Vec3d)points.elementAt(1);
            }
        } else if (count == 3) {
            double d1 = v.getDistance((Vec3d)points.elementAt(0));
            double d2 = v.getDistance((Vec3d)points.elementAt(1));
            double d3 = v.getDistance((Vec3d)points.elementAt(2));
            if (d1 >= d2) {
                if (d1 >= d3) {
                    if (d2 >= d3) {
                        newv = (Vec3d)points.elementAt(0);
                        v = (Vec3d)points.elementAt(1);
                    } else {
                        newv = (Vec3d)points.elementAt(0);
                        v = (Vec3d)points.elementAt(2);
                    }
                } else {
                    newv = (Vec3d)points.elementAt(2);
                    v = (Vec3d)points.elementAt(0);
                }
            } else if (d2 >= d3) {
                if (d1 >= d3) {
                    newv = (Vec3d)points.elementAt(1);
                    v = (Vec3d)points.elementAt(0);
                } else {
                    newv = (Vec3d)points.elementAt(1);
                    v = (Vec3d)points.elementAt(2);
                }
            } else {
                newv = (Vec3d)points.elementAt(2);
                v = (Vec3d)points.elementAt(1);
            }
        }
        pt[0] = newv;
        pt[1] = v;
        return pt;
    }

    protected double modifyV(double v, double min, double max) {
        if (!this.fillBoundingBox.isEmpty()) {
            if (v > max && this.fillToPlane.distance < max) {
                return max;
            }
            if (v < min && this.fillToPlane.distance > min) {
                return min;
            }
        }
        return v;
    }

    protected void projectToPlaneAndDraw(Channel channel, Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, Vec3d newv1, Vec3d newv2, Vec3d newv3, Vec3d newv4) {
        boolean splitForSpec;
        Color specColor;
        block52: {
            int firstIndex = this.getFirstIndex();
            boolean slo = false;
            double specHigh = 0.0;
            double specLow = 0.0;
            specColor = null;
            Color fc = null;
            splitForSpec = false;
            this.isSpecLimitLower = false;
            this.isSpecLimitUpper = false;
            if (this.fillToPlane.isParallelTo(Plane.XY)) {
                v1.z = this.modifyV(v1.z, this.minBBox.z, this.maxBBox.z);
                v2.z = this.modifyV(v2.z, this.minBBox.z, this.maxBBox.z);
                v3.x = v2.x;
                v3.y = v2.y;
                v3.z = !this.fillBoundingBox.isEmpty() ? Math.max(Math.min(this.fillToPlane.distance, this.maxBBox.z), this.minBBox.z) : this.fillToPlane.distance;
                v4.x = v1.x;
                v4.y = v1.y;
                v4.z = v3.z;
                if (this.makeNewv2) {
                    newv2.z = this.modifyV(newv2.z, this.minBBox.z, this.maxBBox.z);
                    newv3.x = newv2.x;
                    newv3.y = newv2.y;
                    newv3.z = v3.z;
                }
                if (this.makeNewv1) {
                    newv1.z = this.modifyV(newv1.z, this.minBBox.z, this.maxBBox.z);
                    newv4.x = newv1.x;
                    newv4.y = newv1.y;
                    newv4.z = v4.z;
                }
            } else if (this.fillToPlane.isParallelTo(Plane.YZ)) {
                v1.x = this.modifyV(v1.x, this.minBBox.x, this.maxBBox.x);
                v2.x = this.modifyV(v2.x, this.minBBox.x, this.maxBBox.x);
                v3.x = !this.fillBoundingBox.isEmpty() ? Math.max(Math.min(this.fillToPlane.distance, this.maxBBox.x), this.minBBox.x) : this.fillToPlane.distance;
                v3.y = v2.y;
                v3.z = v2.z;
                v4.x = v3.x;
                v4.y = v1.y;
                v4.z = v1.z;
                if (this.makeNewv2) {
                    newv2.x = this.modifyV(newv2.x, this.minBBox.x, this.maxBBox.x);
                    newv3.x = v3.x;
                    newv3.y = newv2.y;
                    newv3.z = newv2.z;
                }
                if (this.makeNewv1) {
                    newv1.x = this.modifyV(newv1.x, this.minBBox.x, this.maxBBox.x);
                    newv4.x = v4.x;
                    newv4.y = newv1.y;
                    newv4.z = newv1.z;
                }
                try {
                    double specXIntercept;
                    double slope;
                    slo = this.specificationLimitsOn.getValue(firstIndex);
                    if (!slo) break block52;
                    specHigh = this.specificationLimitHigh.getValue(firstIndex);
                    specLow = this.specificationLimitLow.getValue(firstIndex);
                    fc = this.fillColor.getValue(firstIndex);
                    if (specHigh < v1.y) {
                        this.isSpecLimitUpper = true;
                        specColor = this.specificationLimitAboveHighColor.getValue(firstIndex);
                        if (specHigh > v2.y) {
                            slope = (v2.x - v1.x) / (v2.y - v1.y);
                            specXIntercept = v1.x + (specHigh - v1.y) * slope;
                            splitForSpec = true;
                            this.specv1.set(v1);
                            this.specv2.set(v2);
                            this.specv3.set(v3);
                            this.specv4.set(v4);
                            this.specv2.y = specHigh;
                            this.specv3.y = specHigh;
                            this.specv2.x = specXIntercept;
                            v1.y = specHigh;
                            v4.y = specHigh;
                            v1.x = specXIntercept;
                        }
                    }
                    if (specLow > v2.y) {
                        this.isSpecLimitLower = true;
                        specColor = this.specificationLimitBelowLowColor.getValue(firstIndex);
                        if (specLow < v2.y) {
                            slope = (v2.x - v1.x) / (v2.y - v1.y);
                            specXIntercept = v1.x + (specLow - v1.y) * slope;
                            splitForSpec = true;
                            this.specv1.set(v1);
                            this.specv2.set(v2);
                            this.specv3.set(v3);
                            this.specv4.set(v4);
                            this.specv2.y = specLow;
                            this.specv3.y = specLow;
                            this.specv2.x = specXIntercept;
                            v1.y = specLow;
                            v4.y = specLow;
                            v1.x = specXIntercept;
                        }
                    }
                }
                catch (MissingValueException slope) {}
            } else if (this.fillToPlane.isParallelTo(Plane.ZX)) {
                v1.y = this.modifyV(v1.y, this.minBBox.y, this.maxBBox.y);
                v2.y = this.modifyV(v2.y, this.minBBox.y, this.maxBBox.y);
                v3.x = v2.x;
                if (!this.fillBoundingBox.isEmpty()) {
                    v3.y = Math.max(Math.min(this.fillToPlane.distance, this.maxBBox.y), this.minBBox.y);
                } else {
                    v3.y = this.fillToPlane.distance;
                    v3.y -= this.getWorldCoordinatePixelHeight(channel);
                }
                v3.z = v2.z;
                v4.x = v1.x;
                v4.y = v3.y;
                v4.z = v1.z;
                if (this.makeNewv2) {
                    newv2.y = this.modifyV(newv2.y, this.minBBox.y, this.maxBBox.y);
                    newv3.x = newv2.x;
                    newv3.y = v3.y;
                    newv3.z = newv2.z;
                }
                if (this.makeNewv1) {
                    newv1.y = this.modifyV(newv1.y, this.minBBox.y, this.maxBBox.y);
                    newv4.x = newv1.x;
                    newv4.y = v4.y;
                    newv4.z = newv1.z;
                }
                try {
                    slo = this.specificationLimitsOn.getValue(firstIndex);
                    if (slo) {
                        double specYIntercept;
                        double slope;
                        specHigh = this.specificationLimitHigh.getValue(firstIndex);
                        specLow = this.specificationLimitLow.getValue(firstIndex);
                        fc = this.fillColor.getValue(firstIndex);
                        if (specHigh < v2.x) {
                            this.isSpecLimitUpper = true;
                            specColor = this.specificationLimitAboveHighColor.getValue(firstIndex);
                            if (specHigh > v1.x) {
                                slope = (v2.y - v1.y) / (v2.x - v1.x);
                                specYIntercept = v1.y + (specHigh - v1.x) * slope;
                                splitForSpec = true;
                                this.specv1.set(v1);
                                this.specv2.set(v2);
                                this.specv3.set(v3);
                                this.specv4.set(v4);
                                this.specv1.x = specHigh;
                                this.specv4.x = specHigh;
                                this.specv1.y = specYIntercept;
                                v2.x = specHigh;
                                v3.x = specHigh;
                                v2.y = specYIntercept;
                            }
                        }
                        if (specLow > v1.x) {
                            this.isSpecLimitLower = true;
                            specColor = this.specificationLimitBelowLowColor.getValue(firstIndex);
                            if (specLow < v2.x) {
                                slope = (v2.y - v1.y) / (v2.x - v1.x);
                                specYIntercept = v1.y + (specLow - v1.x) * slope;
                                splitForSpec = true;
                                this.specv1.set(v1);
                                this.specv2.set(v2);
                                this.specv3.set(v3);
                                this.specv4.set(v4);
                                this.specv2.x = specLow;
                                this.specv3.x = specLow;
                                this.specv2.y = specYIntercept;
                                v1.x = specLow;
                                v4.x = specLow;
                                v1.y = specYIntercept;
                            }
                        }
                    }
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
        if (this.makeNewv1 || this.makeNewv2) {
            if (!this.renderSpecLimit) {
                if (this.makeNewv1) {
                    if (this.subpixelRendering) {
                        this.addVertices(v1, newv1, newv4, v4);
                        this.addVertices(newv1, v2, v3, newv4);
                    } else {
                        this.drawArea(channel, v1, newv1, newv4, v4);
                        this.drawArea(channel, newv1, v2, v3, newv4);
                    }
                } else if (this.makeNewv2) {
                    if (this.subpixelRendering) {
                        this.addVertices(v1, newv2, newv3, v4);
                        this.addVertices(newv2, v2, v3, newv3);
                    } else {
                        this.drawArea(channel, v1, newv2, newv3, v4);
                        this.drawArea(channel, newv2, v2, v3, newv3);
                    }
                }
            }
        } else if (this.renderSpecLimit) {
            if (specColor != null) {
                channel.glColor(specColor);
                if (splitForSpec) {
                    if (this.subpixelRendering) {
                        this.addVertices(this.specv1, this.specv2, this.specv3, this.specv4);
                    } else {
                        this.drawArea(channel, this.specv1, this.specv2, this.specv3, this.specv4);
                    }
                } else if (this.subpixelRendering) {
                    this.addVertices(v1, v2, v3, v4);
                } else {
                    this.drawArea(channel, v1, v2, v3, v4);
                }
            }
        } else if (splitForSpec) {
            if (this.subpixelRendering) {
                this.addVertices(v1, v2, v3, v4);
            } else {
                this.drawArea(channel, v1, v2, v3, v4);
            }
        } else if (specColor == null) {
            if (this.subpixelRendering) {
                this.addVertices(v1, v2, v3, v4);
            } else {
                this.drawArea(channel, v1, v2, v3, v4);
            }
        }
    }

    private void addVertices(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4) {
        Vec3d v11 = new Vec3d(v1);
        Vec3d v22 = new Vec3d(v2);
        Vec3d v33 = new Vec3d(v3);
        Vec3d v44 = new Vec3d(v4);
        if (this.renderSpecLimit) {
            if (this.isSpecLimitLower) {
                this.specLimitLower.add(v11);
                this.specLimitLower.add(v22);
            } else if (this.isSpecLimitUpper) {
                this.specLimitUpper.add(v11);
                this.specLimitUpper.add(v22);
            }
        } else {
            this.middle.add(v11);
            this.middle.add(v22);
        }
    }

    protected void drawSegments(Channel channel) {
        int firstIndex = this.getFirstIndex();
        Vec3d v = null;
        double fillBase = 0.0;
        if (this.fillToPlane.isParallelTo(Plane.ZX)) {
            if (!this.fillBoundingBox.isEmpty()) {
                fillBase = Math.max(Math.min(this.fillToPlane.distance, this.maxBBox.y), this.minBBox.y);
            } else {
                fillBase = this.fillToPlane.distance;
                fillBase -= this.getWorldCoordinatePixelHeight(channel);
            }
        } else if (this.fillToPlane.isParallelTo(Plane.YZ)) {
            fillBase = !this.fillBoundingBox.isEmpty() ? Math.max(Math.min(this.fillToPlane.distance, this.maxBBox.x), this.minBBox.x) : this.fillToPlane.distance;
        }
        try {
            if (this.renderSpecLimit) {
                int i;
                Color specColor;
                if (this.specLimitLower != null && this.specLimitLower.size() > 0) {
                    specColor = this.specificationLimitBelowLowColor.getValue(firstIndex);
                    channel.glColor(specColor);
                    channel.glPolygonMode(3);
                    channel.glBegin(2);
                    for (i = 0; i < this.specLimitLower.size(); ++i) {
                        v = (Vec3d)this.specLimitLower.get(i);
                        channel.glVertex(v.x, v.y, v.z);
                    }
                    if (this.fillToPlane.isParallelTo(Plane.ZX)) {
                        channel.glVertex(v.x, fillBase, v.z);
                        channel.glVertex(((Vec3d)this.specLimitLower.get((int)0)).x, fillBase, v.z);
                    } else if (this.fillToPlane.isParallelTo(Plane.YZ)) {
                        channel.glVertex(fillBase, v.y, v.z);
                        channel.glVertex(fillBase, ((Vec3d)this.specLimitLower.get((int)0)).y, v.z);
                    }
                    channel.glEnd();
                }
                if (this.specLimitUpper != null && this.specLimitUpper.size() > 0) {
                    specColor = this.specificationLimitAboveHighColor.getValue(firstIndex);
                    channel.glColor(specColor);
                    channel.glPolygonMode(3);
                    channel.glBegin(2);
                    for (i = 0; i < this.specLimitUpper.size(); ++i) {
                        v = (Vec3d)this.specLimitUpper.get(i);
                        channel.glVertex(v.x, v.y, v.z);
                    }
                    if (this.fillToPlane.isParallelTo(Plane.ZX)) {
                        channel.glVertex(v.x, fillBase, v.z);
                        channel.glVertex(((Vec3d)this.specLimitUpper.get((int)0)).x, fillBase, v.z);
                    } else if (this.fillToPlane.isParallelTo(Plane.YZ)) {
                        channel.glVertex(fillBase, v.y, v.z);
                        channel.glVertex(fillBase, ((Vec3d)this.specLimitUpper.get((int)0)).y, v.z);
                    }
                    channel.glEnd();
                }
            } else if (this.middle != null && this.middle.size() > 0) {
                Color fc = this.fillColor.getValue(firstIndex);
                channel.glColor(fc);
                channel.glPolygonMode(3);
                channel.glBegin(2);
                for (int i = 0; i < this.middle.size(); ++i) {
                    v = (Vec3d)this.middle.get(i);
                    channel.glVertex(v.x, v.y, v.z);
                }
                if (this.fillToPlane.isParallelTo(Plane.ZX)) {
                    channel.glVertex(v.x, fillBase, v.z);
                    channel.glVertex(((Vec3d)this.middle.get((int)0)).x, fillBase, v.z);
                } else if (this.fillToPlane.isParallelTo(Plane.YZ)) {
                    channel.glVertex(fillBase, v.y, v.z);
                    channel.glVertex(fillBase, ((Vec3d)this.middle.get((int)0)).y, v.z);
                }
                channel.glEnd();
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    private double getWorldCoordinatePixelHeight(Channel channel) {
        double ph = 1.0;
        double[] world1 = new double[]{0.0, 0.0, 0.0};
        double[] world2 = new double[3];
        double[] p = new double[3];
        channel.gluProject(world1, p);
        p[0] = p[0] + 1.0;
        p[1] = p[1] + 1.0;
        channel.gluUnProject(p, world2);
        ph = Math.abs(world1[1] - world2[1]);
        return ph;
    }

    protected void drawArea(Channel channel, Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4) {
        if (this.fillBoundingBox.isEmpty() || this.fillBoundingBox.isPointContained(v1) && this.fillBoundingBox.isPointContained(v2) && this.fillBoundingBox.isPointContained(v3) && this.fillBoundingBox.isPointContained(v4)) {
            Vec3d edge1 = new Vec3d(v2.x - v1.x, v2.y - v1.y, v2.z - v1.z);
            Vec3d edge2 = new Vec3d(v4.x - v1.x, v4.y - v1.y, v4.z - v1.z);
            boolean positiveBegin = this.fillToPlane.isOnPositiveSide(v1);
            boolean positiveEnd = this.fillToPlane.isOnPositiveSide(v2);
            int drawMode = 2;
            if (this.depth.length() > 0.0) {
                drawMode = 3;
            }
            if (positiveBegin && positiveEnd) {
                if (!this.reverseAreaNormal) {
                    edge2.cross(edge1);
                    this.drawTrapezoid(channel, drawMode, edge2, v1, v2, v3, v4);
                } else {
                    edge1.cross(edge2);
                    this.drawTrapezoid(channel, drawMode, edge1, v4, v3, v2, v1);
                }
            } else if (!positiveBegin && !positiveEnd) {
                if (!this.reverseAreaNormal) {
                    edge1.cross(edge2);
                    this.drawTrapezoid(channel, drawMode, edge1, v1, v2, v3, v4);
                } else {
                    edge2.cross(edge1);
                    this.drawTrapezoid(channel, drawMode, edge2, v4, v3, v2, v1);
                }
            } else {
                Vec3d intersectionPoint = new Vec3d();
                intersectionPoint = this.fillToPlane.getPointOfIntersection(v1, v2);
                if (!this.reverseAreaNormal) {
                    if (positiveBegin) {
                        edge2.cross(edge1);
                        this.drawTrapezoid(channel, drawMode, edge2, v1, intersectionPoint, intersectionPoint, v4);
                        this.drawTrapezoid(channel, drawMode, edge2, intersectionPoint, v2, v3, intersectionPoint);
                    } else {
                        edge1.cross(edge2);
                        this.drawTrapezoid(channel, drawMode, edge1, v4, intersectionPoint, intersectionPoint, v1);
                        this.drawTrapezoid(channel, drawMode, edge1, intersectionPoint, v3, v2, intersectionPoint);
                    }
                } else if (positiveBegin) {
                    edge1.cross(edge2);
                    this.drawTrapezoid(channel, drawMode, edge1, v4, intersectionPoint, intersectionPoint, v1);
                    this.drawTrapezoid(channel, drawMode, edge1, intersectionPoint, v3, v2, intersectionPoint);
                } else {
                    edge2.cross(edge1);
                    this.drawTrapezoid(channel, drawMode, edge2, v1, intersectionPoint, intersectionPoint, v4);
                    this.drawTrapezoid(channel, drawMode, edge2, intersectionPoint, v2, v3, intersectionPoint);
                }
            }
        }
    }

    public static Plane[] getPlanesOfBoundingBox(BoundingBox bbox) {
        Plane[] planes = new Plane[6];
        Vec3d min = bbox.getMinimum();
        Vec3d max = bbox.getMaximum();
        planes[0] = new Plane(1.0, 0.0, 0.0, min.x);
        planes[1] = new Plane(0.0, 0.0, 1.0, max.z);
        planes[2] = new Plane(1.0, 0.0, 0.0, max.x);
        planes[3] = new Plane(0.0, 0.0, 1.0, min.z);
        planes[4] = new Plane(0.0, 1.0, 0.0, max.y);
        planes[5] = new Plane(0.0, 1.0, 0.0, min.y);
        return planes;
    }

    public static Vector getPointsOfIntersection(BoundingBox bbox, Vec3d beginLine, Vec3d endLine) {
        Vector<Vec3d> points = new Vector<Vec3d>(2, 2);
        Plane[] planes = FilledLineConnector.getPlanesOfBoundingBox(bbox);
        Vec3d point = new Vec3d();
        for (int i = 0; i < planes.length; ++i) {
            boolean positiveBegin = planes[i].isOnPositiveSide(beginLine);
            boolean positiveEnd = planes[i].isOnPositiveSide(endLine);
            if ((!positiveBegin || positiveEnd) && (positiveBegin || !positiveEnd)) continue;
            point = planes[i].getPointOfIntersection(beginLine, endLine);
            points.addElement(new Vec3d(point.x, point.y, point.z));
        }
        return points;
    }

    public static Vec3d getInternalPoint(BoundingBox bbox, Vec3d beginLine, Vec3d endLine) {
        int count = 0;
        Vec3d point = new Vec3d();
        Vector allPoints = new Vector(2, 2);
        Vec3d[] twoPoints = new Vec3d[2];
        allPoints = FilledLineConnector.getPointsOfIntersection(bbox, beginLine, endLine);
        for (int i = 0; i < allPoints.size(); ++i) {
            point = (Vec3d)allPoints.elementAt(i);
            if (!bbox.isPointContained(point)) continue;
            twoPoints[count] = point;
            ++count;
        }
        if (twoPoints[0] != null && twoPoints[1] != null) {
            point.x = (twoPoints[0].x + twoPoints[1].x) / 2.0;
            point.y = (twoPoints[0].y + twoPoints[1].y) / 2.0;
            point.z = (twoPoints[0].z + twoPoints[1].z) / 2.0;
        } else {
            point = null;
        }
        return point;
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        Vector v;
        if (this.multipleGroup) {
            this.renderMultipleGroups(buildAction);
            return;
        }
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int index = ba.getValueIndex();
        try {
            double w = this.lineWidth.getValue(index);
            this.v5.x = this.pointX.getValue(index);
            this.v5.y = this.pointY.getValue(index);
            this.v5.z = this.pointZ.getValue(index);
            this.color.getValue(index);
            this.fillColor.getValue(index);
            boolean fill = this.fillOn.getValue(index);
            if (ba.isUseNameStack()) {
                this.drawSelectableGeometry(channel, index, fill, w, this.v5);
            }
        }
        catch (MissingValueException e) {
            if (this.skipMissing) {
                ++this.current;
            }
            throw e;
        }
        if (this.current > this.renderIndices.size() - 1) {
            for (int i = this.renderIndices.size(); i < this.current + 1; ++i) {
                this.renderIndices.addElement(new Vector());
            }
            v = (Vector)this.renderIndices.elementAt(this.current);
        } else {
            v = (Vector)this.renderIndices.elementAt(this.current);
            if (v == null) {
                v = new Vector();
                this.renderIndices.setElementAt(v, this.current);
            }
        }
        v.addElement(new Integer(index));
    }

    protected void renderMultipleGroups(ABuildAction buildAction) {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        boolean subpixel = channel.isSubpixelRendering();
        if (!subpixel && this.isSubpixelRendering()) {
            channel.setSubpixelRendering(this.isSubpixelRendering());
        }
        this.updateHighlight();
        Collection groups = this.perGroupPolylines.values();
        Iterator iter = groups.iterator();
        boolean lo = this.lineOn.getValue();
        boolean fo = this.fillOn.getValue();
        boolean mo = this.markerOn.getValue();
        boolean dlto = this.dataLabelTopOn.getValue();
        boolean dlbo = this.dataLabelBottomOn.getValue();
        boolean slo = this.specificationLimitsOn.getValue();
        channel.glPushAttrib(0);
        while (iter.hasNext()) {
            this.currentGroup = (PolylineGroup)iter.next();
            this.renderIndices = this.currentGroup.getPolylines();
            if (fo) {
                if (this.subpixelRendering && !ba.isUseNameStack()) {
                    this.middle = new ArrayList();
                }
                this.currentGroup.setFillAttributes(channel);
                this.renderPolylineGroup(buildAction, this.currentGroup, true);
            }
            if (slo) {
                if (this.subpixelRendering && !ba.isUseNameStack()) {
                    this.specLimitLower = new ArrayList();
                    this.specLimitUpper = new ArrayList();
                }
                this.renderSpecLimit = true;
                this.currentGroup.setFillAttributes(channel);
                this.renderPolylineGroup(buildAction, this.currentGroup, true);
                this.renderSpecLimit = false;
            }
            if (lo) {
                this.startArrow = this.currentGroup.isStartArrowOn();
                this.endArrow = this.currentGroup.isEndArrowOn();
                this.arrowShape = this.currentGroup.getArrowHeadShape();
                this.arrowScale = this.currentGroup.getArrowHeadScale();
                this.currentGroup.setDrawAttributes(channel);
                this.renderPolylineGroup(buildAction, this.currentGroup, false);
                channel.glSkinType(0);
                channel.lineCapStyle(0);
                channel.setLineJoinStyle(1);
            }
            if (mo) {
                this.renderMarkers(buildAction, this.currentGroup);
            }
            if (!dlbo && !dlto) continue;
            this.renderDataLabels(buildAction, this.currentGroup, dlbo, dlto, mo);
        }
        channel.glPopAttrib();
        channel.setSubpixelRendering(subpixel);
    }

    private void renderMarkers(ABuildAction buildAction, PolylineGroup group) {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int polyLineCount = group.getPolylineCount();
        if (polyLineCount <= 0) {
            return;
        }
        for (int i = 0; i < polyLineCount; ++i) {
            Vector line = group.getPolyline(i);
            if (line == null) continue;
            int vertexCount = line.size();
            for (int j = 0; j < vertexCount; ++j) {
                try {
                    int valueIndex = (Integer)line.elementAt(j);
                    this.v1.x = this.pointX.getValue(valueIndex);
                    this.v1.y = this.pointY.getValue(valueIndex);
                    this.v1.z = this.pointZ.getValue(valueIndex);
                    int size = this.markerSize.getValue(valueIndex);
                    Color c = this.markerColor.getValue(valueIndex);
                    Color ec = this.markerEdgeColor.getValue(valueIndex);
                    int type = this.markerType.getValue(valueIndex);
                    channel.setMarkerSize(size);
                    channel.setMarkerType(type);
                    channel.glDisable(28);
                    channel.glColor(c);
                    channel.glEdgeColor(ec);
                    channel.glLineWidth(1.0f);
                    channel.glMarker(this.v1.x, this.v1.y, this.v1.z);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
    }

    private void renderDataLabels(ABuildAction buildAction, PolylineGroup group, boolean dlto, boolean dlbo, boolean mo) {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int polyLineCount = group.getPolylineCount();
        if (polyLineCount <= 0) {
            return;
        }
        Vec3d topLabelPosition = new Vec3d();
        Vec3d bottomLabelPosition = new Vec3d();
        channel.glSelect2DFont(this.dataLabelFont);
        for (int i = 0; i < polyLineCount; ++i) {
            Vector line = group.getPolyline(i);
            if (line == null) continue;
            int vertexCount = line.size();
            for (int j = 0; j < vertexCount; ++j) {
                try {
                    String s;
                    int valueIndex = (Integer)line.elementAt(j);
                    this.v1.x = this.pointX.getValue(valueIndex);
                    this.v1.y = this.pointY.getValue(valueIndex);
                    this.v1.z = this.pointZ.getValue(valueIndex);
                    if (mo) {
                        int ms = this.markerSize.getValue(valueIndex);
                        double[] obj = new double[3];
                        double[] objTemp = new double[3];
                        double[] win = new double[3];
                        obj[0] = this.v1.x;
                        obj[1] = this.v1.y;
                        obj[2] = this.v1.z;
                        channel.gluProject(obj, win);
                        win[1] = win[1] - (double)(ms / 2);
                        channel.gluUnProject(win, objTemp);
                        topLabelPosition.x = objTemp[0];
                        topLabelPosition.y = objTemp[1];
                        topLabelPosition.z = objTemp[2];
                        win[1] = win[1] + ((double)(ms / 2) + (double)ms / 2.0);
                        channel.gluUnProject(win, objTemp);
                        bottomLabelPosition.x = objTemp[0];
                        bottomLabelPosition.y = objTemp[1];
                        bottomLabelPosition.z = objTemp[2];
                    } else {
                        topLabelPosition.set(this.v1);
                        bottomLabelPosition.set(this.v1);
                    }
                    Color c = this.dataLabelColor.getValue(valueIndex);
                    channel.glColor(c);
                    int hj = this.dataLabelHorizontalJustification.getValue(valueIndex);
                    boolean to = this.dataLabelTrimOn.getValue(0);
                    if (dlto) {
                        s = this.dataLabelTop.getValue(valueIndex);
                        if (to) {
                            s = s.trim();
                        }
                        channel.glAlignment(hj, 3);
                        channel.gl2DText(s, topLabelPosition.x, topLabelPosition.y, topLabelPosition.z);
                    }
                    if (!dlbo) continue;
                    s = this.dataLabelBottom.getValue(valueIndex);
                    if (to) {
                        s = s.trim();
                    }
                    channel.glAlignment(hj, 0);
                    channel.gl2DText(s, bottomLabelPosition.x, bottomLabelPosition.y, bottomLabelPosition.z);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
    }

    private void updateHighlight() {
        Collection groups = this.perGroupPolylines.values();
        for (PolylineGroup group : groups) {
            group.setHighlightOn(false);
        }
        for (int i = 0; i < this.myValueCount; ++i) {
            PolylineGroup group;
            Object key = this.getGroupKey(i);
            if (key == null) continue;
            group = (PolylineGroup)this.perGroupPolylines.get(key);
            try {
                boolean ho = this.highlightOn.getValue(i);
                group.setHighlightOn(ho | group.isHighlightOn());
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    protected void renderPolylineGroup(ABuildAction buildAction, PolylineGroup group, boolean fo) {
    }

    protected void drawSelectableGeometry(Channel channel, int i, boolean fill, double w, Vec3d pnt) {
        this.drawIntersections(channel, w, pnt);
    }

    protected void drawIntersections(Channel channel, double w, Vec3d pnt) {
        if (w < 3.0) {
            w = 3.0;
        }
        channel.setMarkerSize((int)w);
        channel.setMarkerType(3);
        channel.glBegin(4);
        channel.glVertex(pnt.x, pnt.y, pnt.z);
        channel.glEnd();
    }

    protected void drawTrapezoid(Channel channel, int drawMode, Vec3d normal, Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4) {
        if (this.depth.length() > 0.0) {
            Vec3d centerTweak = new Vec3d(this.getDepth());
            centerTweak.scale(-0.5);
            v1.add(centerTweak);
            v2.add(centerTweak);
            v3.add(centerTweak);
            v4.add(centerTweak);
        }
        boolean isFill = false;
        boolean isHighlightOn = false;
        Color ec = Color.BLACK;
        int firstIndex = this.getFirstIndex();
        try {
            isFill = this.fillOn.getValue(firstIndex);
            isHighlightOn = this.highlightOn.getValue(firstIndex);
            if (isHighlightOn) {
                ec = this.highlightColor.getValue(firstIndex);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        if (drawMode == 3 && isFill) {
            channel.setExtrusionVector(this.depth.x, this.depth.y, this.depth.z);
        } else {
            channel.setExtrusionVector(0.0, 0.0, 0.0);
        }
        if (isHighlightOn) {
            channel.glPolygonMode(6);
            channel.glEdgeColor(ec);
        } else {
            channel.glPolygonMode(3);
        }
        channel.glBegin(drawMode);
        channel.glNormal(normal.x, normal.y, normal.z);
        channel.glVertex(v1.x, v1.y, v1.z);
        channel.glVertex(v2.x, v2.y, v2.z);
        channel.glVertex(v3.x, v3.y, v3.z);
        channel.glVertex(v4.x, v4.y, v4.z);
        channel.glVertex(v1.x, v1.y, v1.z);
        channel.glEnd();
    }

    protected void drawArrow(Channel channel, Vec3d arrowV1, Vec3d arrowV2) {
        Vec3d X_AXIS = Vec3d.getXAxis();
        Vec3d diff = new Vec3d();
        diff.set(arrowV2);
        diff.subtract(arrowV1);
        double length = diff.length();
        double angle = length < MY_ZERO ? 0.0 : diff.angle(X_AXIS) * 57.29577951308232;
        Vec3d axisOfRotation = new Vec3d();
        if (Math.abs(angle - 180.0) < MY_ZERO) {
            axisOfRotation.set(0.0, 0.0, 1.0);
        } else {
            axisOfRotation.set(X_AXIS);
            axisOfRotation.cross(diff);
        }
        double lw = this.currentGroup.getLineWidth();
        int arrowShape = this.currentGroup.getArrowHeadShape();
        double arrowScale = this.currentGroup.getArrowHeadScale();
        double size = FilledLineConnector.getArrowSize(lw, this.DPIScaleFactor, arrowShape) * arrowScale;
        double h = size * Math.sin(1.0471975511965976);
        double miterLength = this.getArrowMiterLength(lw);
        double[] p2w = this.pixel2World(channel);
        h *= p2w[0];
        miterLength *= p2w[0];
        double w2 = Math.floor(((size *= p2w[1]) + 1.0) * 0.5);
        channel.glDisable(6);
        channel.glPushMatrix();
        channel.glTranslate(arrowV1.x, arrowV1.y, arrowV1.z);
        channel.glRotate(angle, axisOfRotation.x, axisOfRotation.y, axisOfRotation.z);
        switch (arrowShape) {
            case 0: {
                if (lw >= 2.0) {
                    channel.glLineWidth((float)(0.67 * lw));
                }
                channel.glBegin(1);
                channel.glVertex((length -= miterLength) - h, -w2);
                channel.glVertex(length, 0.0);
                channel.glVertex(length - h, w2);
                channel.glEnd();
                if (!(lw >= 2.0)) break;
                channel.glLineWidth((float)lw);
                break;
            }
            case 2: {
                channel.glBegin(2);
                channel.glPolygonMode(3);
                channel.glVertex(length - h, -w2);
                channel.glVertex(length, 0.0);
                channel.glVertex(length - h, w2);
                channel.glVertex(length - h * 0.66, 0.0);
                channel.glVertex(length - h, -w2);
                channel.glEnd();
                break;
            }
            case 1: {
                channel.glBegin(2);
                channel.glPolygonMode(3);
                channel.glVertex(length - h, -w2);
                channel.glVertex(length, 0.0);
                channel.glVertex(length - h, w2);
                channel.glVertex(length - h, -w2);
                channel.glEnd();
            }
        }
        channel.glPopMatrix();
        channel.glEnable(6);
    }

    protected double getArrowMiterLength(double lw) {
        if (lw < 2.0) {
            return 0.0;
        }
        return 0.67 * lw - 1.0;
    }

    public static double getArrowSize(double lw, double DPIScaleFactor, int shape) {
        if ((lw = (double)Math.round(lw / DPIScaleFactor)) < 2.0) {
            lw = 2.0;
        }
        double size = shape == 0 ? lw + 2.0 * (0.67 * lw / 1.732 + 2.0) : lw + 2.0 * (lw / 1.732 + 2.0);
        if (shape == 2) {
            size *= 1.125;
        }
        return size *= DPIScaleFactor;
    }

    protected double getArrowSizeAdjustment(Channel channel, double lw, int shape, double scale) {
        if (lw < 2.0) {
            return 0.0;
        }
        double[] p2w = this.pixel2World(channel);
        switch (shape) {
            case 0: {
                return 2.0 * this.getArrowMiterLength(lw) * p2w[0];
            }
            case 1: 
            case 2: {
                return 0.5 * FilledLineConnector.getArrowSize(lw, this.DPIScaleFactor, shape) * scale * Math.sin(1.0471975511965976) * p2w[0];
            }
        }
        return 0.0;
    }

    protected double[] pixel2World(Channel channel) {
        double[] s = new double[3];
        double[] d1 = new double[3];
        double[] d2 = new double[3];
        s[2] = 0.0;
        s[1] = 0.0;
        s[0] = 0.0;
        channel.gluUnProject(s, d1);
        s[1] = 1.0;
        s[0] = 1.0;
        channel.gluUnProject(s, d2);
        return new double[]{Math.abs(d2[0] - d1[0]), Math.abs(d2[1] - d1[1])};
    }

    protected double getAngle(Vec3d v1, Vec3d v2) {
        Vec3d X_AXIS = Vec3d.getXAxis();
        Vec3d diff = new Vec3d();
        diff.set(v2);
        diff.subtract(v1);
        if (diff.length() < MY_ZERO) {
            return 0.0;
        }
        return diff.angle(X_AXIS);
    }

    protected Vec3d adjustStartPoint(Vec3d v) {
        if (this.adjX != 0.0) {
            v.x = this.arrowV2.x > this.arrowV1.x ? (v.x -= this.adjX) : (v.x += this.adjX);
        }
        if (this.adjY != 0.0) {
            v.y = this.arrowV2.y > this.arrowV1.y ? (v.y -= this.adjY) : (v.y += this.adjY);
        }
        return v;
    }

    protected Vec3d adjustEndPoint(Vec3d v) {
        if (this.adjXend != 0.0) {
            v.x = this.arrowV2end.x > this.arrowV1end.x ? (v.x -= this.adjXend) : (v.x += this.adjXend);
        }
        if (this.adjYend != 0.0) {
            v.y = this.arrowV2end.y > this.arrowV1end.y ? (v.y -= this.adjYend) : (v.y += this.adjYend);
        }
        return v;
    }

    protected double[] adjustStartPoint(double x, double y, double z) {
        if (this.adjX != 0.0) {
            x = this.arrowV2.x > this.arrowV1.x ? (x -= this.adjX) : (x += this.adjX);
        }
        if (this.adjY != 0.0) {
            y = this.arrowV2.y > this.arrowV1.y ? (y -= this.adjY) : (y += this.adjY);
        }
        return new double[]{x, y, z};
    }

    protected double[] adjustEndPoint(double x, double y, double z) {
        if (this.adjXend != 0.0) {
            x = this.arrowV2end.x > this.arrowV1end.x ? (x -= this.adjXend) : (x += this.adjXend);
        }
        if (this.adjYend != 0.0) {
            y = this.arrowV2end.y > this.arrowV1end.y ? (y -= this.adjYend) : (y += this.adjYend);
        }
        return new double[]{x, y, z};
    }

    protected boolean adjustStartArrow(Channel channel) {
        this.adjX = 0.0;
        this.adjY = 0.0;
        if (this.arrowV1 != null && this.arrowV2 != null) {
            double sizeAdj = this.getArrowSizeAdjustment(channel, this.currentGroup.getLineWidth(), this.arrowShape, this.arrowScale);
            if (sizeAdj > 0.0) {
                Vec3d diff = new Vec3d();
                diff.set(this.arrowV2);
                diff.subtract(this.arrowV1);
                sizeAdj = Math.min(sizeAdj, diff.length());
                double angle = this.getAngle(this.arrowV1, this.arrowV2);
                this.adjX = Math.abs(sizeAdj * Math.cos(angle));
                this.adjY = Math.abs(sizeAdj * Math.sin(angle));
            }
            return true;
        }
        return false;
    }

    protected boolean adjustEndArrow(Channel channel) {
        this.adjXend = 0.0;
        this.adjYend = 0.0;
        if (this.arrowV1end != null && this.arrowV2end != null) {
            double sizeAdj = this.getArrowSizeAdjustment(channel, this.currentGroup.getLineWidth(), this.arrowShape, this.arrowScale);
            if (sizeAdj > 0.0) {
                Vec3d diff = new Vec3d();
                diff.set(this.arrowV2end);
                diff.subtract(this.arrowV1end);
                sizeAdj = Math.min(sizeAdj, diff.length());
                double angle = this.getAngle(this.arrowV1end, this.arrowV2end);
                this.adjXend = Math.abs(sizeAdj * Math.cos(angle));
                this.adjYend = Math.abs(sizeAdj * Math.sin(angle));
            }
            return true;
        }
        return false;
    }

    protected int getFirstIndex() {
        int result = 0;
        for (int i = 0; i < this.renderIndices.size(); ++i) {
            Vector v = (Vector)this.renderIndices.elementAt(i);
            int j = 0;
            if (v == null || j >= v.size()) continue;
            return (Integer)v.elementAt(j);
        }
        return result;
    }

    protected void resetRenderIndices() {
        if (this.multipleGroup) {
            return;
        }
        this.renderIndices.removeAllElements();
        this.current = 0;
    }

    protected Vector getCurrentPolyline() {
        Vector result = null;
        if (this.renderIndices.size() > this.current) {
            result = (Vector)this.renderIndices.elementAt(this.current);
        }
        return result;
    }

    protected void replaceObservation(Channel channel, int index) {
        channel.glPopName();
        channel.glPopName();
        channel.glPushName((Object)this.buildSelectEntry(index));
        if (channel.isSVGSelectionMode()) {
            channel.setSVGSelectionText(this.userDataToString(index));
        }
        channel.glPushName(null);
    }

    @Override
    public void reset(AResetAction resetAction) {
        if (this.multipleGroup) {
            return;
        }
        super.reset(resetAction);
        this.sortIndices();
    }

    @Override
    public SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        LineConnectorDetail detail;
        if (!this.multipleGroup) {
            return super.getSelectDetail(rawDetail, startIndex);
        }
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        Double interpolationPercent = new Double(1.0);
        if (entryLength == 4) {
            int lineGroupIndex = startIndex + entryLength - 2;
            Vector lineGroup = (Vector)nameStack.elementAt(lineGroupIndex);
            int interpolationIndex = lineGroupIndex + 1;
            interpolationPercent = (Double)nameStack.elementAt(interpolationIndex);
            detail = new LineConnectorDetail(lineGroup, interpolationPercent);
        } else {
            int lineGroupIndex = startIndex + entryLength - 1;
            PolylineGroup group = (PolylineGroup)nameStack.elementAt(lineGroupIndex);
            detail = new LineConnectorDetail(group);
        }
        return detail;
    }

    public void setConnectionOrder(int connectionOrder) {
        this.connectionOrder = connectionOrder;
    }

    public int getConnectionOrder() {
        return this.connectionOrder;
    }

    protected void sort() {
        int order = this.getConnectionOrder();
        if (order != 0) {
            Collection groups = this.perGroupPolylines.values();
            for (PolylineGroup group : groups) {
                this.renderIndices = group.getPolylines();
                this.sortIndices();
            }
        }
    }

    protected void sortIndices() {
        int order = this.getConnectionOrder();
        if (order != 0) {
            NumericProperty p = order == 3 ? this.pointZ : (order == 2 ? this.pointY : this.pointX);
            if (this.comparator == null) {
                this.comparator = new IndexedValueComparator();
                this.comparator.setSortOrder(1);
            }
            this.comparator.setSortPipe(p);
            for (int i = 0; i < this.renderIndices.size(); ++i) {
                Collections.sort((List)this.renderIndices.elementAt(i), this.comparator);
            }
        }
    }

    public Font getDataLabelFont() {
        return this.dataLabelFont;
    }

    public void setDataLabelFont(Font dataLabelFont) {
        this.dataLabelFont = dataLabelFont;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setDPIScaleFactor(float fac) {
        this.DPIScaleFactor = fac;
    }

    public float getDPIScaleFactor() {
        return this.DPIScaleFactor;
    }

    public void setPresortRequired(boolean presort) {
        this.presortRequired = presort;
    }

    public boolean isPresortRequired() {
        return this.presortRequired;
    }

    public void setSubpixelRendering(boolean b) {
        this.subpixelRendering = b;
    }

    public boolean isSubpixelRendering() {
        return this.subpixelRendering;
    }

    public Vector[] getGroupPolylines() {
        Collection groups = this.perGroupPolylines.values();
        Iterator iter = groups.iterator();
        int numLines = 0;
        while (iter.hasNext()) {
            PolylineGroup oneGroup = (PolylineGroup)iter.next();
            numLines += oneGroup.getPolylineCount();
        }
        Vector[] lines = new Vector[numLines];
        iter = groups.iterator();
        int idx = 0;
        while (iter.hasNext()) {
            PolylineGroup oneGroup = (PolylineGroup)iter.next();
            int n = oneGroup.getPolylineCount();
            for (int i = 0; i < n; ++i) {
                lines[idx++] = oneGroup.getPolyline(i);
            }
        }
        return lines;
    }

    public class PolylineGroup {
        private Vector polylines = new Vector();
        private Color lineColor = Color.black;
        private Color fillColor = Color.black;
        private double lineWidth;
        private int stipplePattern;
        private int stippleFactor;
        private int patternIndex;
        private boolean highlightOn;
        private Color highlightColor;
        private int vertexCount = 0;
        private boolean is3D = false;
        protected int arrowHeadShape;
        protected boolean endArrowOn = false;
        protected boolean startArrowOn = false;
        protected double arrowHeadScale = 1.0;
        private Color fillPatternColor = Color.black;
        private int fillPatternType;
        private double fillPatternWidth;
        private double fillPatternScaleFactor = 1.0;

        public PolylineGroup() {
            this(false);
        }

        public PolylineGroup(boolean is3D) {
            this.is3D = is3D;
            this.addPolyline();
        }

        public void setHighlightColor(Color hc) {
            this.highlightColor = hc;
        }

        public Color getHighlightColor() {
            return this.highlightColor;
        }

        public boolean isHighlightOn() {
            return this.highlightOn;
        }

        public void setHighlightOn(boolean ho) {
            this.highlightOn = ho;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public void setLineColor(Color color) {
            this.lineColor = color;
        }

        public void addPolyline() {
            this.polylines.add(new Vector());
        }

        public Vector getCurrentPolyline() {
            return (Vector)this.polylines.get(this.polylines.size() - 1);
        }

        public int getPolylineCount() {
            return this.polylines.size();
        }

        public Vector getPolyline(int i) {
            return (Vector)this.polylines.get(i);
        }

        public Vector getPolylines() {
            return this.polylines;
        }

        public double getLineWidth() {
            return this.lineWidth;
        }

        public void setLineWidth(double lineWidth) {
            this.lineWidth = lineWidth;
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public void setFillColor(Color fillColor) {
            this.fillColor = fillColor;
        }

        public void setLinePatternIndex(int patternIndex) {
            this.patternIndex = patternIndex;
            if (patternIndex >= 0) {
                if (FilledLineConnector.this.customLinePatterns != null) {
                    int[] pf = (int[])FilledLineConnector.this.customLinePatterns.get(patternIndex % FilledLineConnector.this.customLinePatterns.size());
                    this.stipplePattern = pf[0];
                    this.stippleFactor = pf[1];
                } else {
                    this.stipplePattern = SASLinePatterns.getStipplePattern((int)patternIndex);
                    this.stippleFactor = (int)(0.5 + FilledLineConnector.this.stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)patternIndex));
                }
            }
        }

        public int getStipplePattern() {
            return this.stipplePattern;
        }

        public int getStippleFactor() {
            return this.stippleFactor;
        }

        public Color getFillPatternColor() {
            return this.fillPatternColor;
        }

        public void setFillPatternColor(Color fpc) {
            this.fillPatternColor = fpc;
        }

        public int getFillPatternType() {
            return this.fillPatternType;
        }

        public void setFillPatternType(int fpt) {
            this.fillPatternType = fpt;
        }

        public double getFillPatternWidth() {
            return this.fillPatternWidth;
        }

        public void setFillPatternWidth(double fpw) {
            this.fillPatternWidth = fpw;
        }

        public double getFillPatternScaleFactor() {
            return this.fillPatternScaleFactor;
        }

        public void setFillPatternScaleFactor(double fpsf) {
            this.fillPatternScaleFactor = fpsf;
        }

        public void setDrawAttributes(Channel channel) {
            if (this.highlightOn) {
                channel.glColor(this.highlightColor);
            } else {
                channel.glColor(this.lineColor);
            }
            channel.glLineWidth((float)this.lineWidth);
            if (this.patternIndex >= 0) {
                channel.glEnable(6);
                channel.glLineStipple(this.stippleFactor, this.stipplePattern);
            } else {
                channel.glDisable(6);
            }
            channel.lineCapStyle(FilledLineConnector.this.capStyle);
            channel.setLineJoinStyle(FilledLineConnector.this.joinStyle);
            channel.glSkinType(FilledLineConnector.this.getSkinType());
            channel.glDPIScaleFactor(FilledLineConnector.this.getDPIScaleFactor());
        }

        public void setFillAttributes(Channel channel) {
            if (this.highlightOn) {
                if (channel.getBackbufferId() == -1) {
                    channel.glColor(this.fillColor);
                    channel.glEdgeColor(this.highlightColor);
                } else {
                    channel.glColor(this.highlightColor);
                }
            } else {
                channel.glColor(this.fillColor);
                channel.glEdgeColor(this.fillColor);
            }
            if (this.is3D) {
                channel.glEnable(16);
                channel.glPolygonOffset(FilledLineConnector.this.polygonOffsetFactor, FilledLineConnector.this.polygonOffsetUnits);
                channel.glEnable(1);
            } else {
                channel.glDisable(1);
                channel.glDisable(16);
            }
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public void addVertex() {
            ++this.vertexCount;
        }

        public void setStartArrowOn(boolean on) {
            this.startArrowOn = on;
        }

        public boolean isStartArrowOn() {
            return this.startArrowOn;
        }

        public void setEndArrowOn(boolean on) {
            this.endArrowOn = on;
        }

        public boolean isEndArrowOn() {
            return this.endArrowOn;
        }

        public void setArrowHeadShape(int shape) {
            this.arrowHeadShape = shape;
        }

        public int getArrowHeadShape() {
            return this.arrowHeadShape;
        }

        public void setArrowHeadScale(double s) {
            this.arrowHeadScale = s;
        }

        public double getArrowHeadScale() {
            return this.arrowHeadScale;
        }
    }

    public static class IndexedValueComparator
    implements Comparator {
        private int sortOrder = 1;
        private NumericPipe np;

        public void setSortOrder(int sortOrder) {
            this.sortOrder = sortOrder;
        }

        public int getSortOrder() {
            return this.sortOrder;
        }

        public void setSortPipe(NumericPipe np) {
            this.np = np;
        }

        public int compare(Object o1, Object o2) {
            int i1 = (Integer)o1;
            int i2 = (Integer)o2;
            double d1 = 0.0;
            double d2 = 0.0;
            boolean getValue1 = false;
            boolean getValue2 = false;
            try {
                d1 = this.np.getValue(i1);
                getValue1 = true;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            try {
                d2 = this.np.getValue(i2);
                getValue2 = true;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            int result = getValue1 && getValue2 ? (d1 == d2 ? 0 : (d1 < d2 ? -1 : 1)) : (getValue1 ? 1 : (getValue2 ? -1 : 0));
            if (this.sortOrder == 2) {
                if (result > 0) {
                    result = -1;
                } else if (result < 0) {
                    result = 1;
                }
            }
            return result;
        }
    }
}

