/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.SelectEntry;

public abstract class Element
extends PropertyContainer {
    private Object userData;
    private int valueCount;
    public final BooleanProperty selectEnabled = new BooleanProperty(this, true);
    public final BooleanProperty selectDetailEnabled = new BooleanProperty(this, true);
    public final ATransform transform;

    protected Element(ATransform aTransform) {
        this.selectEnabled.setValue(true);
        this.selectDetailEnabled.setValue(false);
        this.valueCount = -1;
        this.transform = aTransform;
        this.transform.setOwner(this);
    }

    @Override
    public void init(AInitAction initAction) {
        initAction.setConstantValueCount();
        super.init(initAction);
        this.setValueCount(initAction.getValueCount());
    }

    protected void setValueCount(int aValueCount) {
        this.valueCount = aValueCount;
    }

    protected int getValueCount() {
        return this.valueCount;
    }

    public void build(ABuildAction buildAction) {
        int n = this.getValueCount();
        if (n == -1) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            buildAction.setValueIndex(i);
            this.buildOne(buildAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetNetwork(AResetAction action) {
        if (this.getValueCount() == 0) {
            return;
        }
        boolean isIdentity = false;
        try {
            action.pushName(this);
            isIdentity = this.transform.isIdentity();
            if (!isIdentity) {
                this.transform.push(action);
                this.transform.apply(action);
            }
            this.reset(action);
        }
        catch (MissingValueException missingValueException) {
        }
        finally {
            if (!isIdentity) {
                this.transform.pop(action);
            }
            action.popName(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildOne(ABuildAction action) {
        boolean isIdentity = false;
        try {
            action.pushName(this);
            isIdentity = this.transform.isIdentity();
            if (!isIdentity) {
                this.transform.push(action);
                this.transform.apply(action);
            }
            this.render(action);
        }
        catch (MissingValueException missingValueException) {
        }
        finally {
            if (!isIdentity) {
                this.transform.pop(action);
            }
            action.popName(this);
        }
    }

    protected abstract void render(ABuildAction var1) throws MissingValueException;

    public void computeBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        int n = this.getValueCount();
        if (n == -1) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            bBoxAction.setValueIndex(i);
            this.computeBoundingBoxOne(bBoxAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeBoundingBoxOne(AComputeBoundingBoxAction bBoxAction) {
        try {
            this.transform.push(bBoxAction);
            this.transform.apply(bBoxAction);
            this.transform.getMatrix(bBoxAction, bBoxAction.matrix);
            this.getBoundingBox(bBoxAction);
            BoundingBox ebox = bBoxAction.getElementBoundingBox();
            BoundingBox nbox = bBoxAction.getNetworkBoundingBox();
            ebox.transform(bBoxAction.matrix);
            nbox.union(ebox);
            ebox.makeEmpty();
        }
        catch (MissingValueException missingValueException) {
        }
        finally {
            this.transform.pop(bBoxAction);
        }
    }

    protected abstract void getBoundingBox(AComputeBoundingBoxAction var1) throws MissingValueException;

    public void setUserData(Object o) {
        this.userData = o;
    }

    public Object getUserData() {
        return this.userData;
    }

    public SelectEntry buildSelectEntry(int valueIndex) {
        SelectEntry se = null;
        se = new SelectEntry();
        se.setElement(this);
        se.setValueIndex(valueIndex);
        return se;
    }

    protected SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        return null;
    }

    protected boolean canHaveSelectDetails() {
        return true;
    }

    protected String[] userDataToString(int valueIndex) {
        String tooltip;
        if (!(this.userData instanceof Probe)) {
            return null;
        }
        Probe probe = (Probe)this.userData;
        String[] allLabels = probe.getLabels();
        String[] allValues = probe.getValues(valueIndex);
        StringBuffer sb = new StringBuffer();
        String href = null;
        for (int j = 0; j < allLabels.length; ++j) {
            if (allLabels[j].indexOf("_URL_") >= 0) {
                if (allValues[j] == null || allValues[j].length() <= 0) continue;
                href = allValues[j];
                continue;
            }
            sb = sb.append(allLabels[j] + " = " + allValues[j] + " \n");
        }
        String string = tooltip = href != null ? sb.toString() : probe.getString(valueIndex);
        if (tooltip.lastIndexOf("\n") > 0) {
            tooltip = tooltip.substring(0, tooltip.lastIndexOf("\n") - 1);
        }
        return new String[]{href, tooltip};
    }
}

