/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.util.NumericRangeSegment;
import java.awt.Color;
import java.util.Vector;

public class DiscreteRangeToColorMap
extends ColorMap {
    private Vector pipes = new Vector(4, 2);
    protected Color[] colorValues;
    protected double[] rangeValues;
    protected Color otherColor = new Color(0, 0, 0);
    protected boolean lowerExclude;
    protected NumericRangeSegment[] rangeSegments;

    private String formatRange(Formatter labelFormat, double value1, double value2) {
        String result = null;
        result = value1 == value2 ? labelFormat.format(new Double(value1)) : labelFormat.format(new Double(value1)).trim() + " - " + labelFormat.format(new Double(value2)).trim();
        return result;
    }

    @Override
    public void init(AInitAction ia) {
        int i;
        if (ia.beenInitialized(this)) {
            return;
        }
        if (this.rangeSegments == null || this.rangeSegments.length == 0) {
            if (this.rangeValues == null || this.colorValues == null) {
                return;
            }
            this.createRangeSegments();
        }
        this.sortRangeSegments();
        this.uniqueValueVector.setSize(this.rangeSegments.length);
        this.labelVector.setSize(this.rangeSegments.length);
        Formatter labelFormat = this.getOwnerFormatter();
        for (i = 0; i < this.rangeSegments.length; ++i) {
            String str = this.rangeSegments[i].getMin() == Double.NEGATIVE_INFINITY ? (this.rangeSegments[i].getMaxExclude() ? "   < " + labelFormat.format(new Double(this.rangeSegments[i].getMax())).trim() : "   <= " + labelFormat.format(new Double(this.rangeSegments[i].getMax())).trim()) : (this.rangeSegments[i].getMax() == Double.POSITIVE_INFINITY ? (this.rangeSegments[i].getMinExclude() ? "   > " + labelFormat.format(new Double(this.rangeSegments[i].getMin())).trim() : "   >= " + labelFormat.format(new Double(this.rangeSegments[i].getMin())).trim()) : this.formatRange(labelFormat, this.rangeSegments[i].getMin(), this.rangeSegments[i].getMax()));
            this.labelVector.setValueAt(str, i);
        }
        for (i = 0; i < this.rangeSegments.length; ++i) {
            this.uniqueValueVector.setValueAt((Color)this.rangeSegments[i].getValue(null), i);
        }
        if (this.isReplaceMissingValuesAny() && this.isLabelMissingValuesAny()) {
            int pipeCount = this.pipes.size();
            for (int pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
                NumericPipe np = (NumericPipe)this.pipes.elementAt(pipeIndex);
                ia.setCategoryRequest(true);
                ia.pushValueCount();
                np.init(ia);
                ia.popValueCount();
                NumericVector nv = (NumericVector)ia.getUniqueValueVector();
                if (nv == null) continue;
                int count = nv.size();
                for (i = 0; i < count; ++i) {
                    try {
                        nv.getValue(i);
                        continue;
                    }
                    catch (MissingValueException e) {
                        MissingValues mv = e.getMissingValue();
                        if (!this.isLabelMissingValues(mv) || !this.isReplaceMissingValues(mv) || this.uniqueValueVector.contains(this.getMissingReplacement(mv))) continue;
                        this.labelVector.addValue(this.getMissingValueLabel(mv));
                        this.uniqueValueVector.addValue(this.getMissingReplacement(mv));
                    }
                }
            }
        }
    }

    public Color getValue(int index, NumericPipe input) throws MissingValueException {
        double value = 0.0;
        try {
            value = input.getValue(index);
        }
        catch (MissingValueException e) {
            MissingValues mv = e.getMissingValue();
            if (this.isReplaceMissingValues(mv)) {
                return this.getMissingReplacement(e.getMissingValue());
            }
            throw e;
        }
        return this.getValueImpl(value);
    }

    public Color getValue(double value) {
        this.init(new AInitAction());
        return this.getValueImpl(value);
    }

    private Color getValueImpl(double value) {
        int i = 0;
        boolean found = false;
        int low = 0;
        int high = this.rangeSegments.length - 1;
        while (low <= high && !found) {
            int middle = (low + high) / 2;
            int inRange = this.rangeSegments[middle].inRange(value);
            if (inRange == -1) {
                high = middle - 1;
                continue;
            }
            if (inRange == 1) {
                low = middle + 1;
                continue;
            }
            found = true;
            i = middle;
        }
        if (!found) {
            return this.otherColor;
        }
        return (Color)this.rangeSegments[i].getValue(null);
    }

    public NumericRangeSegment[] getRangeSegments() {
        return this.rangeSegments;
    }

    public double[] getRangeValue() {
        return this.rangeValues;
    }

    public Color[] getColorValue() {
        return this.colorValues;
    }

    public void setRangeSegments(NumericRangeSegment[] rs) {
        this.rangeSegments = new NumericRangeSegment[rs.length];
        for (int i = 0; i < this.rangeSegments.length; ++i) {
            this.rangeSegments[i] = new NumericRangeSegment(rs[i].getMin(), rs[i].getMax(), rs[i].getMinExclude(), rs[i].getMaxExclude(), rs[i].getValue(null));
        }
    }

    public void setRangeValue(double[] value) {
        if (value.length == 0) {
            throw new Error("No numeric values specified for the Numeric array in the RangeToNumMapper.");
        }
        this.rangeValues = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.rangeValues[i] = value[i];
        }
        this.setModified();
    }

    public void setColorValue(Color[] value) {
        if (value.length == 0) {
            throw new Error("No color values specified for the Color array in the RangeToColorMapper.");
        }
        this.colorValues = new Color[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.colorValues[i] = value[i];
        }
        this.setModified();
    }

    public void setCategoryColorValue(Color[] value) {
        double[] range = new double[value.length + 1];
        double rv = -0.5;
        for (int i = 0; i < range.length; ++i) {
            range[i] = rv;
            rv += 1.0;
        }
        this.setRangeValue(range);
        this.setColorValue(value);
        this.setModified();
    }

    public Color[] getCategoryColorValue() {
        return this.getColorValue();
    }

    public void setOutOfRangeColor(Color aColor) {
        if (aColor != null) {
            this.otherColor = aColor;
            this.setModified();
        }
    }

    public Color getOutOfRangeColor() {
        return this.otherColor;
    }

    public void setLowerExclude(boolean trueOrFalse) {
        this.lowerExclude = trueOrFalse;
        this.setModified();
    }

    public boolean isLowerExclude() {
        return this.lowerExclude;
    }

    public void addNumericPipe(NumericPipe pipe) {
        if (!this.pipes.contains(pipe)) {
            this.pipes.addElement(pipe);
            this.setModified();
        }
    }

    public void removeAllNumericPipes() {
        this.pipes.removeAllElements();
        this.setModified();
    }

    public void removeNumericPipe(NumericPipe pipe) {
        this.pipes.removeElement(pipe);
        this.setModified();
    }

    public int getNumericPipeCount() {
        return this.pipes.size();
    }

    public NumericPipe getNumericPipe(int i) {
        return (NumericPipe)this.pipes.elementAt(i);
    }

    private void createRangeSegments() {
        if (this.colorValues.length < this.rangeValues.length) {
            this.rangeSegments = new NumericRangeSegment[this.colorValues.length];
            int lastIndex = this.colorValues.length - 1;
            for (int i = 0; i < lastIndex; ++i) {
                this.rangeSegments[i] = new NumericRangeSegment(this.rangeValues[i], this.rangeValues[i + 1], this.lowerExclude, !this.lowerExclude, (Object)this.colorValues[i]);
            }
            this.rangeSegments[lastIndex] = new NumericRangeSegment(this.rangeValues[lastIndex], this.rangeValues[lastIndex + 1], this.lowerExclude, false, (Object)this.colorValues[lastIndex]);
        } else if (this.colorValues.length == this.rangeValues.length) {
            this.rangeSegments = new NumericRangeSegment[this.colorValues.length];
            this.rangeSegments[0] = new NumericRangeSegment(Double.NEGATIVE_INFINITY, this.rangeValues[0], false, !this.lowerExclude, (Object)this.colorValues[0]);
            int lastIndex = this.colorValues.length - 1;
            for (int i = 1; i < lastIndex; ++i) {
                this.rangeSegments[i] = new NumericRangeSegment(this.rangeValues[i - 1], this.rangeValues[i], this.lowerExclude, !this.lowerExclude, (Object)this.colorValues[i]);
            }
            this.rangeSegments[lastIndex] = new NumericRangeSegment(this.rangeValues[lastIndex], this.rangeValues[lastIndex + 1], this.lowerExclude, false, (Object)this.colorValues[lastIndex]);
        } else if (this.colorValues.length > this.rangeValues.length) {
            this.rangeSegments = new NumericRangeSegment[this.rangeValues.length + 1];
            this.rangeSegments[0] = new NumericRangeSegment(Double.NEGATIVE_INFINITY, this.rangeValues[0], false, !this.lowerExclude, (Object)this.colorValues[0]);
            this.rangeSegments[this.rangeValues.length] = new NumericRangeSegment(this.rangeValues[this.rangeValues.length - 1], Double.POSITIVE_INFINITY, this.lowerExclude, false, (Object)this.colorValues[this.rangeValues.length]);
            for (int i = 1; i < this.rangeValues.length; ++i) {
                this.rangeSegments[i] = new NumericRangeSegment(this.rangeValues[i - 1], this.rangeValues[i], this.lowerExclude, !this.lowerExclude, (Object)this.colorValues[i]);
            }
        }
    }

    private void sortRangeSegments() {
        for (int pass = 1; pass < this.rangeSegments.length; ++pass) {
            for (int i = 0; i < this.rangeSegments.length - 1; ++i) {
                if (!(this.rangeSegments[i].getMin() > this.rangeSegments[i + 1].getMin()) && (this.rangeSegments[i].getMin() != this.rangeSegments[i + 1].getMin() || !(this.rangeSegments[i].getMax() > this.rangeSegments[i + 1].getMax()))) continue;
                NumericRangeSegment temp = this.rangeSegments[i];
                this.rangeSegments[i] = this.rangeSegments[i + 1];
                this.rangeSegments[i + 1] = temp;
            }
        }
    }
}

