/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.Debug;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.RB;
import com.sas.text.Message;
import java.text.FieldPosition;
import java.text.MessageFormat;

public class ContinuousRangeToNumericMap
extends NumericMap {
    private NumericVector majorTickOffsetVector = new NumericVector();
    public final NumericPipe majorTickOffset = this.majorTickOffsetVector;
    private static int RIDICULOUS_NUMBER_OF_LABELS = 1000;
    private static final MessageFormat defaultRangeMessageFormat = new MessageFormat("{4}");
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int CENTER = 2;
    protected double inMin = 0.0;
    protected double inMax = 1.0;
    protected double outMin = 0.0;
    protected double outMax = 1.0;
    protected int labelCount = 2;
    protected double margin = 0.0;
    protected int zeroRangeOutput = 0;
    private boolean labelRanges;
    private MessageFormat rangeMessageFormat;

    public void setOffset(double offset) {
        this.margin = offset;
    }

    public double getOffset() {
        return this.margin;
    }

    @Override
    public void init(AInitAction ia) {
        double outSize;
        super.init(ia);
        if (ia.beenInitialized(this)) {
            return;
        }
        this.labelVector.removeAllValues();
        this.uniqueValueVector.removeAllValues();
        this.majorTickOffsetVector.removeAllValues();
        double inSize = this.inMax - this.inMin;
        if (inSize == 0.0) {
            Debug.println((String)"Input range is zero. Using OutputMin value for all incoming data points.");
        }
        if ((outSize = this.outMax - this.outMin) == 0.0) {
            Debug.println((String)"Output range is zero. Using InputMin value for all incoming data points.");
        }
        if (this.labelRanges) {
            this.initLabelRanges(inSize, outSize);
        } else {
            this.initLabelsAtUniqueValues(inSize, outSize);
        }
    }

    private void initLabelRanges(double inSize, double outSize) {
        Formatter labelFormat = this.getOwnerFormatter();
        MessageFormat f = this.getRangeFormat();
        if (f == null) {
            f = defaultRangeMessageFormat;
        }
        Object[] formatArgs = new Object[5];
        if (this.labelCount >= 2) {
            this.labelVector.setSize(this.labelCount - 1);
            this.uniqueValueVector.setSize(this.labelCount - 1);
            this.majorTickOffsetVector.setSize(this.labelCount);
            for (int i = 0; i < this.labelCount; ++i) {
                double ratio = (double)i / (double)(this.labelCount - 1);
                double outV = this.outMin + ratio * outSize;
                this.majorTickOffsetVector.setValueAt(outV, i);
                if (i <= 0) continue;
                double ratioPrev = (double)(i - 1) / (double)(this.labelCount - 1);
                double inVPrev = this.inMin + ratioPrev * inSize;
                double inV = this.inMin + ratio * inSize;
                Double inVPrev_Double = new Double(inVPrev);
                Double inV_Double = new Double(inV);
                String fvPrev = labelFormat.format(inVPrev_Double).trim();
                String fv = labelFormat.format(inV_Double).trim();
                formatArgs[0] = inVPrev_Double;
                formatArgs[1] = inV_Double;
                formatArgs[2] = fvPrev;
                formatArgs[3] = fv;
                formatArgs[4] = Message.format((String)RB.getStringResource("numericLowToHighRangeFormat.fmt.txt"), (Object)fvPrev, (Object)fv);
                String l = f.format(formatArgs, new StringBuffer(), (FieldPosition)null).toString();
                this.labelVector.setValueAt(l, i - 1);
                double outVPrev = this.outMin + ratioPrev * outSize;
                this.uniqueValueVector.setValueAt(outVPrev + (outV - outVPrev) / 2.0 + this.margin, i - 1);
            }
        } else if (this.labelCount == 1) {
            double out;
            this.labelVector.setSize(1);
            this.uniqueValueVector.setSize(1);
            this.majorTickOffsetVector.setSize(1);
            this.labelVector.setValueAt(labelFormat.format(new Double(this.inMin)).trim(), 0);
            switch (this.zeroRangeOutput) {
                default: {
                    out = this.outMin;
                    break;
                }
                case 1: {
                    out = this.outMax;
                    break;
                }
                case 2: {
                    out = 0.5 * (this.outMin + this.outMax);
                }
            }
            this.uniqueValueVector.setValueAt(out + this.margin, 0);
        }
    }

    private void initLabelsAtUniqueValues(double inSize, double outSize) {
        Formatter labelFormat = this.getOwnerFormatter();
        this.labelVector.setSize(this.labelCount);
        this.uniqueValueVector.setSize(this.labelCount);
        if (this.labelCount >= 2) {
            for (int i = 0; i < this.labelCount; ++i) {
                double ratio = (double)i / (double)(this.labelCount - 1);
                this.labelVector.setValueAt(labelFormat.format(new Double(this.inMin + ratio * inSize)).trim(), i);
                this.uniqueValueVector.setValueAt(this.outMin + ratio * outSize + this.margin, i);
            }
        } else if (this.labelCount == 1) {
            double out;
            this.labelVector.setValueAt(labelFormat.format(new Double(this.inMin)).trim(), 0);
            switch (this.zeroRangeOutput) {
                default: {
                    out = this.outMin;
                    break;
                }
                case 1: {
                    out = this.outMax;
                    break;
                }
                case 2: {
                    out = 0.5 * (this.outMin + this.outMax);
                }
            }
            this.uniqueValueVector.setValueAt(out + this.margin, 0);
        }
    }

    public double getValue(int index, NumericPipe input) throws MissingValueException {
        double actualValue = 0.0;
        try {
            actualValue = input.getValue(index);
        }
        catch (MissingValueException e) {
            MissingValues mv = e.getMissingValue();
            if (this.isReplaceMissingValues(mv)) {
                return this.getMissingReplacement(e.getMissingValue());
            }
            throw e;
        }
        return this.getValue(actualValue);
    }

    public double getValue(double input) {
        double mappedValue;
        double denominator = this.inMax - this.inMin;
        if (denominator == 0.0) {
            switch (this.zeroRangeOutput) {
                default: {
                    mappedValue = this.outMin;
                    break;
                }
                case 1: {
                    mappedValue = this.outMax;
                    break;
                }
                case 2: {
                    mappedValue = 0.5 * (this.outMin + this.outMax);
                    break;
                }
            }
        } else {
            double normalizedValue = (input - this.inMin) / denominator;
            mappedValue = this.outMin + (this.outMax - this.outMin) * normalizedValue;
        }
        return mappedValue + this.margin;
    }

    public double getInverseValue(double output) {
        double mappedValue;
        double denominator = this.outMax - this.outMin;
        output -= this.margin;
        if (denominator == 0.0) {
            mappedValue = this.inMin;
        } else {
            double normalizedValue = (output - this.outMin) / denominator;
            mappedValue = this.inMin + (this.inMax - this.inMin) * normalizedValue;
        }
        return mappedValue;
    }

    @Override
    public double getOutputMin() {
        return this.outMin;
    }

    public void setOutputMin(double min) {
        this.outMin = min;
        this.setModified();
    }

    @Override
    public double getOutputMax() {
        return this.outMax;
    }

    public void setOutputMax(double max) {
        this.outMax = max;
        this.setModified();
    }

    public double getInputMin() {
        return this.inMin;
    }

    public void setInputMin(double min) {
        this.inMin = min;
        this.setModified();
    }

    public double getInputMax() {
        return this.inMax;
    }

    public void setInputMax(double max) {
        this.inMax = max;
        this.setModified();
    }

    public int getLabelCount() {
        return this.labelCount;
    }

    public void setLabelCount(int labelCount) {
        labelCount = Math.max(0, labelCount);
        this.labelCount = labelCount = Math.min(RIDICULOUS_NUMBER_OF_LABELS, labelCount);
        this.setModified();
    }

    @Override
    public void setReplaceMissingValues(boolean replace) {
        super.setReplaceMissingValues(replace);
    }

    @Override
    public void setReplaceMissingValues(boolean replace, MissingValues missingValue) {
        super.setReplaceMissingValues(replace, missingValue);
    }

    public int getZeroRangeOutput() {
        return this.zeroRangeOutput;
    }

    public void setZeroRangeOutput(int output) {
        switch (output) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
        this.zeroRangeOutput = output;
    }

    public boolean isLabelRanges() {
        return this.labelRanges;
    }

    public void setLabelRanges(boolean labelRanges) {
        this.labelRanges = labelRanges;
        this.setModified();
    }

    public MessageFormat getRangeFormat() {
        return this.rangeMessageFormat;
    }

    public void setRangeFormat(MessageFormat rangeMessageFormat) {
        this.rangeMessageFormat = rangeMessageFormat;
        this.setModified();
    }
}

